$(function()
{
    var zindex = 10;
    var dropped = 0;
    var top;
    var left;
    var elements = 8;
    var speed = [3000, 2800, 2600, 2400, 2200, 2100, 2300, 2500, 2700, 2900];

    function shuffleArray(array) {
        for (var i = array.length - 1; i > 0; i--) {
            var j = Math.floor(Math.random() * (i + 1));
            var temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
        return array;
    }
    shuffleArray(speed);

    for (var i = 0; i < 40; i++) {
        left = 750 + (i - elements * Math.floor(i / elements)) * 33;
        top = 75 + 100 * Math.floor(i / elements);
        $('main').append('<div class="flower" style="top:' + top + 'px;left:' + left + 'px;" data-dropped="0" data-value="1"></div>');
    }

    $(".flower").draggable({
        start: function() {
            zindex++;
            $(this).css('z-index', zindex);
        }
    });

    var drop = function(event, ui) {
        if (ui.draggable.data('dropped') === 0) {
            dropped++;
            ui.draggable.data('dropped', 1);
            var x = $(this).data('value');
            var y = ui.draggable.data('value');
            $(this).data('value', x + y);
            check();
        }
    };
    var out = function(event, ui) {
        if (ui.draggable.data('dropped') === 1) {
            dropped--;
            ui.draggable.data('dropped', 0);
            var x = $(this).data('value');
            var y = ui.draggable.data('value');
            $(this).data('value', x - y);
            check();
        }
    };
    $(".target").droppable({
        accept: ".flower",
        tolerance: "pointer",
        drop: drop,
        out: out
    });

    function check() {
        var bad = 0;

        for (var i = 1; i <= 10; i++) {
            bad += ($('#t' + i).data('value') === 4) ? 0 : 1;
        }

        if (bad === 0) {
            $('#jplayer_well').jPlayer('play');
            $('.target').fadeOut(100);
            $('.flower').each(function() {
                var position = $(this).position().top;
                if (position < 184) {
                    $(this).css('top', Math.floor((Math.random() * 215)+184)+'px');
                }
            });

            for (var i = 1; i <= 10; i++) {
                left = Math.floor((Math.random() * 10) + 1) * -160;
                $('#b' + i).animateSprite({
                    fps: 48,
                    autoplay: true,
                    loop: true
                }).animate({top: '-260px', left: left}, speed[i - 1]);
            }
        } else {
            if (dropped === 40) {
                $('#jplayer_wrong').jPlayer('play');
            }
        }
    }
});