﻿
	$(function ()
	{

		/**
		 * Elements
		 */

		var elements = [];
		for (var i = 1; i <= 16; ++i)
		{
			elements[i - 1] = i;
		}
		var positions = [
			[-47, -38], [85, -38], [218, -38], [351, -38],
			[-47, 100], [85, 100], [218, 100], [351, 100],
			[-47, 235], [85, 235], [218, 235], [351, 235],
			[-47, 370], [85, 370], [218, 370], [351, 370],
		];
		var count = 0;
		$.each(_.shuffle(elements), function (index, value)
		{
			$('.elements').append('<div style="position: absolute; right: ' + positions[count][0] + 'px; top: ' + positions[count][1] + 'px;" class="element_' + value + '" data-element="' + value + '"/>');
			count++;

		});

		/**
		 * Draggable style="background: none; background-color: #ffffff;"
		 */
		$('.elements > *').each(function ()
		{
			var $this = $(this);

			$this.draggable(
				{
					cursor: 'move',
					opacity: .7,
					scope: $this.data('element'),
					stack: ".elements > *"
				});
		});

		/**
		 * Droppable
		 */


		$('.boxes > *').each(function ()
		{
			var $this = $(this);

			$this.droppable(
				{
					accept: $('.elements > *'),
					addClasses: false,
					scope: $this.data('kind'),
					drop: function (event, ui)
					{
					
						$(event.target).addClass('ok').droppable('disable');
						$(event.target).css('background', '');
						if (!$("html").hasClass("ie8")) {
							ui.helper.css('display', 'none').draggable('destroy');
						}
						;

					}
				});
		});
		/**
		 * Hint
		 */
		$('a.hint').click(function (e)
		{
			e.preventDefault();
			$('div.hint').fadeToggle();
		});

		var top;
		var left;
		var boxes = [0, 0, 0];
		var dataValue;
		var cloneText;

		$(".textbox").draggable({revert: true, helper: 'clone'});

		$('.target').droppable(
			{
				addClasses: false,
				drop: function (event, ui)
				{

					if (ui.draggable.data('dropped') === 0)
					{

						top = $(this).position().top + ($(this).height() / 2) - (ui.draggable.height() / 2) - 5;
						left = $(this).position().left + ($(this).width() / 2) - (ui.draggable.width() / 2);
						dataValue = ui.draggable.data('value');
						cloneText = ui.draggable.text();
						$('.droppat' + $(this).data("value")).fadeOut(function () {
							$(this).remove();
						});
						var el = $('<div data-value="' + dataValue + '" data-dropped="1" style="position: absolute; top: ' + ui.helper.position().top + 'px; left: ' + ui.helper.position().left + 'px;" class="textbox clone droppat' + $(this).data("value") + '">' + cloneText + '</div>');
						$('.stage1').append(el);
						ui.helper.remove();
						el.animate({left: left, top: top}, {duration: 500, easing: 'easeOutBounce', complete: function () {
								$(this).draggable({stack: ".textbox"});
							}});
						boxes[$(this).data('value')] = ui.draggable.data('value');

						if ($.grep(boxes, function (n, i) {
							return n === 0;
						}).length === 0)
						{

							if ('sz,sz,rz' === boxes.toString())
							{
								$('.stage1').fadeOut(function(){
									$('.stage2').fadeIn();
									$('.wrapper').css('background-image', 'none');
								});
								$('#jplayer_well').jPlayer('play')
							} else
								$('#jplayer_wrong').jPlayer('play');

						}
					}
				},
				out: function (event, ui) {
					if (ui.draggable.data('dropped') === 1)
					{
						ui.draggable.removeClass('droppat' + $(this).data("value"));
						ui.draggable.data('dropped', 0);
						boxes[$(this).data('value')] = 0;
					}
				}
			});




	});
