$(function () {

    var elements = [1, 2, 3, 4, 5];

    function shuffle(o) {
        for (var j, x, i = o.length; i; j = Math.floor(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x)
            ;
        return o;
    }

    function mix(list, shuffleElements) {
        for (var i = $(list)[0].childElementCount; i; i--) {
            $(list + ' li:nth-child(' + i + ')').attr('data-value', shuffleElements[i - 1]);
        }
    }

    function checkList(id) {
        var items = $('#' + id),
                err = 0;
        for (var i = 1; i <= items[0].childElementCount; i++) {
            var item = parseInt(items[0].children[i - 1].dataset.value);
            err += (item !== i) ? 1 : 0;
        }
        return err;
    }

    do {
        mix('#sortable1', shuffle(elements));
        mix('#sortable2', shuffle(elements));
    } while (checkList('sortable1') === 0 || checkList('sortable2') === 0)

    $(".sortable").sortable({
        axis: "x",
        update: function () {
            if (checkList('sortable1') === 0 && checkList('sortable2') === 0) {
                $('#jplayer_well').jPlayer('play');
                $(".sortable").sortable("disable");
                $('.z2').fadeIn(500);
                $('.z3').fadeIn(500);
            }
        }
    });

    $(".sortable").disableSelection();

    $('.bt').click(function () {
        if ($(this).data('value') === 0) {
            $('#jplayer_wrong').jPlayer('play');
        } else {
            $('#jplayer_well').jPlayer('play');
            var bt = $(this).attr('class');
            var brothers = bt.replace('bt ', '');
            $(this)
                    .addClass('ok')
                    .unbind('click');
            setTimeout(function () {
                $('.' + brothers + ':not(span.ok)').css('display', 'none');
            }, 400);
        }
    });
});