$(function()
{
    var zindex = 10,
            dropped = 0,
            drop = function(event, ui) {
                if (ui.draggable.data('value') === $(this).data('value')) {
                    var top = $(this).position().top;
                    var left = $(this).position().left;
                    dropped++;
                    ui.draggable
                            .data('dropped', 1)
                            .draggable({revert: false})
                            .draggable("option", "disabled", true);
                    if (dropped === 5) {
                        $('#jplayer_well').jPlayer('play');
                    }
                    ui.draggable.animate({
                        top: top + 300 - $(this).data('value'),
                        left: left
                    }, 900);
                } else {
                    $('#jplayer_wrong').jPlayer('play');
                }
            };

    $(".dragg")
            .draggable({
                start: function() {
                    zindex++;
                    $(this).css('z-index', zindex);
                },
                revert: true,
                revertDuration: 900
            });

    $(".foto").droppable({
        accept: ".dragg",
        tolerance: "pointer",
        drop: drop
    });

    $("#miarka").draggable({
        start: function() {
            zindex++;
            $(this).css('z-index', zindex);
        },
        axis: "x"
    });

});