$(function () {

    var listLenght,
	    countColor = 0,
	    countLetters = 0,
	    alphabetValues = [0, 0, 1, 2, 3, 4, 5],
	    left,
	    zindex,
	    dropColors = function (event, ui) {
		if (ui.draggable.data('value') === $(this).data('value')) {
		    countColor++;
		    var color = ui.draggable.css('color');
		    $(this).css('color', color);
		    $('#jplayer_well').jPlayer('play');
		    if (countColor === 7) {
			$('.paint').fadeOut(1000);
			startPart3();
		    }
		} else {
		    $('#jplayer_wrong').jPlayer('play');
		}
	    },
	    dropLetters = function (event, ui) {
		if (ui.draggable.data('alphabet') === $(this).data('value')) {
		    countLetters++;
		    var top = $(this).position().top;
		    var left = $(this).position().left;
		    ui.draggable
			    .css({
				top: top,
				left: left,
				position: "absolute"
			    })
			    .draggable({revert: false})
			    .draggable("option", "disabled", true);
		    $('#jplayer_well').jPlayer('play');
		    if (countLetters === 7) {
			$(".letter").css('color', 'rgb(252, 212, 147)');
		    }
		} else {
		    $('#jplayer_wrong').jPlayer('play');
		}
	    },
	    getListContent = function (listLenght) {
		for (var i = 0, text = ''; i < listLenght; i++) {
		    text += $("#sortable1")[0].children[i].textContent;
		}
		return text;
	    },
	    updateListPart1 = function () {
		listLenght = $(this)[0].children.length;
		var text = getListContent(listLenght);
		var condition = (text === 'WA.KA.CJE' || text === 'WAKA.CJE' || text === 'WA.KACJE');
		checkSyllabize(text, condition);
	    },
	    checkSyllabize = function (text, condition) {
		if (condition) {
		    $('#jplayer_well').jPlayer('play');
		    $("#sortable1 li .h").css('background-color', 'rgb(148, 204, 59)');
		    if (listLenght === 9) {
			startPart2();
		    }
		} else {
		    $('#jplayer_wrong').jPlayer('play');
		    for (var i = 0; i < text.length; i++) {
			if (text[i] === '.') {
			    if (i === 2 || i === 5) {
				$("#sortable1 li:nth-child(" + (i + 1) + ") .h").css('background-color', 'rgb(148, 204, 59)');
			    } else {
				$("#sortable1 li:nth-child(" + (i + 1) + ") .h").css('background-color', 'red');
			    }
			}
		    }
		}
	    };

    function startPart2() {
	$(".assignment_description").html('Pokoloruj na&nbsp;czerwono wszystkie samogłoski, a&nbsp;na&nbsp;zielono – wszystkie spółgłoski w&nbsp;wyrazie <strong><u>wakacje</u></strong>.');
	$("#sortable1").unbind('sortable');
	$("#sortable2").fadeOut(1000);
	$(".paint").fadeIn(1000);
	$(".slash").fadeOut(1000);

	setTimeout(function () {
	    $(".slash").remove();
	    $("#sortable1 li").animate({
		width: 65
	    });
	    $("#sortable1 li").droppable({
		accept: ".drag",
		tolerance: "pointer",
		drop: dropColors
	    });
	}, 1000);

	$(".drag").draggable({
	    start: function () {
		zindex++;
		$(this).css('z-index', zindex);
	    },
	    revert: true,
	    revertDuration: 400
	});
    }

    function startPart3() {
	$(".assignment_description").html('Ustaw litery z wyrazu <strong><u>wakacje</u></strong> w takiej kolejności, w jakiej występują w alfabecie. <span style="color:red;">Uwaga: takie same literki ustaw jedną za drugą.</span>');
	$(".drag").draggable("option", "disabled", true);
	$("#sortable1 li").unbind('droppable');

	for (var i = 0; i < 7; i++) {
	    left = 120 + 65 * i;
	    $("#sortable1").append('<li style="top:80px;left:' + left + 'px;" class="dropForLetters" data-value="' + alphabetValues[i] + '"></li>');
	}

	$(".letter").draggable({
	    start: function () {
		zindex++;
		$(this).css('z-index', zindex);
	    },
	    revert: true,
	    revertDuration: 400
	}).css('cursor', 'pointer');

	$(".dropForLetters").droppable({
	    accept: "#sortable1 li",
	    tolerance: "pointer",
	    drop: dropLetters
	});
    }

    $("#sortable1").sortable({
	connectWith: "#sortable2",
	handle: ".h",
	update: updateListPart1
    }).disableSelection();

    $("#sortable2").sortable({
	connectWith: "#sortable1",
	update: function () {
	    $("#sortable2 li .h").css('background-color', 'white');
	}

	/* sprawdzanie ręczne
	 ,
	 start: function () {
	 $(".check")
	 .click(function () {
	 var text = getListContent(listLenght);
	 listLenght = $(this)[0].children.length;
	 var condition = (text === 'WA.KA.CJE');
	 checkSyllabize(text, condition);
	 })
	 .css('visibility', 'visible')
	 .animate({
	 top: 9,
	 left: 106
	 }, 1000);
	 }
	 */

    }).disableSelection();

});