$(function () {

    var zindex = 10,
            snake = 'jfiasummeraweangsandcastleatsqvchefrisbeeahxtwbadmintonqrpungslashellwzgabucketostar',
            accept = [
                ['04', '05', '06', '07', '08', '09'], //summer
                ['16', '17', '18', '19', '20', '21', '22', '23', '24', '25'], //sand castle
                ['34', '35', '36', '37', '38', '39', '40'], //frisbee
                ['46', '47', '48', '49', '50', '51', '52', '53', '54'], //badminton
                ['64', '65', '66', '67', '68'], //shell
                ['73', '74', '75', '76', '77', '78']//bucket
            ],
            pos = [22,204,369,552,685,847],
            letters = [],
            left = 123,
            top = 50,
            paddingTop = 0,
            deg = 8,
            rotate = 280,
            dropped = 0,
            drop = function (event, ui) {
                if (ui.draggable.data('value') === $(this).data('value')) {
                    var top = $(this).position().top;
                    var left = $(this).position().left;
                    $('#jplayer_sound').jPlayer('setMedia', {mp3: './media/661_' + ui.draggable.data('value') + '.mp3'});
                    setTimeout(function () {
                        $('#jplayer_sound').jPlayer('play');
                    }, 500);

                    dropped++;
                    ui.draggable
                            .draggable({revert: false})
                            .draggable("option", "disabled", true);

                    ui.draggable.animate({
                        top: top,
                        left: left
                    }, 900);
                    if (dropped === 6) {
                        $('#jplayer_sound').on($.jPlayer.event.ended, function (event) {
                            $('#jplayer_well').jPlayer('play');
                        });
                    }
                } else {
                    $('#jplayer_wrong').jPlayer('play');
                }
            };

    for (var i = 1; i <= snake.length; i++) {
        var noLetter = (i < 10) ? '0' + i : i;

        if (i % 21 === 0) {
            rotate = 450;
            left += 256;
            deg = deg * -1;
        }
        if (i % 42 === 0) {
            rotate = 280;
            left -= 7;
            deg = deg * 1;
        }
        if (i % 63 === 0) {
            rotate = 450;
            left += 0;
            deg = deg * 1;
        }
        if (i / 21 === 1) {
            top -= 21;
            paddingTop = 255;
        }
        if (i / 21 === 2) {
            top += 50;
            paddingTop = 0;
        }
        if (i / 21 === 3) {
            top -= 6;
            paddingTop = 255;
        }
        rotate += deg;

        $('.dandd').append('<div id="letter' + noLetter +
                '" class="letter" style="top:' + top +
                'px;left:' + left +
                'px;transform:rotate(' + rotate +
                'deg);-webkit-transform:rotate(' + rotate +
                'deg);-moz-transform:rotate(' + rotate +
                'deg);-o-transform:rotate(' + rotate +
                'deg);-ms-transform:rotate(' + rotate +
                'deg);padding-top:' + paddingTop + 'px;">' +
                snake.substr(i, 1) +
                '</div>');
    }





    $('.letter').click(function () {
        var id = $(this).attr('id');
        if (!$(this).hasClass('checked')) {
            $(this).addClass('checked');
            letters.push(id.replace('letter', ''));
        } else {
            $(this).removeClass('checked');
            letters.splice(letters.indexOf(id.replace('letter', '')), 1);
        }
        for (var i = 0; i < accept.length; i++) {
            if (_.difference(accept[i], letters).length === 0) {
                var word = '';
                var top = $('#letter' + accept[i][0]).position().top + $('#letter' + accept[i][0]).height() / 2;
                var left = $('#letter' + accept[i][0]).position().left + $('#letter' + accept[i][0]).width() / 2;
                for (var j = 0; j < accept[i].length; j++) {
                    word += $('#letter' + accept[i][j]).text();
                    if (i === 1 && j === 3)
                        word += ' ';
                    $('#letter' + accept[i][j]).remove();
                }
                $('.dandd').append('<div id="dragg' + i + '" style="top:' + top + 'px;left:' + left + 'px;" class="dragg" data-value="' + i + '">' + word + '</div>');

                letters.splice(0, letters.length);
                $('#dragg' + i).animate({top: 360, left: pos[i]}, 800).draggable({
                    start: function () {
                        zindex++;
                        $(this).css('z-index', zindex);
                    },
                    revert: true,
                    revertDuration: 900
                });
                ;
            }
        }
    });


    $(".dropp").droppable({
        accept: ".dragg",
        tolerance: "pointer",
        drop: drop
    });
    	$('#jplayer_sound').jPlayer(
		{
		    ready: function ()
		    {
			$(this).jPlayer('setMedia', {mp3: './media/661_0.mp3'});
		    },
		    swfPath: '../../styles/flash',
		    supplied: 'mp3',
		    cssSelectorAncestor: '#jp_container_sound'
		});
});