$(function () {

    var accept = [
        'ż', 'ż', 'ż', 'rz', 'ż', 'ż', 'ż', 'ż', 'rz', 'ż', //10
        'rz', 'ż', 'ż', 'ż', 'ż', 'ż', 'rz', 'rz', 'ż', 'ż' //20
    ],
            digrafy = ['rz', 'ch', 'sz', 'cz', 'dz', 'dż', 'dź'],
            ok = '#3CB639',
            bad = '#F56B6B',
            wym = [1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1],
            first = true,
            click = function () {
                if ($(this).attr('data-wym') === "0") {
                    remMark($(this));
                    $(this).attr('data-wym', "1").addClass('mark');
                } else {
                    $(this).attr('data-wym', "0");
                    remMark($(this));
                }
                if(first){
                    $('a.button.small.check').fadeIn(300).animate({top:9,left:105},1000);
                    first = false;
                }
            };

    function remMark($el) {
        $el.removeClass('mark bad ok');
    }

    function checkWym() {
        for (var i = 1, $element, err = 0; i <= wym.length; i++) {
            $element = $('span.nowrap:nth-child(' + i + ')');
            if (parseInt($element.attr('data-wym')) !== wym[i - 1]) {
                remMark($element);
                $element.attr('data-wym', "0");
                err++;
            } else {
                remMark($element);
                $element.addClass('ok');
            }
            if (err === 0) {
                $('#jplayer_well').jPlayer('play');
            } else {
                $('#jplayer_wrong').jPlayer('play');
            }
        }
    }

    function countFilled() {
        var count = 0;
        for (var i = 1; i <= accept.length; i++) {
            var str = $("#i" + i).val();
            if (str !== '') {
                count++;
            }
        }
        return count;
    }

    function checkAll(a, mark) {
        var err = 0;
        for (var i = 1; i <= accept.length; i++) {
            var str = $("#i" + i).val();
            if (str !== accept[i - 1]) {
                err++;
                if (mark) {
                    $("#i" + i).css({'background': bad, 'border-color': bad}).val('');
                }
            } else {
                if (mark) {
                    $("#i" + i).css({'background': 'transparent', 'border-color': ok}).attr('disabled', true);
                }
            }
        }
        return err;
    }

    $("input").each(function () {
        var readOnly = $(this)[0].readOnly;
        if (!readOnly)
            $(this).val('');
    });

    $(".letterinput").keyup(function () {
        var str = $(this).val();
        if (digrafy.indexOf(str) >= 0) {
            $(this).addClass('thi');
        } else {
            $(this).removeClass('thi');
        }
        if (countFilled() === accept.length) {
            if (checkAll(0, false) !== 0) {

                setTimeout(function () {
                    $('#jplayer_wrong').jPlayer('play');
                    checkAll(0, true);
                }, 300);
            } else {
                $('#jplayer_well').jPlayer('play');
                $('.letterinput').css({'background': 'transparent', 'border-color': ok});
                $('.nowrap').click(click);
            }
        }
    });

    $('a.button.small.check').click(function () {
        checkWym();
    });
    
});