$(function () {

    var accept = [
	['43-20-8=23-8=15', '43-23-5=20-5=15'],
	['82-40-8=42-8=34', '82-42-6=40-6=34'],
	['56-30-9=26-9=17', '56-36-3=20-3=17']
    ], count = 0;

    function testArray(arr, leftStr) {
	var pattern = "^" + leftStr;
	var re = new RegExp(pattern);
	var ret = 0;
	for (var i = 0; i < arr.length; i++) {
	    if (re.test(arr[i]))
		ret++;
	}
	return ret;
    }

            $('.letterinput').keydown(function(event) {
                if (event.keyCode > 36 && event.keyCode < 41) {
                    return false;
                }
            }
        );

    $("input").each(function () {
	var readOnly = $(this)[0].readOnly;
	if (!readOnly)
	    $(this).val('');
    });

    $(".letterinput").keyup(function () {
	var str = $(this).val().toLowerCase().trim();
	var repSpace = str.replace(' ', '');
	var type = $(this).data('type');

	$(this).val(repSpace);
	if (testArray(accept[type], str) !== 0) {
	    var maxlength = parseInt($(this).attr('maxlength'));

	    $(this).css('color', 'green');
	    if (str.length === maxlength) {
		var index = accept[type].indexOf(str);

		$(this).attr('disabled', true);
		accept[type].splice(index, 1);
		count++;
		$('.haslo span:nth-child(' + count + ')').css('visibility', 'visible');
		$('#jplayer_well').jPlayer('play');
		if (count === 6) {
		    $('.haslo').css('background-color', '#1CA662');
		    $('input').css('background-color', '#FEEAD1');
		}
	    }
	} else {
	    $('#jplayer_wrong').jPlayer('play');
	    $(this).css('color', 'red');
	}
    });

});