-- phpMyAdmin SQL Dump
-- version 4.1.8deb0.1
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Generation Time: 31 Lip 2015, 11:12
-- Server version: 5.5.29-0ubuntu0.12.04.1
-- PHP Version: 5.3.10-1ubuntu3.16

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `hotelstars`
--

DELIMITER $$
--
-- Procedury
--
CREATE DEFINER=`hotel`@`%` PROCEDURE `add_to_categories`(
      IN _user_id BIGINT,
      IN _internal_messages_ids VARCHAR(8000),
      IN _internal_categories_ids VARCHAR(8000)
)
BEGIN
  
  DECLARE _internal_message_id VARCHAR(64);
  DECLARE _internal_category_id VARCHAR(64);
  DECLARE _loop1 INT;
  DECLARE _loop2 INT;
  SET @str_insert = '';

  START TRANSACTION;

  SET _loop1 = 1;

  LOOP1: loop
    SET _loop2 = 1;

    SELECT split_str(_internal_messages_ids,',',_loop1) INTO _internal_message_id;

    IF _internal_message_id IS NULL OR _internal_message_id = '' THEN
      LEAVE LOOP1;
    END IF;

    LOOP2: loop
      SELECT split_str(_internal_categories_ids,',',_loop2) INTO _internal_category_id;

      IF _internal_category_id IS NULL OR _internal_category_id = '' THEN
        LEAVE LOOP2;
      END IF;

      DELETE FROM internal_message_category WHERE user_id=_user_id AND internal_message_id=_internal_message_id AND internal_category_id=_internal_category_id;
      SET @str_insert = CONCAT (@str_insert, ',(', _user_id, ', ', _internal_message_id, ', ', _internal_category_id, ')' );

      SET _loop2 = _loop2 + 1;
    END LOOP LOOP2;

    SET _loop1 = _loop1 + 1;
  END LOOP LOOP1;

  SET @str_insert = SUBSTRING(@str_insert, 2);
  IF (@str_insert <> '') THEN
      SET @str_insert = CONCAT ('INSERT INTO internal_message_category(user_id, internal_message_id, internal_category_id) VALUES ', @str_insert);
      PREPARE stmt1 FROM @str_insert;
      EXECUTE stmt1;
   END IF;

  COMMIT;
END$$

CREATE DEFINER=`hotel`@`%` PROCEDURE `add_user_tag`(
      IN _user_tag_name VARCHAR(250),
      IN _user_email VARCHAR(255),
      IN _user_tag_description VARCHAR(2000)
)
BEGIN
  DECLARE _user_tag_id BIGINT;
  DECLARE _guard_user_id BIGINT;
  DECLARE _newsletter_user_id BIGINT;
  DECLARE _tmp_id BIGINT;
  
  
  START TRANSACTION;

  SELECT id FROM user_tag WHERE name=  _user_tag_name INTO _user_tag_id;

  IF _user_tag_id is null THEN
    INSERT INTO user_tag VALUES (NULL, _user_tag_name,_user_tag_description);
    SELECT LAST_INSERT_ID() INTO _user_tag_id;
  END IF;

  SELECT id FROM sf_guard_user WHERE email_address=  _user_email INTO _guard_user_id;
  
  IF _guard_user_id IS NOT null THEN    
    SET _tmp_id = NULL;
    select id from guard_user_tag where user_id=_guard_user_id AND user_tag_id = _user_tag_id INTO _tmp_id;
    IF _tmp_id IS null THEN    
      INSERT INTO guard_user_tag (id,user_id, user_tag_id,created_at,updated_at,deleted_at) 
        VALUES (NULL, _guard_user_id, _user_tag_id,now(),now(),NULL);
    ELSE
      UPDATE guard_user_tag SET updated_at=now(), deleted_at=NULL WHERE id = _tmp_id;
    END IF;
  END IF;
  
  SELECT id FROM newsletter_user WHERE email=  _user_email INTO _newsletter_user_id;
  IF _newsletter_user_id IS NOT null THEN    
    SET _tmp_id = NULL;
    select id from newsletter_user_tag where newsletter_user_id=_newsletter_user_id AND user_tag_id = _user_tag_id INTO _tmp_id;
    IF _tmp_id IS null THEN    
      INSERT INTO newsletter_user_tag (id,newsletter_user_id, user_tag_id,created_at,updated_at,deleted_at) 
        VALUES (NULL, _newsletter_user_id, _user_tag_id,now(),now(),NULL);
    ELSE
      UPDATE newsletter_user_tag SET updated_at=now(), deleted_at=NULL WHERE id = _tmp_id;
    END IF;
  END IF;
  
  

  COMMIT;

END$$

CREATE DEFINER=`hotel`@`%` PROCEDURE `move_to_categories`(
      IN _user_id BIGINT,
      IN _internal_messages_ids VARCHAR(8000),
      IN _internal_categories_ids VARCHAR(8000),
      IN _old_category_id INT
)
BEGIN

  START TRANSACTION;

  SET @delete = CONCAT ('DELETE FROM internal_message_category WHERE user_id=', _user_id);
  SET @delete = CONCAT (@delete, ' AND internal_message_id IN (', _internal_messages_ids,') AND internal_category_id=', _old_category_id);
  PREPARE stmt1 FROM @delete;
  EXECUTE stmt1;

  call add_to_categories(_user_id, _internal_messages_ids, _internal_categories_ids);

  COMMIT;

END$$

CREATE DEFINER=`hotel`@`%` PROCEDURE `remove_user_tag`(
      IN _user_tag_name VARCHAR(250),
      IN _user_email VARCHAR(255)
)
BEGIN
  DECLARE _user_tag_id BIGINT;
  DECLARE _guard_user_id BIGINT;
  DECLARE _newsletter_user_id BIGINT;
  
  START TRANSACTION;

  SELECT id FROM user_tag WHERE name=  _user_tag_name INTO _user_tag_id;

  IF _user_tag_id IS NOT null THEN

    SELECT id FROM sf_guard_user WHERE email_address=  _user_email INTO _guard_user_id;

    IF _guard_user_id IS NOT null THEN    
      UPDATE guard_user_tag SET deleted_at=NOW() WHERE user_id=_guard_user_id AND user_tag_id = _user_tag_id;
    END IF;

    SELECT id FROM newsletter_user WHERE email=  _user_email INTO _newsletter_user_id;
    IF _newsletter_user_id IS NOT null THEN    
      UPDATE newsletter_user_tag SET deleted_at=NOW() WHERE newsletter_user_id=_newsletter_user_id AND user_tag_id = _user_tag_id;
    END IF;

  END IF;
 
  COMMIT;

END$$

CREATE DEFINER=`hotel`@`%` PROCEDURE `send_newsletter_to_database`(
      IN _message_center_id BIGINT,
      IN _max_message_count INT,
      IN _number_of_emails_to_send INT
)
BEGIN
  START TRANSACTION;

  SET @_st = CONCAT('CREATE TEMPORARY TABLE  temp_users (id bigint(20), PRIMARY KEY (`id`)) AS SELECT id FROM newsletter_user where status = 2 AND message_count <= ',_max_message_count,' 
          ORDER BY id LIMIT ', _number_of_emails_to_send);
  PREPARE stmt FROM @_st; 
  EXECUTE stmt;
  DEALLOCATE PREPARE stmt;

  UPDATE newsletter_user nu join temp_users t on t.id=nu.id SET nu.status = 4;
  
  INSERT INTO message_multisend_list 
      SELECT NULL, _message_center_id, 3, NULL, nu.id, now(), now() FROM newsletter_user nu join temp_users t on t.id=nu.id;

  COMMIT;

END$$

CREATE DEFINER=`hotel`@`%` PROCEDURE `send_newsletter_to_list`(
      IN _message_center_id BIGINT,
      IN _max_message_count INT,
      IN _emails_list varchar(21000)
)
BEGIN
  START TRANSACTION;
  CREATE TEMPORARY TABLE  temp_emails (email varchar(255), UNIQUE KEY (`email`))ENGINE=InnoDB  DEFAULT CHARSET=utf8;

  SET @_st = CONCAT('INSERT INTO temp_emails values ', _emails_list);
  PREPARE stmt FROM @_st; 
  EXECUTE stmt;
  DEALLOCATE PREPARE stmt;

  
  CREATE TEMPORARY TABLE  temp_emails_2 (email varchar(255), UNIQUE KEY (`email`)) AS SELECT t.email FROM temp_emails t 
      LEFT OUTER JOIN newsletter_user nu on t.email=nu.email WHERE nu.email IS NULL;
  
  INSERT INTO newsletter_user (email,first_name,last_name,status,created_at,updated_at) SELECT email,"","",3,now(),now() FROM temp_emails_2;


  
  
  CREATE TEMPORARY TABLE  temp_users (id bigint(20), PRIMARY KEY (`id`)) AS SELECT u.id FROM sf_guard_user u join temp_emails e on e.email = u.email_address 
      LEFT OUTER JOIN newsletter_user nu ON nu.user_id = u.id WHERE nu.user_id IS NULL;
  
  UPDATE newsletter_user nu JOIN sf_guard_user u ON u.email_address = nu.email SET nu.user_id = u.id, nu.first_name = u.first_name,nu.last_name = u.last_name WHERE nu.user_id IS NULL;
  
  IF _max_message_count >= 0 THEN
    INSERT INTO message_multisend_list 
      SELECT NULL, _message_center_id, 3, NULL, nu.id, now(), now() FROM newsletter_user nu join temp_emails t on t.email=nu.email WHERE nu.message_count <= _max_message_count;
  ELSE
    INSERT INTO message_multisend_list 
      SELECT NULL, _message_center_id, 3, NULL, nu.id, now(), now() FROM newsletter_user nu join temp_emails t on t.email=nu.email;
  END IF;

  COMMIT;

END$$

CREATE DEFINER=`hotel`@`%` PROCEDURE `set_article_order`(
      IN category_id VARCHAR(1000), 
      IN article_id INT(11) 
)
BEGIN
   DECLARE _query VARCHAR(2300);  

   START TRANSACTION;

   DROP TABLE IF EXISTS article_temporary_order;

   SET @_query = CONCAT('CREATE TABLE article_temporary_order AS SELECT max(b.order)+1 AS o, b.category_id AS c FROM article_article_category b WHERE b.category_id IN (', category_id ,');');
   
   PREPARE stmt FROM @_query; 
   EXECUTE stmt;
   DEALLOCATE PREPARE stmt;

   SET _query = CONCAT('UPDATE article_article_category a JOIN article_temporary_order ON article_temporary_order.c=a.category_id SET a.order = article_temporary_order.o WHERE a.category_id IN (', category_id ,') AND a.article_id=',article_id);

   SET @_query = _query;

   PREPARE stmt FROM @_query; 
   EXECUTE stmt;
   DEALLOCATE PREPARE stmt;

   COMMIT;
END$$

CREATE DEFINER=`hotel`@`%` PROCEDURE `sync_user_tag`(
      IN _user_email VARCHAR(255)
)
BEGIN
  DECLARE _user_tag_id BIGINT;
  DECLARE _guard_user_id BIGINT;
  DECLARE _newsletter_user_id BIGINT;
  
  START TRANSACTION;

  

  SELECT id FROM sf_guard_user WHERE email_address=  _user_email INTO _guard_user_id;
  SELECT id FROM newsletter_user WHERE email=  _user_email INTO _newsletter_user_id;
  
  IF _guard_user_id IS NOT null AND _newsletter_user_id IS NOT null THEN   
    INSERT INTO guard_user_tag (id,user_id, user_tag_id,created_at,updated_at,deleted_at) 
      SELECT gut.id, _guard_user_id, nut.user_tag_id, now(),now(), NULL FROM 
          (SELECT * FROM newsletter_user_tag WHERE newsletter_user_id = _newsletter_user_id AND deleted_at IS NULL) nut 
          LEFT OUTER JOIN (SELECT * FROM guard_user_tag WHERE user_id = _guard_user_id) gut ON gut.user_tag_id=nut.user_tag_id
        WHERE (gut.user_id = _guard_user_id OR gut.user_id IS NULL) AND nut.newsletter_user_id = _newsletter_user_id 
      ON DUPLICATE KEY UPDATE updated_at=now(), deleted_at=NULL;

    INSERT INTO newsletter_user_tag (id,newsletter_user_id, user_tag_id,created_at,updated_at,deleted_at) 
      SELECT nut.id, _newsletter_user_id, gut.user_tag_id, now(),now(), NULL FROM 
        (SELECT * FROM guard_user_tag WHERE user_id = _guard_user_id AND deleted_at IS NULL) gut 
        LEFT OUTER JOIN (SELECT * FROM newsletter_user_tag WHERE newsletter_user_id = _newsletter_user_id ) nut ON gut.user_tag_id=nut.user_tag_id
        WHERE (nut.newsletter_user_id = _newsletter_user_id OR nut.newsletter_user_id IS NULL) AND gut.user_id = _guard_user_id 
      ON DUPLICATE KEY UPDATE updated_at=now(), deleted_at=NULL;

   
  END IF;
  
  
  
 
  COMMIT;

END$$

--
-- Funkcje
--
CREATE DEFINER=`hotel`@`%` FUNCTION `article_flash_get_position`(_unique_name VARCHAR(100), _slug VARCHAR(255), _lang CHAR(2) ) RETURNS int(11)
    DETERMINISTIC
BEGIN
    DECLARE _rank INT;
   
    SET @rownum := 0; 
    set _rank = 0;
    select b.rank 
        from ( select @rownum := @rownum+1 AS rank, a.id, a.slug, a.name, a.title 
            from ( SELECT  `a`.`id` AS id, a4.slug as slug, `a2`.`unique_name` AS name,  `a4`.`title` AS title 
                FROM `article` `a` 
                LEFT JOIN `article_article_category` `a3` ON (`a`.`id` = `a3`.`article_id`) 
                LEFT JOIN `article_category` `a2` ON `a2`.`id` = `a3`.`category_id` 
                LEFT JOIN `article_translation` `a4` ON `a`.`id` = `a4`.`id` 
                AND (`a4`.`lang` = _lang) 
                WHERE  (`a2`.`unique_name` = _unique_name AND `a`.`is_displayed` = '1') 
                ORDER BY `a3`.`order` ASC ) a
        ) b 
    where b.slug = _slug LIMIT 1 INTO _rank;
     
    RETURN _rank;
  END$$

CREATE DEFINER=`hotel`@`%` FUNCTION `levenshtein`( s1 VARCHAR(255), s2 VARCHAR(255) ) RETURNS int(11)
    DETERMINISTIC
BEGIN
    DECLARE s1_len, s2_len, i, j, c, c_temp, cost INT;
    DECLARE s1_char CHAR;
    DECLARE cv0, cv1 VARBINARY(256);
    SET s1_len = CHAR_LENGTH(s1), s2_len = CHAR_LENGTH(s2), cv1 = 0x00, j = 1, i = 1, c = 0;
    IF s1 = s2 THEN
      RETURN 0;
    ELSEIF s1_len = 0 THEN
      RETURN s2_len;
    ELSEIF s2_len = 0 THEN
      RETURN s1_len;
    ELSE
      WHILE j <= s2_len DO
        SET cv1 = CONCAT(cv1, UNHEX(HEX(j))), j = j + 1;
      END WHILE;
      WHILE i <= s1_len DO
        SET s1_char = SUBSTRING(s1, i, 1), c = i, cv0 = UNHEX(HEX(i)), j = 1;
        WHILE j <= s2_len DO
          SET c = c + 1;
          IF s1_char = SUBSTRING(s2, j, 1) THEN 
            SET cost = 0; ELSE SET cost = 1;
          END IF;
          SET c_temp = CONV(HEX(SUBSTRING(cv1, j, 1)), 16, 10) + cost;
          IF c > c_temp THEN SET c = c_temp; END IF;
            SET c_temp = CONV(HEX(SUBSTRING(cv1, j+1, 1)), 16, 10) + 1;
            IF c > c_temp THEN 
              SET c = c_temp; 
            END IF;
            SET cv0 = CONCAT(cv0, UNHEX(HEX(c))), j = j + 1;
        END WHILE;
        SET cv1 = cv0, i = i + 1;
      END WHILE;
    END IF;
    RETURN c;
  END$$

CREATE DEFINER=`hotel`@`%` FUNCTION `split_str`(
  x TEXT,
  delim VARCHAR(12),
  pos INT
) RETURNS varchar(255) CHARSET latin1
RETURN REPLACE(SUBSTRING(SUBSTRING_INDEX(x, delim, pos),
       LENGTH(SUBSTRING_INDEX(x, delim, pos -1)) + 1),
       delim, '')$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `article`
--

CREATE TABLE IF NOT EXISTS `article` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `creator_id` bigint(20) NOT NULL,
  `editor_id` bigint(20) DEFAULT NULL,
  `layout_id` int(11) DEFAULT NULL,
  `unique_name` varchar(100) DEFAULT NULL,
  `is_displayed` tinyint(4) DEFAULT '1',
  `start_at` datetime DEFAULT NULL,
  `expire_at` datetime DEFAULT NULL,
  `flag` mediumtext,
  `title_image` varchar(255) DEFAULT NULL,
  `title_image_label` varchar(255) DEFAULT NULL,
  `big_image` varchar(255) DEFAULT NULL,
  `views` int(11) DEFAULT NULL,
  `vote_sum` float(18,2) DEFAULT NULL,
  `vote_count` int(11) DEFAULT NULL,
  `source` text,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_article_sf_guard_user_idx` (`creator_id`),
  KEY `fk_article_sf_guard_user1_idx` (`editor_id`),
  KEY `fk_article_layout1_id` (`layout_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=64 ;

--
-- Zrzut danych tabeli `article`
--

INSERT INTO `article` (`id`, `creator_id`, `editor_id`, `layout_id`, `unique_name`, `is_displayed`, `start_at`, `expire_at`, `flag`, `title_image`, `title_image_label`, `big_image`, `views`, `vote_sum`, `vote_count`, `source`, `created_at`, `updated_at`) VALUES
(1, 2, 2, 1, 'badanie_marketingowe_popyt_standard', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(2, 2, 2, 1, 'runda-16', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(4, 2, 2, 1, 'kierowniczka', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(5, 2, 2, 1, 'mikolajkowy-eskpres', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(7, 2, 2, 1, 'panele-sloneczne', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(8, 2, 2, 1, 'podwyzka-placy-minimalnych', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(9, 2, 2, 1, 'podwyzka-placy-sredniej', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(10, 2, 2, 1, 'pralnia-ekologiczna', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(12, 2, 2, 1, 'stop-umowom-smieciowym', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(13, 2, 2, 1, 'szkolenie', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(14, 2, 2, 1, 'zimowisko', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(15, 2, 2, 1, 'runda-1', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(16, 2, 2, 1, 'runda-2', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(17, 2, 2, 1, 'runda-3', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(18, 2, 2, 1, 'runda-4', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(19, 2, 2, 1, 'runda-5', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(20, 2, 2, 1, 'runda-6', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(21, 2, 2, 1, 'runda-7', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(22, 2, 2, 1, 'runda-8', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(23, 2, 2, 1, 'runda-10', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(24, 2, 2, 1, 'runda-9', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(25, 2, 2, 1, 'runda-11', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(26, 2, 2, 1, 'runda-12', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(27, 2, 2, 1, 'runda-13', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(28, 2, 2, 1, 'runda-14', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(29, 2, 2, 1, 'runda-15', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(31, 2, 2, 1, 'badanie_marketingowe_uslugi_podstawowe', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(32, 2, 2, 1, 'badanie_marketingowe_sezonowosc', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(34, 2, 2, 1, 'badanie_marketingowe_popyt_lux', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(35, 2, 2, 1, 'urzad-pracy-informacje', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(36, 2, 2, 1, 'urzad-pracy-stawki-plac', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(37, 2, 2, 1, 'badanie_marketingowe_reklama_zaawansowana', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(38, 2, 2, 1, 'badanie_marketingowe_konkurencja', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(39, 2, 2, 1, 'badanie_marketingowe_uslugi_zaawansowane_segmentacja', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(40, 2, 2, 1, 'sniadania', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(41, 2, 2, 1, 'grupy-klientow', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(42, 2, 2, 1, 'podjazd-dla-niepelnosprawnych', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(43, 2, 2, 1, 'brak-pokoi', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(45, 2, 2, 1, 'kredyt-karny', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(46, 2, 2, 1, 'zaciekly-konkurent', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(47, 2, 2, 1, 'projekty-wladz-samorzadowych', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(48, 2, 2, 1, 'uwaga-badanie-marketingowe-uslugi-podstawowe', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(49, 2, 2, 1, 'uwaga-badanie-marketingowe-sezonowosc', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(50, 2, 2, 1, 'uwaga-badanie-marketingowe-popyt-lux', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(51, 2, 2, 1, 'uwaga-badanie-marketingowe-reklama-zaawansowana', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(52, 2, 2, 1, 'uwaga-badanie-marketingowe-konkurencja', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(53, 2, 2, 1, 'uwaga-badanie-marketingowe-uslugi-zaawansowane-segmentacja', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(59, 2, 2, 1, 'cena-zero-standard', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(60, 2, 2, 1, 'cena-zero-lux', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(61, 2, 2, 1, 'akcja-charytatywna', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(63, 2, 2, 1, 'przykladowe-loga', 1, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, '', '2015-07-31 11:02:42', '2015-07-31 11:02:42');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `article_article_blog_category`
--

CREATE TABLE IF NOT EXISTS `article_article_blog_category` (
  `article_blog_category_id` int(11) NOT NULL DEFAULT '0',
  `article_id` int(11) NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`article_blog_category_id`,`article_id`),
  KEY `fk_article_article_blog_category_article_blog_category_idx` (`article_blog_category_id`),
  KEY `fk_article_article_blog_category_article1_idx` (`article_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `article_article_category`
--

CREATE TABLE IF NOT EXISTS `article_article_category` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `article_id` int(11) DEFAULT NULL,
  `subcategory_id` int(11) DEFAULT NULL,
  `order` int(11) NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_article_category_category1_idx` (`category_id`),
  KEY `fk_article_category_article1_idx` (`article_id`),
  KEY `fk_article_category_category2_idx` (`subcategory_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=45 ;

--
-- Zrzut danych tabeli `article_article_category`
--

INSERT INTO `article_article_category` (`id`, `category_id`, `article_id`, `subcategory_id`, `order`, `created_at`, `updated_at`) VALUES
(4, 1, 5, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(6, 1, 7, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(7, 1, 8, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(8, 1, 9, NULL, 5, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(9, 1, 10, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(11, 1, 12, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(12, 1, 13, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(13, 1, 14, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(14, 1, 32, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(16, 1, 40, NULL, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(17, 1, 42, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(18, 1, 43, NULL, 4, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(20, 2, 15, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(21, 2, 16, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(22, 2, 17, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(23, 2, 18, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(24, 2, 19, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(25, 2, 20, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(26, 2, 21, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(27, 2, 22, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(28, 2, 23, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(29, 2, 24, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(30, 2, 25, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(31, 2, 26, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(32, 2, 27, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(33, 2, 28, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(34, 2, 29, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(36, 2, 31, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(37, 2, 34, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(38, 2, 37, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(39, 2, 38, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(40, 2, 39, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(41, 3, 35, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(42, 3, 36, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(43, 3, 41, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(44, 2, 2, NULL, 0, '2015-07-31 11:02:42', '2015-07-31 11:02:42');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `article_article_tag`
--

CREATE TABLE IF NOT EXISTS `article_article_tag` (
  `article_id` int(11) NOT NULL DEFAULT '0',
  `tag_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`article_id`,`tag_id`),
  KEY `fk_article_tag_article1_idx` (`article_id`),
  KEY `fk_article_tag_tag1_idx` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `article_blog_category`
--

CREATE TABLE IF NOT EXISTS `article_blog_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `article_blog_category_translation`
--

CREATE TABLE IF NOT EXISTS `article_blog_category_translation` (
  `id` int(11) NOT NULL DEFAULT '0',
  `name` text,
  `lang` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`lang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `article_category`
--

CREATE TABLE IF NOT EXISTS `article_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title_image` varchar(255) DEFAULT NULL,
  `unique_name` varchar(100) DEFAULT NULL,
  `is_displayed` int(11) DEFAULT NULL,
  `layout_id` int(11) DEFAULT NULL,
  `image_count` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Zrzut danych tabeli `article_category`
--

INSERT INTO `article_category` (`id`, `title_image`, `unique_name`, `is_displayed`, `layout_id`, `image_count`) VALUES
(1, NULL, 'eventy', NULL, NULL, 1),
(2, NULL, 'wiadomosci', NULL, NULL, 1),
(3, NULL, 'artykuly', NULL, NULL, 1);

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `article_category_translation`
--

CREATE TABLE IF NOT EXISTS `article_category_translation` (
  `id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL,
  `description` text,
  `slug` varchar(500) DEFAULT NULL,
  `lang` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`lang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Zrzut danych tabeli `article_category_translation`
--

INSERT INTO `article_category_translation` (`id`, `name`, `description`, `slug`, `lang`) VALUES
(1, 'Events', '', NULL, 'en'),
(1, 'Eventy', '', NULL, 'pl'),
(2, 'Wiadomości', '', NULL, 'pl'),
(3, 'Artykuły', '', NULL, 'pl');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `article_comment`
--

CREATE TABLE IF NOT EXISTS `article_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `article_id` int(11) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `parent_article_comment_id` int(11) DEFAULT NULL,
  `text` mediumtext NOT NULL,
  `display` tinyint(1) NOT NULL DEFAULT '1',
  `nick` varchar(100) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `www` varchar(255) DEFAULT NULL,
  `gg` varchar(45) DEFAULT NULL,
  `notify` tinyint(1) DEFAULT '0',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_article_comment_article1_idx` (`article_id`),
  KEY `fk_article_comment_sf_guard_user1_idx` (`user_id`),
  KEY `fk_article_comment_article_comment1_idx` (`parent_article_comment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `article_file`
--

CREATE TABLE IF NOT EXISTS `article_file` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `article_id` int(11) NOT NULL,
  `file` text NOT NULL,
  `original_filename` text NOT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `order` int(11) DEFAULT '0',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_article_file_article1_idx` (`article_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `article_file_translation`
--

CREATE TABLE IF NOT EXISTS `article_file_translation` (
  `id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `description` mediumtext,
  `lang` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`lang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `article_group`
--

CREATE TABLE IF NOT EXISTS `article_group` (
  `article_id` int(11) NOT NULL DEFAULT '0',
  `group_id` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`article_id`,`group_id`),
  KEY `fk_article_group_article1_idx` (`article_id`),
  KEY `fk_article_group_sf_guard_group1_idx` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `article_index`
--

CREATE TABLE IF NOT EXISTS `article_index` (
  `keyword` varchar(200) NOT NULL DEFAULT '',
  `field` varchar(50) NOT NULL DEFAULT '',
  `position` bigint(20) NOT NULL DEFAULT '0',
  `id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`keyword`,`field`,`position`,`id`),
  KEY `article_index_id_article_id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `article_permission`
--

CREATE TABLE IF NOT EXISTS `article_permission` (
  `article_id` int(11) NOT NULL DEFAULT '0',
  `permission_id` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`article_id`,`permission_id`),
  KEY `fk_article_permission_article1_idx` (`article_id`),
  KEY `fk_article_permission_sf_guard_permission1_idx` (`permission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `article_photo`
--

CREATE TABLE IF NOT EXISTS `article_photo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `article_id` int(11) NOT NULL,
  `original_image` varchar(100) DEFAULT NULL,
  `small_image` varchar(100) DEFAULT NULL,
  `medium_image` varchar(100) DEFAULT NULL,
  `big_image` varchar(100) DEFAULT NULL,
  `order` int(11) DEFAULT '1',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_article_photo_article1_idx` (`article_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Zrzut danych tabeli `article_photo`
--

INSERT INTO `article_photo` (`id`, `article_id`, `original_image`, `small_image`, `medium_image`, `big_image`, `order`, `created_at`, `updated_at`) VALUES
(2, 63, 'logo1.png', 'logo1.png', 'logo1.png', 'logo1.png', 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(3, 63, 'logo2.png', 'logo2.png', 'logo2.png', 'logo2.png', 2, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(4, 63, 'logo3.png', 'logo3.png', 'logo3.png', 'logo3.png', 3, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(5, 63, 'logo4.png', 'logo4.png', 'logo4.png', 'logo4.png', 4, '2015-07-31 11:02:42', '2015-07-31 11:02:42');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `article_photo_translation`
--

CREATE TABLE IF NOT EXISTS `article_photo_translation` (
  `id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `description` mediumtext,
  `lang` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`lang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Zrzut danych tabeli `article_photo_translation`
--

INSERT INTO `article_photo_translation` (`id`, `title`, `description`, `lang`) VALUES
(2, '', NULL, 'pl'),
(3, '', NULL, 'pl'),
(4, '', NULL, 'pl'),
(5, '', NULL, 'pl');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `article_preferred_article`
--

CREATE TABLE IF NOT EXISTS `article_preferred_article` (
  `article_id` int(11) NOT NULL DEFAULT '0',
  `preferred_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`article_id`,`preferred_id`),
  KEY `fk_preferred_article_article1_idx` (`article_id`),
  KEY `fk_preferred_article_article2_idx` (`preferred_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `article_tag`
--

CREATE TABLE IF NOT EXISTS `article_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `article_tag_translation`
--

CREATE TABLE IF NOT EXISTS `article_tag_translation` (
  `id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL,
  `lang` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`lang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `article_temporary_order`
--

CREATE TABLE IF NOT EXISTS `article_temporary_order` (
  `o` bigint(12) DEFAULT NULL,
  `c` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Zrzut danych tabeli `article_temporary_order`
--

INSERT INTO `article_temporary_order` (`o`, `c`) VALUES
(5, 1);

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `article_translation`
--

CREATE TABLE IF NOT EXISTS `article_translation` (
  `id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  `short_description` text,
  `meta_title` varchar(255) DEFAULT NULL,
  `meta_description` text,
  `meta_keywords` text,
  `lang` char(2) NOT NULL DEFAULT '',
  `slug` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`,`lang`),
  UNIQUE KEY `article_translation_sluggable_idx` (`slug`,`lang`,`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Zrzut danych tabeli `article_translation`
--

INSERT INTO `article_translation` (`id`, `title`, `description`, `short_description`, `meta_title`, `meta_description`, `meta_keywords`, `lang`, `slug`) VALUES
(1, 'Badanie marketingowe - charakterystyka rynku hotelarskiego w Pekunii', '<p>Badanie rynku hotelarskiego w Pekunii dobiegło końca. Na jego podstawie przygotowaliśmy prognozę popytu na usługę, którą będą Państwo świadczyć. Z naszych analiz wynika, że w przeciągu najbliższych miesięcy nastąpi wzrost zapotrzebowania na usługi hotelarskie. Jest to efekt inwestycji, które realizuje Ratusz; już niedługo zakończy się renowacja takich atrakcji turystycznych jak Amfiteatr z XVII wieku oraz Katedra Gotycka ze schyłku XVI wieku. Ponadto kończy się budowa Muzeum Gier Komputerowych a Miejski Ośrodek Kultury zaplanował wiele wyjątkowych wydarzeń kulturalnych. Te działania przyczynią się do przyciągnięcia licznych turystów i gości spoza miasta. Prawdopodobnie większość z nich będzie szukać noclegu.</p>\r\n\r\n<p>Poniżej przedstawiamy wykresy popytu na usługi hotelowe w różnych lokalizacjach. Na ich podstawie można oszacować jaki popyt może być osiągnięty przy danej cenie. Należy pamiętać, iż badania zostały przeprowadzone z założeniem, że oferta hotelu będzie optymalnie dostosowana do potrzeb klienta. Należy również pamiętać, że koszty prowadzenia działalności różnią się w zależności od wybranej lokalizacji. Wpływa na to przede wszystkim koszt wynajmowanej powierzchni, dlatego utrzymanie tej samej liczby pokoi w centrum będzie najdroższe a na przedmieściach najtańsze.</p>\r\n\r\n<p>Wybierz mądrze. Raz wybranej lokalizacji nie będzie już można zmienić!</p>\r\n\r\n<p style="text-align:center"><img alt="" src="/images/kfm_images/popyt_standard_0.jpg" style="box-shadow:1px 1px 1px silver; display:inline; width:700px" /></p>\r\n\r\n<p style="text-align:center"><img alt="" src="/images/kfm_images/popyt_standard_1.jpg" style="box-shadow:1px 1px 1px silver; display:inline; width:700px" /></p>\r\n\r\n<p style="text-align:center"><img alt="" src="/images/kfm_images/popyt_standard_2.jpg" style="box-shadow:1px 1px 1px silver; display:inline; width:700px" /></p>\r\n\r\n<p style="text-align:center"><img alt="" src="/images/kfm_images/popyt_standard_3.jpg" style="box-shadow:1px 1px 1px silver; display:inline; width:700px" /></p>\r\n', '', '', '', '', 'pl', 'badanie-marketingowe-charakterystyka-rynku-hotelarskiego-w-pekunii'),
(2, 'Gratulacje - to już koniec!', '<p>Gratulujemy ukończenia gry Hotel Stars!</p>\r\n\r\n<p>Zapoznaj się ze swoimi wynikami przeglądając raporty, oraz sprawdź jak wygląda ranking końcowy. Czy zajeliście pierwsze miejsce?</p>\r\n', '', '', '', '', 'pl', 'gratulacje-to-juz-koniec'),
(4, 'Propozycja usługi', '<p>OD: jarzabek.anna@poczta.pl</p>\r\n\r\n<p>DO: hotel@pekunia.pl</p>\r\n\r\n<p>Temat: Propozycja współpracy.</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>Witam!</p>\r\n\r\n<p>Nazywam się Anna Jarząbek i jestem profesjonalną doradczynią do spraw motywowania oraz szkolenia kadry pracowniczej. Wiele słyszałam o Waszej firmie i muszę przyznać, że dostrzegam w niej duży potencjał. Uważam jednak, że Państwa system szkolenia pracowników oraz poziom ich motywacji do pracy pozostawia wiele do życzenia. Jest to duże marnotrawstwo, gdyż pracownicy Waszego hotelu nie wykorzystują w pełni swoich możliwości. Chciałabym Państwu zaoferować moje skromne usługi. Jestem w stanie doprowadzić w ciągu jednego kwartału m.in. do: usprawnienia pracy zespołowej, stworzenia programu hierarchizacji pracowników oraz do wprowadzenia systemu szkolenia pracowników nowych i mniej doświadczonych przez tych, którzy posiadają już staż i doświadczenie (nie tracąc przy tym, na jakości obsługi klientów). &nbsp;Posiadam wieloletnie doświadczenie w tej materii. Gwarantuję znaczną poprawę, jakości obsługi, a przez to poziomu zadowolenia klientów. Pozwoliłam sobie przedstawić Państwu dwa pakiety usług. Pierwszy to propozycja przeprowadzenia szkolenia na poziomie podstawowym, drugi to szkolenie na poziomie zaawansowanym oraz restrukturyzacja systemu zatrudnienia. Ufam, że będzie nam się mile współpracowało.</p>\r\n\r\n<p><em>Pozdrawiam,</em></p>\r\n\r\n<p><em>Anna Jarząbek</em></p>\r\n', '', '', '', '', 'pl', 'propozycja-uslugi'),
(5, 'Mikołajkowy ekspres', '<p style="margin-left:17.85pt;">OD: brodacz.jakub@poczta.pl</p>\r\n\r\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; DO: hotel@pekunia.pl</p>\r\n\r\n<p style="margin-left:17.85pt;">Temat: Mikołajkowy ekspres.</p>\r\n\r\n<p style="margin-left:17.85pt;"><em>Witam Państwa!</em></p>\r\n\r\n<p style="margin-left:17.85pt;"><em>Nazywam się Jakub Brodacz i jestem przedstawicielem fundacji Mikołajowy Ekspres. Jak co roku organizujemy zbiórkę pieniędzy na gwiazdkowe prezenty</em> <em>dla dzieci z </em><em>D</em><em>omów </em><em>D</em><em>ziecka, oraz tych należących do ubogich rodzin. Możecie Państwo sprawić, że w tym szczególnym okresie uśmiech zawita na twarzach potrzebujących. Serdecznie zachęcamy do udziału w naszej akcji. Będziemy niesamowicie wdzięczni za każdą pomoc.</em></p>\r\n\r\n<p style="margin-left:17.85pt;"><em>Serdecznie pozdrawiam,</em></p>\r\n\r\n<p style="margin-left:17.85pt;"><em>Jakub Brodacz</em></p>\r\n', '', '', '', '', 'pl', 'mikolajkowy-ekspres'),
(7, 'Panele słoneczne', '<p><strong>Unia Europejska przychodzi z pomocą wciąż mocno zanieczyszczonemu miastu.</strong></p>\r\n\r\n<p>Kolejnym etapem rozwoju ekologicznych rozwiązań w Pekunii będzie montaż baterii słonecznych w miejscach, gdzie prowadzona jest działalność gospodarcza. Dzięki takiemu rozwiązaniu przedsiębiorcy mogą znacząco obniżyć wydatki na prąd.</p>\r\n\r\n<p>Koszt zamontowania jednego panelu to 30&nbsp;000 PLN. Dotacja z Unii Europejskiej pokryje 75% tych kosztów, co oznacza, że zapłacisz tylko 7&nbsp;500 PLN za panel. Pamiętaj, że panele pozwolą Ci na obniżenie rachunków za prąd o 1&nbsp;000 PLN za każdy zamontowany panel. Czy chcesz dokonać montażu baterii słonecznych w Twoim hotelu?</p>\r\n', '', '', '', '', 'pl', 'panele-sloneczne'),
(8, 'Podwyżka płacy minimalnej', '<p>OD:&nbsp;ratusz@pekunia.org</p>\r\n\r\n<p>DO:&nbsp;hotel@pekunia.org</p>\r\n\r\n<p>Temat: Podwyżka płacy minimalnej</p>\r\n\r\n<p>Szanowni Państwo,</p>\r\n\r\n<p>decyzją parlamentu - podwyższeniu uległy stawki płac minimalnych o 10%. Więcej informacji znajdziecie Państwo w dzisiejszym "Głosie Pekunii". Prosimy o zapoznanie się z nowymi stawkami w Urzędzie Pracy.</p>\r\n\r\n<p>Pozdrawiamy,</p>\r\n\r\n<p>Urząd Miasta Pekunia</p>\r\n', '', '', '', '', 'pl', 'podwyzka-placy-minimalnej'),
(9, 'Wzrost płac średnich', '<p>&nbsp;</p>\r\n\r\n<p>OD: urzad.pracy@pekunia.org</p>\r\n\r\n<p>DO: hotel@pekunia.pl&nbsp;</p>\r\n\r\n<p>Temat: Wzrost płacy średniej – informacje.&nbsp;</p>\r\n\r\n<p>Witam,</p>\r\n\r\n<p>w związku ze wzrostem liczby firm świadczących usługi hotelarskie w Pekunii, nastąpiła znacząca zmiana średniej pensji w tym sektorze. Przeciętny wzrost wynagrodzenia wynosi 30% w stosunku do poprzedniego kwartału. Uprzejmie prosimy o uwzględnienie tej zmiany przy ustalaniu wysokości wynagrodzeń dla Państwa pracowników.</p>\r\n\r\n<p>Z poważaniem,&nbsp;</p>\r\n\r\n<p>K. Adra&nbsp;</p>\r\n\r\n<p>Urząd Pracy w Pekunii</p>\r\n', '', '', '', '', 'pl', 'wzrost-plac-srednich'),
(10, 'Pralnia eko', '<p>W tym kwartale masz możliwość zbudowania pralni ekologicznej w Twoim hotelu oraz wzięcie udziału w programie sortowania śmieci. Dzięki temu, wzrasta jakość oferowanych usług oraz wizerunek firmy, a wraz z nimi popyt na Twoje usługi. Wiąże się to z jednorazowym kosztem inwestycji oraz podwyższeniem Twoich rachunków.</p>\r\n', '', '', '', '', 'pl', 'pralnia-eko'),
(12, 'Stop umowom śmieciowym', '<p>OD: korzen.waclaw@pekunia.gov.pl</p>\r\n\r\n<p>DO: hotel@pekunia.pl</p>\r\n\r\n<p><em>Witam!</em></p>\r\n\r\n<p><em>Jestem przedstawicielem władz terytorialnych i piszę do Państwa z upoważnienia burmistrza naszego miasta. Zwracamy się do Państwa z propozycją wzięcia udziału w akcji, która promuje stosowanie umów o pracę. W zamian za współpracę z nami jesteśmy zgodni promować Państwa firmę, jako przyjazną pracownikom. Ponadto oferujemy umieszczanie loga oraz nazwy Waszego hotelu na naszych stronach internetowych oraz w turystycznych prospektach informacyjnych. W zamian oczekujemy, że co najmniej 70% pracowników Państwa hotelu będzie zatrudnionych na umowę o pracę, na czas nieokreślony oraz, że ten stan nie ulegnie pogorszeniu przez najbliższy rok.</em></p>\r\n\r\n<p><em>Z poważaniem,</em></p>\r\n\r\n<p><em>Wacław Korzeń</em></p>\r\n\r\n<p><em>Asystent Burmistrza </em></p>\r\n', '', '', '', '', 'pl', 'stop-umowom-smieciowym'),
(13, 'Szkolenie', '<p>OD: kadra@up.pekunia.pl</p>\r\n\r\n<p>DO:&nbsp;hotel@peuknia.org</p>\r\n\r\n<p>Temat:&nbsp;Szkolenie</p>\r\n\r\n<p>Sznowni Państwo!</p>\r\n\r\n<p>Na Uniwersytecie w Pekunii organizowane jest szkolenie dla pracowników zajmujących stanowiska administracyjne, zarządzające, recepcyjne oraz księgowe. Jeżeli posiadasz takich pracowników i chcesz zwiększyć ich efektywność, zainwestuj w ich szkolenie.</p>\r\n\r\n<p>Pozdrawiam</p>\r\n\r\n<p>K. Adra</p>\r\n\r\n<p>Urząd Pracy w Pekunii</p>\r\n', '', '', '', '', 'pl', 'szkolenie'),
(14, 'Dom Dziecka.', '<p>Dzień dobry Państwu,</p>\n\n<p>jesteśmy Domem Dziecka, który funkcjonuje w Pekunii od dziesiątków lat. Mamy pod swoją opieką około pięćdziesięciu wychowanków. Obecnie poszukujemy środków finansowych, które mogłyby posłużyć jako dofinansowanie wyjazdu naszych podopiecznych w góry, na obóz narciarski.</p>\n\n<p>Jeżeli chcieliby Państwo pomóc i uszczęśliwić naszych wychowanków, prosilibyśmy o zaznaczenie odpowiedzi „Tak” na formularzu.</p>\n\n<p>Z wyrazami szacunku,</p>\n\n<p>Dom Dziecka w Pekunii</p>\n', '', '', '', '', 'pl', 'dom-dziecka'),
(15, 'Głos Pekunii #1', '<p><strong>Już niedługo I Festiwal Filmów i Filmików! </strong></p>\r\n\r\n<p>Nasze miasto już wkrótce stanie się światową stolicą filmu! W przyszłym kwartale rozpoczyna się I Festiwal Filmów i Filmików. Swoją obecność na festiwalu potwierdzili znani aktorzy polskich superprodukcji, wielokrotnie nagradzani reżyserzy, scenarzyści oraz operatorzy. <span style="text-align: justify;">Wyjątkowość festiwalu zapewnią także tzw. gwiazdy internetu, czyli ludzie, którzy zdobyli masową popularność dzięki filmom umieszczanym w internecie.</span>&nbsp;Według naszych informacji, większość celebrytów spędzi tych kilka festiwalowych dni w najlepszych hotelach naszego miasta. &nbsp;Ratusz, który spodziewa się napływu miłośników filmu z całej Polski, rozpoczął już przygotowania związane z organizacją wydarzenia. Zapewnia również&nbsp; wsparcie dla organizatorów&nbsp;i uczestników I Festiwalu Filmu i Filmików.</p>\r\n\r\n<p><strong>Zakaz topienia marzanny w rzece.</strong></p>\r\n\r\n<p>Ratusz wraz z Komendą Policji zawiadomiły, że w trosce o środowisko, podniosły prawie trzykrotnie kary dla osób myjących swoje auta nad rzeką oraz kary dla firm, które odprowadzają bezpośrednio do niej ścieki. Ponadto wprowadzony został całkowity zakaz wrzucania do rzeki przedmiotów wykonanych z tworzyw sztucznych. Czy oznacza to, że już nigdy nie będziemy mogli powitać wiosny w mieście Pekunia topieniem marzanny? Na szczęście pozostają nam wszystkie tradycyjne, ekologiczne metody.</p>\r\n', '', '', '', '', 'pl', 'glos-pekunii-1'),
(16, 'Głos Pekunii #2', '<p><strong>WAŻNE! </strong></p>\r\n\r\n<p><strong>Rosną ceny wody. Czy to już czas, żeby zacząć kopać studnie?!&nbsp;</strong></p>\r\n\r\n<p>Władze miasta przygotowały dla nas kolejną „niespodziankę”. Szkoda, że tak nieprzyjemną. Jeszcze w tym kwartale mają wzrosnąć ceny zużycia wody płynącej z naszych kranów. Po zmianie, ceny mają wzrosnąć o 10%. Czy to oznacza, że będziemy musieli rzadziej się myć? Niekoniecznie. O radę jak oszczędzać wodę a tym samym płacić mniejsze rachunki, zapytaliśmy wybitnego eksperta hydrauliki – pana Czesława Hydranta. –&nbsp;<em>Metodę jaką stosuję najczęściej w celu ograniczenia zużycia wody jest instalacja specjalnego kranu ekologicznego, który działa w dwóch trybach: Górski Potok ® i Płukanko ®. Tego pierwszego używamy podczas zmywania, czy prysznica, a drugiego np. myjąc ręce. Polecam też bardziej klasyczne sposoby tzn. kąpiel pod prysznicem zamiast w wannie czy mycie zębów przy zakręconym kranie.</em></p>\r\n\r\n<p><strong>E-sport nową dyscypliną olimpijską?</strong></p>\r\n\r\n<p>E-sport, czyli profesjonalne zawody w gry komputerowe, zdobywa coraz większą popularność. Nagrody jakie można zdobyć w turniejach na całym świecie zaczynają być tak samo wartościowe jak te, które można zdobyć w klasycznych dyscyplinach sportowych. Nasze źródła donoszą, że mówi się o uznaniu e-sportu jako oficjalnej dyscypliny olimpijskiej. W naszym mieście również odbywają się lokalne rozgrywki drużyn e-sportowych, głównie w gry, w których kluczem do zwycięstwa jest współpraca kilkuosobowej drużyny. Chętnie napiszemy o tym więcej. Zgłoś się do nas, jeżeli jesteś e-sportowcem!</p>\r\n', '<p><strong>WAŻNE! </strong></p>\r\n\r\n<p><strong>Rosną ceny wody. Czy to już czas, żeby zacząć kopać studnie?!&nbsp;</strong></p>\r\n\r\n<p>Władze miasta przygotowały dla nas kolejną „niespodziankę”. Szkoda, że tak nieprzyjemną. Jeszcze w tym kwartale mają wzrosnąć ceny zużycia wody płynącej z naszych kranów. Po zmianie, ceny mają wzrosnąć o 10%. Czy to oznacza, że będziemy musieli rzadziej się myć? Niekoniecznie. O radę jak oszczędzać wodę a tym samym płacić mniejsze rachunki, zapytaliśmy wybitnego eksperta hydrauliki – pana Czesława Hydranta.–<em>Metodę jaką stosuję najczęściej w celu ograniczenia zużycia wody jest instalacja specjalnego kranu ekologicznego, który działa w dwóch trybach: Górski Potok ® i Płukanko ®. Tego pierwszego używamy podczas zmywania, czy prysznica, a drugiego np. myjąc ręce. Polecam też bardziej klasyczne sposoby tzn. kąpiel pod prysznicem zamiast w wannie czy mycie zębów przy zakręconym kranie.</em></p>\r\n\r\n<p><strong>E-sport nową dyscypliną olimpijską?</strong></p>\r\n\r\n<p>E-sport, czyli profesjonalne zawody w gry komputerowe, zdobywa coraz większą popularność. Nagrody jakie można zdobyć w turniejach na całym świecie zaczynają być tak samo wartościowe jak te, które można zdobyć w klasycznych dyscyplinach sportowych. Nasze źródła donoszą, że mówi się o uznaniu e-sportu jako oficjalnej dyscypliny olimpijskiej. W naszym mieście również odbywają się lokalne rozgrywki drużyn e-sportowych, głównie w gry, których kluczem do zwycięstwa jest współpraca kilkuosobowej drużyny. Chętnie napiszemy o tym więcej. Zgłoś się do nas, jeżeli jesteś e-sportowcem!</p>\r\n', '', '', '', 'pl', 'glos-pekunii-2'),
(17, 'Głos Pekunii #3', '<p style="margin-left:18.0pt;"><strong>Gorączka Świątecznej Nocy dotarła do Pekunii! Zaczyna się ulubiona pora roku dla przedsiębiorców z naszego miasta. Przypomnijmy dlaczego.</strong></p>\r\n\r\n<p>Od kilku lat w okresie przedświątecznym, Pekunia prowadzi ogólnokrajową akcję „Jak kupować to tylko w Pekunii”. Różne firmy przygotowują na ten czas wyjątkowo kuszące oferty. Przez kilka tygodni oferują klientom swoje towary i usługi w niespotykanych, promocyjnych cenach. Problem w tym, że o danej przecenie, informują dopiero o 8.00 rano danego dnia. Właśnie dlatego wielu potencjalnych klientów przyjeżdża do miasta na kilka dni i poluje na okazje. Tegoroczna Gorączka Świątecznej Nocy rozpoczyna się już w listopadzie. Będzie się działo!</p>\r\n\r\n<p style="margin-left:18.0pt;"><strong>UWAGA! Psołoś po raz kolejny pojawił się na przedmieściach Pekunii.</strong></p>\r\n\r\n<p>To dziwne stworzenie już nieraz nękało mieszkańców naszego miasta. Trudno było uwierzyć w opowieści o zwierzęciu, które ma ciało dużego psa i rozłożyste poroże jak u łosia. Tym razem nasz dzielny czytelnik, Jędrzej Andrzejczak, zdobył zdjęcie tego dziwoląga! Otóż podczas spaceru w lesie, uwagę pana Jędrzeja przyciągnął dźwięk wydobywający się z krzaków. Gdy nasz czytelnik zaczął zbliżać się do źródła hałasu, nagle z liści wyłoniła się głowa psa z dorodnym porożem. Szybka reakcja pana Jędrzeja pozwoliła uwiecznić na zdjęciu to dziwne spotkanie za pomocą aparatu w telefonie komórkowym. Czy natura przestanie nas kiedyś zaskakiwać?</p>\r\n\r\n<p style="margin-left:18.0pt;"><strong>Dzielna akcja pekuńskiej policji. Grupa przestępcza rozbita!</strong></p>\r\n\r\n<p>Przestępcy z grupy Filateliści zostali złapani przez funkcjonariuszy policji. Nazwa grupy pochodzi od metody ich działania. Otóż podając się za znajomych wnuków starszych ludzi, dostawali się do mieszkań i prosili o wspólne oglądanie kolekcji znaczków pocztowych. W czasie gdy niczego nieświadoma ofiara przygotowywała herbatę i ciasteczka, sprytni złodzieje upychali po kieszeniach co cenniejsze egzemplarze z kolekcji, okradając &nbsp;niewinnych staruszków. Sposób pojmania złoczyńców policjanci określają jako niezwykle wyrafinowaną akcję, która powiodła się dzięki wykorzystaniu technik nieznanych nawet w FBI. Szczegóły operacji mają przedstawić w przyszłym tygodniu na konferencji prasowej.</p>\r\n', '<p style="margin-left:18.0pt;"><strong>Gorączka Świątecznej Nocy dotarła do Pekunii! Zaczyna się ulubiona pora roku dla przedsiębiorców z naszego miasta. Przypomnijmy dlaczego.</strong></p>\r\n\r\n<p>Od kilku lat w okresie przedświątecznym, Pekunia prowadzi ogólnokrajową akcję „Jak kupować to tylko w Pekunii”. Różne firmy przygotowują na ten czas wyjątkowo kuszące oferty. Przez kilka tygodni oferują klientom swoje towary i usługi w niespotykanych, promocyjnych cenach. Problem w tym, że o danej przecenie, informują dopiero o 8.00 rano danego dnia. Właśnie dlatego wielu potencjalnych klientów przyjeżdża do miasta na kilka dni i poluje na okazje. Tegoroczna Gorączka Świątecznej Nocy rozpoczyna się już w listopadzie. Będzie się działo!</p>\r\n\r\n<p style="margin-left:18.0pt;"><strong>UWAGA! Psołoś po raz kolejny pojawił się na przedmieściach Pekunii.</strong></p>\r\n\r\n<p>To dziwne stworzenie już nieraz nękało mieszkańców naszego miasta. Trudno było uwierzyć w opowieści o zwierzęciu, które ma ciało dużego psa i rozłożyste poroże jak u łosia. Tym razem nasz dzielny czytelnik, Jędrzej Andrzejczak, zdobył zdjęcie tego dziwoląga! Otóż podczas spaceru w lesie, uwagę pana Jędrzeja przyciągnął dźwięk wydobywający się z krzaków. Gdy nasz czytelnik zaczął zbliżać się do źródła hałasu, nagle z liści wyłoniła się głowa psa z dorodnym porożem. Szybka reakcja pana Jędrzeja pozwoliła uwiecznić na zdjęciu to dziwne spotkanie za pomocą aparatu w telefonie komórkowym. Czy natura przestanie nas kiedyś zaskakiwać?</p>\r\n\r\n<p style="margin-left:18.0pt;"><strong>Dzielna akcja pekuńskiej policji. Grupa przestępcza rozbita!</strong></p>\r\n\r\n<p>Przestępcy z grupy Filateliści zostali złapani przez funkcjonariuszy policji. Nazwa grupy pochodzi od specyfiki ich występków i fachu jakim się trudnią. Otóż podając się za znajomych wnuków starszych ludzi, dostawali się do mieszkań i prosili o wspólne oglądanie kolekcji znaczków pocztowych. W czasie gdy niczego nieświadoma ofiara przygotowywała herbatę i ciasteczka, sprytni złodzieje upychali po kieszeniach co cenniejsze egzemplarze z kolekcji, okradając &nbsp;niewinnych staruszków. Sposób pojmania złoczyńców policjanci określają jako niezwykle wyrafinowaną akcję, która powiodła się dzięki wykorzystaniu technik nieznanych nawet w FBI. Szczegóły operacji mają przedstawić w przyszłym tygodniu na konferencji prasowej.</p>\r\n', '', '', '', 'pl', 'glos-pekunii-3'),
(18, 'Głos Pekunii #4', '<p><strong>Twój bank to Pewniak!</strong></p>\r\n\r\n<p>W Pekunii doszło do spektakularnego wydarzenia. Otóż powstał, pierwszy w historii naszego miasta, bank<sup>i</sup> z prawdziwego zdarzenia. Nosi on nazwę Pewniak. Wcześniej otaczało nas pełno instytucji parabankowych<sup> </sup>Od tej chwili, nasi przedsiębiorcy<sup> </sup>będą mogli korzystać z usług&nbsp; poważnej instytucji finansowej. Taka sytuacja z pewnością wpłynie w pozytywny sposób na ich konkurencyjność na rynku krajowym, a nawet zagranicznym. Już teraz chodzą słuchy, że wiele firm zamierza rozwinąć swoją działalność, korzystając z kapitału obcego<sup>.</sup></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><strong>Nowy rok, nowe postanowienia</strong>.</p>\r\n\r\n<p>Ratusz postanowił, że ten rok będzie mijał pod znakiem inwestycji ekologicznych. Szczegółowe informacje dotyczące konkretnych przedsięwzięć, zostaną podane już wkrótce. Cieszymy się, że nawet w kreatywności doganiamy czołówkę europejskich miast. Bardzo ważna w tym aspekcie okazała się ubiegłoroczna konferencja w Berlinie, w której nasze władze brały udział po raz pierwszy. Na bazie omawianych tam doświadczeń innych europejskich miast, władze Pekunii będą tworzyły nową, bardziej ekologiczną strategię rozwoju.</p>\r\n\r\n<div><br />\r\n&nbsp;</div>\r\n', '', '', '', '', 'pl', 'glos-pekunii-4'),
(19, 'Głos Pekunii #5', '<p><strong>Pewny sukces?</strong></p>\r\n\r\n<p>Jak pisaliśmy w poprzednim numerze, w ubiegłym kwartale miało miejsce huczne otwarcie banku Pewniak w naszym mieście. Dzięki temu, wielu przedsiębiorców może załatwiać swoje sprawy w znacznie szybszy sposób. Część z nich skorzystała z promocyjnego oprocentowania na kredyt inwestycyjny dzięki czemu będą mogli rozwinąć swój biznes, co z pewnością przyczyni się do wzrostu konkurencyjności naszego miasta. Ogromne kolejki przed wejściem w pierwszych tygodniach funkcjonowania banku były zaskoczeniem nawet dla samego kierownictwa. Przedstawiciel zarządu Pewniaka powiedział naszej redakcji, że jego firma widzi ogromy potencjał w Pekunii.</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><strong>Społeczna Odpowiedzialność Biznesu <em>- </em>to jest właśnie to czego szukamy w XXI wieku.</strong></p>\r\n\r\n<p>Ostatnio bardzo dużo czasu poświęca się sprawom związanym ze Społeczną Odpowiedzialnością Biznesu<strong>.</strong> Wiele programów rządowych oraz samorządowych jest nastawionych na wspieranie inwestycji w zrównoważony rozwój. Zachęca się wszystkich przedsiębiorców do zainteresowania się tą kwestią. Jednym z pomysłów jaki podsuwa redakcja to kwestia Elektrowni Węglowej „Niedźwiedź”. Nasze piękne miasto przez dziesiątki lat było zatruwane przez elektrownię zasilaną węglem brunatnym. Spowodowało to wyniszczenie pięciu hektarów otaczających nas lasów oraz wyginięcie kilkunastu gatunków zwierząt w naszej okolicy. Przez wiele lat organizacja pozarządowa Zielonomi walczyła o zamknięcie elektrowni. Pod koniec ubiegłego roku, jej starania przyniosły efekt i elektrownia zakończyła swoje funkcjonowanie. Obecnie Zielonomi poszukuje chętnych, którzy są w stanie sfinansować rekultywację terenu, polegającą na posadzeniu tysięcy drzew.</p>\r\n\r\n<div>&nbsp;</div>\r\n', '', '', '', '', 'pl', 'glos-pekunii-5'),
(20, 'Głos Pekunii #6', '<p><strong>Święto sportu w naszym mieście!</strong></p>\r\n\r\n<p>Dzięki staraniom władz miasta, w nadchodzącym kwartale odbędą się w Pekunii Mistrzostwa Europy w Piłce Siatkowej. W związku z tym spodziewany jest przyjazd turystów i licznych fanów tego sportu. Lokalni hotelarze, restauratorzy oraz sklepikarze już zacierają ręce z okazji zbliżającej się imprezy. Spodziewają się znaczącego wzrostu sprzedaży podczas Mistrzostw. Ciekawe czy faktycznie tak będzie. Jednak teraz mamy gorszą wiadomość dla miłośników piłki siatkowej; wciąż niepewny jest występ Radka Tadka w naszej drużynie narodowej w Mistrzostwach Europy. W najbliższym czasie sztab trenerski wraz z lekarzami kadry ma podjąć ostateczną decyzję związaną z jego uczestnictwem w rozgrywkach pucharowych. Przypominamy, że w ubiegłą środę Radek, podczas porannego treningu, skręcił kostkę. Zaraz po tym incydencie trener naszej kadry był załamany. Nic dziwnego, przecież Radek Tadek to największa gwiazda naszego zespołu. Wiarę przywracają nam lekarze, którzy obecnie oceniają szanse występu Radka na 50%. Radku trzymamy kciuki!</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><strong>Wyróżnienie dla Pekunii! </strong></p>\r\n\r\n<p>Naczelna Izba Hotelarska uznała Pekunię za najprężniej rozwijające się miasto pod względem sportowo-rekreacyjnym. Analizując doświadczenia miast, które otrzymały tę nagrodę wcześniej, istnieje wysokie prawdopodobieństwo, że to wyróżnienie przysłuży się zwiększeniu liczby turystów odwiedzających Pekunię w kolejnych latach. Będzie to niewątpliwie szansa dla mieszkańców, ale również ogromne wyzwanie, któremu mamy nadzieję wszyscy podołamy.</p>\r\n', '', '', '', '', 'pl', 'glos-pekunii-6'),
(21, 'Głos Pekunii #7', '<p><strong>Siatkarskie Mistrzostwa Europy zakończone sukcesem!</strong></p>\r\n\r\n<p>Międzynarodowa społeczność sportowa bardzo wysoko oceniła organizację Mistrzostw Europy w naszym mieście. Największe wrażenie wywarła na nich bogata baza hotelowa. Impreza tej rangi z pewnością przysłuży się zwiększeniu popularności Pekunii w Europie, a nawet na świecie. Już teraz obserwowany jest wzrost rezerwacji hotelowych na przyszły rok. Prezydent Europejskiej Federacji Siatkówki przyznał, że były to jedne z najlepszych mistrzostw w historii. Jak zawsze kibice okazali się niezawodni i stworzyli zawodnikom niezapomnianą atmosferę. Niestety nie obyło się bez incydentów. Fala zamieszek po jednym z meczów spowodowała znaczące straty. Szkody zostały wycenione na 5 mln zł. Chuligani bardzo szybko zostali złapani przez policję.</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><strong>Nieprzyjemna niespodzianka czeka na turystów odwiedzających Pekunię.</strong></p>\r\n\r\n<p>W związku ze stale zwiększającą się liczbą turystów przyjeżdżających do naszego miasta, Ratusz postanowił wprowadzić od najbliższego kwartału opłatę klimatyczną w wysokości 2 zł za osobę za każdy dzień pobytu. Jest to praktyka stosowana w każdym mieście, gdzie liczba turystów jest znacząca. Czy to oznacza, że zbliżamy się do takich międzynarodowych kurortów turystycznych jak Paryż i Rzym?</p>\r\n', '', '', '', '', 'pl', 'glos-pekunii-7'),
(22, 'Głos Pekunii #8', '<p><strong>O pracę będzie łatwiej!</strong></p>\r\n\r\n<p>Tydzień temu zakończony został remont naszego Urzędu Pracy. Nie dość, że jest on w stanie obsługiwać trzy razy większą liczbę petentów niż dawniej, to jeszcze został on kompletnie zrestrukturyzowany. Dzięki temu znalezienie pracy powinno być prostsze. Inwestycja opiewała na sumę 3,5 mln zł. Miejmy nadzieję, że pieniądze te rzeczywiście pomogą znaleźć zatrudnienie młodym ludziom (należy przypomnieć, że odsetek bezrobocia wśród najmłodszych wzrasta systematycznie z roku na rok). Jeżeli szukasz pracy, bądź pracowników, nowy urząd jest miejscem dla Ciebie.</p>\r\n\r\n<p><strong>Strajki aktorskie?</strong></p>\r\n\r\n<p>Od pewnego czasu docierają do nas doniesienia o rosnącym niezadowoleniu środowiska aktorskiego, zatrudnionego w pobliskim teatrze "Chochlik". Okazuje się, iż przez ostatni rok liczba klientów tego teatru spadła o 25%. Wg dyrektora teatru, Pana Zygmunta Dudka, jest to wynikiem cięć budżetowych, które niefortunnie skupiły się na sekcji kultury. Władze samorządowe jak na razie milczą w tej sprawie. Jeżeli sytuacja nie ulegnie poprawie, to zgodnie z nieoficjalnymi zapowiedziami można będzie spodziewać się strajków i demonstracji.</p>\r\n\r\n<p><strong>Walka o bezpieczne zatrudnienie. </strong></p>\r\n\r\n<p>Ostatnimi czasy, władze samorządowe nagłaśniają sprawę pewności zatrudnienia. Sprawa ta budzi wiele kontrowersji. Jak twierdzi przedstawiciel prasowy z biura burmistrza - Pan Wacław Korzeń: <em>W naszym kraju niewiedza dotycząca rodzajów umów o pracę oraz ich wpływu na nasze wynagrodzenia, czy też praw nam przysługujących jest zatrważająca.</em> Dlatego też władze terytorialne zdecydowały się na rozpoczęcie kampanii informacyjnej, mającej na celu uświadomienie mieszkańców naszego miasta. Rozdawane są ulotki informacyjne, w telewizji natomiast pojawiają się reklamy społeczne, mają także w planach organizację kilku wykładów gościnnych na naszym uniwersytecie. &nbsp;</p>\r\n', '', '', '', '', 'pl', 'glos-pekunii-8'),
(23, 'Głos Pekunii #10', '<p><strong>Na naukę nigdy nie jest za późno.</strong></p>\r\n\r\n<p>Ministerstwo Edukacji wydało rozporządzenie mające na celu poszerzenie oferty uniwersytetów o szkolenia dla osób zatrudnionych w branży usługowej. Realizując zalecenia Ministerstwa, Uniwersytet w Pekunii uwzględnił takie szkolenia w swojej ofercie edukacyjnej. Twoi pracownicy będą mogli z nich skorzystać od następnego kwartału. Wykłady będą prowadzone przez czołowych ekspertów z całego świata. Według międzynarodowych rankingów, jakość tego szkolenia jest porównywalna z ofertami dominującymi na rynku niemieckim.</p>\r\n\r\n<p><strong>Doskonała akcja straży pożarnej</strong></p>\r\n\r\n<p>W ostatnim tygodniu nagłośniona została sprawa pewnego kota o imieniu Ferdek i jego Pani Barbary Krzem. Kot ten został przepędzony przez wściekłego psa na jedno z największych drzew znajdujących się w naszym miejskim parku. Jak można się domyślić, nie był on w stanie sam z niego zejść. Pani Barbara, która była niesamowicie do Ferdka przywiązana, zadzwoniła do straży pożarnej. Mundurowi zjawili już się 5 minut po wezwaniu, ponadto ściągnęli kota bez najmniejszych problemów i to bez użycia wozu strażackiego! Naoczni świadkowie opisują akcję jako doskonale zorganizowaną i wykonaną. Po tym zajściu, strażacy otrzymali pochwałę od burmistrza miasta.</p>\r\n', '', '', '', '', 'pl', 'glos-pekunii-10'),
(24, 'Głos Pekunii #9', '<p><strong>Nagła zmiana kariery</strong></p>\r\n\r\n<p>Wzięta aktorka i zarazem kultowa piosenkarka Krystyna Peszek (słynna z ról w filmach takich jak "Kosmiczna Rzepa" i "Rachunek bez Napiwku") zdecydowała się na porzucenie show-biznesu. Według doniesień postanowiła&nbsp;całkowicie poświęcić się ochronie środowiska. Do sieci trafiły ostatnio zdjęcia Krystyny w roli leśniczego. Słynny reżyser Bogusław&nbsp; Wajcha, skomentował sprawę tak: <em>Według mnie Krysia musi odpocząć. Ostatnie role niesamowicie ją wyczerpały. Cieszę się, że wybrała do tego tak spokojne miejsce jak las. Ufam, że szybko wróci do pracy gdyż chciałbym żeby zagrała główną rolę w moim najnowszym filmie, który będzie nosił tytuł "Taniec Korników". </em>Czy słynna aktorka będzie w stanie wcielić się w rolę strażnika lasu? O tym jeszcze się przekonamy.</p>\r\n\r\n<p><strong>Skandal w piłce nożnej</strong></p>\r\n\r\n<p>Po ostatnim towarzyskim meczu, trener klubu "Pekunia Sfora" został zatrzymany przez policję pod zarzutem stosowania dopingu. Okazuje się, że przed ostatnim meczem trener Miłosz Ź. dodał środków dopingujących do napojów energetycznych, przeznaczonych dla kadry sportowej. Jak mówi rzecznik Policji, reprezentanci nie mieli o tym najmniejszego pojęcia. W wyniku tego ostatni mecz zostanie powtórzony w przyszły piątek, &nbsp;trenera zaś czeka proces sądowy.</p>\r\n', '', '', '', '', 'pl', 'glos-pekunii-9'),
(25, 'Głos Pekunii #11', '<p><strong>Nadchodzą podwyżki!</strong></p>\n\n<p>Decyzją parlamentu, stawka płacy minimalnej wzrośnie o 10%. Jest to wynikiem głośnych strajków związków zawodowych, które miały miejsce ostatnimi czasy. Po długich negocjacjach, projekt trafił do sejmu a następnie został zatwierdzony. Pracodawcy już zgłaszają sprzeciw wobec tej ustawy. Twierdzą oni, że będą przez to zmuszeni do cięcia kosztów a możliwe nawet, że do zakończenia swej działalności gospodarczej. Jeżeli jesteś pracodawcą to zalecamy zapoznanie się z nowymi stawkami w naszym urzędzie pracy.</p>\n\n<p><strong>Największy ziemniak świata?</strong></p>\n\n<p>W przyszłym tygodniu w naszym mieście zjawi się specjalna komisja, która przyznaje nagrody w kategoriach ekstremalnych, to oznacza, iż będziemy mieli zaszczyt gościć komitet Guinnessa w sprawie gigantycznego ziemniaka wyhodowanego przez Pana Krzysztofa Susła (55 letniego rolnika). Ziemniak ten o imieniu Franek waży niespełna 5 kilogramów! Dotychczasowy największy ziemniak świata ważył 3,8 kg. Jeżeli komisja nie dopatrzy się żadnych nieprawidłowości, to Pan Krzysztof może liczyć na wpis do księgi Guinnessa oraz zyskać światową sławę (a wraz z nim nasze miasto :-))</p>\n', '', '', '', '', 'pl', 'glos-pekunii-11'),
(26, 'Głos Pekunii #12', '<p><strong>Na hotelarskim rynku Pekunii znowu zawrzało!</strong></p>\r\n\r\n<p>Tym razem jest to spowodowane wejściem na rynek trzech zagranicznych sieci hotelarskich. Tak duże zainteresowanie Pekunią jest spowodowane znaczącym wzrostem liczby osób odwiedzających nasze miasto.</p>\r\n\r\n<p>Pierwsza sieć nazywa się <strong>Busyday</strong>. Jest to światowa marka, głównie skierowana na obsługę gości biznesowych. Mówi się jednak, że w Pekunii nie będzie to ich jedyna grupa docelowa.</p>\r\n\r\n<p>Druga sieć to <strong>Cheapbed</strong>. Jest to wciąż zdobywająca nowe rynki sieć, która kieruje swoją ofertę do klientów o stosunkowo niskich wymaganiach. W wielu krajach ceniona jest przez studentów oraz pasjonatów podróży, gdyż wybiera swoje lokalizacje z największą starannością.</p>\r\n\r\n<p>Ostatnia sieć&nbsp; to <strong>Your choice</strong>, która jest mistrzem w swoim fachu. Udowodniła to przez pięćdziesiąt lat swojego funkcjonowania. Profil jej hoteli jest bardzo szeroki, a każdy hotel dostosowany jest do specyfiki rynku danego regionu. Your choice jest uwielbiana przez rodziny z dziećmi.</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><strong>Pekunia „Czystym miastem”!</strong></p>\r\n\r\n<p>Ministerstwo Ochrony Środowiska doceniło starania władz Pekunii w dziedzinie ochrony środowiska naturalnego. Przyznany został nam tytuł „Czyste miasto”. Takie wyróżnienie jest niewątpliwie najlepszym zwieńczeniem pierwszego etapu planu, który ma na celu dbanie o ekologię w Pekunii. Największe brawa za ten tytuł&nbsp; należą się władzom naszego miasta.</p>\r\n', '', '', '', '', 'pl', 'glos-pekunii-12'),
(27, 'Głos Pekunii #13', '<p><strong>Straż Pożarna najbardziej bohaterską jednostką służb miejskich Pekunii. </strong></p>\r\n\r\n<p>Mieszkańcy Pekunii w drodze głosowania, które odbyło się na łamach "Głosu Pekunii", wybrali najbardziej pomocną służbę mundurową. Okazało się, że to właśnie strażacy najczęściej i najskuteczniej pomagali Pekunianom. Wystarczy przypomnieć takie brawurowe akcje jak ratowanie dzieci podczas pożaru szkoły podstawowej czy zdjęcie z drzewa – bez pomocy wozu strażackiego – kota Pani Barbary (opisywaliśmy to pod koniec zeszłego roku). Kolejne miejsca zajęli: lekarze, żołnierze, policjanci, straż miejska.</p>\r\n\r\n<p><strong>Zarzuty korupcyjne w sprawie budowy dróg. </strong></p>\r\n\r\n<p>Trwa afera korupcyjna związana z budową obwodnicy Pekunii. Firma Przekrętex (główny wykonawca) usłyszała zarzuty niedotrzymania zasad konkurencyjności przy wyborze usług transportowych. Naruszenie procedury przetargowej zostało udowodnione na podstawie dostarczonej dokumentacji. Najbliższa rozprawa odbędzie się już w przyszłym miesiącu. Obwodnicę zbudowano jedynie w połowie. Nie wiadomo kiedy prace zostaną wznowione.</p>\r\n', '', '', '', '', 'pl', 'glos-pekunii-13'),
(28, 'Głos Pekuni #14', '<p><strong>Psołoś zdemaskowany!</strong></p>\r\n\r\n<p>Pamiętacie jeszcze sensacyjne zdjęcie psołosia sprzed dwóch lat? Rozwiązanie zagadki tego dziwnego stworzenia ma swój finał. Okazało się, że psołoś to tak naprawdę pies Azor – Buldog Amerykański, należący do jednego z ekscentrycznych reżyserów, który odwiedził Pekunię podczas I Festiwalu Filmów i Filmików. Podczas imprezy festiwalowej, właściciel wraz z przyjaciółmi wpadli na pomysł nakręcenia krótkiego filmu z udziałem czworonoga. Poroże było przyklejone do głowy psa jako element charakteryzacji głównego bohatera. W trakcie kręcenia scen do filmu, w pewnym momencie pies zaginął, a było już tak późno, że nikt nie miał siły go szukać. Zdezorientowany Azor dotarł na drugi koniec miasta i tam błąkał się przez kilka miesięcy. Następnie ślad po nim zaginął. Widocznie wyrzuty sumienia w końcu przygniotły właścicieli Azora – historię (z nawiązaniem do naszego artykułu) opisali na swoim blogu, gdzie proszą o wszelkie informacje na temat aktualnego pobytu Azora. Dla znalazcy przygotowano nagrodę - scenariusz filmu o Psołosiu z podpisem autorów! Pomożecie?&nbsp;</p>\r\n\r\n<p><strong>Nowe miejsca pracy!</strong></p>\r\n\r\n<p>Znana na całym świecie firma produkująca rowery "Bicyx" kupiła ziemię w naszym mieście w celu otworzenia nowoczesnej fabryki. Planowany czas budowy fabryki to 1,5 roku. Według prognoz Urzędu Pracy, wraz z otwarciem fabryki, pracę będzie mogło znaleźć aż 200 osób. Rekrutacja na nowe stanowiska pracy rozpocznie się na 3 miesiące przed otwarciem. Zainteresowanych odsyłamy do Urzędu Pracy.</p>\r\n', '', '', '', '', 'pl', 'glos-pekuni-14'),
(29, 'Głos Pekunii #15', '<p style="margin-left:17.85pt;"><strong>Akcja "Parkuj odpowiednio" rozpoczęta.</strong></p>\r\n\r\n<p style="margin-left:17.85pt;">Zgodnie z zapowiedziami, Policja oraz Straż Miejska przeprowadziły akcję mającą na celu wyeliminowanie zagrożeń, oraz utrudnień na drogach spowodowanych nieprzepisowym parkowaniem. Szczególnie skupili się na karaniu właścicieli pojazdów, którzy parkują w&nbsp;miejscach ograniczających widoczność. Akcja zakończyła się udzieleniem 2679 mandatów. Efekty akcji można zobaczyć już dzisiaj. Ilość wypadków drogowych w naszym mieście spadła o 17% w odniesieniu do zeszłego miesiąca. Policja zapowiada kontynuację tej akcji w przyszłości.</p>\r\n\r\n<p style="margin-left:17.85pt;"><strong>Pekunia uzdrowiskiem?</strong></p>\r\n\r\n<p style="margin-left:17.85pt;">Najnowsze badania niezależnych hydrologów stwierdzają, że w naszym mieście znajduje się źródło wody oligoceńskiej. Woda z tego źródła jest bogata w sole mineralne, przez co posiada znacznie większe wartości odżywcze od zwyczajnej wody, dostępnej&nbsp;w sklepach. Władze miasta poważnie rozpatrują utworzenie rozlewni. Bardzo możliwe, że mieszkańcy naszego pięknego miasta będą mogli cieszyć się tą rzadko spotykaną wodą już w przyszłym roku!</p>\r\n', '', '', '', '', 'pl', 'glos-pekunii-15'),
(31, 'Badanie marketingowe - charakterystyka usług podstawowych', '<p dir="ltr" id="docs-internal-guid-7154af9d-faa1-8146-2091-49e418767950" style="line-height:1.15;margin-top:0pt;margin-bottom:0pt;">Inwestycja w usługi podstawowe przyczyni się do poprawienia pozycji Twojego hotelu na rynku. N<span style="line-height: 18.399999618530273px; text-align: justify;">a wykresie umieszczonym poniżej&nbsp;możesz zaobserwować w</span>&nbsp;jaki sposób liczba usług wpływa na zmianę popytu na Twoje pokoje.</p>\n\n<p dir="ltr" style="line-height:1.15;margin-top:0pt;margin-bottom:0pt;"><img src="/images/kfm_images/uslug_podstawowe.jpg" style="width: 604px; height: 332px;" /></p>\n\n<p>&nbsp;</p>\n\n<p>Decyzja o tym, w które usługi&nbsp;zainwestujesz należy do Ciebie. Decydujące znaczenie ma liczba usług,&nbsp;a nie ich rodzaj. Pamiętaj, że oferowanie usług podstawowych jest standardem na rynku hotelarskim. Posiadanie ich w ofercie jest niejako obowiązkiem każdej osoby prowadzącej hotel. Inwestując w usługi podstawowe nie wyróżnisz się spośród innych, ale z pewnością dołączysz do grona hotelarzy prowadzących hotele na wysokim poziomie.</p>\n\n<p>&nbsp;</p>\n', '', '', '', '', 'pl', 'badanie-marketingowe-charakterystyka-uslug-podstawowych'),
(32, 'Badanie marketingowe - pory roku a popyt', '<p dir="ltr"><span style="background-color:transparent; color:#000000; font-family:arial; font-size:15px">&nbsp;</span></p>\r\n\r\n<p>Czy w ostatnim kwartale&nbsp;zaobserwowałeś niewielki wzrost&nbsp;popytu na Twoje usługi? Jeśli tak, to z pewnością jednym z czynników, który na to wpłynął, była sezonowość czyli zmiany wielkości popytu w zależności od pory roku. To jak poszczególne pory roku wpływają na popyt na usługi hotelarskie w różnych miejscowościach zależy np. od czynników przyrodniczych, lokalnych walorów turystycznych i infrastruktury turystycznej.</p>\r\n\r\n<p>Ciebie, jako właściciela hotelu w Pekunii, z pewnością&nbsp; interesuje to jak zachowuje się tutejszy rynek hotelarski. Najlepiej przedstawia to wykres poniżej.</p>\r\n\r\n<p><br />\r\n<img src="/images/kfm_images/sezonowosc.png" style="height:332px; width:604px" /></p>\r\n\r\n<p dir="ltr">Pokazuje on, że większy popyt na usługi hotelarskie panuje w I i III kwartale oraz, że mniejszy popyt widoczny jest w II i IV kwartale.<span style="background-color:transparent; color:#000000; font-family:arial; font-size:15px"> </span></p>\r\n\r\n<p dir="ltr">Pragniemy również przypomnieć jak wygląda podział na kwartały w Pekunii:</p>\r\n\r\n<p dir="ltr"><span style="background-color:rgb(255, 255, 255); font-family:arial,sans,sans-serif; font-size:13px"><strong>Q1, zima:</strong>&nbsp;grudzień - luty; </span></p>\r\n\r\n<p dir="ltr"><span style="background-color:rgb(255, 255, 255); font-family:arial,sans,sans-serif; font-size:13px"><strong>Q2, wiosna:</strong>&nbsp;marzec - maj; </span></p>\r\n\r\n<p dir="ltr"><span style="background-color:rgb(255, 255, 255); font-family:arial,sans,sans-serif; font-size:13px"><strong>Q3, lato:</strong>&nbsp;czerwiec - sierpień, </span></p>\r\n\r\n<p dir="ltr"><span style="background-color:rgb(255, 255, 255); font-family:arial,sans,sans-serif; font-size:13px"><strong>Q4, jesień:</strong>&nbsp;wrzesień - listopad</span></p>\r\n\r\n<p><br />\r\n<br />\r\n<br />\r\n&nbsp;</p>\r\n', '', '', '', '', 'pl', 'badanie-marketingowe-pory-roku-a-popyt'),
(34, 'Badanie marketingowe - charakterystyka popytu na pokoje Delux', '<p>Pewnie zauważyłeś, że od zeszłego kwartału możesz zainwestować w pokoje Delux. Chcielibyśmy przekazać Ci kilka ważnych informacji dotyczących tego rodzaju pokoi.</p>\r\n\r\n<p>Pokoje tego typu cieszą się sporą popularnością wśród zamożnych gości, przede wszystkim przedsiębiorców. Dzieje się tak dlatego, że właśnie tej grupie klientów najbardziej zależy na wysokim standardzie. Z naszych badań na rynku hotelarskim wynika, że pokoje o podwyższonym standardzie należy budować w centrach miast. Tam właśnie popyt na nie jest najwyższy.</p>\r\n\r\n<p>Poniżej przedstawiamy wykresy popytu na usługi hotelowe o podwyższonym standardzie (Delux) dla różnych lokalizacji. Na ich podstawie można oszacować jaki popyt może być osiągnięty przy danej cenie. Należy pamiętać, że koszty prowadzenia działalności różnią się w zależności od wybranej lokalizacji.</p>\r\n\r\n<p style="text-align:center"><img alt="" src="/images/kfm_images/popyt_lux_0.jpg" style="box-shadow:1px 1px 1px silver; width:700px" /></p>\r\n\r\n<p style="text-align:center"><img alt="" src="/images/kfm_images/popyt_lux_1.jpg" style="box-shadow:1px 1px 1px silver; width:700px" /></p>\r\n\r\n<p style="text-align:center"><img alt="" src="/images/kfm_images/popyt_lux_2.jpg" style="box-shadow:1px 1px 1px silver; width:700px" /></p>\r\n\r\n<p style="text-align:center"><img alt="" src="/images/kfm_images/popyt_lux_3.jpg" style="box-shadow:1px 1px 1px silver; width:700px" /></p>\r\n', '', '', '', '', 'pl', 'badanie-marketingowe-charakterystyka-popytu-na-pokoje-delux'),
(35, 'Urząd pracy - informacje', '<p><strong>Rodzaje umów</strong></p>\r\n\r\n<p>Na polskim rynku pracy występują dwa główne rodzaje umów dotyczących zatrudnienia:</p>\r\n\r\n<ul>\r\n	<li>\r\n	<p><strong>Umowa o pracę-</strong> jest regulowana przepisami kodeksu pracy. Dzięki temu, gwarantuje ona między innymi: minimalne wynagrodzenie, prawo do płatnego urlopu, unormowany czas pracy oraz zasiłek chorobowy. Ten typ umowy charakteryzuje się dużą pewnością zatrudnienia. Pracodawca zawiązujący umowę o pracę jest zmuszony do opłacania składek ZUS, co istotnie zwiększa jej koszt.</p>\r\n	</li>\r\n	<li>\r\n	<p><strong>Umowa zlecenie-</strong> jest regulowana przepisami kodeksu cywilnego. Ze względu na to, nie dotyczą jej ścisłe regulacje, z jakimi mamy do czynienia w przypadku umowy o pracę. Ponadto nie występują ograniczenia dotyczące rozwiązania tejże umowy. Dlatego też umowy o zlecenie charakteryzują się dużą niepewnością oraz ryzkiem dla pracownika. Nie należy jednak zapominać o tym, że umowa ta nie wymaga opłacania składek ZUS. Skutkuje to zmniejszeniem kosztu dla pracodawcy.</p>\r\n	</li>\r\n</ul>\r\n\r\n<p><strong>Płaca netto a płaca brutto</strong></p>\r\n\r\n<ul>\r\n	<li>\r\n	<p>Płaca netto - to inaczej pieniądze otrzymywane "do ręki". Jest to część wynagrodzenia, która bezpośrednio trafia w ręce pracownika.</p>\r\n	</li>\r\n	<li>\r\n	<p>Płaca brutto to inaczej płaca całkowita. Składa się ona z płacy netto, składki ZUS, zaliczki na podatek dochodowy oraz składki NFZ. Przykładowo, przy płacy brutto wynoszącej 10.000 zł, płaca netto wynosi 7034,39 zł.</p>\r\n	</li>\r\n</ul>\r\n', '', '', '', '', 'pl', 'urzad-pracy-informacje'),
(36, 'Urząd pracy - stawki płac', '<p>Płaca minimalna: %płaca_minimalna%</p>\r\n\r\n<p><strong>Obsługa</strong></p>\r\n\r\n<p>Płaca średnia: %średnia_oferta_obsługa%</p>\r\n\r\n<p><strong>Administracja</strong></p>\r\n\r\n<p>Płaca średnia: %średnia_oferta_administracja%</p>\r\n\r\n<ul>\r\n	<li>\r\n	<p><strong>Płaca minimalna</strong> jest to <strong>najmniejsze możliwe </strong><strong>wynagrodzenie, </strong><strong>jakie</strong> może osiągnąć pracownik zatrudniony w pełnym wymiarze czasu pracy w ciągu miesiąca.</p>\r\n	</li>\r\n	<li>\r\n	<p><strong>Płaca średnia</strong> to średnia oferta wynagrodzenia pracownika danej branży i na danym stanowisku.</p>\r\n	</li>\r\n</ul>\r\n', '', '', '', '', 'pl', 'urzad-pracy-stawki-plac'),
(37, 'Badanie marketingowe - efektywność form reklamy ', '<p>&nbsp;</p>\r\n\r\n<p>Badanie to powinno ułatwić Ci dobranie odpowiedniej formy reklamy, do Twojej strategii.</p>\r\n\r\n<p>Na tym etapie możesz wypromować swój hotel w mediach lokalnych i regionalnych. Dokładny opis poszczególnych form reklamy znajduje się w naszej agencji. Aby Twoja polityka marketingowa była efektywna ważne jest odpowiednie skomponowanie różnych form reklamy.</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>Z naszych długoletnich badań wynika, że reklama będzie efektywna przy wykupieniu:</p>\r\n\r\n<table border="1" cellpadding="0" cellspacing="0" width="317">\r\n	<tbody>\r\n		<tr>\r\n			<td style="width: 142px;">\r\n			<p>Forma reklamy</p>\r\n			</td>\r\n			<td style="width: 176px;">\r\n			<p>Proponowana wielkość</p>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style="width: 142px;">\r\n			<p><strong>Billboardy</strong></p>\r\n			</td>\r\n			<td style="width: 176px;">\r\n			<p><strong>2 – 8 billboardów</strong></p>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style="width: 142px;">\r\n			<p><strong>Prasa lokalna</strong></p>\r\n			</td>\r\n			<td style="width: 176px;">\r\n			<p><strong>4 – 12 stron</strong></p>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style="width: 142px;">\r\n			<p><strong>Radio lokalne</strong></p>\r\n			</td>\r\n			<td style="width: 176px;">\r\n			<p><strong>20 – 60 reklam</strong></p>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style="width: 142px;">\r\n			<p><strong>Prasa regionalna</strong></p>\r\n			</td>\r\n			<td style="width: 176px;">\r\n			<p><strong>8 – 16 stron</strong></p>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style="width: 142px;">\r\n			<p><strong>Radio regionalne</strong></p>\r\n			</td>\r\n			<td style="width: 176px;">\r\n			<p><strong>nie mniej niż 25 reklam</strong></p>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td style="width: 142px;">\r\n			<p><strong>TV regionalna</strong></p>\r\n			</td>\r\n			<td style="width: 176px;">\r\n			<p><strong>4 – 8 minut</strong></p>\r\n			</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n', '', '', '', '', 'pl', 'badanie-marketingowe-efektywnosc-form-reklamy'),
(38, 'Badanie marketingowe - badanie konkurencji', '<p>Jak już z pewnością wiesz z „Głosu Pekunii" w Twoim mieście pojawili się wielcy gracze rynku hotelarskiego z naszego kraju i nie tylko. Poniżej znajduje się analiza ich działalności.</p>\r\n\r\n<p><img alt="" src="/images/kfm_images/konkurencja.jpg" style="height:547px; width:830px" /></p>\r\n', '', '', '', '', 'pl', 'badanie-marketingowe-badanie-konkurencji');
INSERT INTO `article_translation` (`id`, `title`, `description`, `short_description`, `meta_title`, `meta_description`, `meta_keywords`, `lang`, `slug`) VALUES
(39, 'Badanie marketingowe - jednorodne grupy konsumentów', '<p>Teraz przyszedł czas, abyś poznał zjawisko, które w ekonomii nosi nazwę segmentacji rynku. Jest to podział rynku na grupy konsumentów, którzy wykazują podobne preferencje w podejściu do danego produktu. Oznacza to, że klienci danej grupy zgłaszają na niego podobny popyt. Preferencje społeczeństwa są bardzo zróżnicowane. Obecnie nie jesteś w stanie stworzyć produktu, który będzie podobał się każdemu. Dlatego właśnie, dzieli się społeczeństwo na grupy wykazujące jednorodne cechy. Tym sposobem przedsiębiorca jest w stanie zdobyć przewagę konkurencyjną.</p>\r\n\r\n<p>Na rynku hotelarskim Pekunii możemy wyróżnić cztery segmenty/grupy:</p>\r\n\r\n<ul>\r\n	<li>Oszczędni;</li>\r\n	<li>Globtroterzy;</li>\r\n	<li>Rodziny z dziećmi;</li>\r\n	<li>Biznesmeni.</li>\r\n</ul>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>W zależności od rodzaju grupy do której przynależy klient, różne czynniki będą wpływały na jego decyzję o wyborze hotelu oraz pokoju. Główne zmienne to:</p>\r\n\r\n<ul>\r\n	<li>Położenie hotelu;</li>\r\n	<li>Cena za pokój Standard;</li>\r\n	<li>Cena za pokój Delux;</li>\r\n	<li>Wyposażenie pokoju;</li>\r\n	<li>Dodatkowe udogodnienia oferowane przez hotel.</li>\r\n</ul>\r\n\r\n<p>Wyżej wymienione segmenty są również mniej lub bardziej wrażliwe na różne formy reklamy.</p>\r\n\r\n<p>Poniżej przedstawiliśmy tabelę, która powinna Ci pomóc w stworzeniu odpowiedniej strategii:</p>\r\n\r\n<p style="text-align:center"><img alt="" src="/images/kfm_images/segmentacja.jpg" style="box-shadow:1px 1px 1px silver; width:700px" /></p>\r\n', '', '', '', '', 'pl', 'badanie-marketingowe-jednorodne-grupy-konsumentow'),
(40, 'Śniadania', '<p><strong>OD</strong>: womlet@omet.pl</p>\r\n\r\n<p><strong>DO</strong>: hotelstar@pekunia.pl</p>\r\n\r\n<p><strong>TEMAT</strong>: Śniadania</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><em>Witam serdecznie!</em></p>\r\n\r\n<p><em>W zeszłym tygodniu miałem okazję spędzić noc w Państwa hotelu. Bardzo mi się podobało. Jak na tak krótki staż w branży, potraficie Państwo zadbać zarówno o klienta jak i o stan jego portfela. Mam jednak pewną sugestię. Otóż, ze względu na specyfikę mojego zawodu, spędzam w hotelach bardzo dużo czasu. Co najmniej tydzień w każdym miesiącu. Przyzwyczaiłem się do śniadania oferowanego klientom w cenie noclegu. Dobrze jest coś przekąsić przed wyruszeniem w dalszą drogę. Proszę się nad tym zastanowić, nawet jeżeli miałoby to nieznacznie wpłynąć na cenę doby hotelowej. Najedzony klient to podwójnie zadowolony klient. Z przyjemnością sprawdzę jaką podjęli Państwo decyzję w tej kwestii, jeżeli tylko będę w pobliżu uroczego miasta Pekunia.</em></p>\r\n\r\n<p><em>Z pozdrowieniami,</em></p>\r\n\r\n<p><em>Wiesław Omlet</em></p>\r\n', '<p><strong>OD</strong>: womlet@omet.pl</p>\r\n\r\n<p><strong>DO</strong>: hotelstar@pekunia.pl</p>\r\n\r\n<p><strong>TEMAT</strong>: Śniadania</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><em>Witam serdecznie!</em></p>\r\n\r\n<p><em>W zeszłym tygodniu miałem okazję spędzić noc w Państwa hotelu. Bardzo mi się podobało. Jak na tak krótki staż w branży, potraficie Państwo zadbać zarówno o klienta jak i o stan jego portfela. Mam jednak pewną sugestię. Otóż, ze względu na specyfikę mojego zawodu, spędzam w hotelach bardzo dużo czasu. Co najmniej tydzień w każdym miesiącu. Przyzwyczaiłem się do śniadania oferowanego klientom w cenie noclegu. Dobrze jest coś przekąsić przed wyruszeniem w dalszą drogę. Proszę się nad tym zastanowić, nawet jeżeli miałoby to nieznacznie wpłynąć na cenę doby hotelowej. Najedzony klient to podwójnie zadowolony klient. Z przyjemnością sprawdzę jaką podjęli Państwo decyzję w tej kwestii, jeżeli tylko będę w pobliżu uroczego miasta Pekunia.</em></p>\r\n\r\n<p><em>Z pozdrowieniami,</em></p>\r\n\r\n<p><em>Wiesław Omlet</em></p>\r\n', '', '', '', 'pl', 'sniadania'),
(41, 'Grupy klientów', '<p>od: doradca@ue.pl</p>\r\n\r\n<p>do: hotel@pekunia.pl</p>\r\n\r\n<p>Temat: Grupy klientów</p>\r\n\r\n<p>Witaj!</p>\r\n\r\n<p>Widzę znaczne postępy od naszego ostatniego spotkania. Gratulacje! Tym razem chciałbym przedstawić Ci coś, co nazywa się segmentacją rynku. Oznacza to, że Twoich klientów można przyporządkować do grupy określającej ich zachowania, preferencje. Dzięki temu, będziesz miał możliwość dostosowania swojej oferty dla danego segmentu. Przemyśl to, Twoja decyzja na których segmentach chcesz się skupić powinna wynikać z aktualnej sytuacji finansowej hotelu.</p>\r\n\r\n<ol>\r\n	<li><strong>Oszczędni</strong> – studenci i pracownicy o niskich dochodach. Czynnikiem jaki skusi ich do spędzenia nocy w twoim hotelu jest niska cena. Ich oczekiwania co do jakości są również niskie, nie wpływa na nich oferta usług dodatkowych np. śniadań. Przeciętnie zostają na dłużej. Nawet powyżej 1–2 tygodni. Najefektywniej dotrzeć do nich można poprzez reklamę lokalną.</li>\r\n	<li><strong>Globtroterzy.</strong> Podróżujący turyści również będą zainteresowani niską ceną. Nie mają wygórowanych oczekiwań co do jakości obsługi, czy liczby oferowanych usług dodatkowych. Jednakże przywiązują szczególną uwagę do jakości dodatkowych usług czy wydarzeń, jakie dzieją się w mieście. Klienci z tego segmentu pojawiają się okresowo. Jest ich wielu, jednakże tylko w okresach szczytowych, dlatego zostają na krótko – 1–2 dni. Dotrzeć do nich możesz za pomocą reklamy internetowej i rozbudowanej strony www.</li>\r\n	<li><strong>Rodziny.</strong> Ich oczekiwania to balans pomiędzy ceną a jakością obsługi. Silnie wpływa na nich cena i jakość obsługi, także oferty dodatkowe skierowane stricte do nich (np. opieka nad dziećmi). Jest to najliczniejszy segment spędzający raczej średnią ilości czasu, najwyżej kilka dni. Dotrzeć do nich można za pomocą reklamy regionalnej i lokalnej.</li>\r\n	<li><strong>Biznesmeni</strong>, segment oczekujący najwyższej jakości, zarazem niewrażliwy na ceny, interesuje ich klasa i ranga usług. Oferta dodatkowa nie wypływa na nich zbyt mocno, chyba że jest do nich skierowana. Dotrzeć do nich możesz przez reklamę regionalną.</li>\r\n</ol>\r\n', '<h1>Witaj!</h1>\r\n\r\n<p>Widzę znaczne postępy od naszego ostatniego spotkania. Gratulacje! Tym razem chciałbym przedstawić Ci coś, co nazywa się segmentacją rynku. Oznacza to, że Twoich klientów można przyporządkować do grupy określającej ich zachowania, preferencje. Dzięki temu, będziesz miał możliwość dostosowania swojej oferty dla danego segmentu. Przemyśl to, Twoja decyzja na których segmentach chcesz się skupić powinna wynikać z aktualnej sytuacji finansowej hotelu.</p>\r\n\r\n<p>Zakładka grupy klientów:</p>\r\n\r\n<ol>\r\n	<li><strong>Oszczędni</strong> – studenci i pracownicy o niskich dochodach. Czynnikiem jaki skusi ich do spędzenia nocy w twoim hotelu jest niska cena. Ich oczekiwania co do jakości są również niskie, nie wpływa na nich oferta usług dodatkowych np. śniadań. Przeciętnie zostają na dłużej. Nawet powyżej 1–2 tygodni. Najefektywniej dotrzeć do nich można poprzez reklamę lokalną.</li>\r\n	<li><strong>Globtroterzy.</strong> Podróżujący turyści również będą zainteresowani niską ceną. Nie mają wygórowanych oczekiwań co do jakości obsługi, czy liczby oferowanych usług dodatkowych. Jednakże przywiązują szczególną uwagę do jakości dodatkowych usług czy wydarzeń, jakie dzieją się w mieście. Klienci z tego segmentu pojawiają się okresowo. Jest ich wielu, jednakże tylko w okresach szczytowych, dlatego zostają na krótko – 1–2 dni. Dotrzeć do nich możesz za pomocą reklamy internetowej i rozbudowanej strony www.</li>\r\n	<li><strong>Rodziny.</strong> Ich oczekiwania to balans pomiędzy ceną a jakością obsługi. Silnie wpływa na nich cena i jakość obsługi, także oferty dodatkowe skierowane stricte do nich (np. opieka nad dziećmi). Jest to najliczniejszy segment spędzający raczej średnią ilości czasu, najwyżej kilka dni. Dotrzeć do nich można za pomocą reklamy regionalnej i lokalnej.</li>\r\n	<li><strong>Biznesmeni</strong>, segment oczekujący najwyższej jakości, zarazem niewrażliwy na ceny, interesuje ich klasa i ranga usług. Oferta dodatkowa nie wypływa na nich zbyt mocno, chyba że jest do nich skierowana. Dotrzeć do nich możesz przez reklamę regionalną.</li>\r\n</ol>\r\n', '', '', '', 'pl', 'grupy-klientow'),
(42, 'Podjazd dla osób niepełnosprawnych', '<p>OD: npnspr@pomagam.pl</p>\r\n\r\n<p>DO: hotel@pekunia.pl</p>\r\n\r\n<p>Temat: Sprawozdanie z kontroli wydatkowania funduszy europejskich.</p>\r\n\r\n<p>Szanowni Państwo!</p>\r\n\r\n<p>Istnieje możliwość dostosowania budynku Twojego hotelu dla osób niepełnosprawnych. Dzięki temu, będziesz mógł zatrudniać osoby niepełnosprawne oraz przyjmować niepełnosprawnych gości. Wpłynie to na wzrost prestiżu Twojego hotelu.</p>\r\n\r\n<p>Z wyrazami szacunku,</p>\r\n\r\n<p>Stowarzyszenie Osób Niepełnosprawnych</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '<p><span style="text-align: justify;">Tekst eventu "Podjazd dla niepełnosprawnych".</span></p>\r\n', '', '', '', 'pl', 'podjazd-dla-osob-niepelnosprawnych'),
(43, 'Sprawozdanie z kontroli wydatkowania funduszy europejskich', '<p>OD: kontrola@efs.gov.pl</p>\r\n\r\n<p>DO: hotel@pekunia.pl</p>\r\n\r\n<p>Temat: Sprawozdanie z kontroli wydatkowania funduszy europejskich.</p>\r\n\r\n<p>Szanowni Państwo!</p>\r\n\r\n<p>W związku z kontrolą w Państwa przedsiębiorstwie, która obejmowała ostatnie pół roku działalności, z przykrością zawiadamiamy o znalezionych nieprawidłowościach. Otrzymane fundusze miały zostać przeznaczone na rozwój Państwa przedsiębiorstwa. We wniosku aplikacyjnym deklarowali Państwo rozpoczęcie działalności hotelarskiej. Niestety okazuje się, że otrzymane fundusze nie zostały wykorzystane na rozwój pomieszczeń do wynajęcia. W związku z tym wysyłamy <strong><u>ostateczne ostrzeżenie;</u></strong> proszę zacząć rozbudowywać swoją działalność w najbliższym kwartale. W przeciwnym wypadku będziemy zmuszeni cofnąć dofinansowanie i ubiegać się o zwrot wypłaconych już pieniędzy.</p>\r\n\r\n<p>Z wyrazami szacunku,</p>\r\n\r\n<p>Komisja Funduszy Europejskich</p>\r\n', '<p>OD: kontrola@efs.gov.pl</p>\r\n\r\n<p>DO: hotel@pekunia.pl</p>\r\n\r\n<p>Szanowni Państwo!</p>\r\n\r\n<p>W związku z kontrolą w Państwa przedsiębiorstwie, która obejmowała ostatnie pół roku działalności, z przykrością zawiadamiamy o znalezionych nieprawidłowościach. Otrzymane fundusze miały zostać przeznaczone na rozwój Państwa przedsiębiorstwa. We wniosku aplikacyjnym deklarowali Państwo rozpoczęcie działalności hotelarskiej. Niestety okazuje się, że otrzymane fundusze nie zostały wykorzystane na rozwój pomieszczeń do wynajęcia. W związku z tym wysyłamy <strong><u>ostateczne ostrzeżenie;</u></strong> proszę zacząć rozbudowywać swoją działalność w najbliższym kwartale. W przeciwnym wypadku będziemy zmuszeni cofnąć dofinansowanie i ubiegać się o zwrot wypłaconych już pieniędzy.</p>\r\n\r\n<p>Z wyrazami szacunku,</p>\r\n\r\n<p>Komisja Funduszy Europejskich</p>\r\n', '', '', '', 'pl', 'sprawozdanie-z-kontroli-wydatkowania-funduszy-europejskich'),
(45, 'Kredyt karny', '<p>OD:&nbsp;bank@pekunia.pl</p>\r\n\r\n<p>DO: hotel@pekunia.pl</p>\r\n\r\n<p>TEMAT:&nbsp;Kredyt karny</p>\r\n\r\n<p>Szanowni Państwo,</p>\r\n\r\n<p>Ponieważ zabrakło Wam środków na pokrycie zobowiązań finansowych w zeszłym kwartale, przyznano Ci kredyt karny w wysokości %kredyt_karny_kwota%<wartosc modelu="" z="">. Jeżeli uda Ci się poprawić sytuację finansową możesz dokonać spłaty tego kredytu w najbliższym oddziale banku. Oprocentowanie kredytu karnego wynosi %kredyt_karny_odsetki% %&nbsp;<wartosc modelu="" z="">&nbsp;w skali roku.</wartosc></wartosc></p>\r\n\r\n<p>Z poważaniem,</p>\r\n\r\n<p>Bank Pewniak</p>\r\n', '<p>&nbsp;</p>\r\n\r\n<p><span style="text-align: justify;">Uwaga dostałeś kredyt karny!!!</span></p>\r\n', '', '', '', 'pl', 'kredyt-karny'),
(46, 'Zaciekły konkurent', '<p>OD:&nbsp;<a href="mailto:doradca@omet.pl" target="_blank">doradca@omet.pl</a></p>\r\n\r\n<p>DO:&nbsp;<a href="mailto:hotel@pekunia.pl" target="_blank">hotel@pekunia.pl</a></p>\r\n\r\n<p>Witam!</p>\r\n\r\n<p>Mam nadzieję, że dobrze sobie radzicie z zarządzaniem hotelem. Z moich informacji wynika, że jeden z Waszych konkurentów rozpoczął krajową kampanię reklamową, w której oczernia inne firmy hotelarskie w Pekunii (pewnie już o tym wiecie). Pamiętajcie, że jedną z metod obrony, którą możecie zastosować w tej sytuacji jest inwestycja w reklamę krajową i dostosowanie swojej oferty do preferencji wybranego segmentu klientów.</p>\r\n\r\n<p>Życzę Wam powodzenia!</p>\r\n\r\n<p>Wasz doradca</p>\r\n\r\n<p>&nbsp;</p>\r\n', '<p>Zaciekły konkurent</p>\r\n', '', '', '', 'pl', 'zaciekly-konkurent'),
(47, 'Projekty władz samorządowych', '<p>OD: ratusz@pekunia.gov.pl</p>\r\n\r\n<p>DO: hotel@pekunia.pl</p>\r\n\r\n<p>Tytuł: Projekty władz samorządowych.</p>\r\n\r\n<p>Szanowni Państwo,</p>\r\n\r\n<p>władze samorządowe Pekunii planują w najbliższych kwartałach, budowę trzech nowych obiektów: wyciągu narciarskiego, kolejki plażowej oraz pola golfowego. Przedsiębiorcy, którzy zdecydują się na współfinansownie tych inwestycji mogą liczyć na długoterminowe korzyści. Koszt partycypacji w danym projekcie jest jednorazowy.</p>\r\n\r\n<p>Poniżej przedstawiamy krótką charakterystykę inwestycji:</p>\r\n\r\n<ul>\r\n	<li>Wyciąg narciarski. Poszukiwani są inwestorzy, gotowi pomóc w wybudowaniu wyciągu narciarskiego w naszym mieście. W zamian za współfinansowanie inwestycji, przedsiębiorcy będą mogli wykupić nieograniczoną liczbę karnetów po preferencyjnych cenach.</li>\r\n	<li>Kolejka plażowa. Poszukujemy inwestorów, mogących wspomóc projekt wybudowania kolejki linowej na plażę Zalewu Pekuńskiego. W zamian za współfinansowanie inwestycji, przedsiębiorcy będą mogli wykupić nieograniczoną liczbę karnetów po preferencyjnych cenach.</li>\r\n	<li>Pole golfowe. Projekt ten adresowany jest do wszystkich inwestorów zainteresowanych poszerzeniem swojej oferty o tańsze karnety wstępu dla swoich klientówna na nowoczesne pole golfowe. W zamian za współfinansowanie inwestycji, przedsiębiorcy będą mogli wykupić nieograniczoną liczbę karnetów po preferencyjnych cenach.</li>\r\n</ul>\r\n\r\n<p>Pozdrawiamy,</p>\r\n\r\n<p>Urząd Miasta Pekunia</p>\r\n', '<p><span style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-size: 13px; background-color: rgb(255, 255, 255);">Projekty władz samorządowych</span></p>\r\n', '', '', '', 'pl', 'projekty-wladz-samorzadowych'),
(48, 'Nowe badanie marketingowe!', '<p><strong>OD</strong>: agencja.reklamy@pekunia.org</p>\r\n\r\n<p><strong>Do</strong>: hotel@pekunia.pl</p>\r\n\r\n<p><strong>Temat</strong>: Badanie marketingowe dotczące oddziaływania usług podstawowych na rynek.</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>Mili Państwo,</p>\r\n\r\n<p>w tej rundzie mamy do zaoferowania badanie marketingowe, które przedstawi sposób oraz efektywność działania usług podstawowych.</p>\r\n\r\n<p>Z poważaniem,</p>\r\n\r\n<p>Agencja Reklamy</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '<p>uwaga-badanie-marketingowe-uslugi-podstawowe</p>\r\n', '', '', '', 'pl', 'nowe-badanie-marketingowe'),
(49, 'Nowe Badanie Marketingowe!', '<p>OD: agencja.reklamy@pekunia.org</p>\r\n\r\n<p>Do: hotel@pekunia.pl</p>\r\n\r\n<p>Temat: Sezonowość w Pekunii.</p>\r\n\r\n<p>Mili Państwo,</p>\r\n\r\n<p>w tej rundzie mamy do zaoferowania badanie marketingowe, które opisuje czym jest sezonowość oraz jak ona oddziałuje na hotelarski rynek Pekunii.</p>\r\n\r\n<p>Z poważaniem,</p>\r\n\r\n<p>Agencja Reklamy</p>\r\n', '<p>uwaga-badanie-marketingowe-sezonowosc</p>\r\n', '', '', '', 'pl', 'uwaga-badanie-marketingowe-sezonowosc'),
(50, 'Nowe Badanie Marketingowe!', '<p>&nbsp;</p>\r\n\r\n<p>OD: agencja.reklamy@pekunia.org</p>\r\n\r\n<p>DO: hotel@pekunia.pl</p>\r\n\r\n<p>Temat: Badanie marketingowe opisujące popyt na pokoje Delux.</p>\r\n\r\n<p>Mili Państwo,</p>\r\n\r\n<p>w tej rundzie mamy do zaoferowania badanie marketingowe, które przedstawia czym charakteryzuje się popyt na pokoje Delux.</p>\r\n\r\n<p>Z poważaniem,</p>\r\n\r\n<p>Agencja Reklamy</p>\r\n', '<p>uwaga-badanie-marketingowe-popyt-lux</p>\r\n', '', '', '', 'pl', 'uwaga-badanie-marketingowe-popyt-lux'),
(51, 'Nowe Badanie Marketingowe!', '<p>OD: agencja.reklamy@pekunia.org</p>\r\n\r\n<p>DO: hotel@pekunia.pl</p>\r\n\r\n<p>Temat: Badanie marketingowe dotyczące oddziaływania reklamy na rynek.</p>\r\n\r\n<p>Mili Państwo,</p>\r\n\r\n<p>w tej rundzie mamy do zaoferowania badanie marketingowe, które pomoże zaplanować odpowiednią strategię reklamową.</p>\r\n\r\n<p>Z poważaniem,</p>\r\n\r\n<p>Agencja Reklamy</p>\r\n', '<p>uwaga-badanie-marketingowe-reklama-zaawansowana</p>\r\n', '', '', '', 'pl', 'uwaga-badanie-marketingowe-reklama-zaawansowana'),
(52, 'Nowe Badanie Marketingowe!', '<p>OD: agencja.reklamy@pekunia.org</p>\r\n\r\n<p>DO: hotel@pekunia.pl</p>\r\n\r\n<p>Temat: Badanie konkurencji.</p>\r\n\r\n<p>Mili Państwo,</p>\r\n\r\n<p>w tej rundzie mamy do zaoferowania badanie konkurencji, które przedstawia jej najważniejsze cechy.</p>\r\n\r\n<p>Z poważaniem,</p>\r\n\r\n<p>Agencja Reklamy</p>\r\n', '<p>uwaga-badanie-marketingowe-konkurencja</p>\r\n', '', '', '', 'pl', 'nowe-badanie-marketingowe-1'),
(53, 'Nowe Badanie Marketingowe!', '<p><strong>OD</strong>: agencja.reklamy@pekunia.org</p>\r\n\r\n<p><strong>DO</strong>: hotel@pekunia.pl</p>\r\n\r\n<p><strong>Temat</strong>: Badanie marketingowe dotczące zjawiska segmentacji oraz działania usług zaawansowanych.</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>Mili Państwo,</p>\r\n\r\n<p>W tej rundzie mamy do zaoferowania badanie marketingowe, które wyjaśni Ci zjawisko segmentacji rynku oraz opisze działanie usług zaawansowanych.</p>\r\n\r\n<p>Z poważaniem,</p>\r\n\r\n<p>Agencja Reklamy</p>\r\n', '<p>uwaga-badanie-marketingowe-uslugi-zaawansowane-segmentacja</p>\r\n', '', '', '', 'pl', 'uwaga-badanie-marketingowe-uslugi-zaawansowane-segmentacja'),
(59, 'Sprawdź ceny pokoi Standard!', '<p>od: doradca@pekunia.pl</p>\r\n\r\n<p>do: hotel@pekunia.pl</p>\r\n\r\n<p>Temat: Ceny Standard</p>\r\n\r\n<p>Witajcie,</p>\r\n\r\n<p>W poprzednim kwartale nie ustawiliście ceny za wynajem pokoi Standard. Niestety w związku z tym niedopatrzeniem w obecnej rundzie Wasze pokoje nie będą mogły być wynajmowane - robienie tego za darmo byłoby istnym szaleństwem! Poprawcie ten błąd i uważajcie na swoje decyzje w kolejnych rundach.</p>\r\n\r\n<p>pozdrawiam,</p>\r\n\r\n<p>Doradca</p>\r\n', 'Cena zero standard', '', '', '', 'pl', 'sprawdz-ceny-pokoi-standard'),
(60, 'Sprawdź ceny pokoi Delux!', '<p>od: doradca@pekunia.pl</p>\r\n\r\n<p>do: hotel@pekunia.pl</p>\r\n\r\n<p>Temat: Ceny Delux</p>\r\n\r\n<p>Witajcie,</p>\r\n\r\n<p>W poprzednim kwartale nie ustawiliście ceny za wynajem pokoi Delux. Niestety w związku z tym niedopatrzeniem w obecnej rundzie Wasze pokoje nie będą mogły być wynajmowane - robienie tego za darmo byłoby istnym szaleństwem! Poprawcie ten błąd i uważajcie na swoje decyzje w kolejnych rundach.</p>\r\n\r\n<p>pozdrawiam,</p>\r\n\r\n<p>Doradca</p>\r\n', 'Cena zero lux', '', '', '', 'pl', 'sprawdz-ceny-pokoi-delux'),
(61, 'Akcja charytatywna', '<p>OD:&nbsp;ratusz@pekunia.org</p>\r\n\r\n<p>DO: hotel@pekunia.org</p>\r\n\r\n<p>Temat: Akcja charytatywna</p>\r\n\r\n<p>Szanowni Państwo,</p>\r\n\r\n<p>organizujemy zbiórkę pieniędzy, wspierającą pobliski dom dziecka. Gorąco zachęcamy do udziału. Podmioty biorące udział w akcji zostaną wpisane na listę Złotych Darczyńców miasta Pekunia. Zainteresowanych zapraszamy do Ratusza.</p>\r\n\r\n<p>Z poważaniem,</p>\r\n\r\n<p>Zespół Wizerunku Miasta Pekunia</p>\r\n', '', '', '', '', 'pl', 'akcja-charytatywna'),
(63, 'Przykładowe loga', '', '', '', '', '', 'pl', 'przykadlowe-logaa');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `article_translation_index`
--

CREATE TABLE IF NOT EXISTS `article_translation_index` (
  `keyword` varchar(200) NOT NULL DEFAULT '',
  `field` varchar(50) NOT NULL DEFAULT '',
  `position` bigint(20) NOT NULL DEFAULT '0',
  `id` int(11) NOT NULL DEFAULT '0',
  `lang` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`keyword`,`field`,`position`,`id`,`lang`),
  KEY `article_translation_index_id_article_translation_id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `art_configuration`
--

CREATE TABLE IF NOT EXISTS `art_configuration` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` mediumtext NOT NULL,
  `editable` tinyint(4) NOT NULL DEFAULT '1',
  `widget` mediumtext,
  `validator` mediumtext,
  `renderer` mediumtext,
  `default` mediumtext,
  `order` int(11) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order` (`order`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=16 ;

--
-- Zrzut danych tabeli `art_configuration`
--

INSERT INTO `art_configuration` (`id`, `name`, `editable`, `widget`, `validator`, `renderer`, `default`, `order`, `created_at`, `updated_at`) VALUES
(1, 'meta_description', 1, 'new sfWidgetFormTextarea(array(), array(''rows'' => ''3'' , ''class'' => ''no-ckeditor''))', 'new sfValidatorString(array(''required'' => false))', NULL, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(2, 'meta_title', 1, 'new sfWidgetFormTextarea(array(), array(''rows'' => ''3'' , ''class'' => ''no-ckeditor''))', 'new sfValidatorString(array(''required'' => false))', NULL, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(3, 'meta_keywords', 1, 'new sfWidgetFormTextarea(array(), array(''rows'' => ''3'' , ''class'' => ''no-ckeditor''))', 'new sfValidatorString(array(''required'' => false))', NULL, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(4, 'meta_keywords', 0, 'new sfArtWidgetFormInputText()', 'new sfValidatorString(array(''required'' => false))', NULL, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(5, 'google_maps_code', 1, 'new sfWidgetFormTextarea(array(), array(''rows'' => ''3'' , ''class'' => ''no-ckeditor''))', 'new sfValidatorString(array(''required'' => false))', NULL, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(6, 'google_analytics_code', 1, 'new sfWidgetFormTextarea(array(), array(''rows'' => ''3'' , ''class'' => ''no-ckeditor''))', 'new sfValidatorString(array(''required'' => false))', NULL, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(7, 'phone', 1, 'new sfArtWidgetFormInputText()', 'new sfValidatorString(array(''required'' => false))', NULL, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(8, 'copyright', 1, 'new sfArtWidgetFormInputText()', 'new sfValidatorString(array(''required'' => false))', NULL, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(9, 'contact_email', 1, 'new sfArtWidgetFormInputText()', 'new sfValidatorEmail(array(''required'' => false))', NULL, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(10, 'teacher_register_mode', 1, 'new sfWidgetFormChoice(array(''choices'' => array(\n  0 => _(''Pełne''),\n  1 => _(''Demo'')\n)))\n', 'new sfValidatorChoice(array(\n          ''choices'' => array(0,1),\n          ''required'' => true\n      ))\n', NULL, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(11, 'social_facebook', 1, 'new sfArtWidgetFormInputText()', 'new sfValidatorString(array(''required'' => false))', NULL, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(12, 'social_twitter', 1, 'new sfArtWidgetFormInputText()', 'new sfValidatorString(array(''required'' => false))', NULL, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(13, 'social_googleplus', 1, 'new sfArtWidgetFormInputText()', 'new sfValidatorString(array(''required'' => false))', NULL, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(14, 'social_youtube', 1, 'new sfArtWidgetFormInputText()', 'new sfValidatorString(array(''required'' => false))', NULL, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(15, 'teacher_register_mode', 1, 'new sfWidgetFormChoice(array(''''choices'''' => array(\\n  0 => _(''''Pełne''''),\\n  1 => _(''''Demo'''')\\n)))\\n', 'new sfValidatorChoice(array(\\n          ''''choices'''' => array(0,1),\\n          ''''required'''' => true\\n      ))\\n', NULL, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `art_configuration_translation`
--

CREATE TABLE IF NOT EXISTS `art_configuration_translation` (
  `id` int(11) NOT NULL DEFAULT '0',
  `label` varchar(255) DEFAULT NULL,
  `hint` mediumtext,
  `value` mediumtext NOT NULL,
  `lang` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`lang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Zrzut danych tabeli `art_configuration_translation`
--

INSERT INTO `art_configuration_translation` (`id`, `label`, `hint`, `value`, `lang`) VALUES
(1, NULL, NULL, '', 'pl'),
(2, NULL, NULL, 'HotelStars', 'pl'),
(3, NULL, NULL, '', 'pl'),
(4, NULL, NULL, '', 'pl'),
(5, NULL, NULL, '', 'pl'),
(6, NULL, NULL, '', 'pl'),
(7, NULL, NULL, '', 'pl'),
(8, NULL, NULL, '', 'pl'),
(9, NULL, NULL, 'mailer@email.arteneo.pl', 'pl'),
(10, NULL, NULL, '', 'pl'),
(11, NULL, NULL, '', 'pl'),
(12, NULL, NULL, '', 'pl'),
(13, NULL, NULL, '', 'pl'),
(14, NULL, NULL, '', 'pl'),
(15, NULL, NULL, '', 'pl');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `class_has_user`
--

CREATE TABLE IF NOT EXISTS `class_has_user` (
  `class_id` bigint(20) NOT NULL DEFAULT '0',
  `user_id` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`class_id`,`user_id`),
  KEY `fk_class_has_sf_guard_user_sf_guard_user1_idx` (`user_id`),
  KEY `fk_class_has_sf_guard_user_class1_idx` (`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `friend`
--

CREATE TABLE IF NOT EXISTS `friend` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `friend_id` bigint(20) DEFAULT NULL,
  `accepted` tinyint(4) DEFAULT '0',
  `mail` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_friend_sf_guard_user1_idx` (`user_id`),
  KEY `fk_friend_sf_guard_user2_idx` (`friend_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `friend_blacklist`
--

CREATE TABLE IF NOT EXISTS `friend_blacklist` (
  `user_id` bigint(20) NOT NULL DEFAULT '0',
  `ignored_user_id` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`ignored_user_id`),
  KEY `fk_sf_guard_user_has_sf_guard_user_sf_guard_user2_idx` (`ignored_user_id`),
  KEY `fk_sf_guard_user_has_sf_guard_user_sf_guard_user1_idx` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `game`
--

CREATE TABLE IF NOT EXISTS `game` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `teacher_id` bigint(20) NOT NULL,
  `name` varchar(255) NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `game_data_json` longtext,
  `game_controller_class` varchar(125) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_game_sf_guard_user1_idx` (`teacher_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=249 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `game_teacher_permission`
--

CREATE TABLE IF NOT EXISTS `game_teacher_permission` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sf_guard_user_permission_id` bigint(20) NOT NULL,
  `game_id` bigint(20) NOT NULL,
  `teacher_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_game_teacher_permission_idx` (`sf_guard_user_permission_id`,`game_id`,`teacher_id`),
  KEY `fk_game_teacher_permission_sf_guard_user_permission1_idx` (`sf_guard_user_permission_id`),
  KEY `fk_game_teacher_permission_game1_idx` (`game_id`),
  KEY `fk_game_teacher_permission_sf_guard_user1_idx` (`teacher_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `guard_user_tag`
--

CREATE TABLE IF NOT EXISTS `guard_user_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `i18n_category`
--

CREATE TABLE IF NOT EXISTS `i18n_category` (
  `cat_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`cat_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- Zrzut danych tabeli `i18n_category`
--

INSERT INTO `i18n_category` (`cat_id`, `name`, `created_at`, `updated_at`) VALUES
(1, 'messages.pl', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(2, 'messages.en', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(3, 'game_info.pl', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(4, 'hint_raport_operacyjny.pl', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(5, 'raport_operacyjny.pl', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(6, 'raport_ranking.pl', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(7, 'raport_kpir.pl', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(8, 'raport_finansowy.pl', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(9, 'adviser.pl', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(10, 'decision_log.pl', '2015-07-31 11:02:42', '2015-07-31 11:02:42');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `i18n_translations`
--

CREATE TABLE IF NOT EXISTS `i18n_translations` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `cat_id` bigint(20) NOT NULL,
  `source` longtext NOT NULL,
  `target` longtext NOT NULL,
  `comments` longtext,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `translated` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `cat_id_idx` (`cat_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2079 ;

--
-- Zrzut danych tabeli `i18n_translations`
--

INSERT INTO `i18n_translations` (`id`, `cat_id`, `source`, `target`, `comments`, `created_at`, `updated_at`, `translated`) VALUES
(1, 1, 'Kobieta', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2, 1, 'Mężczyzna', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(3, 1, 'Zaloguj', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(4, 1, 'Zamknij', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(5, 1, 'Zmień Hasło', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(6, 1, 'Twoje konto %email% zostało uaktywnione.', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(7, 1, 'Alarm zabezpieczeń: nie masz dostępu do oglądania tej strony.', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(8, 1, 'Wyloguj', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(9, 1, 'Email i/lub hasło niepoprawne.', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(10, 1, 'Przypomnienie hasła', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(11, 1, 'Rejestracja', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(12, 1, 'Usuń konto', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(13, 1, 'Potwierdź aby usunąć konto.', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(14, 1, 'Potwierdź', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(15, 1, 'Panel logowania', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(16, 1, 'Zmiana hasła', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(17, 1, 'Zmień', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(18, 1, 'Twoje konto jest aktywne.', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(19, 1, 'Wypełnij formularz poniżej, a otrzymasz e-mail z informacjami jak postępować dalej, żeby zresetować hasło.', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(20, 1, 'Witaj %first_name%', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(21, 1, 'Poniżej pokazane są Twoja nazwa użytkownika i hasło:', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(22, 1, 'Nazwa użytkownika', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(23, 1, 'Hasło', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(24, 1, 'Witaj %name%', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(25, 1, 'Wpisz swoje nowe hasło do formularza poniżej.', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(26, 1, 'Ten e-mail został wysłany, ponieważ zdecydowałeś się zmienić hasło.', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(27, 1, 'W celu zmiany hasła kliknij na link zamieszczony poniżej. Link ten jest ważny przez 24 godziny:', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(28, 1, 'Kliknij tutaj, aby zmienić hasło.', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(29, 1, 'Register', 'Rejestracja', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(30, 1, 'Edytujesz hasło dla ', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(31, 1, 'Zapisz', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(32, 2, 'Kobieta', 'Female', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(33, 2, 'Mężczyzna', 'Male', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(34, 2, 'Zaloguj', 'Login', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(35, 2, 'Zamknij', 'Close', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(36, 2, 'Zmień Hasło', 'Change password', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(37, 2, 'Twoje konto ''%email%'' zostało uaktywnione.', 'Your account ''%email%'' have been activated.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(38, 2, 'Alarm zabezpieczeń: nie masz dostępu do oglądania tej strony.', 'Security Alert: do not have access to view this page.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(39, 2, 'Wyloguj', 'Logout', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(40, 2, 'Email i/lub hasło niepoprawne.', 'Email and / or password incorrect.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(41, 2, 'Przypomnienie hasła', 'Forgot Password?', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(42, 2, 'Rejestracja', 'Register', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(43, 2, 'Usuń konto', 'Delete account', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(44, 2, 'Potwierdź aby usunąć konto.', 'Confirm to delete the account.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(45, 2, 'Potwierdź', 'Confirm', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(46, 2, 'Panel logowania', 'Login panel', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(47, 2, 'Zmiana hasła', 'Changing the password', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(48, 2, 'Zmień', 'Change', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(49, 2, 'Twoje konto jest aktywne.', 'Your account is active.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(50, 2, 'Wypełnij formularz poniżej, a otrzymasz e-mail z informacjami jak postępować dalej, żeby zresetować hasło.', 'Fill out the form below and you will receive an e-mail with information about how to proceed to reset your password.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(51, 2, 'Witaj %first_name%', 'Hello% first_name%', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(52, 2, 'Poniżej pokazane są Twoja nazwa użytkownika i hasło:', 'Are shown below your username and password:', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(53, 2, 'Nazwa użytkownika', 'Usename', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(54, 2, 'Hasło', 'Password', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(55, 2, 'Witaj %name%', 'Hello %name%', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(56, 2, 'Wpisz swoje nowe hasło do formularza poniżej.', 'Enter your new password in the form below.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(57, 2, 'Ten e-mail został wysłany, ponieważ zdecydowałeś się zmienić hasło.', 'This e-mail was sent because you decided to change your password.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(58, 2, 'W celu zmiany hasła kliknij na link zamieszczony poniżej. Link ten jest ważny przez 24 godziny:', 'To change your password, click on the link below. This link is valid for 24 hours:', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(59, 2, 'Kliknij tutaj, aby zmienić hasło.', 'Click here to change your password.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(60, 2, 'Register', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(61, 2, 'Edytujesz hasło dla ', 'Editing password', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(62, 2, 'Zapisz', 'Save', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(63, 1, 'Array', 'Array', 'Array', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 0),
(64, 1, 'Nie podano nazwy', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(65, 1, 'Imie', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(66, 1, 'Nazwisko', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(67, 1, 'Nazwa statusu', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(68, 1, 'Niaktywny', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(69, 1, 'Aktywny', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(70, 1, 'Ręcznie dodany', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(71, 1, 'Dodany z bazy danych', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(72, 1, 'Z bazy danych - Wysyłanie', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(73, 1, 'Ręcznie dodany - Wysyłanie', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(74, 1, 'Unikalna nazwa niezdefiniowana.', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(75, 1, 'Brak Message Template, skontaktuj się z administratorem.', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(76, 1, '[No title]', '[Brak tytułu]', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(77, 1, 'Nazwa unikalna', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(78, 1, 'Zarządzaj katalogami', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(79, 1, 'Dodaj katalog', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(80, 1, 'Edytuj katalogi', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(81, 1, 'Usuń katalogi', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(82, 1, 'Wybierz akcję', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(83, 1, 'Usuń całkowicie', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(84, 1, 'Przenieś do kosza', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(85, 1, 'Dodaj do folderu:', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(86, 1, 'Przenieś do folderu:', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(87, 1, 'Zapisz', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(88, 1, 'Nowa wiadomość', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(89, 1, 'First page', 'Pierwsza strona', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(90, 1, 'Pierwsza strona', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(91, 1, 'Previous page', 'Poprzednia strona', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(92, 1, 'Poprzednia strona', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(93, 1, 'Next page', 'Następna strona', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(94, 1, 'Nastepna strona', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(95, 1, 'Last page', 'Ostatnia strona', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(96, 1, 'Ostatnia strona', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(97, 1, 'Czy na pewno?', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(98, 1, 'Lista użytkowników newslettera', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(99, 1, 'Edytujesz ustawienia wiadomości dla kanału "%1%" i unikalnej nazwy "%2%"', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(100, 1, 'Dodaj szablon wiadomości', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(101, 1, 'Wysłano', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(102, 1, 'Dodaj', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(103, 1, 'tab_', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(104, 1, 'Przygotowano wiadomości do wysłania, wyślą się automatycznie.', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(105, 1, 'Wysłano %count% wiadomości!', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(106, 1, 'Tutaj możesz wysłać wiadomość testową na podany e-mail, aby sprawdzić jej poprawność', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(107, 2, 'Nie podano nazwy', 'No name given', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(108, 2, 'Imie', 'First name', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(109, 2, 'Nazwisko', 'Last name', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(110, 2, 'Nazwa statusu', 'Status name', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(111, 2, 'Niaktywny', 'Inactive', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(112, 2, 'Aktywny', 'Active', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(113, 2, 'Ręcznie dodany', 'Manually added', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(114, 2, 'Dodany z bazy danych', 'Added from the database', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(115, 2, 'Z bazy danych - Wysyłanie', 'From database - sending', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(116, 2, 'Ręcznie dodany - Wysyłanie', 'Manually added - sending', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(117, 2, 'Unikalna nazwa niezdefiniowana.', 'Unique name is not defined.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(118, 2, 'Brak Message Template, skontaktuj się z administratorem.', 'No Message Template, please contact the administrator.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(119, 2, '[No title]', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(120, 2, 'Nazwa unikalna', 'Unique name', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(121, 2, 'Zarządzaj katalogami', 'Manage catalogs', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(122, 2, 'Dodaj katalog', 'Add catalog', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(123, 2, 'Edytuj katalogi', 'Edit catalogs', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(124, 2, 'Usuń katalogi', 'Delete catalogs', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(125, 2, 'Wybierz akcję', 'Choose an action', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(126, 2, 'Usuń całkowicie', 'Delete completely', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(127, 2, 'Przenieś do kosza', 'Move to trash', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(128, 2, 'Dodaj do folderu:', 'Add to catalog', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(129, 2, 'Przenieś do folderu:', 'Move to catalog', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(130, 2, 'Zapisz', 'Save', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(131, 2, 'Nowa wiadomość', 'New message', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(132, 2, 'First page', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(133, 2, 'Pierwsza strona', 'First page', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(134, 2, 'Previous page', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(135, 2, 'Poprzednia strona', 'Previous page', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(136, 2, 'Next page', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(137, 2, 'Nastepna strona', 'Next page', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(138, 2, 'Last page', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(139, 2, 'Ostatnia strona', 'Last page', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(140, 2, 'Czy na pewno?', 'Are you sure?', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(141, 2, 'Lista użytkowników newslettera', 'Member Newsletter List', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(142, 2, 'Edytujesz ustawienia wiadomości dla kanału "%1%" i unikalnej nazwy "%2%"', 'Edit Message center for channel "%1%" and unique name "%2%"', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(143, 2, 'Dodaj szablon wiadomości', 'Add messages template', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(144, 2, 'Wysłano', 'Submitted', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(145, 2, 'Dodaj', 'Add', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(146, 2, 'tab_', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(147, 2, 'Przygotowano wiadomości do wysłania, wyślą się automatycznie.', 'Prepared message to send, send automatically.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(148, 2, 'Wysłano %count% wiadomości!', 'Send %count% messages!', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(149, 2, 'Tutaj możesz wysłać wiadomość testową na podany e-mail, aby sprawdzić jej poprawność', 'Here you can send a test message to the specified e-mail to verify its correctness.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(150, 1, 'Search', 'Wyszukiwanie', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(151, 1, 'Dodaj artykuł', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(152, 1, 'Edytuj artykuł', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(153, 1, 'Edytuj metadane', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(154, 1, 'Usuń artykuł', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(155, 1, 'Edytuj galerię', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(156, 1, 'Dodaj referencję', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(157, 1, 'Edytuj referencję', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(158, 1, 'Usuń referencję', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(159, 1, 'Dodaj kategorię', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(160, 1, 'Edytuj kategorię', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(161, 1, 'Usuń kategorię', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(162, 1, 'Przesuń w prawo', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(163, 1, 'Przesuń w lewo', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(164, 1, 'Zmień hasło', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(165, 1, 'Pokaż ikonki', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(166, 1, 'Ukryj ikonki', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(167, 1, 'Konfiguracja', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(168, 1, 'Wyloguj', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(169, 1, 'Brak artykułów', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(170, 1, 'Ta kategoria nie istnieje.', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(171, 1, 'Posted on ', 'Wysłano', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(172, 1, 'Czytaj więcej', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(173, 1, 'Skomentuj', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(174, 1, 'Ostatnie posty', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(175, 1, 'No results', 'Brak wyników', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(176, 1, 'none', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(177, 1, 'inside', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(178, 1, '0.6', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(179, 1, '#fff', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(180, 1, '50', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(181, 1, 'Komentarze', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(182, 1, 'Comments', 'Komentarze', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(183, 1, 'Submit', 'Zapisz', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(184, 1, 'więcej', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(185, 1, 'Pobierz', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(186, 1, 'Edycja artykułu', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(187, 1, 'Załączniki', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(188, 1, 'Nie masz uprawnień do oglądania tej strony', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(189, 1, 'Referencje', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(190, 1, 'Galeria zdjęć', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(191, 1, 'Podany artykuł nie istnieje lub jest nieaktywny!', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(192, 1, 'Jesteś pewien?', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(193, 1, 'Wyszukiwanie ...', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(194, 1, 'search-form', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(195, 1, 'searchText', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(196, 1, 'Wyszukiwanie', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(197, 1, 'Ustawienia artykułu', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(198, 1, 'Send', 'Wyślij', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(199, 1, 'Drukuj', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(200, 1, 'Are you sure?', 'Jesteś pewien?', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(201, 1, 'Add new article', 'Dodaj nowy artykuł', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(202, 1, 'Zmień opis artykułu', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(203, 1, 'Zmień meta tagi arykułu', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(204, 1, 'Dodaj nowy artykuł', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(205, 1, 'Image', 'Obraz', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(206, 1, 'of', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(207, 1, 'Brak wyników', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(208, 1, 'Pobierz PDF', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(209, 1, 'Czytaj więcej...', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(210, 1, 'więcej...', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(211, 1, 'mniej...', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(212, 1, 'Lista newsów', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(213, 1, 'Nie posiadasz uprawnień do oglądania tej strony!', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(214, 1, 'Search ...', 'Wyszukiwanie...', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(215, 1, 'Wyślij', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(216, 1, 'Dodaj komentarz', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(217, 1, 'Zaloguj się aby dołączyć do rozmowy.', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(218, 1, 'Komentarz dodany pomyślnie.', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(219, 1, 'Zatwierdzony!', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(220, 1, 'Usunięty!', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(221, 1, 'SUBCATEGORY: ', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(222, 1, 'ARTICLE: ', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(223, 1, 'Zapisz', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(224, 1, 'Zamknij', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(225, 1, 'Cofnij', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(226, 1, 'Czy napewno chcesz zmienić kolejność elementów?', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(227, 1, 'Zmień', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(228, 1, 'Dodawanie referencji', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(229, 1, 'Edycja referencji', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(230, 1, 'Usuwanie referencji', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(231, 1, 'Zapisz kolejność', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(232, 1, 'Dodaj zdjęcie', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(233, 1, 'Edycja galerii', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(234, 1, 'Dodawanie zdjęcia', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(235, 1, 'Edycja zdjęcia', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(236, 1, 'Usuwanie zdjęcia', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(237, 1, 'Czy napewno chcesz usunąć referencję "%title%"?', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(238, 1, 'Usuń', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(239, 1, 'Dodawanie artykułu', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(240, 1, 'Edycja metadanych artykułu', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(241, 1, 'Usuwanie artykułu', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(242, 1, 'Czy napewno chcesz usunąć artykuł "%title%"?', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(243, 1, 'Zmiana kolejności', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(244, 1, 'Czy napewno chcesz usunąć kategorię "%name%"?', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(245, 1, 'Czy napewno chcesz usunąć zdjęcie?', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(246, 1, 'Dodawanie kategorii', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(247, 1, 'Edycja kategorii', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(248, 1, 'Usuwanie kategorii', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(249, 2, 'Search', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(250, 2, 'Dodaj artykuł', 'Add article', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(251, 2, 'Edytuj artykuł', 'Edit article', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(252, 2, 'Edytuj metadane', 'Edit metadata', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(253, 2, 'Usuń artykuł', 'Delete article', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(254, 2, 'Edytuj galerię', 'Edit gallery', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(255, 2, 'Dodaj referencję', 'Add reference', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(256, 2, 'Edytuj referencję', 'Edit reference', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(257, 2, 'Usuń referencję', 'Delete reference', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(258, 2, 'Dodaj kategorię', 'Add category', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(259, 2, 'Edytuj kategorię', 'Edit category', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(260, 2, 'Usuń kategorię', 'Delete category', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(261, 2, 'Przesuń w prawo', 'Move right', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(262, 2, 'Przesuń w lewo', 'Move left', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(263, 2, 'Zmień hasło', 'Change password', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(264, 2, 'Pokaż ikonki', 'Show icons', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(265, 2, 'Ukryj ikonki', 'Hide icons', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(266, 2, 'Konfiguracja', 'Configuration', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(267, 2, 'Wyloguj', 'Logout', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(268, 2, 'Brak artykułów', 'No articles', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(269, 2, 'Ta kategoria nie istnieje.', 'This category does not exist.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(270, 2, 'Posted on ', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(271, 2, 'Czytaj więcej', 'Read more', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(272, 2, 'Skomentuj', 'Leave a reply', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(273, 2, 'Ostatnie posty', 'Recent posts', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(274, 2, 'No results', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(275, 2, 'none', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(276, 2, 'inside', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(277, 2, '0.6', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(278, 2, '#fff', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(279, 2, '50', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(280, 2, 'Komentarze', 'Comments', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(281, 2, 'Comments', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(282, 2, 'Submit', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(283, 2, 'więcej', 'more', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(284, 2, 'Pobierz', 'Download', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(285, 2, 'Edycja artykułu', 'Edit article', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(286, 2, 'Załączniki', 'Attachments', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(287, 2, 'Nie masz uprawnień do oglądania tej strony', 'You don''''t have the required permission to access this page.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(288, 2, 'Referencje', 'References', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(289, 2, 'Galeria zdjęć', 'Photo gallery', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(290, 2, 'Podany artykuł nie istnieje lub jest nieaktywny!', 'Article does not exist or is inactive!', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(291, 2, 'Jesteś pewien?', 'Are you sure?', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(292, 2, 'Wyszukiwanie ...', 'Searching ...', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(293, 2, 'search-form', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(294, 2, 'searchText', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(295, 2, 'Wyszukiwanie', 'Search', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(296, 2, 'Ustawienia artykułu', 'Article settings', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(297, 2, 'Send', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(298, 2, 'Drukuj', 'Print', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(299, 2, 'Are you sure?', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(300, 2, 'Add new article', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(301, 2, 'Zmień opis artykułu', 'Change article desription', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(302, 2, 'Zmień meta tagi arykułu', 'Change article meta tags', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(303, 2, 'Dodaj nowy artykuł', 'Add new article', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(304, 2, 'Image', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(305, 2, 'of', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(306, 2, 'Brak wyników', 'No results', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(307, 2, 'Pobierz PDF', 'Download PDF', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(308, 2, 'Czytaj więcej...', 'Read more...', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(309, 2, 'więcej...', 'more...', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(310, 2, 'mniej...', 'less...', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(311, 2, 'Lista newsów', 'News list', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(312, 2, 'Nie posiadasz uprawnień do oglądania tej strony!', 'You don''t have the required permission to access this page!', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(313, 2, 'Search ...', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(314, 2, 'Wyślij', 'Send', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(315, 2, 'Dodaj komentarz', 'Leave a reply', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(316, 2, 'Zaloguj się aby dołączyć do rozmowy.', 'You must log in to join the conversation.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(317, 2, 'Komentarz dodany pomyślnie.', 'Comment added successfully.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(318, 2, 'Zatwierdzony!', 'Approved!', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(319, 2, 'Usunięty!', 'Deleted!', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(320, 2, 'SUBCATEGORY: ', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(321, 2, 'ARTICLE: ', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(322, 2, 'Zapisz', 'Save', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(323, 2, 'Zamknij', 'Close', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(324, 2, 'Cofnij', 'Back', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(325, 2, 'Czy napewno chcesz zmienić kolejność elementów?', 'Are you sure want to change order of elements?', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(326, 2, 'Zmień', 'Change', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(327, 2, 'Dodawanie referencji', 'Add reference', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(328, 2, 'Edycja referencji', 'Edit reference', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(329, 2, 'Usuwanie referencji', 'Delete reference', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(330, 2, 'Zapisz kolejność', 'Save order', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(331, 2, 'Dodaj zdjęcie', 'Add photo', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(332, 2, 'Edycja galerii', 'Edit gallery', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(333, 2, 'Dodawanie zdjęcia', 'Add photo', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(334, 2, 'Edycja zdjęcia', 'Edit photo', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(335, 2, 'Usuwanie zdjęcia', 'Delete photo', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(336, 2, 'Czy napewno chcesz usunąć referencję "%title%"?', 'Are you sure you want to delete reference "%title%"?', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(337, 2, 'Usuń', 'Delete', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(338, 2, 'Dodawanie artykułu', 'Add article', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(339, 2, 'Edycja metadanych artykułu', 'Edit article metadata', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(340, 2, 'Usuwanie artykułu', 'Delete article', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(341, 2, 'Czy napewno chcesz usunąć artykuł "%title%"?', 'Are you sure you want to delete article "%title%"?', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(342, 2, 'Zmiana kolejności', 'Change order', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(343, 2, 'Czy napewno chcesz usunąć kategorię "%name%"?', 'Are you sure you want to delete category "%name%"?', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(344, 2, 'Czy napewno chcesz usunąć zdjęcie?', 'Are you sure you want to delete photo?', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(345, 2, 'Dodawanie kategorii', 'Add category', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(346, 2, 'Edycja kategorii', 'Edit category', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(347, 2, 'Usuwanie kategorii', 'Delete category', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(348, 1, 'Required.', 'Wymagane.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(349, 1, 'Required', 'Wymagane', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(350, 1, 'Password', 'Hasło', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(351, 1, 'The username and/or password is invalid.', 'Nazwa użytkownika lub/i hasło jest niepoprawna', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(352, 1, 'Original image', 'Zdjęcie', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(353, 1, 'Domyślny', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(354, 1, 'Pusty', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(355, 1, 'm2', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(356, 1, 'Record ', 'Rekord', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(357, 1, 'Yes', 'Tak', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(358, 1, 'No', 'Nie', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(359, 1, 'Zaznacz', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(360, 1, 'Wyczyść', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(361, 1, 'Wybierz', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(362, 1, '# wybranych', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(363, 1, 'add_widget_', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(364, 1, 'Anuluj', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(365, 1, 'Dodaj', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(366, 1, 'Date format: yyyy-mm-dd', 'Format daty: yyyy-mm-dd', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(367, 1, 'Przeglądaj', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(368, 1, 'Explore', 'Przeglądaj', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(369, 1, 'From', 'z', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(370, 1, 'To', 'do', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(371, 1, 'Edytuj', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(372, 1, 'Brak wyników', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(373, 1, 'Zamknij', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(374, 1, 'Edycja konfiguracji', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(375, 1, 'Zapisz', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(376, 1, 'Cofnij', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(377, 1, 'Lista konfiguracji', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(378, 1, 'Lista ustawień konfiguracyjnych', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(379, 1, 'Edytuj ustawienie', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(380, 1, 'Projekt', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(381, 1, 'Wykonawca', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(382, 1, 'we współpracy z', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(383, 1, 'tab_', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(384, 1, 'Popraw', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(385, 1, 'Improve the form or cancel changes?', 'Popraw formularz lub anuluj zamiany', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(386, 1, 'Ooops! Błąd 404 !', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(387, 1, 'Strona o podanym adresie nie istnieje !', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(388, 1, 'Powrót do poprzedniej strony', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(389, 1, 'Przejdź do strony głównej', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(390, 1, '<<', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(391, 1, '<', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(392, 1, '>', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(393, 1, '>>', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(394, 1, 'Ilość elementów: ', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(395, 1, 'Strona:', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(396, 1, 'Dodaj nowy plik', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(397, 1, 'Jesteś pewien?', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(398, 1, 'Dodaj nowy obrazek', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(399, 1, 'Add new file', 'Dodaj nowy plik', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(400, 1, 'Komunikat', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(401, 1, 'Błąd', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(402, 1, 'Add new photo', 'Dodaj nowe zdjęcie', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(403, 1, 'Usuń zdjęcie', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(404, 1, 'Loading zoom', 'Wczytywanie powiększenia', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(405, 2, 'Domyślny', 'Default', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(406, 2, 'Pusty', 'Empty', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(407, 2, 'm2', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(408, 2, 'Record ', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(409, 2, 'Yes', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(410, 2, 'No', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(411, 2, 'Zaznacz', 'check', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(412, 2, 'Wyczyść', 'clear', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(413, 2, 'Wybierz', 'choose', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(414, 2, '# wybranych', '# choosen', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(415, 2, 'add_widget_', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(416, 2, 'Anuluj', 'Cancel', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(417, 2, 'Dodaj', 'Add', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(418, 2, 'Date format: yyyy-mm-dd', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(419, 2, 'Przeglądaj', 'Explore', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(420, 2, 'Explore', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(421, 2, 'From', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(422, 2, 'To', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(423, 2, 'Edytuj', 'Edit', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(424, 2, 'Brak wyników', 'No results', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(425, 2, 'Zamknij', 'Close', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(426, 2, 'Edycja konfiguracji', 'Edit configure', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(427, 2, 'Zapisz', 'Save', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(428, 2, 'Cofnij', 'Back', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(429, 2, 'Lista konfiguracji', 'Configuration list', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(430, 2, 'Lista ustawień konfiguracyjnych', 'List of configuration settings', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(431, 2, 'Edytuj ustawienie', 'Edit settings', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(432, 2, 'Projekt', 'Project', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(433, 2, 'Wykonawca', 'Performer', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(434, 2, 'we współpracy z', 'in association with', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(435, 2, 'tab_', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(436, 2, 'Popraw', 'Improvement', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(437, 2, 'Improve the form or cancel changes?', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(438, 2, 'Ooops! Błąd 404 !', 'Ooops! Error 404 !', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(439, 2, 'Strona o podanym adresie nie istnieje !', 'Page you requested does not exist!', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(440, 2, 'Powrót do poprzedniej strony', 'Back to previous page', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(441, 2, 'Przejdź do strony głównej', 'Go to home page', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(442, 2, '<<', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(443, 2, '<', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(444, 2, '>', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(445, 2, '>>', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(446, 2, 'Ilość elementów: ', 'Number of elements:', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(447, 2, 'Strona:', 'Page:', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(448, 2, 'Dodaj nowy plik', 'Add new file', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(449, 2, 'Jesteś pewien?', 'Are you sure?', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(450, 2, 'Dodaj nowy obrazek', 'Add new image', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(451, 2, 'Add new file', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(452, 2, 'Komunikat', 'Message', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(453, 2, 'Błąd', 'Error', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(454, 2, 'Add new photo', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(455, 2, 'Usuń zdjęcie', 'Delete photo', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(456, 2, 'Loading zoom', '', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(457, 1, 'Article does\\''t exist', 'Artykuł nie istnieje', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(458, 1, 'Contact form does\\''t exist', 'Formularz nie istnieje', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(459, 1, 'Message sent', 'Wiadomość wysłana', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(460, 1, 'Users', 'Użytkownicy', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(461, 1, 'Others', 'Pozostałe', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(462, 1, 'Explore', 'Przeglądaj', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(463, 1, 'Please wait, you logged in with Facebook...', 'Proszę zaczekać, następuje logowanie za pomocą konta Facebook...', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(464, 1, 'Manage gallery', 'Zarządzaj galerią', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(465, 1, 'Icon', 'Ikonka', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(466, 1, 'Permissions', 'Uprawnienia', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(467, 1, 'Groups', 'Grupy', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(468, 1, 'Edit articles', 'Edycja Treści', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(469, 1, 'Articles', 'Artykuły', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(470, 1, 'Articles Category', 'Kategorie artykułów', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(471, 1, 'Your Account is Active.', 'Twoje konto jest aktywne.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(472, 1, 'CSRF attack detected.', 'Wykryto atak CSRF.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(473, 1, 'Your account is active.', 'Twoje konto jest aktywne.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(474, 1, 'Your account ''%email%'' have been activated.', 'Twoje konto ''%email%'' zostało uaktywnione.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(475, 1, 'Your account has been activated.', 'Twoje konto zostało uaktywnione.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(476, 1, 'Your account ''''%email%'''' have been activated.', 'Twoje konto ''''%email%'''' zostało uaktywnione.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(477, 1, 'Reports', 'Raporty', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(478, 1, 'Logs', 'Logi', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(479, 1, 'Generate report', 'Generuj raport', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(480, 1, 'Report history', 'Historia raportów', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(481, 1, 'Service', 'Podgląd serwisu', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(482, 1, 'Messages', 'Wiadomości', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(483, 1, 'Links', 'Odnośniki', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(484, 1, 'Applicants', 'Aplikanci', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(485, 1, 'Settings', 'Ustawienia', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(486, 1, 'Change password', 'Zmień Hasło', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(487, 1, 'Emails', 'Adresy email', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(488, 1, 'Logout', 'Wyloguj', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(489, 1, 'Categories', 'Kategorie', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(490, 1, 'Email have been send.', 'Wiadomość zotała wysłana.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(491, 1, 'Show', 'Zobacz', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(492, 1, 'Send date', 'Data wysłania', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(493, 1, 'Error', 'Błąd', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(494, 1, 'Errors', 'Błędy', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(495, 1, 'Created at', 'Stworzony', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(496, 1, 'Updated at', 'Aktualizowany', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(497, 1, 'Send date', 'Data wysłania', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(498, 1, 'Send date:', 'Data wysłania', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(499, 1, 'error', 'Błędy', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(500, 1, 'created_at', 'Stworzony', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(501, 1, 'message', 'wiadomość', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(502, 1, 'updated_at', 'Zaktualizowany', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(503, 1, 'Subject', 'Temat', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(504, 1, 'is empty', 'puste', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(505, 1, 'Filter', 'Filtruj', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(506, 1, 'Reset', 'Resetuj', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(507, 1, 'Page', 'Strona', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(508, 1, 'of %1%', 'z %1%', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(509, 1, 'Actions', 'Akcja', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(510, 1, 'User list', 'Lista użytkowników', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(511, 1, 'Users list', 'Lista użytkowników', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(512, 1, 'Permission list', 'Lista pozwoleń', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(513, 1, 'Description', 'Opis', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(514, 1, 'Group list', 'Lista grup', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(515, 1, 'Name', 'Nazwa', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(516, 1, 'Username', 'Nazwa użytkownika', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(517, 1, 'Incorrect link.', 'Nieprawidłowy link.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(518, 1, 'Your email address was deleted from our newsletter database.', 'Twój adres email został usunięty z naszej bazy danych.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1);
INSERT INTO `i18n_translations` (`id`, `cat_id`, `source`, `target`, `comments`, `created_at`, `updated_at`, `translated`) VALUES
(519, 1, 'Your email address was added to our newsletter database.', 'Twój adres email został dodany do naszej bazy danych.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(520, 1, 'Your email was submitted successfuly.', 'Twój adres email został zapisany.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(521, 1, 'Last login', 'Ostatnio zalogowany', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(522, 1, 'Filters', 'Filtrowanie', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(523, 1, 'Filter', 'Filtruj', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(524, 1, 'Access', 'Dostęp', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(525, 1, 'Amount', 'Liczba', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(526, 1, 'Started at', 'Rozpoczęty', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(527, 1, 'Finished at', 'Zakończony', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(528, 1, 'Permissions', 'Uprawnienia', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(529, 1, 'Permissions and groups', 'Uprawnienia i grupy', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(530, 1, 'Is active', 'Aktywny', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(531, 1, 'Is super admin', 'Super admin', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(532, 1, 'Groups list', 'Grupy', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(533, 1, 'New Pa category', 'Nowa Kategoria', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(534, 1, 'Editing User "%%username%%"', 'Edytujesz użytkownika "%%username%%"', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(535, 1, 'New User', 'Nowy użytkownik', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(536, 1, 'File Manager', 'Menedżer plików', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(537, 1, 'Edit Pa category', 'Edytuj kategorię', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(538, 1, 'Editing Permission "%%name%%"', 'Edytuj pozwolenie "%%name%%"', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(539, 1, 'New Permission', 'Nowe pozwolenie', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(540, 1, 'Editing Group "%%name%%"', 'Edytuj grupę "%%name%%"', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(541, 1, 'New Group', 'Nowa grupa', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(542, 1, 'Password', 'Hasło', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(543, 1, 'Address', 'Adres', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(544, 1, 'Required.', 'Wymagane.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(545, 1, 'Polish', 'Polski', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(546, 1, 'English', 'Angielski', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(547, 1, 'max_length', 'Tekst jest za długi (maksymalna ilość znaków to %max_length%).', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(548, 1, '"%value%" is too short (%min_length% characters min).', '"%value%" jest za krótki (minimalna ilość znaków to %min_length%).', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(549, 1, 'The username and/or password is invalid.', 'Email i/lub hasło niepoprawne.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(550, 1, 'Password again', 'Hasło ponownie', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(551, 1, 'Password has been modified successfully.', 'Hasło zostało zmodyfikowane pomyślnie.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(552, 1, 'min length is 5', 'minimalna długość to 5 znaków', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(553, 1, 'max length is 128', 'maksymalna długość to 128 znaków', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(554, 1, 'The date must be after %min%.', 'Data musi być poźniejsza niż %min%.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(555, 1, 'The date must be before %max%.', 'Data musi być wcześniejsza niż %max%.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(556, 1, 'User', 'Użytkownik', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(557, 1, 'First name', 'Imię', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(558, 1, 'Last name', 'Nazwisko', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(559, 1, 'Email address', 'E-mail', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(560, 1, 'Password (again)', 'Hasło (ponownie)', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(561, 1, 'yes or no', 'tak lub nie', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(562, 1, 'Yes or No', 'Tak lub Nie', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(563, 1, 'yes', 'tak', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(564, 1, 'no', 'nie', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(565, 1, 'Yes', 'Tak', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(566, 1, 'No', 'Nie', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(567, 1, 'The item was deleted successfully.', 'Element został usunięty pomyślnie.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(568, 1, 'Are you sure?', 'Jesteś pewien?', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(569, 1, 'Remember', 'Zapamiętaj', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(570, 1, 'Unique name', 'Nazwa', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(571, 1, 'Order', 'Kolejność', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(572, 1, 'Message', 'Wiadomość', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(573, 1, 'The item was created successfully. You can add another one below.', 'Obiekt został utworzony pomyślnie. Możesz teraz dodać kolejny.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(574, 1, 'The item has not been saved due to some errors.', 'Obiekt nie został utworzony, wystąpiły błędy.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(575, 1, 'The item was updated successfully.', 'Element został zaktualizowany.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(576, 1, 'The selected items have been deleted successfully.', 'Zaznaczone elementy zostały usunięte pomyślnie.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(577, 1, 'Other', 'Pozostałe', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(578, 1, 'Date', 'Data', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(579, 1, 'Avg', 'Średnia', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(580, 1, 'Sum', 'Suma', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(581, 1, 'a: - values greater than a', 'a: - wartości większe niż a', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(582, 1, ':b - values less than b', ':b - wartości mniejsze niż b', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(583, 1, 'a:b - values between a and b', 'a:b - wartości pomiędzy a i b', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(584, 1, 'x|y - values in interval x or interval y', 'x|y - wartości w przedziałach x lub y', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(585, 1, 'Invalid mime type (%mime_type%).', 'Nieprawidłowy format pliku (%mime_type%).', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(586, 1, 'The uploaded file was only partially uploaded.', 'Plik został wrzucony tylko częściowo.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(587, 1, 'Failed to write file to disk.', 'Błąd zapisu pliku na dysk.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(588, 1, 'File is too large (maximum is %max_size% bytes).', 'Plik jest zbyt duży (maksymalna wielkość pliku to %max_size% bajtów).', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(589, 1, 'Date format: yyyy-mm-dd', 'Format daty: yyyy-mm-dd', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(590, 1, 'Invalid.', 'Niepoprawne dane', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(591, 1, 'You must at least select one item.', 'Musisz wybrać co najmniej jeden element.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(592, 1, 'Group-User', 'Grupa-Użytkownik', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(593, 1, 'Permission-Group', 'Uprawnienia-Grupa', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(594, 1, '"%value%" must be at least %min%.', 'Wartość "%value%" powinna być równa przynajmniej %min%.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(595, 1, '"%value%" must be at most %max%.', 'Wartość "%value%" powinna być równa co najwyżej %max%.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(596, 1, 'Short description', 'Krótki opis', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(597, 1, 'Long description', 'Długi opis', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(598, 1, 'from', 'od', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(599, 1, 'to', 'do', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(600, 1, 'A problem occurs when deleting the selected items as some items do not exist anymore. ', 'Wystąpił problem, ponieważ część z zaznaczonych rekordów nie istnieje.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(601, 1, 'Title', 'Tytuł', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(602, 1, 'Lang', 'Język', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(603, 1, 'Id permission', 'Pozwolenia', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(604, 1, 'Id art category', 'Kategorie', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(605, 1, 'Start at', 'Aktywny od', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(606, 1, 'Expire at', 'Aktywny do', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(607, 1, 'Is public', 'Publiczny?', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(608, 1, 'Keywords', 'Słowa kluczowe', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(609, 1, 'Is activated', 'Aktywny?', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(610, 1, 'Layout style', 'Styl layoutu', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(611, 1, 'The item was created successfully.', 'Obiekt został utworzony pomyślnie.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(612, 1, '"%value%" has not %digits% digits after coma.', '"%value%" nie posiada %digits% miejsc po przecinku.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(613, 1, 'Value of field "%field_name%" must be at most %max%.', 'Maksymalna wartość pola "%field_name%" wynosi  %max%.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(614, 1, 'Value of field "%field_name%" must be at least %min%.', 'Minimalna wartość pola "%field_name%" wynosi %min%.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(615, 1, 'Value of field must be at most %max%.', 'Maksymalna wartość pola wynosi  %max%.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(616, 1, 'Value of field must be at least %min%.', 'Minimalna wartość pola wynosi %min%.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(617, 1, '"%value%" is not a number.', '"%value%" nie jest liczbą.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(618, 1, '"%value%" is not an integer.', '"%value%" nie jest liczbą.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(619, 1, 'Field "%field_name%" is required.', 'Pole "%field_name%" jest wymagane.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(620, 1, 'Value of field "%field_name%" must be integer.', 'Wartość pola "%field_name%" musi być liczbą całkowitą.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(621, 1, 'Value of field "%field_name%" should has %digits% digits after coma.', 'Wartość pola "%field_name%" powinna posiadać %digits% miejsca po przecinku.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(622, 1, 'Value of field "%field_name%" should has %digit% digit after coma.', 'Wartość pola "%field_name%" powinna posiadać %digit% miejsce po przecinku.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(623, 1, 'Value of field "%field_name%" should has max %digits% digits after coma.', 'Wartość pola "%field_name%" powinna posiadać maksymalnie %digits% miejsca po przecinku.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(624, 1, 'Value of field "%field_name%" should has max %digit% digit after coma.', 'Wartość pola "%field_name%" powinna posiadać maksymalnie %digit% miejsce po przecinku.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(625, 1, 'Value of field should has max %digits% digits after coma.', 'Wartość pola powinna posiadać maksymalnie %digits% miejsca po przecinku.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(626, 1, 'Value of field should has max %digit% digit after coma.', 'Wartość pola powinna posiadać maksymalnie %digit% miejsce po przecinku.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(627, 1, 'Invalid value in field "%field_name%".', 'Nieprawidłowa wartość w polu "%field_name%".', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(628, 1, 'Save', 'Zapisz', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(629, 1, 'Both passwords must be the same.', 'Obydwa hasła muszą być takie same.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(630, 1, 'Both password must be the same.', 'Obydwa hasła muszą być takie same.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(631, 1, 'That e-mail already exist in our system.', 'Ten e-mail już istnieje w naszym systemie.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(632, 1, 'Administration panel', 'Panel administracyjny', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(633, 1, 'Account created successfully! Wait for email how to activate the account.', 'Konto utworzone pomyślnie! Czekaj na wiadomość email, w której znajdziesz informację jak aktywować konto.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(634, 1, 'This article does not exist.', 'Ten artykuł nie istnieje.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(635, 1, 'Confirm', 'Potwierdź', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(636, 1, 'Cancel', 'Anuluj', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(637, 1, 'Description', 'Opis', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(638, 1, 'Delete', 'Usuń', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(639, 1, 'm2', 'm2', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(640, 1, 'Permissions list', 'Uprawnienia', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(641, 1, 'Record deleted', 'Rekord usunięty', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(642, 1, 'Record updated', 'Rekord zaktualizowany', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(643, 1, 'Record inserted', 'Rekord dodany', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(644, 1, 'Are you sure?', 'Jesteś pewien?', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(645, 1, 'New value:', 'Nowa wartość:', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(646, 1, 'Old value:', 'Stara wartość:', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(647, 1, 'Sf guard user', 'Użytkownik', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(648, 1, 'Flag', 'Typ', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(649, 1, 'Is displayed', 'Czy wyświetlać?', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(650, 1, 'Views', 'Ilość wyświetleń', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(651, 1, 'Categories list', 'Kategorie', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(652, 1, 'Tags list', 'Tagi', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(653, 1, 'Preferred articles list', 'Preferowane artykuły', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(654, 1, 'Creator', 'Autor', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(655, 1, 'Layout', 'Układ strony', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(656, 1, 'Vote sum', 'Suma głosów', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(657, 1, 'Vote count', 'Ilość głosów', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(658, 1, 'Pa article List', 'Lista artykułów', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(659, 1, 'New Pa article', 'Nowy artykuł', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(660, 1, 'Edit Pa article', 'Edytuj artykuł', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(661, 1, 'Title image', 'Obrazek tytułowy', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(662, 1, 'Big image', 'Duży obrazek', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(663, 1, 'Source', 'Źródło', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(664, 1, 'remove the current file', 'usuń obecny plik', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(665, 1, 'Slug', 'Link do artykułu', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(666, 1, 'Articles Tag', 'Tagi', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(667, 1, 'Pa category List', 'Lista kategorii', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(668, 1, 'Articles list', 'Lista artykułów', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(669, 1, 'Pa tag List', 'Lista tagów', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(670, 1, 'Edit Pa tag', 'Edytuj tag', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(671, 1, 'New Pa tag', 'Nowy tag', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(672, 1, 'Set order', 'Ustaw kolejność', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(673, 1, 'Subcategories list', 'Subkategorie', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(674, 1, 'Record translation inserted', 'Dodawanie rekordu translacyjnego', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(675, 1, 'ARTICLE: ', 'ARTYKUŁ: ', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(676, 1, 'SUBCATEGORY: ', 'SUBKATEGORIA: ', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(677, 1, 'Data has been saved!', 'Dane zostały zapisane pomyślnie.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(678, 1, 'Determine the order of the articles and subcategories in the category:', 'Ustal kolejność artykułów i subkategorii w kategorii:', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(679, 1, 'Articles Layouts', 'Układy stron', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(680, 1, 'Pa layout type List', 'Lista układów stron', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(681, 1, 'Pdf print', 'Pdfy i drukowanie', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(682, 1, 'Votes', 'Głosowanie', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(683, 1, 'Comments', 'Komentarze', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(684, 1, 'See also', 'Zobacz też', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(685, 1, 'Socials', 'Portale społecznościowe', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(686, 1, 'Title[br /]image', 'Obrazek tytułowy', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(687, 1, 'ViewsBR', 'Ilość wyświetleń', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(688, 1, 'Images upload', 'Upload obrazków', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(689, 1, 'Created date', 'Data utworzenia', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(690, 1, 'Short[br /]description', 'Krótki opis', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(691, 1, 'New Pa layout type', 'Nowy układ strony', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(692, 1, 'Edit Pa layout type', 'Edytuj układ strony', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(693, 1, 'Will be generated automatically.', 'Zostanie wygenerowany automatycznie.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(694, 1, 'Title image label', 'Podpis do obrazka tytułowego', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(695, 1, 'Has author', 'Autor', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(696, 1, 'You must select an action to execute on the selected items.', 'Wybierz akcje, aby ją wykonać na zaznaczonych elementach.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(697, 1, 'Gallery', 'Galeria', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(698, 1, 'Edit only if not set and you want use gallery.', 'Edytuj tylko gdy nie ustawione i chcesz użyć galerii.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(699, 1, 'Meta title', 'Meta tytuł', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(700, 1, 'Meta description', 'Meta opis', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(701, 1, 'Meta keywords', 'Słowa kluczowe', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(702, 1, 'Add images to gallery', 'Dodaj obrazki do galerii', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(703, 1, 'Add images', 'Dodaj obrazki', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(704, 1, 'You must set unique name if you want add images to gallery!', 'Musisz ustawić unikalną nazwę jeżeli chcesz dodać obrazki do galerii!', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(705, 1, 'Article does not exist or is inactive!', 'Podany artykuł nie istnieje lub jest nieaktywny!', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(706, 1, 'Read more...', 'Czytaj więcej...', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(707, 1, 'Show more', 'Pokaż więcej', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(708, 1, 'Hide more', 'Ukryj więcej', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(709, 1, 'Message template', 'Szablon wiadomości', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(710, 1, 'Message layout', 'Układ wiadomości', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(711, 1, 'Message Center', 'Centrum wiadomości', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(712, 1, 'Default channel setting', 'Kanał aktywny domyślnie?', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(713, 1, 'Add message template', 'Dodaj szablon wiadomości', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(714, 1, 'Edit Pa Message center', 'Edytujesz ustawienie wiadomości', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(715, 1, 'Submit', 'Zapisz', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(716, 1, 'Layout List', 'Lista szablonów', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(717, 1, 'article', 'artykuł', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(718, 1, 'message', 'wiadomość', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(719, 1, 'Edit Layout', 'Edytujesz szablon', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(720, 1, 'New Layout', 'Nowy szablon', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(721, 1, 'Author', 'Autor', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(722, 1, 'View', 'Widok', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(723, 1, 'Module', 'Moduł', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(724, 1, 'Pa message center List', 'Lista ustawień wiadomości', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(725, 1, 'Message channel', 'Kanał wiadomości', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(726, 1, 'New Internal message', 'Nowa wiadomość wewnętrzna', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(727, 1, 'Receiver', 'Odbiorca', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(728, 1, 'Internal message List', 'Lista wiadomości wewnętrznych', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(729, 1, 'Inbox', 'Odebrane', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(730, 1, 'Outbox', 'Wysłane', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(731, 1, 'Trash', 'Kosz', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(732, 1, 'Message was sended successfully.', 'Wiadomość została wysłana pomyślnie.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(733, 1, 'New message', 'Nowa wiadomość', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(734, 1, 'Are you sure?', 'Jesteś pewien?', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(735, 1, 'Move to trash', 'Przenieś do kosza', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(736, 1, 'Delete completely', 'Usuń całkowicie', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(737, 1, 'There are some errors. Please try again.', 'Wystąpił błąd. Proszę spróbować ponownie.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(738, 1, 'Message was moved to the trash successfully.', 'Wiadomość została przeniesiona do kosza pomyślnie.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(739, 1, 'Messages were moved to the trash successfully.', 'Wiadomości zostały przeniesione do kosza pomyślnie.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(740, 1, 'Message was deleted successfully.', 'Wiadomość została usunięta pomyślnie.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(741, 1, 'Messages were deleted successfully.', 'Wiadomości zostały usunięte pomyślnie.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(742, 1, 'Add to catalog:', 'Dodaj do folderu:', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(743, 1, 'Check', 'Zaznacz', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(744, 1, 'Clear', 'Wyczyść', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(745, 1, 'Choose', 'Wybierz', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(746, 1, '# selected', '# wybranych', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(747, 1, 'Archive', 'Archiwum', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(748, 1, '[No title]', '[Bez tematu]', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(749, 1, 'Edit Message center for channel "%1%" and unique name "%2%"', 'Edytujesz ustawienia wiadomości dla kanału "%1%" i unikalnej nazwy "%2%"', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(750, 1, 'Collector class', 'Klasa kolektora', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(751, 1, 'Channel enabled', 'Kanał aktywny', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(752, 1, 'Default', 'Domyślny', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(753, 1, 'Empty', 'Pusty', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(754, 1, 'Copy', 'Kopiuj', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(755, 1, 'Messages were moved to selected categories successfully.', 'Wiadomości zostały przeniesione do wybranych kategorii pomyślnie.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(756, 1, 'Messages were added to selected categories successfully.', 'Wiadomości zostały dodane do wybranych kategorii pomyślnie.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(757, 1, 'Move to catalog:', 'Przenieś do folderu:', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(758, 1, 'Show all', 'Pokaż wszystko', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(759, 1, 'Manage catalogs', 'Zarządzaj katalogami', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(760, 1, 'Delete catalogs', 'Usuń katalogi', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(761, 1, 'Add catalog', 'Dodaj katalog', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(762, 1, 'Edit catalogs', 'Edytuj katalogi', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(763, 1, 'Catalog deleted successfully.', 'Katalog usunięty pomyślnie.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(764, 1, 'Message has not been send due to some errors. ', 'Wiadomość nie została wysłana z powodu błędów.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(765, 1, 'Back', 'Powrót', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(766, 1, 'Photo has been deleted!', 'Zdjęcie zostało usunięte!', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(767, 1, 'Save order', 'Zapisz kolejność', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(768, 1, 'Image', 'Obrazek', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(769, 1, 'Add new photo', 'Dodaj nowy obrazek', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(770, 1, 'Gallery descriptions', 'Opisy w galerii', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(771, 1, 'Gallery type', 'Rodzaj galerii', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(772, 1, 'Gallery caption position', 'Położenie opisu (galeria shadow)', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(773, 1, 'Gallery navigation', 'Nawigacja galerii', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(774, 1, 'Gallery orientation', 'Orientacja galerii', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(775, 1, 'Gallery delay', 'Autoodtwarzanie w milisekundach', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(776, 1, 'Horizontal', 'Pozioma', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(777, 1, 'Vertical', 'Pionowa', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(778, 1, 'Top', 'Góra', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(779, 1, 'Bottom', 'Dół', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(780, 1, 'Left', 'Lewo', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(781, 1, 'Right', 'Prawo', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(782, 1, 'Improve', 'Popraw', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(783, 1, 'Improve the form or cancel changes?', 'Poprawić formularz czy anulować wprowadzone zmiany?', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(784, 1, 'Visibility from', 'Widoczny od', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(785, 1, 'Visibility to', 'Widoczny do', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(786, 1, 'Tags', 'Tagi', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(787, 1, 'Admin panel', 'Panel administracyjny', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(788, 1, 'Hello', 'Witaj ', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(789, 1, 'Last login', 'Ostatnio zalogowany', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(790, 1, 'Expand', 'Rozwiń', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(791, 1, 'Collapse', 'Zwiń', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(792, 1, 'Edit CategoryTab', 'Edytuj kategorię', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(793, 1, 'New CategoryTab', 'Nowa kategoria', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(794, 1, 'tab_CategoryTab', 'Podstawowe', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(795, 1, 'tab_SetCategoryOrderTab', 'Ustaw kolejność', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(796, 1, 'Edit ArticleAdvancedTab', 'Edytuj zaawansowane ustawienia', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(797, 1, 'New ArticleTab', 'Nowy artykuł', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(798, 1, 'Edit ArticleTab', 'Edytuj artykuł', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(799, 1, 'tab_ArticleTab', 'Podstawowe', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(800, 1, 'tab_ArticleAdvancedTab', 'Zaawansowane', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(801, 1, 'tab_GalleryTab', 'Galeria', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(802, 1, 'Add article', 'Dodaj artykuł', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(803, 1, 'Add user', 'Dodaj użytkownika', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(804, 1, 'Banned list', 'Lista zbanowanych', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(805, 1, 'Admins list', 'Lista administratorów', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(806, 1, 'tab_BaseUserTab', 'Podstawowe', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(807, 1, 'tab_PermissionsTab', 'Uprawnienia i grupy', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(808, 1, 'tab_UserDetailsTab', 'Dane osobowe', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(809, 1, 'tab_ChangePasswordTab', 'Zmiana hasła', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(810, 1, 'Password expired', 'Wygaśnięcie hasła', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(811, 1, 'Is banned', 'Zbanowany', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(812, 1, 'Edit BaseUserTab', 'Edytuj użytkownika', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(813, 1, 'New BaseUserTab', 'Nowy użytkownik', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(814, 1, 'Edit PermissionsTab', 'Edytuj uprawnienia i grupy', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(815, 1, 'Send', 'Wyślij', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(816, 1, 'Change', 'Zmień', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(817, 1, 'Add', 'Dodaj', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(818, 1, 'Bad format.', 'Zły format.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(819, 1, 'REGON is invalid.', 'REGON jest nieprawidłowy.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(820, 1, 'Your NIP: "%nip%" is invalid.', 'Twój NIP: "%nip%" jest nieprawidłowy.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(821, 1, 'The length is 13 characters with hyphens.', 'Długość to 13 znaków z myślnikami.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(822, 1, 'The length is 13 chars (digits with hyphens) or 10 digits (without hyphens).', 'Długość to 13 znaków (cyfry z myślnikami) lub 10 znaków (bez myślników).', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(823, 1, 'Male', 'Mężczyzna', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(824, 1, 'Female', 'Kobieta', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(825, 1, 'Sex', 'Płeć', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(826, 1, 'Birth date', 'Data urodzenia', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(827, 1, 'Link to delete account.', 'Link do usunięcia konta.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(828, 1, 'Get more', 'Pokaż więcej', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(829, 1, 'Password have been changed.', 'Hasło zostało zmienione.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(830, 1, 'Invalid old password.', 'Nieprawidłowe stare hasło.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(831, 1, 'Pa blog List', 'Lista artykułów na blog', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(832, 1, 'Number of entries per page', 'Ilość wpisów na stronę', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(833, 1, 'Commenter name', 'Komentujący', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(834, 1, 'Approve', 'Zatwierdź', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(835, 1, 'Approved!', 'Zatwierdzony!', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(836, 1, 'Deleted!', 'Usunięty!', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(837, 1, 'Edit', 'Edytuj', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(838, 1, 'Article', 'Artykuł', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(839, 1, 'Comments count', 'Ilość komentarzy', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(840, 1, 'Show comments', 'Pokaż komentarze', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(841, 1, 'Ascending', 'Rosnąco', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(842, 1, 'Descending', 'Malejąco', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(843, 1, 'less than a minute', 'mniej niż minutę', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(844, 1, '1 minute', '1 minuta', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(845, 1, '%minutes% minutes', '%minutes% minut', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(846, 1, '%minutes% minutes2-4', '%minutes% minuty', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(847, 1, 'about 1 hour', 'około 1 godziny', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(848, 1, 'about %hours% hours', 'około %hours% godzin', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(849, 1, 'about %hours% hours2-4', 'około %hours% godziny', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(850, 1, 'about 1 day', 'około 1 dzień', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(851, 1, '%days% days', '%days% dni', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(852, 1, 'about 1 month', 'około 1 miesiąca', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(853, 1, '%months% months', '%months% miesięcy', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(854, 1, '%months% months2-4', '%months% miesiące', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(855, 1, 'about 1 year', 'około 1 roku', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(856, 1, 'over %years% years2-4', 'ponad %years% lata', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(857, 1, 'over %years% years', 'ponad %years% lat', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(858, 1, '1 hour', '1 godziny', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(859, 1, '%hours% hours', '%hours% godzin', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(860, 1, '%hours% hours2-4', '%hours% godziny', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(861, 1, '1 day', '1 dzień', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(862, 1, '1 month', '1 miesiąc', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(863, 1, '1 year', '1 rok', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(864, 1, '%years% years2-4', '%years% lata', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(865, 1, '%years% years', '%years% lat', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(866, 1, 'less than 5 seconds', 'mniej niż 5 sekund', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(867, 1, 'less than 10 seconds', 'mniej niż 10 sekund', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(868, 1, 'less than 20 seconds', 'mniej niż 20 sekund', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(869, 1, 'half a minute', 'pół minuty', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(870, 1, 'Your NIP: "%nip%" has invalid chars. Alowed chars are numbers, spaces and dashes.', 'Twój NIP: "%nip%" zawiera nieprawidłowe znaki. Dozwolone znaki to liczby, spacje oraz myślniki.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(871, 1, 'Active', 'Aktywny', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(872, 1, 'Inactive', 'Nieaktywny', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(873, 1, 'Status name', 'Status', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(874, 1, 'Is registered', 'Zarejestrowany?', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(875, 1, 'Newsletter users', 'Użytkownicy newslettera', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(876, 1, 'Newsletter email', 'Adres email', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(877, 1, 'Newsletter first name', 'Imię', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(878, 1, 'Newsletter last name', 'Nazwisko', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(879, 1, 'Pa newsletter user List', 'Lista użytkowników newslettera', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(880, 1, 'Download CSV', 'Ściągnij CSV', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(881, 1, 'Download all users to CSV', 'Ściągnj wszystkich użytkowników w CSV', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(882, 1, 'tab_NewsletterSettingsTab', 'Ustawienia', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(883, 1, 'Value must be greater or equal than %greater_equal_than%.', 'Wartośc musi być większa lub równa %greater_equal_than%.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(884, 1, 'tab_MessageTemplateTab %1%', 'Treść', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(885, 1, 'tab_TestSendTab', 'Testowa wiadomość', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(886, 1, 'tab_SendToAllTab', 'Wyślij do subskrybentów newslettera', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(887, 1, 'tab_SendToAllImmediatelyTab', 'Wyślij do wszystkich natychmiast', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(888, 1, 'Legend', 'Legenda', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(889, 1, 'Sended!', 'Przygotowano wiadomości do wysłania, wyślą się automatycznie.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(890, 1, 'Sended %count% messages!', 'Wysłano %count% wiadomości!', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(891, 1, 'Pa newsletter List', 'Lista wiadomości newsletter', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(892, 1, 'Newsletter history', 'Historia newslettera', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(893, 1, 'Pa message multisend history List', 'Historia wysłanych wiadomości', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(894, 1, 'Newsletter user', 'Użytkownik', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(895, 1, 'Send newsletter to all.', 'Wyślij newsletter do wszystkich.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(896, 1, 'Send newsletter to all immediately.', 'Wyślij newsletter do wszystkich natychmiast.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(897, 1, 'User last name', 'Nazwisko użytkownika', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(898, 1, 'User email', 'Email użytkownika', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(899, 1, 'Signin link', 'Link potwierdzający', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(900, 1, 'Signout link', 'Link wypisujący', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(901, 1, 'Email address is incorrect', 'Niepoprawny adres email', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(902, 1, 'New password', 'Nowe hasło', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(903, 1, 'New password again', 'Nowe hasło ponownie', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(904, 1, 'Check your e-mail! You should receive something shortly!', 'Sprawdź email. Powinieneś na niego otrzymać link resetujący!', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(905, 1, 'Both password must be the same', 'Hasła muszą być identyczne', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(906, 1, 'Invalid e-mail address!', 'Nieprawidłowy adres email!', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(907, 1, 'The captcha is not valid (%error%).', 'Captcha jest niepoprawna (%error%).', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(908, 1, 'Unable to check the captcha from the server (%error%).', 'Nie można sprawdzić captchy z serwera (%error%).', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(909, 1, 'Phone', 'Telefon', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(910, 1, 'Birth date', 'Data urodzenia', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(911, 1, 'City', 'Miasto', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(912, 1, 'Post code', 'Kod pocztowy', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(913, 1, 'Address', 'Adres', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(914, 1, 'Given email does not exist in our database.', 'Podany adres email nie istnieje w naszej bazie danych.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(915, 1, 'Confirm to delete the account.', 'Potwierdź, aby usunąć konto.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(916, 1, 'Delete account', 'Usuń konto', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(917, 1, 'Link to delete your account has been sent to your email.', 'Link do usunięcia konta został wysłany. Sprawdź swój email.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(918, 1, 'Your account has been deleted successfully.', 'Twoje konto zostało usunięte pomyślnie.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(919, 1, 'Invalid link.', 'Nieprawidłowy link.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(920, 1, 'Add new file', 'Dodaj nowy plik', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(921, 1, 'tab_FilesTab', 'Pliki', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(922, 1, 'New file', 'Plik', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(923, 1, 'Register', 'Rejestracja', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(924, 1, 'Password changed successfully!', 'Hasło zmienione pomyślnie!', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(925, 1, 'Thanks for creating account on our website! Check your e-mail for confirmation message. Click the link inside to activate your account.', 'Dziękujemy za stworzenie konta na naszej stronie! Na twój e-mail została wysłana wiadomość z linkiem aktywacyjnym. Kliknięcie go spowoduje aktywację konta.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(926, 1, 'Save and add', 'Zapisz i dodaj', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(927, 1, 'Bad link.', 'Błędny link.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(928, 1, 'Restore default', 'Przywróć domyślne', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(929, 1, 'Value', 'Wartość', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(930, 1, 'Pa configuration List', 'Lista ustawień konfiguracyjnych', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(931, 1, 'Default value has been restored successfully.', 'Domyślna wartość została przywrócona domyślnie.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(932, 1, 'tab_DictionaryTab', 'Słowo', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(933, 1, 'tab_SetPolishWordOrderTab', 'Kolejność słów polskich', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(934, 1, 'tab_SetEnglishWordOrderTab', 'Kolejność słów angielskich', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(935, 1, 'Edit Pa configuration', 'Edytuj ustawienie', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(936, 1, 'Configuration', 'Ustawienia konfiguracyjne', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(937, 1, 'Word List', 'Lista słów', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(938, 1, 'Dictionary', 'Słownik', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(939, 1, 'Pa article blog List', 'Lista artykułów blogowych', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(940, 1, 'Article blog categories list', 'Kategoria artykułu', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(941, 1, 'Edit Pa article blog category', 'Edytuj kategorię blogową', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(942, 1, 'tab_CommentsTab', 'Komentarze', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(943, 1, 'Blog categories', 'Kategorie', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(944, 1, 'Recent posts', 'Ostatnie posty', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(945, 1, 'Leave a reply', 'Skomentuj', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(946, 1, 'Read more', 'Czytaj więcej', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(947, 1, 'Add comment', 'Dodaj komentarz', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(948, 1, 'Add', 'Dodaj', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(949, 1, 'Comment added successfully.', 'Komentarz dodany pomyślnie.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(950, 1, 'Results', 'Wyników', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(951, 1, 'Results per page', 'Wyników na stronę', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(952, 1, 'Promotional codes', 'Kody promocyjne', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(953, 1, 'New Pa promotional code', 'Nowy kod promocyjny', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(954, 1, 'Edit Pa promotional code', 'Edytuj kod promocyjny', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(955, 1, 'Mailing domain', 'Domena mailowa', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(956, 1, 'Expiration date', 'Data wygaśnięcia', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(957, 1, 'meta_keywords', 'Meta dane - słowa kluczowe', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(958, 1, 'meta_description', 'Meta dane - opis', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(959, 1, 'meta_title', 'Meta dane - tytuł', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(960, 1, 'meta_keywords_pl', 'Meta dane - słowa kluczowe PL', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(961, 1, 'meta_description_pl', 'Meta dane - opis PL', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(962, 1, 'meta_title_pl', 'Meta dane - tytuł PL', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(963, 1, 'meta_keywords_en', 'Meta dane - słowa kluczowe EN', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(964, 1, 'meta_description_en', 'Meta dane - opis EN', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(965, 1, 'meta_title_en', 'Meta dane - tytuł EN', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(966, 1, 'Code', 'Kod', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(967, 1, 'You must log in to join the conversation.', 'Zaloguj się, aby dołączyć do rozmowy.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1);
INSERT INTO `i18n_translations` (`id`, `cat_id`, `source`, `target`, `comments`, `created_at`, `updated_at`, `translated`) VALUES
(968, 1, 'No results', 'Brak wyników', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(969, 1, 'Here you can send a test message to the specified e-mail to verify its correctness', 'Tutaj możesz wysłać wiadomość testową na podany e-mail, aby sprawdzić jej poprawność', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(970, 1, 'Advanced edit article', 'Edytuj metadane', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(971, 1, 'Generate PDF', 'Pobierz PDF', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(972, 1, 'Print', 'Drukuj', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(973, 1, 'Edit article', 'Edycja artykułu', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(974, 1, 'Add category', 'Dodaj kategorię', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(975, 1, 'Edit category', 'Edytuj kategorię', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(976, 1, 'tab_SendToActiveCompany', 'Wyślij do aktywnych firm', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(977, 1, 'tab_SendToInActiveCompany', 'Wyślij do nieaktywnych firm', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(978, 1, 'tab_SendToActiveSkeletonUser', 'Wyślij do aktywnych kont szkieletowych', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(979, 1, 'tab_SendToInActiveSkeletonUser', 'Wyślij do nieaktywnych kont szkieletowych', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(980, 1, 'Send newsletter to active company.', 'Wyślij newsletter do aktywnych firm.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(981, 1, 'Send newsletter to inactive company.', 'Wyślij newsletter do nieaktywnych firm.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(982, 1, 'Send newsletter to active skeleton user.', 'Wyślij newsletter do aktywnych kont szkieletowych.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(983, 1, 'Send newsletter to inactive skeleton user.', 'Wyślij newsletter do nieaktywnych kont szkieletowych.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(984, 1, 'tab_SendToEmailAddresses', 'Wyślij do adresów email', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(985, 1, 'Ooops! Błąd 404 !', 'Ooops! Błąd 404 !', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(986, 1, 'Strona o podanym adresie nie istnieje !', 'Strona o podanym adresie nie istnieje !', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(987, 1, 'Powrót do poprzedniej strony', 'Powrót do poprzedniej strony', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(988, 1, 'Przejdź do strony głównej', 'Przejdź do strony głównej', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(989, 1, 'Projekt', 'Projekt', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(990, 1, 'Wykonawca', 'Wykonawca', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(991, 1, 'we współpracy z', 'we współpracy z', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(992, 1, 'Edycja konfiguracji', 'Edycja konfiguracji', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(993, 1, 'Lista konfiguracji', 'Lista konfiguracji', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(994, 1, 'Edytuj', 'Edytuj', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(995, 1, 'Wybrana konfiguracja nie istnieje.', 'Wybrana konfiguracja nie istnieje.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(996, 1, 'Konfiguracja została pomyślnie zaktualizowana.', 'Konfiguracja została pomyślnie zaktualizowana.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(997, 1, 'lokata_kwota_help', 'Miejsce to służy podaniu kwoty na jaką ma zostać zawarta lokata.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(998, 1, 'wybor_lokalizacji', 'Wybór lokalizacji Twojego hotelu', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(999, 1, 'wybor_lokalizacji_help', 'Czas na wybór lokalizacji Twojego hotelu. Na szczęście masz już pierwsze informacje z badań marketingowych – pojawią się po najechaniu kursorem na dany obszar. Zastanów się, gdzie będziesz miał najbardziej sprzyjające warunki, biorąc pod uwagę wyniki badań.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1000, 1, 'badanie_marketingowe_1', 'Badania marketingowe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1001, 1, 'badanie_marketingowe_1_help', 'Badanie marketingowe dostarczy podstawowe informacje, które przydadzą się przy starcie działalności twojego hotelu.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1002, 1, 'pokoje_standard_help', 'W tym miejscu możesz zdecydować o liczbie pokoi Standard w Twoim hotelu. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1003, 1, 'cena_pokoje_standard', 'Cena pokoju Standard za dobę\r\n', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1004, 1, 'event_festiwal_filmowy', 'Czy chcesz zostać jednym ze sponsorów I Festiwalu Filmów i Filmików w Pekunii?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1005, 1, 'event_festiwal_filmowy_help', 'Decyzje podejmowane w Ratuszu mogą znacząco wpłynąć na popyt na pokoje w Twoim hotelu.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1006, 1, 'strona_internetowa', 'Strona internetowa Twojego hotelu', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1007, 1, 'strona_internetowa_help', 'Zapoznaj się z różnymi ofertami stworzenia strony www hotelu. Reklama za pomocą strony www to podstawowy sposób dotarcia do wielu potencjalnych klientów. Po wybraniu oferty pojawi się jej cena kwartalna.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1008, 1, 'pranie_outsourcing_standard_kwota', 'Pranie  Standard - outsourcing', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1009, 1, 'pranie_outsourcing_standard_kwota', 'Pranie standard - outsourcing', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1010, 1, 'sprzatanie_outsourcing_standard_kwota', 'Sprzątanie Standard - outsourcing', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1011, 1, 'sprzatanie_outsourcing_standard_kwota_help', 'W tym polu wpisujesz jaką kwotę przeznaczysz na sprzątanie pokoi Standard. Kwota ta będzie obejmowała wszystkie te pokoje w nadchodzącym kwartale.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1012, 1, 'pranie_outsourcing_lux_kwota', 'Pranie Delux - outsourcing', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1013, 1, 'sprzatanie_outsourcing_lux_kwota', 'Sprzątanie Delux - outsourcing', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1014, 1, 'pranie_outsourcing_lux_kwota_help', 'W tym polu wpisujesz jaką kwotę przeznaczysz na pranie wszystkich rzeczy z pokoi Delux. Kwota ta obejmie wszystkie te pokoje w nadchodzącym kwartale.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1015, 1, 'sprzatanie_outsourcing_lux_kwota_help', 'W tym polu wpisujesz kwotę jaką chcesz przeznaczyć na sprzątanie wszystkich pokoi Delux w nadchodzącym kwartale.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1016, 1, 'sniadania_kwota', 'Catering  śniadaniowy', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1017, 1, 'sniadania_kwota_help', 'Zdecyduj ile chcesz wydać na śniadanie dla pojedynczego klienta. Dzięki śniadaniom, wzrośnie zadowolenie klientów z twoich usług. Wybierz wartość w PLN za pomocą suwaka.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1018, 1, 'pracownicy_obslugi_liczba', 'Zatrudnij pracowników obsługi i recepcji.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1019, 1, 'pracownicy_obslugi_liczba_help', 'Wybierając tą opcję będziesz mógł/mogła zatrudnić pracownika do obsługi recepcji. Wiąże się to z dodatkowym kosztem, ale zwiększy efektywność oferowanych przez Ciebie usług.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1020, 1, 'pracownicy_administracji_liczba', 'Zatrudnij pracowników administracyjnych.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1021, 1, 'pracownicy_administracji_liczba_help', 'Wybierając tą opcję będziesz mógł/mogła zatrudnić pracownika administracyjnego. Wiąże się to z dodatkowym kosztem ale usprawni działanie Twojego hotelu.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1022, 1, 'pracownicy_obslugi_motywacja_procent', 'Procent nagradzanych pracowników obsługi', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1023, 1, 'pracownicy_administracji_motywacja_procent', 'Procent nagradzanych pracowników administracji', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1024, 1, 'pracownicy_obslugi_motywacja_procent_help', '(Tu będzie tekst o motywacji)', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1025, 1, 'pracownicy_administracji_motywacja_procent_help', '(Tu będzie tekst o motywacji)', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1026, 1, 'pracownicy_obslugi_zlecenie', 'Wybierz ilu z obecnych pracowników obsługi, będzie zatrudnionych na umowę o zlecenie.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1027, 1, 'pracownicy_obslugi_zlecenie_help', 'Wybierając tą opcję będziesz mógł/mogła zatrudnić pracownika do obsługi recepcji poprzez umowę o zlecenie. Wiąże się to z dodatkowym kosztem ale zwiększy efektywność oferowanych przez Ciebie usług.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1028, 1, 'pracownicy_administracji_zlecenie', 'Wybierz ilu z obecnych pracowników administracyjnych, będzie zatrudnionych na umowę o zlecenie.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1029, 1, 'pracownicy_administracji_zlecenie_help', 'Wybierając tą opcję będziesz mógł/mogła zatrudnić pracownika administracyjnego poprzez umowę o zlecenie. Wiąże się to z dodatkowym kosztem ale usprawni działanie Twojego hotelu.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1030, 1, 'pracownicy_obslugi_wynagrodzenie_help', 'Ustal wysokość płac. Im wyższa płaca tym bardziej zadowoleni będą Twoi pracownicy.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1031, 1, 'pracownicy_administracji_wynagrodzenie_help', 'Ustal wysokość płac. Im wyższa płaca tym bardziej zadowoleni będą Twoi pracownicy.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1032, 1, 'pracownicy_obslugi_wynagrodzenie', 'Wynagrodzenie pracownika obsługi', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1033, 1, 'pracownicy_administracji_wynagrodzenie', 'Wynagrodzenie pracownika administracji', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1034, 1, 'sprzatanie_outsourcing_standard_disabled_info', 'Nie możesz zlecić sprzątania innej firmie, ponieważ masz już zatrudnionych pracowników.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1035, 1, 'sprzatanie_outsourcing_lux_disabled_info', 'Nie możesz zlecić sprzątania innej firmie, ponieważ masz już zatrudnionych pracowników.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1036, 1, 'pokoje_standard_wyposazenie_help', 'Wybierz rodzaj wyposażenia pokoi standard. Rodzaj wyposażenia wpłynie na cenę za pokój.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1037, 1, 'pokoje_standard_wyposazenie', 'Rodzaj wyposażenia pokoi Standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1038, 1, 'pokoje_lux_wyposazenie', 'Rodzaj wyposażenia pokoi Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1039, 1, 'pokoje_lux_wyposazenie_help', 'W tym miejscu możesz dokonać wyboru wyposażenia, jakie ma być oferowane twoim gościom w \npokojach Delux.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1040, 1, 'pokoje_lux', 'Pokoje Delux ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1041, 1, 'pokoje_lux_help', 'W tym miejscu możesz zdecydować o liczbie pokoi Delux w Twoim hotelu. Jednorazowo możesz wybudować lub zlikwidować wielokrotność  pięciu pokoi. Zwróć uwagę, że cena jednostkowa za jeden pokój maleje wraz ze wzrostem inwestycji. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1042, 1, 'pokoje_lux_help', 'Cena jednostkowa maleje wraz ze wzrostem ilości kupowanych pokojów w danym kwartale.<br/>\r\nSprzedając pokój nie odzyskasz całej kwoty.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1043, 1, 'cena_pokoje_standard_help', 'Podaj cenę za wynajem pokoju Standard. Pamiętaj, że będzie ona istotnym czynnikiem wpływającym na popyt na pokoje. Cena powinna być podana w liczbach naturalnych.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1044, 1, 'cena_pokoje_lux_help', 'Podaj cenę za wynajem pokoju Delux. Pamiętaj, że będzie ona istotnym czynnikiem wpływającym na popyt na pokoje. Cena powinna być podana w liczbach naturalnych.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1045, 1, 'cena_pokoje_lux', 'Cena pokoju Delux za dobę', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1046, 1, 'automaty_vendingowe_help', 'Automaty z napojami i przekąskami. Jeden automat na każde piętro (również parter – przy recepcji)', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1047, 1, 'automaty_vendingowe', 'Automaty vendingowe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1048, 1, 'ekspresy_czajniki', 'Dodatkowe wyposażenie pokoi', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1049, 1, 'ekspresy_czajniki_help', 'Dodatkowe akcesoria do pokoju, np. ekspres do kawy, czajnik elektryczny.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1050, 1, 'business_lounge', 'Przestrzeń biurowa', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1051, 1, 'business_lounge_help', 'Pomieszczenia do wynajęcia przygotowane do pracy biurowej. Oferta skierowana do właścicieli firm.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1052, 1, 'mozliwosc_odebrania_gosci_help', 'Odbieranie gości z lotniska lub dworca.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1053, 1, 'mozliwosc_odebrania_gosci', 'Transport z lotniska', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1054, 1, 'wspolpraca_biurami_podrozy', 'Współpraca z biurami podróży', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1055, 1, 'wspolpraca_biurami_podrozy_help', 'Współpraca z biurami podróży w celu zapewnienia miejsc hotelowych dla ich klientów.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1056, 1, 'wspolpraca_urzad_pracy', 'Współpraca z urzędem pracy lub miasta', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1057, 1, 'wspolpraca_urzad_pracy_help', 'Dopłaty dla pracowników fizycznych i studentów do kosztów wynajęcia pokoju.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1058, 1, 'wspolpraca_urzad_pracy_help', 'Dopłaty dla pracowników fizycznych i studentów do kosztów wynajęcia pokoju', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1059, 1, 'sala_konferencyjna', 'Sala konferencyjna', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1060, 1, 'sala_konferencyjna_help', 'Możliwość przeprowadzenia konferencji na 100 osób. Sala wyposażona              w rzutnik multimedialny, komputer, wskaźnik laserowy, nagłośnienie. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1061, 1, 'pokoj_zabaw_dla_dzieci', 'Pokój zabaw dla dzieci ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1062, 1, 'pokoj_zabaw_dla_dzieci_help', 'Pomieszczenie przeznaczone głównie dla rodzin z dziećmi, gdzie udostępniono atrakcje dające mnóstwo frajdy dla gości hotelu w wieku od 3 do 103 lat. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1063, 1, 'ochronka_dla_dzieci', 'Opieka nad dziećmi', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1064, 1, 'ochronka_dla_dzieci_help', 'Umożliwienie rodzicom zostawienia pociech pod profesjonalną opieką np. w trakcie wieczornego wyjścia na kolację.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1065, 1, 'media_lokalne_bilboardy', 'Billboardy', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1066, 1, 'media_lokalne_bilboardy_help', 'W tym miejscu wpisujesz liczbę billboardów, które będą promowały Twój hotel przez najbliższy kwartał.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1067, 1, 'media_lokalne_prasa', 'Dziennik "Moje miasto"', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1068, 1, 'media_lokalne_prasa_help', 'W tym polu podajesz liczbę stron, które chcesz wykupić na reklamę w „Moim Mieście”, w nadchodzącym kwartale.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1069, 1, 'media_lokalne_radio', 'Radio Dzień Dobry Pekunia', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1070, 1, 'media_lokalne_radio_help', ' W tym polu podajesz liczbę  trzydziestosekundowych reklam, które chcesz wykupić w Dzień Dobry Pekunia, w nadchodzącym kwartale. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1071, 1, 'media_regionalne_tv', 'Stacja TV Campus', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1072, 1, 'media_lokalne_bilboardy', 'Bilboardy - zasięg lokalny', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1073, 1, 'room_descr_reklama', 'Słynny slogan głosi, że reklama jest dźwignią handlu. Dlatego Ty, jako początkujący przedsiębiorca, który  chce pozyskać jak największą liczbę klientów, musisz w odpowiedni sposób rozreklamować swoje przedsiębiorstwo. W grze sam tworzysz swoją kampanię reklamową. Pamiętaj, że we wszystkim co robisz istotne jest zachowanie odpowiednich proporcji. Poniżej znajdują się różne formy reklamy. Twoim zadaniem jest ich odpowiednie zestawienie, gdyż każda z nich inaczej działa na różne obszary rynku.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1074, 1, 'room_descr_badania_marketingowe', 'Badania marketingowe to instrument dzięki któremu możecie dowiedzieć się więcej o rynku na którym funkcjonujecie oraz zdobyć informacje na temat konkurencji.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1075, 1, 'media_regionalne_radio', 'Radio Sonus', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1076, 1, 'media_regionalne_radio_help', 'W tym polu podajesz liczbę reklam, które chcesz wykupić w Radiu Sonus, w nadchodzącym kwartale.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1077, 1, 'media_regionalne_prasa', 'Tygodnik “Twój region”', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1078, 1, 'media_regionalne_prasa_help', 'W tym polu podajesz liczbę stron, które chcesz wykupić w "Twoim Regionie", w nadchodzącym kwartale.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1079, 1, 'media_krajowe_prasa_help', 'W tym polu podajesz liczbę stron, które chcesz wykupić na reklamę w „Vertitas”, w nadchodzącym kwartale.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1080, 1, 'media_krajowe_prasa', 'Prasa krajowa - “Vertitas”', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1081, 1, 'media_regionalne_tv_help', 'W tym polu podajesz liczbę minut, które chcesz wykupić na reklamę w TV Campus, w nadchodzącym kwartale.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1082, 1, 'media_krajowe_tv_help', 'W tym polu podajesz liczbę minut czasu antenowego, które chcesz wykupić w TV Nasus,  w nadchodzącym kwartale. \r\n', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1083, 1, 'media_krajowe_tv', 'TV Nasus', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1084, 1, 'media_krajowe_radio', 'Radio Terra', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1085, 1, 'media_krajowe_radio_help', 'W tym polu podajesz liczbę  trzydziestosekundowych reklam, które chcesz wykupić w Radiu Terra, w nadchodzącym kwartale.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1086, 1, 'badanie_marketingowe_2', 'Badania marketingowe zaawansowane', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1087, 1, 'badanie_marketingowe_2_help', 'Oferujemy badanie, którego wyniki powinny przyczynić się do sukcesu twojej firmy! Sprawdzimy, kto jest Państwa potencjalnym klientem, oraz jakie są jego preferencje. Dzięki niemu, poznają Państwo również swoją konkurencję. Dostarczymy także -  wszystkie informacje niezbędne do stworzenia najlepszej oferty na rynku. Narzędzia badawcze jakie wykorzystamy to m.in. zogniskowane wywiady grupowe, ankiety i metoda ‘tajemniczego klienta’. Zebrane dane poddamy rzetelnej analizie statystycznej i sporządzimy raport, który przyślemy na Państwa adres e-mail.<br/><b>Czy chcesz skorzystać z naszej oferty?</b>\r\n', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1088, 1, 'badanie_konkurencji_1', 'Badanie konkurencji podstawowe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1089, 1, 'badanie_konkurencji_3', 'Badanie konkurencji premium', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1090, 1, 'badanie_konkurencji_2', 'Badanie konkurencji standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1091, 1, 'badanie_konkurencji_1_help', 'Zawiera informacje bardzo podstawowe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1092, 1, 'badanie_konkurencji_2_help', 'Zawiera informacje standardowe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1093, 1, 'badanie_konkurencji_3_help', 'Zawiera informacje w zakresie premium', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1094, 1, 'room_descr_biuro', 'Tutaj podejmiesz decyzje biurowe i administracyjne', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1095, 1, 'room_descr_pokoje', 'Tutaj podejmiesz decyzje dotyczącą liczby pokoi i ich wyposażenia', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1096, 1, 'room_descr_pokoje', 'Tutaj podejmiesz decyzje dotyczącą liczby pokoi i ich wyposażenia', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1097, 1, 'room_descr_recepcja', 'Tutaj podejmiesz decyzje na temat działania hotelu', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1098, 1, 'room_descr_kredyty', 'Tutaj podejmiesz decyzje kredytowe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1099, 1, 'room_descr_lokaty', 'Tutaj możesz otworzyć i zamknąć lokaty', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1100, 1, 'room_descr_saldo', 'Tutaj możesz zobaczyć Twoje saldo w banku', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1101, 1, 'taxi', 'Taksówki', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1102, 1, 'taxi_help', 'Specjalnie dla gości Twojego hotelu możesz rozpocząć współpracę z firmą taksówkarską. Dzięki niej, goście Twojego hotelu dostaną 10% zniżkę na przejazdy!', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1103, 1, 'taxi_help', 'Czy chcesz mieć postój taxi pod drzwiami Twojego hotelu.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1104, 1, 'sejf', 'Sejf', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1105, 1, 'sejf_help', 'Montaż sejfów w każdym pokoju. Twoi goście poczują się bezpieczniej chowając w nim cenne rzeczy osobiste.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1106, 1, 'budzenie', 'Budzenie na życzenie', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1107, 1, 'budzenie_help', 'Wielu gości Twojego hotelu ma problem z porannym wstawaniem. Możesz im w tym pomóc!', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1108, 1, 'golf', 'Budowa pola golfowego', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1109, 1, 'golf_help', 'Czy chcesz zainwestować w budowę nowoczesnego pola golfowego pod miastem?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1110, 1, 'wyciag_narciarski_help', 'Czy chcesz zainwestować w budowę wyciągu narciarskiego w Pekunii?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1111, 1, 'plaza_help', 'Czy chcesz zainwestować w budowę kolejki liniowej na plażę Zalewu Pekuńskiego?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1112, 1, 'wyciag_narciarski', 'Inwestycja w wyciąg narciarski.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1113, 1, 'plaza', 'Kolejka Plażowa', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1114, 1, 'event_sadzenie_drzew', 'Społeczna Odpowiedzialność Biznesu - sadzenie drzew.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1115, 1, 'event_sadzenie_drzew_help', 'Podaj w jakim stopniu chcesz sfinansować to wydarzenie.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1116, 1, 'event_panele', 'Panele słoneczne', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1117, 1, 'event_panele_help', 'W tym polu wpisujesz liczbę paneli, które chcesz zamontować.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1118, 1, 'event_zimowisko', 'Zimowisko dla dzieci z domu dziecka', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1119, 1, 'event_zimowisko_help', 'Zdecyduj, czy chcesz dofinansować zimowisko w kwocie 5 000 PLN.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1120, 1, 'event_pralnia_ekologiczna', 'Pralnia ekologiczna', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1121, 1, 'event_pralnia_ekologiczna_help', 'Czy chcesz zainwestować w pralnię ekologiczną?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1122, 1, 'event_stop_umowom_smieciowym', 'Inicjatywa Stop Umowom Śmieciowym', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1123, 1, 'event_kierowniczka', 'Oferta szkoleń motywacyjnych', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1124, 1, 'event_kierowniczka_help', 'Czy chcesz przeprowadzić szkolenia dla swoich pracowników?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1125, 1, 'event_stop_umowom_smieciowym_help', 'Twoje stanowisko w związku z inicjatywą Stop Umowom Śmieciowym.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1126, 1, 'event_szkolenie', 'Szkolenie z zarządzania', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1127, 1, 'event_szkolenie_help', 'Bierzesz udział?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1128, 1, 'event_mikolajkowy_ekspres', 'Mikołajkowy Ekspres', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1129, 1, 'event_mikolajkowy_ekspres_help', 'Twój udział w inicjatywie Mikołajkowy Ekspres?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1130, 1, 'media_lokalne_ulotki', 'Ulotki', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1131, 1, 'media_lokalne_ulotki_help', 'Pierwsze działania reklamowe hotelu realizowane są we własnym zakresie. Zaprzyjaźniony grafik zaprojektował ulotkę i polecił tanią drukarnię. Zapoznaj się z ofertą reklamy za pomocą ulotek formatu A5. Ulotki gwarantują głównie reklamę lokalną. Pamiętaj, że zbyt dużo ulotek może być nieefektywne dla promocji hotelu.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1132, 1, 'media_lokalne_plakaty', 'Plakaty', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1133, 1, 'media_lokalne_plakaty_help', 'Pierwsze działania reklamowe hotelu tworzone są we własnym zakresie. Zaprzyjaźniony grafik zaprojektował plakat i polecił tanią drukarnię. Zapoznaj się z ofertą reklamy za pomocą plakatów formatu A2. Plakaty gwarantują głównie reklamę lokalną. Pamiętaj, że zbyt dużo plakatów może być nieefektywne dla promocji hotelu.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1134, 1, 'kredyt_obrotowy_kwota', 'Zaciągnij kredyt obrotowy\r\n', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1135, 1, 'kredyt_obrotowy_kwota_help', 'W tym polu ustalasz na jaką kwotę chciałbyś zaciągnąć kredyt obrotowy. Pamiętaj, że nie może ona przekraczać Twojej zdolności kredytowej, która dla kredytu obrotowego wyliczana jest na podstawie wzoru: 1,5 x wartość Twojego przedsiębiorstwa.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1136, 1, 'kredyt_karny_splata', 'Spłać kredyt karny', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1137, 1, 'kredyt_karny_splata_help', 'Kredyt karny jest bardzo wysoko oprocentowany. Spłać jak najszybciej.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1138, 1, 'kredyt_inwestycyjny_kwota', 'Kredyt inwestycyjny', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1139, 1, 'kredyt_inwestycyjny_kwota_help', 'W tym polu ustalasz na jaką kwotę chciałbyś zaciągnąć kredyt inwestycyjny. Pamiętaj, minimalna kwota tego kredytu to 50 000,00 PLN, natomiast maksymalna jest wyznaczana przez Twoją zdolność kredytową. Zdolność kredytowa, dla kredytu inwestycyjnego, wyliczana jest na podstawie wzoru: 2,5 x wartość Twojego przedsiębiorstwa. Kredyt inwestycyjny możesz wziąć wyłącznie w tej rundzie.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1140, 1, 'kredyt_inwestycyjny_kwota_help', 'Kredyt inwestycyjny umożliwia pozyskanie dodatkowych środków finansowych na rozwój przedsiębiorstwa. Oprocentowanie kredytu będzie zależne zarówno od kwoty kredytu jaki i okresu na jaki zostanie on zaciągnięty. Kredyt będzie spłacany począwszy od następnego kwartału. Raty kredytu będą równe przez cały okres jego spłaty.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1163, 1, 'pokoje_standard', 'Pokoje Standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1164, 1, 'lokata', 'Lokata', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1165, 1, 'strona_internetowa', 'Strona internetowa', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1166, 1, 'pranie_outsourcing', 'Koszty prania - outsourcing', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1167, 1, 'koszty_bazowe', 'Koszty bazowe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1168, 1, 'sniadania', 'Śniadania', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1169, 1, 'pracownicy_obslugi', 'Pracownicy obsługi', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1170, 1, 'kredyt_obrotowy', 'Kredyt obrotowy', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1175, 1, 'dofinansowanie', 'Dofinansowanie', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1176, 1, 'sprzatanie_outsourcing', 'Koszty sprzątania - outsourcing', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1177, 1, 'uslugi', 'Usługi', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1178, 1, 'media', 'Koszty reklamy', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1179, 1, 'pracownicy_administracji', 'Pracownicy administracji', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1221, 1, 'pranie_outsourcing_standard_kwota_help', 'W tym polu wpisujesz jaką kwotę przeznaczysz na pranie w pokojach Standard. Kwota ta będzie obejmowała wszystkie te pokoje w nadchodzącym kwartale.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1222, 1, '<b>Podstawowe:</b> Podwójne łóżko z antyalergicznym, bardzo wygodnym materacem, duży stół, dwa eleganckie krzesła, telewizor LCD 32”. Meble w nowoczesnym stylu.', 'Podwójne łóżko z antyalergicznym, bardzo wygodnym materacem, duży stół, dwa \r\neleganckie krzesła, telewizor LCD 32”. Meble w nowoczesnym stylu.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1223, 1, 'event_podjazd_dla_niepelnosprawnych', 'Podjazd dla osób niepełnosprawnych', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1225, 1, 'event_akcja_charytatywna_help', 'Czy weźmiesz udział w akcji charytatywnej?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1228, 1, 'strona_internetowa_tworzenie', 'Stworzenie strony internetowej', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1230, 1, 'zatrudnienie_pracownicy_obslugi_liczba', 'Ilość pracowników ogółem                                     ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1231, 1, 'zatrudnienie_pracownicy_obslugi_stale', 'Pracownicy na umowę o pracę', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1232, 1, 'zatrudnienie_pracownicy_obslugi_zlecenie', 'Pracownicy na umowę zlecenie', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1233, 1, 'zatrudnienie_pracownicy_obslugi_wynagrodzenie', 'Płaca miesięczna brutto', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1234, 1, 'zatrudnienie_pracownicy_obslugi_motywacja_procent', 'Premia (w %) od płacy brutto', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1235, 1, 'zatrudnienie_pracownicy_obslugi_motywacja_procent', 'Premia', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1236, 1, 'zatrudnienie_pracownicy_administracji_liczba', 'Ilość', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1237, 1, 'zatrudnienie_pracownicy_administracji_stale', 'Ilość na stałe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1238, 1, 'zatrudnienie_pracownicy_administracji_zlecenie', 'Ilość na zlecenie', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1239, 1, 'zatrudnienie_pracownicy_administracji_wynagrodzenie', 'Wynagrodzenie', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1240, 1, 'zatrudnienie_pracownicy_administracji_motywacja_procent', 'Premia (w %)', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1251, 1, 'lokata_kwota', 'Powiększ lokatę', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1254, 1, 'kredyt_karny', 'Kredyt karny', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1255, 1, 'event_fundusz_remontowy', 'Fundusz remontowy', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1261, 1, 'event_akcja_charytatywna', 'Akcja charytatywna', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1262, 1, 'motywacja_procent', 'Program motywacyjny', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1263, 1, 'kredyt_inwestycyjny', 'Kredyt inwestycyjny', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1265, 1, 'Pa article Lista', 'Lista artykułów', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1266, 1, 'Forgot your password?', 'Zapomniałeś hasła?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1267, 1, 'Signin', 'Logowanie', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1268, 1, 'The username and/or password is invalid', 'Nazwa użytkownika lub hasło są nieprawidłowe.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1273, 1, 'Nie jesteś przypisany, do rozgrywki', 'Nie jesteś przypisany, do rozgrywki', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1274, 1, 'Nie jesteś przypisany, do rozgrywki', 'Nie jesteś przypisany, do rozgrywki', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1372, 3, 'pranie_outsourcing_standard_kwota_info', 'Podaj kwartalną kwotę przeznaczoną na pranie. Inne hotele, posiadające taką samą liczbę pokoi jak Twój hotel, ustalają kwoty od %min_koszt% do %max_koszt%. Kwartalny koszt wyniesie <b>%koszt%</b>.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1373, 3, 'sprzatanie_outsourcing_standard_kwota_info', 'Podaj kwartalną kwotę przeznaczoną na sprzątanie. Inne hotele, posiadające taką samą liczbę pokoi jak Twój hotel, ustalają kwoty od %min_koszt% do %max_koszt%. Kwartalny koszt wyniesie <b>%koszt%</b>.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1374, 3, 'sprzatanie_outsourcing_lux_kwota_info', 'Podaj kwotę kwartalną przeznaczoną na sprzątanie. Inne hotele dla Twojej liczby pokoi ustalają kwoty od %min_koszt% do %max_koszt%. Kwartalny koszt wyniesie <b>%koszt%</b>.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1375, 3, 'sniadania_kwota_info', 'Podaj kwotę jaką chcesz przeznaczyć na przygotowanie jednego śniadania. Planowany koszt kwartalny wyniesie <b>%koszt%</b> (przy aktualnej liczbie zajętych pokoi). Pamiętaj o uwzględnieniu go w cenie pokoju!', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1377, 3, 'pranie_outsourcing_lux_kwota_info', 'Podaj kwotę kwartalną. Inne hotele dla Twojej liczby pokoi ustalają kwoty od %min_koszt% do %max_koszt%. Kwartalny koszt wyniesie <b>%koszt%</b>.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1379, 3, 'lokata_kwota_stan_info', 'Lokata umożliwia wykorzystanie wolnych środków finansowych przedsiębiorstwa w celu generowania dodatkowych zysków. Oprocentowanie lokaty dla tej kwoty wynosi %oprocentowanie%% kwartalnie. Wysokość oprocentowania zwiększa się wraz z wysokością kwoty jaką chcesz zainwestować.  <br /><br />Na lokacie posiadasz %kwota%. Szacowane odsetki kwartalne wyniosą %rata%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1380, 3, 'pracownicy_obslugi_motywacja_procent_info', 'Wpisz jaki procent funduszu płac będzie przeznaczany na motywowanie pracowników obsługi. Im mniejszy będzie podany przez Ciebie procent tym trudniej będzie zostać wynagrodzonym za dodatkowy wysiłek.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1381, 3, 'pracownicy_administracji_motywacja_procent_info', 'Wpisz jaki procent funduszu płac będzie przeznaczany na motywowanie pracowników administracji. Im mniejszy będzie podany przez Ciebie procent tym ciężej będzie zostać wynagrodzonym za dodatkowy wysiłek.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1384, 3, 'media_lokalne_bilboardy_info', 'Jest to forma, która rozreklamuje Twój hotel w pojedynczych miejscach na niewielkim terenie. Billboardy po części spełniają rolę informacyjną, ponieważ ułatwią gościom dotarcie do hotelu.  <br><br>Kwartalny koszt jednego billboardu to <b>%koszt_sztuka%</b>.<br /> <br />\r\n\r\nCałkowity koszt tej formy reklamy to <b>%koszt%</b> ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1385, 3, 'media_lokalne_prasa_info', 'Jest wydawany przez tę samą redakcję co „Głos Pekunii”, dlatego dzięki niemu dotrzesz do szerokiego grona czytelników. Często są to właściciele lub pracownicy firm, którzy poszukują miejsca do spania dla swoich kontrahentów.\r\n<br><br>\r\nKoszt każdej strony reklamującej Twój hotel to <b>%koszt_sztuka%</b>.<br /> <br />\r\n\r\n\r\nCałkowity koszt tej formy reklamy to <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1386, 3, 'media_lokalne_radio_info', 'Jest to mała lokalna stacja z bardzo długą tradycją. Ma ona grono stałych słuchaczy. Od niedawna  stacja ta nadaje swoje audycje również przez internet. Stało się tak dlatego, że jedna z rozrywkowych audycji, jest prowadzona przez prezentera, który stał się sławny dzięki występowi w ogólnokrajowym Talent Show.<br><br>\r\nKoszt każdej trzydziestosekundowej reklamy Twojego hotelu to <b>%koszt_sztuka%</b>.\r\n\r\n<br /> <br />\r\n\r\nCałkowity koszt tej formy reklamy to <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1387, 3, 'media_regionalne_radio_info', 'Dzięki reklamie w Radiu Sonus, każdy w regionie będzie znał nazwę Twojego hotelu. Usłyszy ją także wielu kierowców,  którzy często zjeżdżają z pobliskiej autostrady, aby przenocować w Pekunii. Radio pomoże Ci także pozyskać turystów, którzy podróżują samochodem, lecz nie posiadają zapewnionego noclegu.  <br><br>\r\nKoszt każdej trzydziestosekundowej reklamy to <b>%koszt_sztuka%</b>  <br /> <br />\r\nCałkowity koszt tej formy reklamy to <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1388, 3, 'media_regionalne_tv_info', 'Reklamy w TV Campus trafiają do szerokiego grona turystów. Dzięki temu możesz zaprezentować swój hotel w pełnej okazałości. Istnieje duża szansa, że to właśnie wystrojem oraz architekturą wnętrza przyciągniesz do siebie dużą liczbę turystów.\r\n <br><br>\r\nTV Campus sprzedaje swój czas antenowy w cenie  <b>%koszt_sztuka%</b> za każdą minutę. <br /><br />Całkowity koszt tej formy reklamy to <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1389, 3, 'media_regionalne_prasa_info', 'Jest najbardziej popularnym tygodnikiem w Pekunii i okolicach. Od lat, wielu turystów używa właśnie gazety „Twój Region” jako przewodnika, gdyż znajdują się w nim ciekawostki dotyczące zabytków, atrakcji oraz opisy i recenzje najlepszych restauracji.<br><br>\r\nKoszt każdej strony reklamującej Twój hotel to  <b>%koszt_sztuka%</b>.<br /><br />Całkowity koszt tej formy reklamy to <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1390, 3, 'media_krajowe_prasa_info', '„Vertitas” to najbardziej szanowane czasopismo rozrywkowe w naszym kraju. Wydawane jest ono co dwa tygodnie. Czytane jest, przez osoby preferujące aktywny wypoczynek. W tym magazynie znajduje się bardzo dużo artykułów dotyczących ciekawych wydarzeń w naszym kraju, takich jak: koncerty, festiwale, imprezy sportowe. Dodatkowo opisywane są mało znane, a piękne okolice naszego kraju takie jak Pekunia. „Vertitas” jest sprzedawane tylko w prenumeracie.<br><br>\r\nKoszt każdej strony reklamującej Twój hotel to <b>%koszt_sztuka%</b>.<br /><br />Całkowity koszt tej formy reklamy to: <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1391, 3, 'media_krajowe_tv_info', 'TV Nasus - to jeden z najczęściej oglądanych kanałów telewizyjnych w naszym kraju. Z pewnością, dzięki tej formie reklamy, będziesz mógł dotrzeć prawie do każdego segmentu rynku. Jednak jest to najdroższa reklama w naszej ofercie.\r\n<br><br>Każda minuta czasu antenowego w TV Nasus to <b>%koszt_sztuka%</b>.\r\n<br /><br />Całkowity koszt tej formy reklamy to: <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1394, 3, 'badanie_marketingowe_2_info', 'Koszt badań marketingowych zaawansowanych to %koszt%', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1395, 3, 'badanie_marketingowe_1_info', 'Oferujemy badanie, którego wyniki powinny przyczynić się do sukcesu twojej firmy! Sprawdzimy, kto jest Państwa potencjalnym klientem, oraz jakie są jego preferencje. Dzięki niemu, poznają Państwo również swoją konkurencję. Dostarczymy także -  wszystkie informacje niezbędne do stworzenia najlepszej oferty na rynku. Narzędzia badawcze jakie wykorzystamy to m.in. zogniskowane wywiady grupowe, ankiety i metoda ‘tajemniczego klienta’. Zebrane dane poddamy rzetelnej analizie statystycznej i sporządzimy raport, który przyślemy na Państwa adres e-mail.<br/><b>Czy chcesz skorzystać z naszej oferty?</b>\r\n<br><br>Koszt badań marketingowych to %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1396, 3, 'badanie_konkurencji_3_info', 'Koszt badań konkurencji to %koszt%', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1397, 3, 'badanie_konkurencji_2_info', 'Koszt badań konkurencji to %koszt%', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1398, 3, 'badanie_konkurencji_1_info', 'Koszt badań konkurencji to %koszt%', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1399, 3, 'event_akcja_charytatywna_info', 'Koszt Twojego zaangażowania to: <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1400, 3, 'event_pralnia_ekologiczna_info', 'Koszt Twojego zaangażowania to: <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1401, 3, 'event_szkolenie_info', 'Koszt Twojego zaangażowania to: <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1404, 3, 'event_mikolajkowy_ekspres_info', 'Koszt Twojego zaangażowania to: %koszt%', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1405, 3, 'strona_internetowa_info', 'Stworzenie strony internetowej to jednorazowy koszt <b>2 000,00 PLN</b>.<br> Koszt kwartalny utrzymania strony internetowej to <b>%koszt_kwartalny%</b> ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1406, 3, 'taxi_info', 'Koszt kwartalny ponoszony przez hotel: <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1407, 3, 'sejf_info', 'Koszt kwartalny ponoszony przez hotel: <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1408, 3, 'budzenie_info', 'Koszt kwartalny ponoszony przez hotel: <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1409, 3, 'wyciag_narciarski_info', 'Koszt usługi to: <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1410, 3, 'plaza_info', 'Koszt usługi to <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1411, 3, 'ochronka_dla_dzieci_info', 'Koszt usługi to: <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1412, 3, 'pokoj_zabaw_dla_dzieci_info', 'Koszt usługi to: <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1413, 3, 'automaty_vendingowe_info', 'Koszt usługi to: <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1414, 3, 'sala_konferencyjna_info', 'Koszt usługi to: <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1415, 3, 'wspolpraca_urzad_pracy_info', 'Koszt usługi to: <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1416, 3, 'wspolpraca_biurami_podrozy_info', 'Koszt usługi to: <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1417, 3, 'mozliwosc_odebrania_gosci_info', 'Koszt usługi to: <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1418, 3, 'business_lounge_info', 'Koszt usługi to: <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1419, 3, 'ekspresy_czajniki_info', 'Koszt usługi to: <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1420, 3, 'media_lokalne_ulotki_info', 'Podaj ile zamawiasz zestawów ulotek (1 zestaw = 1000 sztuk). Koszt jednego zestawu ulotek to 100,00 PLN. Całkowity koszt tej formy reklamy to:  %koszt%', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1421, 3, 'media_lokalne_plakaty_info', 'Podaj ile zamawiasz zestawów plakatów (1 zestaw = 100 sztuk). Koszt jednego zestawu plakatów to 300,00 PLN. Całkowity koszt tej formy reklamy to: %koszt%', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1429, 3, 'event_podjazd_dla_niepelnosprawnych_info', 'Koszt Twojego zaangażowania to: <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1431, 3, 'koszt_obslugi_ustal_wynagrodzenie_info', 'Ustal wielkość wynagrodzenia pracowników obsługi. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1432, 3, 'koszt_administracji_ustal_wynagrodzenie_info', 'Ustal wielkość wynagrodzenia pracowników administracji. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1433, 3, 'koszt_obslugi_nie_ma_pracownikow_info', 'Pracownicy obsługi mogą zastąpić firmę outsourcingową w sprzątaniu.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1434, 3, 'koszt_administracji_nie_ma_pracownikow_info', 'Pracownicy administracji pozwolą na usprawnienie działania Twojego hotelu.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1435, 3, 'koszt_obslugi_info', 'Koszt utrzymania aktualnej liczby pracowników wynosi: <span>%koszt%</span>. Koszt premii pracowników obsługi to: <span>%kosztMotywacji%</span>.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1436, 3, 'koszt_administracji_info', 'Koszt utrzymania aktualnej liczby pracowników administracji wynosi:  <span> %koszt% </span>.  Koszt premii pracowników administracji to: <span>%kosztMotywacji%</span>.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1437, 3, 'media_krajowe_radio_info', 'Radio Terra - to stacja, która umożliwi Ci w stosunkowo tani sposób dotrzeć do klientów w całym kraju. Niska cena tej reklamy wcale nie oznacza niskiego poziomu jej efektywności. Pamiętaj, że Radio Terra jest słuchane przez bardzo specyficzne grono odbiorców; intelektualistów, którzy rzadko oglądają telewizję. Być może jest to jedyna szansa na dotarcie do tej grupy.<br><br>\r\nKażda trzydziestosekundowa reklama w Radiu Terra kosztuje <b>%koszt_sztuka%</b>. <br /><br />Całkowity koszt tej formy reklamy to: <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1438, 3, 'badanie_marketingowe_1_info', 'Koszt badań marketingowych to %koszt%', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1439, 3, 'event_festiwal_filmowy_info', 'Szacowany koszt zaangażowania przy aktualnej liczbie pokoi wyniesie <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1441, 3, 'event_zimowisko_info', 'Wszelkie niezbędne informacje dotyczące tego wydarzenia znajdują się w wiadomości jaką otrzymałeś od przedstawicieli domu dziecka. <br /><br />Koszt Twojego zaangażowania to: <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1442, 3, 'event_stop_umowom_smieciowym_info', 'Brak możliwości oszacowania kosztu.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1444, 3, 'cena_pokoje_standard_info_0', 'Typowa cena za pokój Standard w tym regionie to od 50,00 do 90,00 PLN za dobę.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1445, 3, 'cena_pokoje_standard_info_1', 'Cena za pokój Standard w tym rejonie miasta wynosi od 70,00 do 100,00 PLN za dobę.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1446, 3, 'cena_pokoje_standard_info_2', 'Typowa cena za pokój standard w tym regionie zawiera się pomiędzy 70 - 100 zł za dobę.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1447, 3, 'pokoje_standard_wyposazenie_stan_info', 'Wyposażenie bez zmiany.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1448, 3, 'pokoje_standard_wyposazenie_kupno_info', 'Kupno wyposażenia na wyższy poziom będzie kosztować %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1449, 3, 'pokoje_standard_wyposazenie_sprzedaz_info', 'Sprzedaż wyposażenia przyniesie zwrot %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1450, 3, 'pokoje_lux_wyposazenie_stan_info', 'Wyposażenie bez zmiany.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1451, 3, 'pokoje_lux_wyposazenie_kupno_info', 'Kupno wyposażenia na wyższy poziom będzie kosztować %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1452, 3, 'pokoje_lux_wyposazenie_sprzedaz_info', 'Sprzedaż wyposażenia przyniesie zwrot %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1);
INSERT INTO `i18n_translations` (`id`, `cat_id`, `source`, `target`, `comments`, `created_at`, `updated_at`, `translated`) VALUES
(1453, 3, 'pokoje_standard_stan_info', 'Posiadasz %pokoje% pokoi.\r\n<br><br>\r\nJednorazowo możesz wybudować lub zlikwidować wielokrotność  pięciu pokoi. Zwróć uwagę, że cena jednostkowa za jeden pokój maleje wraz ze wzrostem inwestycji. Pamiętaj, że jeśli zdecydujesz się na likwidację pokoi, otrzymasz zwrot tylko 50% wartości nakładu poniesionego na ich stworzenie oraz 30% wartości ich dodatkowego wyposażenia.\r\n', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1454, 3, 'pokoje_standard_sprzedaz_info', 'Posiadasz %pokoje% pokoi. Sprzedajesz %pokoje_decyzja% pokoi. Cofasz decyzję sprzedaży %pokoje_zmiana%. Zysk z podjęcia takiej decyzji wyniesie %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1455, 3, 'pokoje_standard_stan_kupno_info', 'Posiadasz %pokoje% pokoi. Planujesz wybudować %pokoje_decyzja% pokoi.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1456, 3, 'pokoje_standard_kupno_info', 'Posiadasz %pokoje% pokoi. \nPlanujesz wybudować %pokoje_decyzja% pokoi - będą one dostępne dla klientów od następnej rundy. Koszt budowy wyniesie %koszt%. \n<br><br>\nJednorazowo możesz wybudować lub zlikwidować wielokrotność  pięciu pokoi. Zwróć uwagę, że cena jednostkowa za jeden pokój maleje wraz ze wzrostem inwestycji. Pamiętaj, że jeśli zdecydujesz się na likwidację pokoi, otrzymasz zwrot tylko 50% wartości nakładu poniesionego na ich stworzenie oraz 30% wartości ich dodatkowego wyposażenia.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1457, 3, 'pokoje_standard_kupno_sprzedaz_info', 'Posiadasz %pokoje% pokoi. Planujesz wybudować %pokoje_decyzja% pokoi. Cofasz decyzję budowy %pokoje_zmiana% pokoi. Przychód z podjęcia takiej decyzji wyniesie %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1458, 3, 'pokoje_standard_sprzedaz_kupno_info', 'Posiadasz %pokoje% pokoi. Sprzedajesz %pokoje_decyzja% pokoi. Zysk ze sprzedaży pokoi wyniesie %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1459, 3, 'pokoje_standard_sprzedaz_kupno_stan_info', 'Posiadasz %pokoje% pokoi. Cofasz decyzję o sprzedaży %pokoje_zmiana% pokoi. Koszt podjęcia takiej decyzji wyniesie %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1460, 3, 'pokoje_standard_sprzedaz_kupno_kupno_info', 'Posiadasz %pokoje% pokoi. Cofasz decyzję o sprzedaży %pokoje_decyzja_stara% pokoi. Planujesz wybudować %pokoje_decyzja% pokoi. Koszt podjęcia takiej decyzji wyniesie %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1461, 3, 'pokoje_standard_kupno_sprzedaz_stan_info', 'Posiadasz %pokoje% pokoi. Cofasz decyzję o budowie %pokoje_zmiana% pokoi. Zysk z podjęcia takiej decyzji wyniesie %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1462, 3, 'pokoje_standard_kupno_sprzedaz_sprzedaz_info', 'Posiadasz %pokoje% pokoi. Cofasz decyzję o budowie %pokoje_decyzja_stara% pokoi. Sprzedajesz %pokoje_decyzja% pokoi. Zysk z podjęcia takiej decyzji wyniesie %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1463, 3, 'pokoje_lux_stan_sprzedaz_info', 'Posiadasz %pokoje% pokoi. Sprzedałeś %pokoje_decyzja% pokoi w tej rundzie. Decyzja o sprzedaży może zostać cofnięta.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1464, 3, 'pokoje_lux_stan_info', 'Pokoje Delux charakteryzują się większą powierzchnią oraz wyższym poziomem wykończenia niż pokoje Standard. Koszt jednostkowy stworzenia takiego pokoju jest wyższy. Dodatkowo należy pamiętać o tym, że późniejsze utrzymanie pokoju Delux jest droższe, gdyż zajmuje on więcej wynajmowanej powierzchni. Pamiętaj, że jeśli zdecydujesz się na likwidację pokoi, otrzymasz zwrot tylko 50% wartości nakładu poniesionego na ich stworzenie oraz 30% wartości ich dodatkowego wyposażenia.<br> <br />Posiadasz %pokoje% pokoi.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1465, 3, 'pokoje_lux_sprzedaz_info', 'Posiadasz %pokoje% pokoi. Sprzedajesz %pokoje_decyzja% pokoi. Cofasz decyzję sprzedaży %pokoje_zmiana%. Zysk z podjęcia takiej decyzji wyniesie %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1466, 3, 'pokoje_lux_stan_kupno_info', 'Posiadasz %pokoje% pokoi. Planujesz wybudować %pokoje_decyzja% pokoi.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1467, 3, 'pokoje_lux_kupno_info', 'Pokoje Delux charakteryzują się większą powierzchnią oraz wyższym poziomem wykończenia niż pokoje Standard. Naturalnie, koszt jednostkowy stworzenia takiego pokoju jest wyższy. Dodatkowo należy pamiętać o tym, że późniejsze utrzymanie pokoju Delux jest droższe, gdyż zajmuje on więcej wynajmowanej powierzchni. <br>\r\n<br>\r\nPosiadasz %pokoje% pokoi. Planujesz wybudować %pokoje_decyzja% pokoi. Koszt budowy wyniesie %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1468, 3, 'pokoje_lux_kupno_sprzedaz_info', 'Posiadasz %pokoje% pokoi. Planujesz wybudować %pokoje_decyzja% pokoi. Cofasz decyzję budowy %pokoje_zmiana% pokoi. Zysk z podjęcia takiej decyzji wyniesie %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1469, 3, 'pokoje_lux_sprzedaz_kupno_info', 'Posiadasz %pokoje% pokoi. Sprzedajesz %pokoje_decyzja% pokoi. Zysk ze sprzedaży pokoi wyniesie %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1470, 3, 'pokoje_lux_sprzedaz_kupno_stan_info', 'Posiadasz %pokoje% pokoi. Cofasz decyzję o sprzedaży %pokoje_zmiana% pokoi. Koszt podjęcia takiej decyzji wyniesie %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1471, 3, 'pokoje_lux_sprzedaz_kupno_kupno_info', 'Posiadasz %pokoje% pokoi. Cofasz decyzję o sprzedaży %pokoje_decyzja_stara% pokoi. Planujesz wybudować %pokoje_decyzja% pokoi. Koszt podjęcia takiej decyzji wyniesie %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1472, 3, 'pokoje_lux_kupno_sprzedaz_stan_info', 'Posiadasz %pokoje% pokoi. Cofasz decyzję o budowie %pokoje_zmiana% pokoi. Zysk z podjęcia takiej decyzji wyniesie %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1473, 3, 'pokoje_lux_kupno_sprzedaz_sprzedaz_info', 'Posiadasz %pokoje% pokoi. Cofasz decyzję o budowie %pokoje_decyzja_stara% pokoi. Sprzedajesz %pokoje_decyzja% pokoi. Zysk z podjęcia takiej decyzji wyniesie %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1474, 3, 'pokoje_standard_stan_sprzedaz_info', 'Posiadasz %pokoje% pokoi. Sprzedałeś %pokoje_decyzja% pokoi w tej rundzie. Decyzja o sprzedaży może zostać cofnięta.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1475, 3, 'rejestracja_na_stronie_www_info', 'Koszt kwartalny ponoszony przez hotel: %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1477, 3, 'rejestracja_na_stronie_www_help', 'Pomoc', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1478, 3, 'cena_pokoje_lux_info_0', 'Typowa cena za pokój Delux w tym regionie zawiera się pomiędzy 125,00 - 175,00 PLN za dobę.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1479, 3, 'cena_pokoje_lux_info_1', 'Typowa cena za pokój Delux w tym regionie zawiera się pomiędzy 135,00 - 185,00 PLN za dobę.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1480, 3, 'cena_pokoje_lux_info_2', 'Typowa cena za pokój Delux w tym regionie zawiera się pomiędzy 145,00 - 195,00 PLN za dobę.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1481, 3, 'event_kierowniczka_info_stan', 'Decyzja o zatrudnieniu kierowniczki bez zmian.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1482, 3, 'event_kierowniczka_info_zysk', 'Planujesz zatrudnić kierowniczkę w niższej wersji. Zysk z podjęcia takiej decyzji to %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1483, 3, 'event_kierowniczka_info_koszt', 'Planujesz zatrudnić kierowniczkę w wyżej wybranej wersji. Koszt podjęcia takiej decyzji to %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1484, 3, 'event_panele_info_stan', 'Montaż paneli słonecznych wspomoże Twoje działania, w obszarze Społecznej Odpowiedzialności Biznesu. Dodatkowo instalacja paneli obniży koszty zużycia prądu w Twoim hotelu. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1485, 3, 'event_panele_info_zysk', 'Cofasz decyzję o kupnie paneli. Zysk z podjęcia takiej decyzji wyniesie %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1486, 3, 'event_panele_info_koszt', 'W tej chwili decydujesz o zamontowaniu nowych paneli słonecznych. Koszt takiej inwestycji to %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1487, 3, 'event_sadzenie_drzew_info_stan', 'Wydarzenie polegające na sadzeniu drzew w najbliższej okolicy. Całkowity koszt to 3 000,00 PLN. <br>Decyzja o uczestnictwie w wydarzeniu bez zmian.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1488, 3, 'event_sadzenie_drzew_info_zysk', 'Zmiejszasz zaanagażowanie w wydarzenie. Zysk z podjęcia takiej decyzji wyniesie %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1489, 3, 'event_sadzenie_drzew_info_koszt', 'Decydujesz się zaangażować w wydarzenie. Koszt podjęcia takiej decyzji to %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1490, 1, 'Obsługa', 'Pracownicy obsługi', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1491, 3, 'golf_info', 'Koszt usługi to: <b>%koszt%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1492, 3, 'event_stop_umowom_smieciowym_info', 'Koszt zaangażowania w wydarzenie nie może zostać oszacowane.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1493, 3, 'kredyt_inwestycyjny_kwota_zysk_info', 'Twoja zdolność kredytowa to %zdolnosc%. Zaciągasz kredyt w wysokości %kwota%. Szacowana rata kwartalna wyniesie %rata%. Zmniejszasz kwotę kredytu o %roznica%. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1494, 3, 'kredyt_inwestycyjny_kwota_stan_info', 'Kredyt inwestycyjny umożliwia pozyskanie dodatkowych środków finansowych na rozwój przedsiębiorstwa. Okres trwania kredytu inwestycyjnego to 20 kwartałów. Będzie on spłacany począwszy od następnego kwartału. Raty kredytu będą automatycznie pobierane z Twojego konta. Oprocentowanie roczne kredytu inwestycyjnego wynosi %oprocentowanie%%.<br /><br />Twoja długoterminowa zdolność kredytowa to %zdolnosc%. Zaciągasz kredyt w wysokości %kwota%. Szacowana rata kwartalna wyniesie %rata%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1495, 3, 'kredyt_inwestycyjny_kwota_koszt_info', 'Twoja zdolność kredytowa to %zdolnosc%. Zaciągasz kredyt w wysokości %kwota%. Szacowana rata kwartalna wyniesie %rata%. Zwiększasz kwotę kredytu o %roznica%. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1496, 1, 'kredyt_obrotowy_splata', 'Spłać kredyt obrotowy', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1497, 3, 'kredyt_obrotowy_splata_stan_info', 'Posiadasz %kwota% kredytu. Szacowane odsetki kwartalne wyniosą %rata%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1498, 3, 'kredyt_obrotowy_splata_zysk_info', 'Spłacasz %value% kredytu. Będziesz posiadał %kwota% kredytu. Szacowane odsetki kwartalne wyniosą %rata%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1499, 3, 'kredyt_obrotowy_kwota_stan_info', 'Kredyt obrotowy pozwala na zwiększenie płynności finansowej przedsiębiorstwa. Ty, jako kredytobiorca, decydujesz o dogodnym momencie spłaty kredytu, jednak odsetki od niego będą automatycznie pobierane z Twojego konta co kwartał. Oprocentowanie roczne kredytu obrotowego dla tej kwoty wynosi %oprocentowanie%%, wysokość oprocentowania zależy od wysokości pożyczki.<br /><br />Twoja bieżąca zdolność kredytowa to %zdolnosc%. Posiadasz %kwota% kredytu. Szacowane odsetki kwartalne wyniosą %rata%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1500, 3, 'kredyt_obrotowy_kwota_koszt_info', 'Twoja zdolność kredytowa to %zdolnosc%. Będziesz posiadał %kwota% kredytu. Szacowane odsetki kwartalne wyniosą %rata%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1501, 1, 'lokata_splata', 'Wypłać z lokaty', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1502, 3, 'lokata_splata_stan_info', 'Na lokacie posiadasz %kwota%. Szacowane odsetki kwartalne wyniosą %rata%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1503, 3, 'lokata_splata_zysk_info', 'Wypłacasz %value%. Na lokacie pozostanie %kwota%. Szacowane odsetki kwartalne wyniosą %rata%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1504, 3, 'lokata_kwota_koszt_info', 'Wpłacasz %value%. Na lokacie będzie %kwota%. Szacowane odsetki kwartalne wyniosą %rata%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1505, 1, 'rejestracja_na_stronie_www', 'Rezerwacja pokoi przez internet', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1506, 1, 'Usługi podstawowe', 'Usługi podstawowe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1511, 1, 'rejestracja_na_stronie_www_help', 'Dzięki ulepszeniu strony www hotelu, Twoi goście będą mogli rezerwować pokoje przez internet.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1512, 1, 'Pokoje standard', 'Pokoje Standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1513, 1, 'kredyt_obrotowy_splata_help', 'W tym polu ustalasz jaką kwotę kredytu obrotowego chcesz spłacić.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1514, 1, 'lokata_splata_help', 'Miejsce to służy podaniu kwoty, która ma zostać wycofana z lokaty.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1515, 1, 'event_podjazd_dla_niepelnosprawnych_help', 'Czy chcesz dostosować swój hotel dla niepełnosprawnych?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1516, 1, 'help_decision_form_pokoje_standard_wyposazenie_0', 'Podwójne łóżko, stolik, 2 krzesła, wieszak, szafka nocna. Stare meble i przedmioty.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1517, 1, 'help_decision_form_strona_internetowa_0', 'Brak strony internetowej', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1518, 1, 'pracownicy_obslugi_help', ' W tym miejscu możesz zatrudnić pracowników obsługi. Do ich obowiązków oprócz obsługi gości należy również sprzątanie pokoi. Pamiętaj też, że odpowiednio zmotywowana i wyszkolona kadra potrafi przynieść lepsze efekty niż firma outsourcingowa. W polu ''''Premia'''', możesz określić procent od całości wydatków na zatrudnienie pracowników, który wpłynie na ich motywację do pracy.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1519, 1, 'pracownicy_administracji_help', 'Pracownicy administracji zajmują się koordynacją pracy, kontrolą wydatków, obsługą gości, promocją i rozwiązywaniem bieżących problemów. W polu Premia, możesz ustalić wysokość premii. Przyznanie premii zwiększa motywację do pracy.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1520, 1, 'help_decision_form_strona_internetowa_1', 'Strona internetowa z podstawowymi informacjami na temat hotelu: adres, cennik, kilka zdjęć. Skromna szata graficzna. Trudno ją znaleźć przez wyszukiwarkę.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1521, 1, 'help_decision_form_strona_internetowa_2', 'Pakiet podstawowy + pozycjonowanie w wynikach wyszukiwarki internetowej; łatwiejsze odnajdywanie strony przez klientów.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1522, 1, 'help_decision_form_strona_internetowa_3', 'Zawartość poprzednich pakietów + promocja hotelu w mediach społecznościowych.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1523, 1, 'help_decision_form_pokoje_standard_wyposazenie_1', 'Podwójne łóżko, komoda, stolik, 3 krzesła, szafa wnękowa, telewizor plazmowy 32”. Nowe meble i przedmioty.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1524, 1, 'help_decision_form_pokoje_standard_wyposazenie_1', 'Podwójne łóżko, komoda, stolik, 3 krzesła, szafa wnękowa, telewizor plazmowy 32”. Meble i przedmioty nowe.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1525, 1, 'help_decision_form_pokoje_standard_wyposazenie_2', 'Łóżko z wygodnym materacem, stolik kawowy, 2 fotele, żyrandol, lustro, szafa wnękowa, telewizor plazmowy 45”, internet. Meble i przedmioty nowe, o podwyższonym standardzie.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1526, 1, 'help_decision_form_wybor_lokalizacji_0', 'Rejon miasta, w  którym nie ma atrakcji turystycznych. Noclegu w tym miejscu szukają ludzie oszczędni, którym nie zależy na najwyższym komforcie i jakości. Zaletą tego rejonu jest fakt, że koszty utrzymania  Twojego hotelu będą zdecydowanie niższe niż w innych dzielnicach.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1527, 1, 'help_decision_form_wybor_lokalizacji_1', 'Wypośrodkowane wskaźniki z pozostałych dwóch dzielnic. Hotel warto umieścić w śródmieściu, jeżeli planujesz przyciągnąć średniozamożnych klientów i będziesz w stanie opłacić rachunki średniej wielkości.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1528, 1, 'help_decision_form_wybor_lokalizacji_2', 'Hotel położony w centrum gwarantuje dużą liczbę klientów, również tych najbogatszych. Należy jednak pamiętać, że koszty utrzymania hotelu (opłaty za wynajem i media) będą znacznie wyższe niż w pozostałych dzielnicach. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1529, 1, 'oblozenie', 'Obłożenie pokoi', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1530, 1, 'pokoje_oblozone_standard', 'Obłożenie pokoi standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1531, 5, 'oblozenie', 'Obłożenie pokoi', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1532, 5, 'pokoje_oblozone_standard', 'Obłożenie pokoi Standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1533, 5, 'pokoje_oblozone_lux', 'Obłożenie pokoi Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1534, 5, 'jakosc', 'Jakość oferty', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1535, 5, 'jakosc_pokoju_standard', 'Jakość pokoi Standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1536, 5, 'jakosc_pokoju_lux', 'Jakość pokoi Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1537, 5, 'zatrudnienie', 'Zatrudnienie', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1538, 5, 'liczba_zatrudnionych', 'Liczba pracowników ogółem', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1539, 5, 'liczba_zatrudnionych_obsluga', 'Liczba pracowników obsługi', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1540, 5, 'liczba_zatrudnionych_administracja', 'Liczba pracowników administracji', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1541, 5, 'satysfakcja', 'Wskaźniki satysfakcji', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1542, 5, 'satysfakcja_pracownikow', 'Satysfakcja pracowników', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1543, 5, 'satysfakcja_klientow_standard', 'Satysfakcja klientów pokoi Standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1544, 5, 'satysfakcja_klientow_lux', 'Satysfakcja klientów pokoi Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1545, 5, 'marketing', 'Efektywność marketingu', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1546, 5, 'efektywnosc_marketingu_standard', 'Efektywność marketingu pokoi Standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1547, 5, 'efektywnosc_marketingu_lux', 'Efektywność marketingu pokoi Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1548, 5, 'marza', 'Zysk na jeden pokój w kwartale', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1549, 5, 'marza_standard', 'Zysk na jeden pokój Standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1550, 5, 'marza_lux', 'Zysk na jeden pokój Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1551, 5, 'firma', 'Wskaźniki firmy', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1552, 5, 'wartosc_zadluzenia', 'Wysokość zadłużenia', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1553, 5, 'majatek_firmy', 'Majątek firmy', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1554, 5, 'skumulowany_zysk', 'Skumulowany wynik finansowy', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1555, 5, 'wartosc_udzialow', 'Wartość udziałów', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1556, 4, 'oblozenie_pokoje_oblozone_standard', 'Wskaźnik obłożenia pokoi Standard w ostatnim kwartale.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1557, 1, 'nazwa_marki', 'Nazwa hotelu', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1558, 1, 'logo_marki', 'Logo firmy', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1559, 1, 'help_decision_form_pokoje_lux_wyposazenie_0', 'Podwójne łóżko z antyalergicznym, bardzo wygodnym materacem, duży stół, dwa eleganckie krzesła, telewizor LCD 32”. Meble w nowoczesnym stylu.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1560, 1, 'help_decision_form_pokoje_lux_wyposazenie_1', 'Łóżko, stół, szafa, krzesła oraz fotele wykonane z dębowego drewna, skórzana kanapa, telewizor LCD 42”. Wnętrze wykończone w zabytkowym stylu; wszystkie przedmioty są nowe oraz starannie wykończone.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1561, 1, 'help_decision_form_pokoje_lux_wyposazenie_2', 'Królewskie łoże z baldachimem, osobna garderoba, bardzo wygodny skórzany komplet wypoczynkowy, telewizor plazmowy 60” z zestawem kina domowego. Meble i przedmioty są nowe, o znacznie podwyższonym standardzie.\r\n', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1562, 1, 'badanie_marketingowe_popyt_standard', 'Badanie marketingowe I', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1563, 1, 'badanie_marketingowe_popyt_standard_help', 'Czy chcesz dowiedzieć się więcej o charakterystyce hotelarskiego rynku Pekunii?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1564, 1, 'Pokoje delux', 'Pokoje Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1565, 1, 'badanie_marketingowe_uslugi_podstawowe', 'Badanie marketingowe II', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1566, 1, 'badanie_marketingowe_uslugi_podstawowe_help', 'Czy chcesz dowiedzieć się więcej o charakterystyce usług podstawowych?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1567, 1, 'badanie_marketingowe_sezonowosc', 'Badanie marketingowe III ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1568, 1, 'badanie_marketingowe_sezonowosc_help', 'Czy chcesz dowiedzieć się więcej o wpływie pór roku na popyt?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1569, 1, 'badanie_marketingowe_popyt_lux', 'Badanie marketingowe IV', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1570, 1, 'badanie_marketingowe_reklama_zaawansowana', 'Badanie marketingowe V', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1571, 1, 'badanie_marketingowe_popyt_lux_help', 'Czy chcesz dowiedzieć się więcej o charakterystyce popytu na pokoje Delux?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1572, 1, 'badanie_marketingowe_popyt_lux_help', 'Czy chcesz dowiedzieć się więcej o charakterystyce popytu na pokoje Delux?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1573, 1, 'badanie_marketingowe_reklama_zaawansowana_help', 'Czy chcesz dowiedzieć się więcej o efektywności różnych form reklamy?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1574, 1, 'badanie_marketingowe_konkurencja', 'Badanie marketingowe VI', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1575, 1, 'badanie_marketingowe_konkurencja_help', 'Czy chcesz dowiedzieć się więcej o nowej konkurencji?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1576, 1, 'badanie_marketingowe_uslugi_zaawansowane_segmentacja', 'Badanie marketingowe VII', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1577, 1, 'badanie_marketingowe_uslugi_zaawansowane_segmentacja_help', 'Czy chcesz dowiedzieć się więcej o grupach konsumentów na rynku hotelarskim?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1578, 7, 'saldo_koncowe', 'Saldo końcowe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1579, 7, 'saldo_poczatkowe', 'Saldo początkowe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1580, 7, 'wplywy', 'Wpływy', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1581, 7, 'wyplywy', 'Wypływy', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1585, 7, 'wplywy_operacyjne', 'Przychody operacyjne', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1586, 7, 'wplywy_nadzwyczajne', 'Przychody nadzwyczajne', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1587, 7, 'wyplywy_operacyjne', 'Rozchody operacyjne', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1588, 7, 'wyplywy_operacyjne_stale', 'Koszty stałe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1589, 7, 'wyplywy_operacyjne_zmienne', 'Koszty zmienne', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1590, 7, 'wplywy_operacyjne_sprzedaz', 'Wpływy ze sprzedaży', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1591, 7, 'wplywy_operacyjne_finansowe', 'Przychody finansowe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1592, 8, 'przychody', 'Przychody', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1601, 8, 'koszty', 'Koszty', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1616, 8, 'suma', 'Wynik finansowy', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1617, 8, 'koszty_marketingowe', 'Koszty marketingowe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1618, 8, 'koszty_bezposrednie', 'Koszty bezpośrednie prowadzenia hotelu', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1619, 8, 'koszty_modernizacja', 'Koszty modernizacji hotelu', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1620, 8, 'koszty_obywatelska', 'Koszty działalności obywatelskiej', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1621, 8, 'przychody_sprzedaz', 'Przychody ze sprzedaży', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1622, 8, 'przychody_finansowe', 'Przychody finansowe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1623, 8, 'przychody_nadzwyczajne', 'Inne przychody', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1624, 8, 'przychody_sprzedaz_pokoje_standard', 'Przychody z wynajmu pokoi Standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1625, 8, 'przychody_sprzedaz_pokoje_lux', 'Przychody z wynajmu pokojów Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1626, 8, 'przychody_finansowe_lokata', 'Przychody z odsetek od lokaty', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1627, 8, 'przychody_nadzwyczajne_oszczednosci_panele', 'Przychody z tytułu posiadania paneli słonecznych', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1628, 8, 'koszty_marketingowe_badania', 'Koszty badań marketingowych', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1629, 8, 'koszty_marketingowe_strona_internetowa', 'Koszty prowadzenia strony internetowej', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1630, 8, 'koszty_marketingowe_ulotki', 'Koszty zakupu ulotek', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1631, 8, 'koszty_marketingowe_plakaty', 'Koszty zakupu plakatów', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1632, 8, 'koszty_marketingowe_reklama_lokalna', 'Reklama lokalna', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1633, 8, 'koszty_marketingowe_reklama_lokalna_bilboardy', 'Billboardy', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1634, 8, 'koszty_marketingowe_reklama_lokalna_prasa', 'Koszt wykupienia reklamy w prasie lokalnej', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1635, 8, 'koszty_marketingowe_reklama_lokalna_radio', 'Koszt wykupienia reklamy w radiu lokalnym', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1636, 8, 'koszty_marketingowe_reklama_regionalna', 'Reklama regionalna', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1637, 8, 'koszty_marketingowe_reklama_regionalna_prasa', 'Koszt wykupienia reklamy w prasie regionalnej', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1638, 8, 'koszty_marketingowe_reklama_regionalna_radio', 'Koszt wykupienia reklamy w radiu regionalnym', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1639, 8, 'koszty_marketingowe_reklama_regionalna_tv', 'Koszt wykupienia reklamy w  telewizji regionalnej', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1640, 8, 'koszty_marketingowe_reklama_krajowa', 'Reklama krajowa', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1641, 8, 'koszty_marketingowe_reklama_krajowa_prasa', 'Koszt wykupienia reklamy w prasie krajowej', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1642, 8, 'koszty_marketingowe_reklama_krajowa_radio', 'Koszt wykupienia reklamy w radiu krajowym', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1643, 8, 'koszty_marketingowe_reklama_krajowa_tv', 'Koszt wykupienia czasu antenowego w telewizji', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1644, 8, 'koszty_bezposrednie_stale', 'Koszty stałe prowadzenia działalności', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1645, 8, 'koszty_bezposrednie_dzierzawa', 'Koszty wynajmu', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1646, 8, 'koszty_bezposrednie_media', 'Koszty mediów', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1647, 8, 'koszty_bezposrednie_media_woda', 'Koszty wody', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1648, 8, 'koszty_bezposrednie_media_prad', 'Koszty prądu', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1649, 8, 'koszty_bezposrednie_inne_i_podatki', 'Inne koszty', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1650, 8, 'koszty_bezposrednie_pracownicy_obslugi', 'Koszty pracowników obsługi', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1651, 8, 'koszty_bezposrednie_pracownicy_obslugi', 'Koszty pracowników obsługi', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1652, 8, 'koszty_bezposrednie_pracownicy_administracji', 'Koszty stałe administracji', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1653, 8, 'koszty_bezposrednie_obsluga', 'Koszty obsługi pokoi', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1654, 8, 'koszty_bezposrednie_sniadania', 'Koszt cateringu śniadaniowego', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1655, 8, 'koszty_bezposrednie_obsluga_sprzatanie_standard', 'Sprzątanie pokoi Standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1656, 8, 'koszty_bezposrednie_obsluga_pranie_standard', 'Pranie pościeli w pokojach Standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1657, 8, 'koszty_bezposrednie_obsluga_sprzatanie_lux', 'Sprzątanie pokoi Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1658, 8, 'koszty_bezposrednie_obsluga_pranie_lux', 'Pranie pościeli w pokojach Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1659, 8, 'koszty_modernizacja_kupno_pokoje_standard', 'Kupno pokoi Standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1660, 8, 'koszty_modernizacja_kupno_wyposazenia_standard', 'Koszt podwyższenia standardu pokoi Standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1661, 8, 'koszty_modernizacja_uslugi', 'Koszt stworzenia usług dodatkowych', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1662, 8, 'koszty_modernizacja_kupno_pokoje_lux', 'Kupno pokoi Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1663, 8, 'koszty_modernizacja_kupno_wyposazenia_lux', 'Koszt podwyższenia standardu pokoi Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1664, 8, 'koszty_modernizacja_kupno_wyposazenia_lux', 'Koszt podwyższenia standardu pokoi Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1665, 8, 'koszty_modernizacja_event_panele', 'Koszt zamontowania paneli słonecznych', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1666, 8, 'koszty_modernizacja_event_kierowniczka', 'Koszt zatrudnienia kierowniczki', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1667, 8, 'koszty_modernizacja_pralnia_ekologiczna', 'Koszt utrzymania pralni ekologicznej', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1668, 8, 'koszty_modernizacja_event_podjazd_dla_niepelnosprawnych', 'Koszt budowy podjazdu dla niepełnosprawnych', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1669, 8, 'koszty_modernizacja_event_pralnia_ekologiczna', 'Koszt budowy pralni ekologicznej', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1670, 8, 'koszty_modernizacja_event_szkolenie', 'Koszt szkolenia pracowników', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1671, 8, 'koszty_obywatelska_event_festiwal_filmowy', 'Koszt uczestnictwa w festiwalu filmowym', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1672, 8, 'koszty_obywatelska_event_sadzenie_drzew', 'Koszt uczestnictwa w sadzeniu drzew', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1673, 8, 'koszty_obywatelska_event_sadzenie_drzew', 'Sadzenie drzew', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1674, 8, 'koszty_obywatelska_event_zimowisko', 'Koszt dofinansowania zimowiska', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1675, 8, 'koszty_obywatelska_golf', 'Koszt dofinansowania pola golfowego', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1676, 8, 'koszty_obywatelska_wyciag_narciarski', 'Koszt dofinansowania wyciągu narciarskiego', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1677, 8, 'koszty_obywatelska_plaza', 'Koszt dofinansowania plaży', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1678, 8, 'koszty_obywatelska_event_akcja_charytatywna', 'Koszt uczestnictwa w akcji charytatywnej', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1679, 8, 'koszty_obywatelska_event_mikolajkowy_ekspres', 'Koszt uczestnictwa w mikołajkowym ekspresie', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1680, 7, 'wplywy_finansowe_dotacje', 'Dotacje', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1681, 7, 'wyplywy_operacyjne_inwestycje', 'Inwestycje', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1682, 7, 'wyplywy_operacyjne_inne_wydatki', 'Inne wydatki', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1683, 8, 'przychody_nadzwyczajne_sprzedaz_pokoje_standard', 'Przychody ze sprzedaży pokojów standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1684, 8, 'przychody_nadzwyczajne_sprzedaz_wyposazenia_standard', 'Przychody ze sprzedaży wyposażenia standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1685, 7, 'wyplywy_operacyjne_kary_i_odsetki', 'Kary i odsetki', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1686, 8, 'przychody_nadzwyczajne_sprzedaz_pokoje_lux', 'Przychody ze sprzedaży pokojów Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1687, 8, 'koszty_finansowe', 'Koszty finansowe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1688, 8, 'koszty_finansowe_kredyt_obrotowy', 'Koszty z odsetek od kredytu obrotowego', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1689, 8, 'koszty_finansowe_kredyt_inwestycyjny', 'Koszty z odsetek od kredytu inwestycyjnego', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1690, 7, 'wplywy_finansowe', 'Dodatnie przepływy finansowe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1691, 7, 'wplywy_finansowe_kredyt_karny', 'Kredyt karny', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1692, 7, 'wplywy_operacyjne_nadzwyczajne', 'Przychody nadzwyczajne', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1693, 8, 'przychody_nadzwyczajne_sprzedaz_wyposazenia_lux', 'Przychody ze sprzedaży wyposażenia Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1694, 8, 'koszty_finansowe_kredyt_karny', 'Koszty z odsetek od kredytu karnego', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1695, 7, 'wplywy_finansowe_lokata', 'Lokata wypłata', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1696, 8, 'koszty_zatrudnienie', 'Zatrudnienie', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1697, 8, 'koszty_zatrudnienie_pracownicy_obslugi', 'Koszty płac - pracownicy obsługi', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1698, 7, 'wplywy_finansowe_kredyt_obrotowy', 'Kredyt obrotowy', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1699, 7, 'wplywy_finansowe_kredyt_karny', 'Kredyt karny', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1700, 7, 'wplywy_finansowe_kredyt_inwestycyjny', 'Kredyt inwestycyjny', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1701, 8, 'koszty_zatrudnienie_pracownicy_administracji', 'Koszty płac - pracownicy administracji', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1702, 7, 'wyplywy_finansowe', 'Wypływy finansowe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1703, 7, 'wyplywy_finansowe_kredyt_obrotowy', 'Kredyt obrotowy', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1704, 7, 'wyplywy_finansowe_kredyt_inwestycyjny', 'Kredyt inwestycyjny', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1705, 7, 'wyplywy_finansowe_kredyt_karny', 'Spłata kredyt karny', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1706, 7, 'wyplywy_finansowe_lokata', 'Lokata', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1707, 9, 'ekran_glowny_bank', 'Wizyta w banku może okazać się dobrym pomysłem, jeżeli będziesz potrzebował środków na inwestycje.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1708, 9, 'ekran_glowny_ratusz', 'W Ratuszu znajdziesz informacje o inicjatywach podejmowanych przez władze samorządowe. Mogą one mieć istotny wpływ na Twoją działalność.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1709, 9, 'ekran_glowny_agencja', 'Aby pozyskać więcej klientów musisz do nich dotrzeć różnymi metodami. Agencja Reklamy pomoże Ci stworzyć rozpoznawalną markę.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1710, 9, 'ekran_glowny_urzad', 'W przyszłości będziesz musiał zatrudnić większą liczbę osób. Wszelkie informacje na ten temat znajdziesz w tym budynku.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1711, 9, 'ekran_glowny_status_bar', 'W tym miejscu znajdziesz skrót najważniejszych informacji na temat działalności hotelu. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1712, 9, 'ekran_glowny_wiadomosci', 'Twoja skrzynka odbiorcza. To tutaj znajdziesz najnowsze informacje na temat hotelu (np. w wiadomościach od klientów) lub na temat tego co dzieje się w Pekunii (z lokalnej gazety - "Głos Pekunii")', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1713, 9, 'ekran_glowny_log', 'Log. W tym miejscu możesz przejrzeć wszystkie podjęte przez Ciebie decyzje.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1714, 9, 'ekran_glowny_raporty', 'I na koniec jeden z najważniejszych obszarów - raporty. Dzięki analizie informacji zawartych w każdym z raportów będziesz mógł zorientować się czy obrałeś dobrą strategię. Zachęcam do wnikliwego przeglądania danych zawartych w raportach!', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1715, 9, 'tworzenie_marki', 'Twoim pierwszym zadaniem będzie wybór nazwy dla hotelu. Byłoby wspaniale, gdyby nie odstraszała potencjalnych klientów. Proponuję nazwę, która jest łatwa do zapamiętania i pozytywnie się kojarzy. Dzięki temu, zyskasz większą popularność!', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1716, 9, 'zmiana_nazwy_marki', 'Doskonale, brzmi nieźle! Drugim elementem, który buduje tożsamość przedsiębiorstwa, jest logo, czyli znak rozpoznawczy w formie graficznej. Możesz wybrać je spośród przygotowanych wzorów.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1717, 9, 'badanie_marketingowe_popyt_standard', 'Bardzo ważne dla startującego przedsiębiorstwa jest rozpoznanie sytuacji panującej na rynku. Pomogą Ci w tym  badania marketingowe, które będziesz mógł kupić w grze. Warto się z nimi zapoznać ponieważ mogą być pomocne w podejmowaniu właściwych decyzji dotyczących prowadzenia hotelu. Pamiętaj jednak, że analiza marketingowa to jedynie podpowiedź, nigdy nie będzie 100% pewną informacją. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1718, 9, 'badanie_marketingowe_1_tresc', 'Wygląda na to, że wyniki badań są już gotowe! Zapoznaj się z nimi przed podjęciem pierwszych decyzji.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1719, 9, 'po_wyborze_lokalizacji', 'Twój hotel wygląda całkiem znośnie z zewnątrz. Zajrzyjmy do środka, mamy jeszcze kilka spraw do ustalenia w tym kwartale.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1720, 9, 'wybor_lokalizacji', 'Czas na wybór lokalizacji Twojego hotelu. Na szczęście masz już pierwsze informacje z badań marketingowych. Zastanów się, gdzie będziesz miał najbardziej sprzyjające warunki do prowadzenia biznesu, biorąc pod uwagę wyniki badań i strategię jaką chcesz zastosować.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1721, 1, 'Badania marketingowe', 'Badania rynku', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1722, 3, 'badanie_marketingowe_popyt_standard_kupione_info', 'Dowiedz się jak kształtują się ceny w różnych dzielnicach Pekunii. Cena badania: 4 000 PLN.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1723, 3, 'badanie_marketingowe_uslugi_podstawowe_kupione_info', 'Dowiedz się do jak wykorzystać usługi dodatkowe w Twoim hotelu. Cena badania: 4 000 PLN.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1724, 3, 'badanie_marketingowe_sezonowosc_info', 'To badanie pomoże zrozumieć jak pory roku wpływają na Twój biznes. Cena badania: 4 000 PLN.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1725, 3, 'badanie_marketingowe_popyt_lux_info', 'Zobacz jak kształtuje się popyt na pokoje Delux. Cena badania: 4 000 PLN.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1726, 3, 'badanie_marketingowe_reklama_zaawansowana_info', 'Poznaj różnice w efektywności wykorzystywania różnych reklam. Cena badania: 4 000 PLN.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1727, 3, 'badanie_marketingowe_reklama_zaawansowana_info', 'Poznaj różnice w efektywności wykorzystywania różnych reklam. Cena badania: 4 000 PLN.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1728, 3, 'badanie_marketingowe_konkurencja_info', 'Poznaj swoich <s>wrogów</s> konkurentów! Cena badania: 4 000 PLN.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1729, 3, 'badanie_marketingowe_uslugi_zaawansowane_segmentacja_info', 'Dowiedz się o różnych grupach klientów, którzy odwiedzają Twój hotel. Cena badania: 4 000 PLN.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1730, 3, 'badanie_marketingowe_popyt_standard_info', 'Dowiedz się jak kształtuje się popyt w różnych dzielnicach Pekunii. Cena badania: 4 000 PLN. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1731, 3, 'badanie_marketingowe_sezonowosc_kupione_info', 'Pory roku mogą wpływać na Twój biznes - zobacz w jakim stopniu! Cena badania: 4 000 PLN.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1732, 3, 'badanie_marketingowe_konkurencja_kupione_info', 'Poznaj swoich <s>wrogów</s> konkurentów. Cena badania: 4 000 PLN.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1733, 3, 'nazwa_marki_info', 'Wybierz nazwę Twojego hotelu.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1734, 3, 'logo_marki_info', 'Wybierz logo Twojego hotelu.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1735, 1, 'nazwa_marki_help', 'Nazwa hotelu powinna budzić pozytywne skojarzenia - dzięki temu Twoja marka będzie bardziej rozpoznawalna.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1736, 1, 'logo_marki_help', 'Wybierz logo Twojego hotelu.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1737, 4, 'jakosc_jakosc_pokoju_standard', 'Wskaźnik ten wskazuje na poziom atrakcyjności Twojej oferty Standard na rynku. Im bliżej 100 tym Twoja oferta jest bardziej atrakcyjna z punktu widzenia klienta. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1738, 4, 'jakosc_jakosc_pokoju_lux', 'Wskaźnik ten wskazuje na poziom atrakcyjności Twojej oferty Delux na rynku. Im bliżej 100 tym Twoja oferta jest bardziej atrakcyjna z punktu widzenia klienta. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1739, 4, 'zatrudnienie_liczba_zatrudnionych', 'Całkowita liczba pracowników.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1740, 8, 'przychody_finansowe_dotacje', 'Dotacja', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1741, 1, 'Wyposarzenie', 'Wyposażenie', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1742, 10, 'badanie_marketingowe_popyt_standard', 'Badanie marketingowe: popyt Standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1743, 10, 'pokoje_standard', 'Pokój Standard: inwestycje', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1744, 1, 'Wybudowanych w tym kwartale: <b>%pokojeStandard%</b>', 'Pokoje w budowie:<b>%pokojeStandard%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1745, 1, 'Wybudowanych w tym kwartale: <b>%pokojeStandard%</b>', 'Pokoje w budowie: <b>%pokoje Standard%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1746, 1, 'Wybudowanych w tym kwartale: <b>%pokojeLux%</b>', 'Pokoje w budowie:<b>%pokojeLux%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1747, 1, 'Wybudowanych w tym kwartale: <b>%pokojeLux%</b>', 'Pokoje w budowie:<b>%pokojeLux%</b>', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1748, 1, 'Obsługa de lux', 'Obsługa Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1749, 1, 'Obsługa standard', 'Obsługa Standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1750, 1, ' STANDARD', 'Standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1751, 1, ' DELUX', ' Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1752, 3, 'sprzatanie_outsourcing_standard_kwota_koszt_nierozsadny_info', '<span class="red fwb">Wybrana kwota może doprowadzić do bankructwa!</span></br>\r\nPodaj kwartalną kwotę przeznaczoną na sprzątanie. Inne hotele dla Twojej liczby pokoi ustalają kwoty od %min_koszt% do %max_koszt%. Kwartalny koszt wyniesie <b>%koszt%</b>.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1753, 3, 'strona_internetowa_bez_stalego_info', 'Koszt kwartalny utrzymania strony internetowej to: <b>%koszt_kwartalny%</b> ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1754, 3, 'badanie_marketingowe_uslugi_podstawowe_info', 'Wyniki badania pomogą w wyborze odpowiednich usług dla klientów hotelu. Cena badania: 4 000 PLN.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1755, 3, 'badanie_marketingowe_reklama_zaawansowana_kupione_info', 'Dowiedz się jak optymalnie wykorzystać reklamę Twojego hotelu. Cena badania: 4000 zł.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1756, 1, 'Wyposazenie', 'Wyposażenie', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1757, 1, 'pracownicy_obslugi_stale_liczba', 'Liczba pracowników umowa o pracę', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1758, 1, 'pracownicy_obslugi_stale_liczba', 'Liczba pracowników umowa o pracę', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1759, 1, 'pracownicy_obslugi_stale_wynagrodzenie', 'Miesięczna płaca brutto', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1760, 1, 'pracownicy_obslugi_stale_motywacja_procent', 'Premia (w % od płacy)', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1761, 1, 'pracownicy_obslugi_zlecenie_liczba', 'Liczba pracowników umowa cywilno-prawna', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1762, 1, 'pracownicy_obslugi_zlecenie_wynagrodzenie', 'Miesięczna płaca brutto', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1763, 1, 'pracownicy_obslugi_zlecenie_motywacja_procent', 'Premia (w % od płacy)', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1764, 3, 'badanie_marketingowe_popyt_lux_kupione_info', 'To badanie pomoże Ci zrozumieć charakterystykę popytu na pokoje Delux. Cena badania: 4000zł.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1765, 3, 'badanie_marketingowe_uslugi_zaawansowane_segmentacja_kupione_info', 'To badanie pomoże Ci zarówno zrozumieć na czym polega zjawisko segmentacji jak i podjąć decyzję jak powinna wyglądać teraz Twoja strategia. Cena badania: 4000zł.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1766, 1, 'pranie_outsourcing_standard_disabled_info', 'Nie możesz zlecić prania innej firmie, ponieważ masz już wybudowaną pralnię ekologiczną.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1767, 1, 'pranie_outsourcing_lux_disabled_info', 'Nie możesz zlecić prania innej firmie, ponieważ masz już wybudowaną pralnię ekologiczną.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1768, 10, 'event_stop_umowom_smieciowym', 'Stop umowom śmieciowym', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1769, 10, 'pracownicy_obslugi_zlecenie_motywacja_procent', 'Premia pracowników obsługi zatrudnionych na zlecenie', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1770, 10, 'pracownicy_obslugi_zlecenie_wynagrodzenie', 'Wynagrodzenie pracowników obsługi zatrudnionych na zlecenie', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1771, 10, 'pracownicy_obslugi_zlecenie_liczba', 'Liczba zatrudnionych pracowników obsługi na zlecenie', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1);
INSERT INTO `i18n_translations` (`id`, `cat_id`, `source`, `target`, `comments`, `created_at`, `updated_at`, `translated`) VALUES
(1772, 10, 'pracownicy_obslugi_stale_motywacja_procent', 'Premia pracowników zatrudnionych na stałe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1773, 10, 'pracownicy_obslugi_stale_wynagrodzenie', 'Wynagrodzenie pracowników zatrudnionych na stałe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1774, 10, 'pracownicy_obslugi_stale_liczba', 'Liczba pracowników obsługi zatrudnionych na stałe ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1775, 10, 'wybor_lokalizacji', 'Wybór lokalizacji', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1776, 10, 'pracownicy_administracji_zlecenie_wynagrodzenie', 'Wynagrodzenie pracowników administracji zatrudnionych na zlecenie', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1777, 10, 'pracownicy_administracji_stale_wynagrodzenie', 'Wynagrodzenie pracowników administracji zatrudnionych na stałe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1778, 10, 'pracownicy_administracji_zlecenie_motywacja_procent', 'Premia pracowników administracji zatrudnionych na zlecenie', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1779, 10, 'pracownicy_administracji_zlecenie_motywacja_procent', 'Premia pracowników administracji zatrudnionych na zlecenie ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1780, 10, 'pracownicy_administracji_stale_motywacja_procent', 'Premia pracowników administracji zatrudnionych na stałe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1781, 10, 'pracownicy_administracji_zlecenie_liczba', 'Liczba pracowników administracji zatrudnionych na zlecenie ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1782, 10, 'pracownicy_administracji_stale_liczba', 'Liczba pracowników administracji zatrudnionych na stałe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1783, 10, 'event_kierowniczka', 'Oferta usługi kierowniczki', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1784, 10, 'plaza', 'Bezpłatny dojazd na plażę', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1785, 10, 'event_akcja_charytatywna', 'Akcja charytatywna', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1786, 10, 'golf', 'Zniżka na golfa', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1787, 10, 'wyciag_narciarski', 'Zniżka na wyciąg narciarski', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1788, 10, 'event_podjazd_dla_niepelnosprawnych', 'Podjazd dla osób niepełnosprawnych', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1789, 10, 'event_pralnia_ekologiczna', 'Pralnia ekologiczna', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1790, 10, 'event_szkolenie', 'Szkolenie z zarządzania', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1791, 10, 'event_szkolenie', 'Szkolenie z zarządzania', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1792, 10, 'event_mikolajkowy_ekspres', 'Mikołajkowy ekspres', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1793, 1, 'Próbujesz podjać potencialnie głupią decyzję. Czy jesteś tego pewien ?', 'Wybrana decyzja może doprowadzić Twoje przedsiębiorstwo do bankructwa. Czy jesteś pewien swojej decyzji?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1794, 10, 'budzenie', 'Usługa: budzenie', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1795, 10, 'rejestracja_na_stronie_www', 'Usługa: rejestracja online', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1796, 10, 'sniadania_kwota', 'Koszt śniadań', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1797, 10, 'taxi', 'Usługa: taksówki', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1798, 10, 'sejf', 'Usługa: sejf', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1799, 10, 'strona_internetowa', 'Strona internetowa', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1800, 10, 'cena_pokoje_standard', 'Pokój Standard: cena', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1801, 10, 'pokoje_standard_wyposazenie', 'Pokój Standard: wyposażenie', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1802, 10, 'nazwa_marki', 'Wybór nazwy hotelu', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1803, 6, 'Wynik ekonomiczny', 'Wynik ekonomiczny firmy', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1804, 4, 'satysfakcja_satysfakcja_pracownikow', 'Wskaźnik satysfakcji pracowników pokazuje satysfakcję Twoich pracowników z warunków pracy i wynagrodzenia. Im bliżej 100 tym bardziej zadowoleni są Twoi pracownicy.  ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1805, 4, 'marza_marza_standard', 'Zysk, który uzyskujemy z jednego pokoju Standard w kwartale', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1806, 4, 'marza_marza_lux', 'Zysk, który uzyskujemy z jednego pokoju Delux w kwartale', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1807, 4, 'marketing_efektywnosc_marketingu_standard', 'Wartości wskaźnika efektywności marketingu mogą przyjąć wartości od 0 do 100, wskazuje on na  silę oddziaływania Twojej reklamy na potencjalnych klientów pokoi Standard. Im wyższy ten wskaźnik tym efektywniej przyciągasz klientów do swojego hotelu.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1809, 4, 'marketing_efektywnosc_marketingu_lux', 'Wartości wskaźnika efektywności marketingu mogą przyjąć wartości od 0 do 100, wskazuje on na siłę oddziaływania Twojej reklamy na potencjalnych klientów pokoi Delux. Im wyższy ten wskaźnik tym efektywniej przyciągasz klientów do swojego hotelu.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1810, 4, 'satysfakcja_satysfakcja_klientow_standard', 'Wskaźnik satysfakcji Twoich klientów pokoi Standard obrazuje ich zadowolenie z poziomu obsługi w Twoim hotelu. Im wskaźnik bliższy wartości 100 tym bardziej zadowoleni są oni z Twoich usług.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1811, 4, 'satysfakcja_satysfakcja_klientow_lux', 'Wskaźnik satysfakcji Twoich klientów pokoi Delux obrazuje ich zadowolenie z poziomu obsługi w Twoim hotelu. Im wskaźnik bliższy wartości 100 tym bardziej zadowoleni są oni z Twoich usług.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1812, 4, 'zatrudnienie_liczba_zatrudnionych_obsluga', 'Całkowita liczba pracowników obsługi.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1813, 4, 'zatrudnienie_liczba_zatrudnionych_administracja', 'Całkowita liczba pracowników administracji.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1814, 4, 'firma_wartosc_zadluzenia', 'Całkowita suma zadłużenia Twojego przedsiębiorstwa.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1815, 4, 'firma_majatek_firmy', 'Wskazuje całkowitą wartość Twojej firmy.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1816, 4, 'firma_skumulowany_zysk', 'Skumulowany zysk liczony od pierwszego kwartału działania firmy. Zysk ten nie obejmuje dotacji otrzymanych od instytucji rządowych i Unijnych.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1817, 4, 'firma_wartosc_udzialow', 'Cena jednego z 10 000 udziałów firmy.  Wartość udziału jest związana z wartością majątku firmy oraz wysokością zadłużenia.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1818, 1, 'pracownicy_administracji_stale_liczba', 'Liczba pracowników na umowę o pracę', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1819, 1, 'pracownicy_administracji_zlecenie_liczba', 'Liczba pracowników umowa cywilno-prawna', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1820, 1, 'pracownicy_administracji_stale_wynagrodzenie', 'Miesięczna płaca brutto', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1821, 1, 'pracownicy_administracji_zlecenie_wynagrodzenie', 'Miesięczna płaca brutto', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1822, 1, 'pracownicy_administracji_stale_motywacja_procent', 'Premia (w % od płacy)', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1823, 1, 'pracownicy_administracji_zlecenie_motywacja_procent', 'Premia (w % od płacy)', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1824, 3, 'koszt_obslugi_stale_info', 'Płaca minimalna w Pekunii wynosi <b>%placa_minimalna%</b>, pracownicy zatrudnieni na stałe nie mogą być opłacani poniżej tej wartości. \r\nCałkowity koszt wynagrodzeń pracowników obsługi zatrudnionych na stałe wyniesie w tym kwartale <b>%koszt%</b>, ponadto koszty ich dodatków motywacyjnych wyniosą <b>%kosztMotywacji%</b>.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1825, 3, 'koszt_obslugi_zlecenie_nie_ma_pracownikow_info', 'Nie posiadasz zatrudnionych pracowników obsługi na umowę cywilno-prawną.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1826, 3, 'koszt_administracji_stale_info', 'Płaca minimalna w Pekunii wynosi <b>%placa_minimalna%</b>, pracownicy zatrudnieni na stałe nie mogą być opłacani poniżej tej wartości. \r\nCałkowity koszt wynagrodzeń pracowników administracji zatrudnionych na stałe wyniesie w tym kwartale <b>%koszt%</b>, ponadto koszty ich dodatków motywacyjnych wyniosą <b>%kosztMotywacji%</b>.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1827, 3, 'koszt_administracji_stale_info', 'Płaca minimalna w Pekunii wynosi <b>%placa_minimalna%</b>, pracownicy zatrudnieni na stałe nie mogą być opłacani poniżej tej wartości. \r\nCałkowity koszt wynagrodzeń pracowników administracji zatrudnionych na stałe wyniesie w tym kwartale <b>%koszt%</b>, dodatkowo koszty ich dodatków motywacyjnych wyniosą <b>%kosztMotywacji%</b>.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1828, 3, 'koszt_obslugi_zlecenie_info', 'Całkowity koszt wynagrodzeń pracowników obsługi zatrudnionych na umowy cywilno-prawne wyniesie w tym kwartale <b>%koszt%</b>, ponadto koszty ich dodatków motywacyjnych wyniosą <b>%kosztMotywacji%</b>.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1829, 3, 'koszt_obslugi_zlecenie_info', 'Całkowity koszt wynagrodzeń pracowników obsługi zatrudnionych na umowy wyniesie w tym kwartale <b>%koszt%</b>, dodatkowo koszty ich dodatków motywacyjnych wyniosą <b>%kosztMotywacji%</b>.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1830, 3, 'koszt_administracji_zlecenie_nie_ma_pracownikow_info', 'Nie posiadasz zatrudnionych pracowników administracji na umowę cywilno-prawną.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1831, 3, 'koszt_administracji_zlecenie_info', 'Całkowity koszt wynagrodzeń pracowników administracji zatrudnionych na umowy cywilno-prawne wyniesie w tym kwartale <b>%koszt%</b>, ponadto koszty ich dodatków motywacyjnych wyniosą <b>%kosztMotywacji%</b>.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1832, 3, 'koszt_administracji_zlecenie_info', 'Całkowity koszt wynagrodzeń pracowników administracji zatrudnionych na umowy cywilno-prawne wyniesie w tym kwartale <b>%koszt%</b>, dodatkowo koszty ich dodatków motywacyjnych wyniosą <b>%kosztMotywacji%</b>.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1833, 3, 'koszt_administracji_zlecenie_info', 'Całkowity koszt wynagrodzeń pracowników administracji zatrudnionych na umowy cywilno-prawne wyniesie w tym kwartale <b>%koszt%</b>, dodatkowo koszty ich dodatków motywacyjnych wyniosą <b>%kosztMotywacji%</b>.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1834, 1, 'Pracownicy obsługi', 'Pracownicy obsługi', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1835, 4, 'oblozenie_pokoje_oblozone_lux', 'Wskaźnik obłożenia pokoi Delux w ostatnim kwartale.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1836, 10, 'komiks', 'Komiks', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1837, 10, 'sprzatanie_outsourcing_standard_kwota', 'Sprzątanie outsourcing - pokoje Standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1838, 10, 'sprzatanie_outsourcing_standard_kwota', 'Sprzątanie outsourcing - pokoje Standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1839, 10, 'pranie_outsourcing_standard_kwota', 'Pranie outsourcing - pokoje Standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1840, 10, 'event_panele', 'Zakup paneli słonecznych', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1841, 10, 'badanie_marketingowe_uslugi_podstawowe', 'Badanie marketingowe: usługi podstawowe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1842, 10, 'event_festiwal_filmowy', 'Sponsoring Festiwalu Filmowego', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1843, 10, 'media_lokalne_ulotki', 'Kupno pakietu ulotek', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1844, 10, 'media_lokalne_plakaty', 'Kupno pakietu plakatów', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1845, 10, 'badanie_marketingowe_sezonowosc', 'Badanie marketingowe: sezonowość', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1846, 10, 'kredyt_inwestycyjny_kwota', 'Kredyt inwestycyjny', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1847, 10, 'pokoje_lux', 'Pokój Delux: inwestycje', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1848, 10, 'media_regionalne_prasa', 'Media regionalne: prasa', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1849, 10, 'media_regionalne_tv', 'Media regionalne: TV', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1850, 10, 'media_regionalne_radio', 'Media regionalne: radio', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1851, 10, 'media_lokalne_radio', 'Media lokalne: radio', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1852, 10, 'media_lokalne_bilboardy', 'Media lokalne: bilboardy', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1853, 10, 'media_lokalne_prasa', 'Media lokalne: prasa', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1854, 10, 'badanie_marketingowe_popyt_lux', 'Badanie marketingowe: popyt na pokoje Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1855, 10, 'badanie_marketingowe_reklama_zaawansowana', 'Badanie marketingowe: reklama zaawansowana', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1856, 10, 'pranie_outsourcing_lux_kwota', 'Pranie outsourcing - pokoje Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1857, 10, 'pranie_outsourcing_lux_kwota', 'Pranie outsourcing: pokoje Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1858, 10, 'sprzatanie_outsourcing_lux_kwota', 'Sprzątanie outscourcing: pokoje Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1859, 10, 'cena_pokoje_lux', 'Pokój Delux: cena', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1860, 10, 'pokoje_lux_wyposazenie', 'Pokoje Delux: wyposażenie', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1861, 10, 'event_sadzenie_drzew', 'Społeczna Odpowiedzialność Biznesu', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1862, 10, 'badanie_marketingowe_uslugi_zaawansowane_segmentacja', 'Badanie marketingowe: usługi zaawansowane', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1863, 10, 'business_lounge', 'Przestrzeń biurowa', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1864, 10, 'automaty_vendingowe', 'Automaty vendingowe', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1865, 10, 'ekspresy_czajniki', 'Dodatkowe wyposażenie pokoi', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1866, 10, 'mozliwosc_odebrania_gosci', 'Odbiór z lotniska', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1867, 10, 'ochronka_dla_dzieci', 'Opieka nad dziećmi', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1868, 10, 'sala_konferencyjna', 'Sala konferencyjna', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1869, 10, 'pokoj_zabaw_dla_dzieci', 'Pokój dla dzieci', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1870, 10, 'wspolpraca_urzad_pracy', 'Współpraca: urząd miasta', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1871, 10, 'wspolpraca_biurami_podrozy', 'Współpraca: biura podróży', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1872, 10, 'media_krajowe_tv', 'Media krajowe: TV', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1873, 10, 'media_krajowe_prasa', 'Media krajowe: prasa', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1874, 10, 'media_krajowe_radio', 'Media krajowe: radio', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1875, 10, 'badanie_marketingowe_konkurencja', 'Badanie marketingowe: konkurencja', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1876, 3, 'koszt_obslugi_stale_nie_ma_pracownikow_info', 'Nie posiadasz zatrudnionych pracowników obsługi na umowę o pracę.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1877, 3, 'koszt_obslugi_stale_ustal_wynagrodzenie_info', 'Zatrudniłeś pracowników obsługi na umowę o pracę, teraz ustal ich miesięczne wynagrodzenie.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1878, 3, 'koszt_obslugi_zlecenie_ustal_wynagrodzenie_info', 'Zatrudniłeś pracowników obsługi na umowę cywilno-prawną, teraz ustal ich miesięczne wynagrodzenie.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1879, 3, 'sprzatanie_outsourcing_lux_kwota_disabled_info', 'Posiadasz zatrudnionych pracowników obsługi.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1880, 3, 'sprzatanie_outsourcing_standard_kwota_disabled_info', 'Posiadasz zatrudnionych pracowników obsługi.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1881, 3, 'koszt_administracji_stale_nie_ma_pracownikow_info', 'Nie posiadasz zatrudnionych pracowników administracji na umowę o pracę.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1882, 3, 'koszt_administracji_stale_ustal_wynagrodzenie_info', 'Zatrudniłeś pracowników administracji na umowę o pracę, teraz ustal ich miesięczne wynagrodzenie.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1883, 3, 'koszt_administracji_zlecenie_ustal_wynagrodzenie_info', 'Zatrudniłeś pracowników administracji na umowę cywilno-prawną, teraz ustal ich miesięczne wynagrodzenie.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1884, 3, 'pranie_outsourcing_standard_kwota_disabled_info', 'Posiadasz pralnię ekologiczną.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1885, 3, 'pranie_outsourcing_lux_kwota_disabled_info', 'Posiadasz pralnię ekologiczną.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1886, 10, 'event_zimowisko', 'Zimowisko dla dzieci', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1887, 9, 'adviser_runda_14_1', 'Od tego kwartału na rynku hotelarskim, a zwłaszcza wśród Twoich klientów, możemy wyróżnić jednorodne grupy. To zjawisko nazywamy segmentacją rynku. Grupy te posiadają podobne potrzeby lub preferencje konsumenckie. Przemyśl jakie usługi zaawansowane możesz zaoferować, aby dotrzeć do konkretnej grupy. ', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1888, 9, 'adviser_runda_9_1', 'Od tego roku pojawia się możliwość zatrudniania własnych pracowników. Informacje na temat rodzajów zatrudnienia oraz stawek płac znajdziesz w Urzędzie Pracy. Nowi pracownicy zastąpią firmy podwykonawcze, które zajmowały się sprzątaniem pokoi hotelowych.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1889, 9, 'adviser_runda_8_1', 'Zastanawiałeś się jak wypadasz na tle znajomych z klasy? Teraz możesz to sprawdzić. Od tej rundy będziemy oceniać Twoje działania! Zestawimy je z wynikami wszystkich grup w Twojej klasie, dzięki czemu będziesz mógł porównać wyniki i przekonasz się czy obrałeś dobrą strategię. Powodzenia. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1890, 9, 'adviser_runda_5_3', 'W grze została uruchomiona sezonowość. Czym jest i jak wpływa na\r\nhotelarski rynek Pekunii, zostało opisane w odpowiednim badaniu marketingowym.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1891, 9, 'adviser_runda_5_2', 'Jeśli możesz już budować pokoje Delux, to najwyższy czas abyś skorzystał z jednej z podstawowych funkcji banku, który pojawił się właśnie w Pekunii. Bank Pewniak dostarcza trzy usługi na lokalny rynek finansowy: udziela kredytu obrotowego i inwestycyjnego oraz przyjmuje depozyty w postaci lokat kwartalnych - odnawiających się automatycznie.\r\n\r\n', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1892, 9, 'adviser_runda_5_1', 'Witaj ponownie! W tej rundzie czeka Cię sporo nowości. Przede wszystkim musisz\r\nwiedzieć, że od teraz możesz budować pokoje Delux.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1893, 9, 'adviser_runda_4_2', 'Przeglądałeś już raporty dotyczące działalności hotelu? Zaraz minie pierwszy rok od otwarcia. Sprawdź jak Ci poszło i przemyśl co można poprawić, aby było lepiej!', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1894, 9, 'adviser_runda_4_1', 'Pojawiła się nowa forma promocji Twojego hotelu. Dzięki produkcji plakatów i ulotek zapewnisz reklamę hotelu na skalę lokalną.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1895, 9, 'adviser_runda_4_3', 'Jak widać - zarządzanie hotelem to szereg decyzji związanych z różnymi aspektami działalności gospodarczej. Zapoznaj się z zawartością wszystkich nowych elementów. Wraz z rozwojem hotelu będę aktywował kolejne obszary decyzyjne.', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1896, 9, 'adviser_runda_2_1', 'Witaj w drugim kwartale. Jeżeli masz już pierwsze pokoje, to należy zadbać o ich odpowiednie przygotowanie. Przejdźmy do panelu hotelu.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1897, 9, 'adviser_runda_2_2', 'Jak widać - zarządzanie hotelem to szereg decyzji związanych z różnymi aspektami działalności gospodarczej. Zapoznaj się z zawartością wszystkich nowych elementów. Wraz z rozwojem hotelu będę aktywował kolejne obszary decyzyjne. ', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1898, 9, 'adviser_runda_2_3', '„Głos Pekunii” zawiera najświeższe informacje na temat miasta, jego mieszkańców oraz wydarzeń kulturalnych i sportowych. Niektóre z tych informacji będą miały wpływ na Twój hotel, więc czytaj je uważnie!', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1899, 9, 'ekran_glowny_hotel_2', 'W tym miejscu możesz zarządzać hotelem. Pierwsza decyzja będzie dotyczyła budowy nowych pokoi hotelowych.  Pamiętaj, że w pierwszym roku otrzymujesz dofinansowanie z Unii Europejskiej. Pierwsza transza dofinansowania jest już na Twoim koncie. To właśnie z niej możesz sfinansować budowę pierwszych pokoi. Aby rozpocząć budowę kliknij ikonę Inwestycje.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1900, 9, 'pokoje_standard_hotel', 'Zapoznaj się z opisem decyzji dotyczącej liczby pokoi. Pod ikoną znaku zapytania znajdziesz dodatkowe informacje na temat danego obszaru decyzyjnego. Pamiętaj, że budowa pokoi zajmuje trochę czasu, dlatego będą one otwarte dopiero w przyszłym kwartale.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1901, 9, 'pokoje_standard_hotel_zapisz', 'Po wyborze liczby pokoi, swoją decyzję zatwierdzasz poprzez kliknięcie guzika ZAPISZ. Identycznie wygląda to przy pozostałych decyzjach, które będziesz podejmował.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1902, 9, 'po_decyzji_ilosci_pokoju', 'Gratuluję pierwszej poważnej decyzji! Przyjrzyjmy się teraz ekranowi głównemu, który jest Twoim centrum dowodzenia. Wraz z rozwojem hotelu i sytuacji w mieście, pojawiać się będą nowe możliwości, a o każdej z nich poinformuję Cię w swoim czasie. Teraz przypatrzmy się głównym elementom interfejsu.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1903, 9, 'ekran_glowny_gotowka', 'do wyrzucenia CAŁOŚĆ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1904, 9, 'ekran_glowny_koniec', 'Gratulacje. To chyba wszystko na dzisiaj. Do zobaczenia w następnym kwartale!', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1905, 1, 'usluga_wyciag_narciarski', 'Zniżka na karnety na wyciąg narciarski dla gości hotelu', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1906, 1, 'usluga_wyciag_narciarski_help', 'Czy chcesz zaoferować klientom 50% zniżkę na wyciąg narciarski? Pamiętaj, że koszt tej usługi jest niższy dla przedsiębiorców, którzy współfinansowali budowę wyciągu narciarskiego (decyzję o udziale w inwestycji możesz podjąć w Ratuszu wyłącznie w rundzie 6).', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1907, 3, 'usluga_wyciag_narciarski_info', 'Usługa na pewno spodoba się amatorom białego szaleństwa! Koszt usługi będzie pobierany tylko w sezonie wiosna, lato i jesień. W bieżącym sezonie wyniesie %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1908, 3, 'usluga_wyciag_narciarski_info', 'Fanatycy białego szaleństwa na pewno skuszą się na taką zniżkę!', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1909, 1, 'usluga_plaza', 'Zniżki na bilety Kolejki Plażowej dla gości hotelu', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1910, 1, 'usluga_plaza_help', 'Czy chcesz zaoferować klientom 50% zniżkę na karnet na kolejkę plażową? Pamiętaj, że koszt tej usługi jest niższy dla przedsiębiorców, którzy współfinansowali budowę kolejki plażowej (decyzję o udziale w inwestycji możesz podjąć w Ratuszu wyłącznie w rundzie 7). ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1911, 3, 'usluga_plaza_info', 'Latem każdy chciałby schłodzić się w czystej wodzie Zalewu Pekuńskiego! Koszt usługi będzie pobierany tylko w sezonie lato i jesień. W bieżącym sezonie wyniesie %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1912, 1, 'usluga_golf', 'Zniżka na korzystanie z pola golfowego', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1913, 1, 'usluga_golf_help', 'Czy chcesz zaoferować klientom 50% zniżkę na karnet na pole golfowe? Pamiętaj, że koszt tej usługi jest niższy dla przedsiębiorców, którzy współfinansowali budowę pola golfowego (decyzję o udziale w inwestycji możesz podjąć w Ratuszu wyłącznie w rundzie 8).', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1914, 3, 'usluga_golf_info', 'Bo nie ma złej pogody do gry w golfa, są tylko źle ubrani golfiści! Koszt usługi będzie pobierany tylko w sezonie jesień i zima. W bieżącym sezonie wyniesie %koszt%.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1915, 3, 'event_kierowniczka_info', 'Wersja 1: przeprowadzenie szkolenia motywacyjnego na poziomie podstawowym.<br>\r\nWersja 2: przeprowadzenie szkolenia motywacyjnego na poziomie zaawansowanym oraz restrukturyzacja systemu zatrudnienia.\r\n', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1916, 9, 'ekran_glowny_hotel', 'To miejsce już poznałeś podejmując pierwszą decyzję o budowie nowych pokoi hotelowych.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1917, 1, 'wybor_loga', 'Wybór loga', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1918, 1, 'wybor_loga_help', 'Wybierz Twoje logo', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1919, 10, 'wybor_loga', 'Wybór loga', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1920, 3, 'brak_mozliwosci_sprzedazy_info', 'Nie możesz sprzedać takiej ilości pokoi.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1921, 7, 'wyplywy_operacyjne_odsetki', 'Odsetki', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1922, 7, 'wyplywy_finansowe_kara', 'Kara / Wydatki nadzwyczajne', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1923, 8, 'koszty_finansowe_kara', 'Kara / Wydatki nadzwyczajne', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1924, 8, 'przychody_finansowe_doplata', 'Dopłata', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1925, 7, 'wplywy_finansowe_doplata', 'Dopłata', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1926, 10, 'kredyt_obrotowy_kwota', 'Kwota kredytu obrotowego', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1927, 10, 'usluga_golf', 'Golf', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1928, 10, 'usluga_plaza', 'Plaża', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1929, 1, 'usluga_wyciag_narciarski', 'Wyciąg narciarski', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1930, 3, 'wybor_loga_info', 'Możesz wybrać własne logo. Pamiętaj, że musi być to plik graficzny (.png, .jpg, .gif, .bmp). Najlepiej będzie wyglądało logo w rozmiarze 150x150px.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1931, 5, 'konkurencja', 'Konkurencja', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1932, 5, 'konkurencja_standard', 'Konkurencja Standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1933, 5, 'konkurencja_lux', 'Konkurencja Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1934, 5, 'konkurencja_standard_ty', 'Twój popyt standard', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1935, 5, 'konkurencja_standard_p1', 'Konkurent bezpośredni', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1936, 5, 'konkurencja_standard_p2', 'Konkurent pośredni 1', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1937, 5, 'konkurencja_standard_p3', 'Konkurent pośredni 2', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1938, 5, 'konkurencja_lux_ty', 'Twój popyt Delux', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1939, 5, 'konkurencja_lux_p1', 'Konkurent bezpośredni', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1940, 5, 'konkurencja_lux_p2', 'Konkurent pośredni 1', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1941, 5, 'konkurencja_lux_p3', 'Konkurent pośredni 2', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1942, 1, 'ankieta_przed_1', 'Co sądzisz o założeniu własnej firmy w przyszłości?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1943, 1, 'ankieta_przed_2', 'Czy uważasz, że rola przedsiębiorcy jest:', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1944, 1, 'ankieta_przed_3', 'Twoim zdaniem możliwość pracy w małym przedsiębiorstwie:', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1945, 1, 'ankieta_przed_4', 'Z regułami rynkowymi nie da się wygrać:', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1946, 1, 'ankieta_przed_5', 'Wiedzę ekonomiczną uważam za:', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1947, 1, 'ankieta_przed_6', 'Uważam, że kariera zawodowa jako właściciel własnej firmy:', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1948, 1, 'ankieta_przed_7', 'Uważam, że praca w czyjejś firmie:', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1949, 1, 'ankieta_przed_8', 'Określ w jakim stopniu Twoja przyszłość zależy od Ciebie:', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1950, 1, 'ankieta_przed_9', 'Czy uważasz, że posiadasz wystarczającą wiedzę pozwalającą na założenie i prowadzenie własnej firmy?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1951, 1, 'ankieta_przed_10', 'Czy uważasz, że wiesz na czym polega prowadzenie własnej firmy?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1952, 1, 'ankieta_przed_11', 'Czy sądzisz, że rola przedsiębiorcy jest niedoceniania w społeczeństwie?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1953, 1, 'ankieta_przed_12', 'Czy sądzisz, że branie kredytów to dobry pomysł?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1954, 1, 'ankieta_przed_13', 'Twoim zdaniem, firmy na rynku powinny zachowywać się:', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1955, 3, 'ankieta_przed_1_info', '<b>1</b> - Kiepski pomysł | <b>4</b> - Nie mam zadania | <b>7</b> - Świetny pomysł', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1957, 3, 'ankieta_przed_2_info', '<b>1</b> - Bardzo łatwa | <b>4</b> - Nie mam zdania | <b>7</b> - Bardzo trudna', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1958, 3, 'ankieta_przed_3_info', '<b>1</b> - Jest mało atrakcyjna | <b>4</b> - Nie mam zdania | <b>7</b> - Jest bardzo atrakcyjna', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1959, 3, 'ankieta_przed_4_info', '<b>1</b> - Zdecydowanie się nie zgadzam | <b>4</b> - Nie mam zdania | <b>7</b> - Zdecydowanie się zgadzam', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1960, 3, 'ankieta_przed_5_info', '<b>1</b> - Całkowicie nieprzydatną | <b>4</b> - Nie mam zdania | <b>7</b> - Bardzo przydatną', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1961, 3, 'ankieta_przed_6_info', '<b>1</b> - Nie jest dla mnie | <b>4</b> - Nie mam zdania | <b>7</b> - Bardzo mi odpowiada', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1962, 3, 'ankieta_przed_7_info', '<b>1</b> - Nie jest dla mnie | <b>4</b> - Nie mam zdania | <b>7</b> - Bardzo mi odpowiada', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1963, 3, 'ankieta_przed_8_info', '<b>1</b> - Nie mam nad nią kontroli | <b>4</b> - Nie mam zdania | <b>7</b> - W całości zależy ode mnie', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1964, 3, 'ankieta_przed_9_info', '<b>1</b> - Zdecydowanie nie | <b>4</b> - Nie mam zdania | <b>7</b> - Zdecydowanie tak', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1965, 3, 'ankieta_przed_10_info', '<b>1</b> - Zdecydowanie nie | <b>4</b> - Nie mam zdania | <b>7</b> - Zdecydowanie tak', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1966, 3, 'ankieta_przed_11_info', '<b>1</b> - Zdecydowanie nie | <b>4</b> - Nie mam zdania | <b>7</b> - Zdecydowanie tak', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1967, 3, 'ankieta_przed_12_info', '<b>1</b> - Zdecydowanie nie | <b>4</b> - Nie mam zdania | <b>7</b> - Zdecydowanie tak', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1968, 3, 'ankieta_przed_13_info', '<b>1</b> - Bardzo agresywnie i aktywnie | <b>4</b> - Nie mam zdania | <b>7</b> - Bardzo ostrożnie i pasywnie', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1969, 1, 'ankieta_po_1', 'Co sądzisz o założeniu własnej firmy w przyszłości?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1970, 1, 'ankieta_po_2', 'Rola przedsiębiorcy jest:', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1971, 1, 'ankieta_po_3', 'Możliwość pracy w małym przedsiębiorstwie:', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1972, 1, 'ankieta_po_4', 'Z regułami rynkowymi nie da się wygrać:', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1973, 1, 'ankieta_po_5', 'Wiedzę ekonomiczną uważam za:', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1974, 1, 'ankieta_po_6', 'Uważam, że kariera zawodowa jako właściciel własnej firmy:', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1975, 1, 'ankieta_po_7', 'Uważam, że praca w czyjejś firmie:', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1976, 1, 'ankieta_po_8', 'Określ w jakim stopniu Twoja przyszłość zależy od Ciebie:', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1977, 1, 'ankieta_po_9', 'Czy uważasz, że posiadasz wystarczającą wiedzę pozwalającą na założenie i prowadzenie własnej firmy?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1978, 1, 'ankieta_po_10', 'Czy uważasz, że wiesz na czym polega prowadzenie własnej firmy?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1979, 1, 'ankieta_po_11', 'Czy sądzisz, że rola przedsiębiorcy jest niedoceniania w społeczeństwie?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1980, 1, 'ankieta_po_12', 'Czy sądzisz, że branie kredytów to dobry pomysł?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1981, 1, 'ankieta_po_13', 'Twoim zdaniem, firmy na rynku powinny zachowywać się:', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1982, 1, 'ankieta_po_14', 'Czy byłbyś zainteresowany dalszym pogłębianie wiedzy ekonomicznej?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1983, 1, 'ankieta_po_15', 'Jak oceniasz ten program nauczania na tle innych zrealizowanych zajęć w szkole?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1984, 1, 'ankieta_po_16', 'Jak oceniasz wykorzystanie gry symulacyjnej do realizacji tego przedmiotu?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1985, 1, 'ankieta_po_17', 'Czy kontynuowałbyś naukę dotyczącą przedsiębiorczości, jeśli miałbyś taką możliwość?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1986, 1, 'ankieta_po_18', 'Czy w przyszłości, samodzielnie będziesz poszerzał swoją wiedzę na temat rynku?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1987, 1, 'ankieta_po_19', 'Czy podobała Ci się taka forma przekazywania wiedzy na temat przedsiębiorczości?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1988, 1, 'ankieta_po_20', 'Czy zarekomendowałbyś te zajęcia swoim  kolegom/koleżankom?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1989, 1, 'ankieta_po_21', 'Czy taka forma według Ciebie jest ciekawsza od standardowych zajęć?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1990, 1, 'ankieta_po_22', 'Czy uważasz, że zastosowanie gry symulacyjnej w tym przedmiocie pomogło w nauce?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1991, 3, 'ankieta_po_1_info', '<b>1</b> - Kiepski pomysł | <b>4</b> - Nie mam zdania | <b>7</b> - Świetny pomysł', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1992, 3, 'ankieta_po_2_info', '<b>1</b> - Bardzo łatwa | <b>4</b> - Nie mam zdania | <b>7</b> - Bardzo trudna', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1993, 3, 'ankieta_po_3_info', '<b>1</b> - Jest mało atrakcyjna | <b>4</b> - Nie mam zdania | <b>7</b> - Jest bardzo atrakcyjna', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1994, 3, 'ankieta_po_4_info', '<b>1</b> - Zdecydowanie się nie zgadzam | <b>4</b> - Nie mam zdania | <b>7</b> - Zdecydowanie się zgadzam', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1995, 3, 'ankieta_po_5_info', '<b>1</b> - Całkowicie nieprzydatną | <b>4</b> - Nie mam zdania | <b>7</b> - Bardzo przydatną', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1996, 3, 'ankieta_po_6_info', '<b>1</b> - Nie jest dla mnie | <b>4</b> - Nie mam zdania | <b>7</b> - Bardzo mi odpowiada', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1997, 3, 'ankieta_po_7_info', '<b>1</b> - Nie jest dla mnie | <b>4</b> - Nie mam zdania | <b>7</b> - Bardzo mi odpowiada', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1998, 3, 'ankieta_po_8_info', '<b>1</b> - Całkowicie nie mam nad nią kontroli | <b>4</b> - Nie mam zdania | <b>7</b> - W całości zależy ode mnie', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(1999, 3, 'ankieta_po_9_info', '<b>1</b> - Zdecydowanie nie | <b>4</b> - Nie mam zdania | <b>7</b> - Zdecydowanie tak', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2000, 3, 'ankieta_po_10_info', '<b>1</b> - Zdecydowanie nie | <b>4</b> - Nie mam zdania | <b>7</b> - Zdecydowanie tak', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2001, 3, 'ankieta_po_11_info', '<b>1</b> - Zdecydowanie nie | <b>4</b> - Nie mam zdania | <b>7</b> - Zdecydowanie tak', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2002, 3, 'ankieta_po_12_info', '<b>1</b> - Zdecydowanie nie | <b>4</b> - Nie mam zdania | <b>7</b> - Zdecydowanie tak', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2003, 3, 'ankieta_po_13_info', '<b>1</b> - Bardzo agresywnie i aktywnie | <b>4</b> - Nie mam zdania | <b>7</b> - Bardzo ostrożnie i pasywnie', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2004, 3, 'ankieta_po_14_info', '<b>1</b> - Zdecydowanie nie | <b>4</b> - Nie mam zdania | <b>7</b> - Zdecydowanie tak', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2005, 3, 'ankieta_po_15_info', '<b>1</b> - Zdecydowanie źle | <b>4</b> - Nie mam zdania | <b>7</b> - Zdecydowanie dobrze', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2006, 3, 'ankieta_po_16_info', '<b>1</b> - Zdecydowanie źle | <b>4</b> - Nie mam zdania | <b>7</b> - Zdecydowanie dobrze', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2007, 3, 'ankieta_po_17_info', '<b>1</b> - Zdecydowanie nie | <b>4</b> - Nie mam zdania | <b>7</b> - Zdecydowanie tak', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2008, 3, 'ankieta_po_18_info', '<b>1</b> - Zdecydowanie nie | <b>4</b> - Nie mam zdania | <b>7</b> - Zdecydowanie tak', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2009, 3, 'ankieta_po_19_info', '<b>1</b> - Zdecydowanie nie | <b>4</b> - Nie mam zdania | <b>7</b> - Zdecydowanie tak', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2010, 3, 'ankieta_po_20_info', '<b>1</b> - Zdecydowanie nie | <b>4</b> - Nie mam zdania | <b>7</b> - Zdecydowanie tak', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2011, 3, 'ankieta_po_21_info', '<b>1</b> - Zdecydowanie nie | <b>4</b> - Nie mam zdania | <b>7</b> - Zdecydowanie tak', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2012, 3, 'ankieta_po_22_info', '<b>1</b> - Zdecydowanie nie | <b>4</b> - Nie mam zdania | <b>7</b> - Zdecydowanie tak', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2013, 1, 'test_po_1', 'Wymień zasady planowania.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2014, 1, 'test_po_2', 'Wymień jak najwięcej czynników wpływających na popyt na usługi hotelarskie.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2015, 1, 'test_po_3', 'Czy przedsiębiorstwo może zbankrutować pomimo pozytywnego wyniku finansowego? Odpowiedź uzasadnij. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2016, 1, 'test_po_4', 'Wymień rodzaje kredytów udzielanych przedsiębiorcom.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2017, 1, 'test_po_5', 'Jakie znasz formy zatrudnienia?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2018, 1, 'test_po_6', 'Wymień zalety umowy o pracę (z punktu widzenia pracownika). ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2019, 1, 'test_po_7', 'Co poza płacą brutto stanowi koszt wynagrodzenia po stronie pracodawcy?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2020, 1, 'test_po_8', 'Wymień jak najwięcej sposobów motywowania pracowników. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2021, 1, 'test_po_9', 'Czym mogą konkurować firmy?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2022, 1, 'test_po_10', 'Opisz na czym polega konkurencja marketingowa. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2023, 1, 'test_po_11', 'Wymień co najmniej 2 kryteria segmentacji rynku.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2024, 1, 'event_zmienne', 'Czym są koszty zmienne?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2025, 1, 'event_odsetkik', 'Co poza odsetkami stanowi koszt kredytu?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2026, 1, 'event_kredytowa', 'Co to jest zdolność kredytowa?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2027, 1, 'event_usługi', 'Jakie usługi świadczy bank?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2028, 1, 'event_strategia', 'Strategię firmy możemy określić jako:', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2029, 3, 'event_zmienne_info', '<b>A</b> - Koszty, które są niezależne od wielkości sprzedaży.<br /> \r\n<b>B</b> - Koszty, które są proporcionalne o wielkości przedsiębiorstwa/hotelu. <br /> \r\n<b>C</b> - Koszty proądu i administracji. <br /> \r\n<b>D</b> - Wszystkie odpowiedzi są poprawne. <br /> ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2030, 3, 'event_odsetkik_info', '<b>A</b> - Opłaty administracyjne nadzoru finansowego.<br /> \r\n<b>B</b> - Ubezpieczanie kredytu i prowizja banku. <br /> \r\n<b>C</b> - Koszty wpisu do rejestru dłużników.<br /> \r\n<b>D</b> - Żadne z powyższych. <br /> ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2031, 3, 'event_kredytowa_info', '<b>A</b> - Umiejętność udzielania przez firmę kredytów innym podmiotom.<br /> \r\n<b>B</b> - Limit zadłużenia firmy wyliczany na podstawie wartości i wyników firmy. <br /> \r\n<b>C</b> - Średni czas obrotu zobowiązań firmy.<br /> \r\n<b>D</b> - Żadne z powyższych. <br /> ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2032, 3, 'event_usługi_info', '<b>A</b> - Udzielania kredytów i pożyczek, przyjmowania lokat, obrotu należnościami i zobowiązaniami.<br /> \r\n<b>B</b> - Udzielania kredytów i pożyczek, przyjmowania lokat, obrotu należnościami i zobowiązaniami oraz ubezpieczeniami majątkowymi i osobistymi. <br /> \r\n<b>C</b> - Udzielania kredytów i pożyczek, przyjmowania lokat, obrotu należnościami i zobowiązaniami oraz prowadzeniem funduszy emerytalnych.<br /> \r\n<b>D</b> - Wszystkie powyższe są prawdziwe. <br /> ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2033, 3, 'event_strategia_info', '<b>A</b> - Bieżące decyzje dotyczące cen i jakości oferty.<br /> \r\n<b>B</b> - Decyzje o wydatkach na reklamę.<br /> \r\n<b>C</b> - Decyzje o kupnie pokoi.<br /> \r\n<b>D</b> - Długofalowy plan rozwoju firmy. <br /> \r\n<b>E</b> - Wszystkie powyższe są prawdziwe. <br /> ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2034, 3, 'test_po_1_info', ' ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2035, 3, 'test_po_2_info', '  ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2036, 3, 'test_po_3_info', ' ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2037, 3, 'test_po_5_info', ' ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2038, 3, 'test_po_6_info', ' ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2039, 3, 'test_po_7_info', ' ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2040, 3, 'test_po_8_info', ' ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2041, 3, 'test_po_9_info', ' ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2042, 3, 'test_po_10_info', ' ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2043, 3, 'test_po_11_info', ' ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2044, 3, 'test_po_1_info', '  ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2045, 3, 'event_wahania_info', '<b>A</b> - Pogoda.<br /> \r\n<b>B</b> - Pory roku.<br /> \r\n<b>C</b> - Lokalizacja biznesu.<br /> \r\n<b>D</b> - Uwarunkowania czynników społeczno-kulturowych np. wydarzenia religijne, sportowe lub kulturalne. <br /> \r\n<b>E</b> - Wszystkie powyższe są prawdziwe. <br /> ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2046, 3, 'event_koszty_info', '<b>A</b> - Koszty, które są niezależne od wielkości sprzedaży.<br /> \r\n<b>B</b> - Koszty, które są proporcionalne do wielkości przedsiębiorstwa/hotelu. <br /> \r\n<b>C</b> - Koszty prądu i administracji.<br /> \r\n<b>D</b> - Wszystkie odpowiedzi są poprawne. <br /> ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2047, 3, 'event_odsetki_info', '<b>A</b> - Opłaty administracyjne nadzoru finansowego.<br /> \r\n<b>B</b> - Ubezpieczanie kredytu i prowizja banku.<br /> \r\n<b>C</b> - Koszty wpisu do rejestru dłużników.<br /> \r\n<b>D</b> - Żadne z powyższych. <br /> ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2048, 3, 'event_kredyt_info', '<b>A</b> - Umiejętność udzielania przez firmę kredytów innym podmiotom.<br /> \r\n<b>B</b> - Limit zadłużenia firmy wyliczany na podstawie wartości i wyników firmy.<br /> \r\n<b>C</b> - Średni czas obrotu zobowiązań firmy.<br /> \r\n<b>D</b> - Żadne z powyższych. <br /> ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2049, 3, 'event_bank_info', '<b>A</b> - Udzielania kredytów i pożyczek, przyjmowania lokat, obrotu należnościami i zobowiązaniami.<br /> \r\n<b>B</b> - Udzielania kredytów i pożyczek, przyjmowania lokat, obrotu należnościami i zobowiązaniami oraz ubezpieczeniami majątkowymi i osobistymi.<br /> \r\n<b>C</b> - Udzielania kredytów i pożyczek, przyjmowania lokat, obrotu należnościami i zobowiązaniami oraz prowadzeniem funduszy emerytalnych.<br /> \r\n<b>D</b> - Wszystkie powyższe są prawdziwe. <br /> ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2050, 1, 'test_przed_1', 'Wymień zasady planowania.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2051, 1, 'test_przed_2', 'Wymieńcie jak najwięcej czynników wpływających na popyt na usługi hotelarskie.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2052, 1, 'test_przed_3', 'Czy przedsiębiorstwo może zbankrutować pomimo pozytywnego wyniku finansowego? Odpowiedź uzasadnij. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2053, 1, 'test_przed_4', 'Wymień rodzaje kredytów udzielanych przedsiębiorcom. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2054, 1, 'test_przed_5', 'Jakie znasz formy zatrudnienia?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2055, 1, 'test_przed_6', 'Wymień zalety umowy o pracę (z punktu widzenia pracownika).', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2056, 1, 'test_przed_7', 'Co poza płacą brutto stanowi koszt wynagrodzenia po stronie pracodawcy?  ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2057, 1, 'test_przed_8', 'Wymień jak najwięcej sposobów motywowania pracowników. ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2058, 1, 'test_przed_9', 'Czym mogą konkurować firmy?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2059, 1, 'test_przed_10', 'Opisz na czym polega konkurencja marketingowa.', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2060, 1, 'test_przed_11', 'Czym jest segmentacja? ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2061, 3, 'test_przed_1_info', ' ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2062, 3, 'test_przed_2_info', ' ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1);
INSERT INTO `i18n_translations` (`id`, `cat_id`, `source`, `target`, `comments`, `created_at`, `updated_at`, `translated`) VALUES
(2063, 3, 'test_przed_3_info', ' ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2064, 3, 'test_przed_4_info', ' ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2065, 3, 'test_przed_5_info', ' ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2066, 3, 'test_przed_6_info', ' ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2067, 3, 'test_przed_7_info', ' ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2068, 3, 'test_przed_8_info', ' ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2069, 3, 'test_przed_9_info', ' ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2070, 3, 'test_przed_10_info', ' ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2071, 3, 'test_przed_11_info', ' ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2072, 1, 'event_wahania', 'Co wpływa na sezonowe wahania popytu?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2073, 1, 'event_koszty', 'Czym są koszty stałe?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2074, 1, 'event_odsetki', 'Co poza odsetkami stanowi koszt kredytu?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2075, 1, 'event_kredyt', 'Co to jest zdolność kredytowa?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2076, 1, 'event_bank', '9. Jakie usługi świadczy bank?', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2077, 3, 'ankieta_przed_1_info', '<b>1</b> - Kiepski pomysł | <b>4</b> - Nie mam zadania | <b>7</b> - Świetny pomysł', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1),
(2078, 3, 'test_po_4_info', ' ', '', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 1);

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `internal_category`
--

CREATE TABLE IF NOT EXISTS `internal_category` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `name` varchar(45) NOT NULL,
  `order` tinyint(4) DEFAULT '1',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_internal_category_sf_guard_user1_idx` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Zrzut danych tabeli `internal_category`
--

INSERT INTO `internal_category` (`id`, `user_id`, `name`, `order`, `created_at`, `updated_at`) VALUES
(1, NULL, 'Inbox', 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(2, NULL, 'Outbox', 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(3, NULL, 'Trash', 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(4, NULL, 'Archive', 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `internal_conversation`
--

CREATE TABLE IF NOT EXISTS `internal_conversation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `internal_message`
--

CREATE TABLE IF NOT EXISTS `internal_message` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `internal_conversation_id` int(11) DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `receiver_id` bigint(20) DEFAULT NULL,
  `is_readed` tinyint(4) DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `description` mediumtext,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_internal_message_sf_guard_user1_idx` (`author_id`),
  KEY `fk_internal_message_sf_guard_user2_idx` (`receiver_id`),
  KEY `fk_internal_message_internal_conversation1_idx` (`internal_conversation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `internal_message_category`
--

CREATE TABLE IF NOT EXISTS `internal_message_category` (
  `internal_message_id` bigint(20) NOT NULL DEFAULT '0',
  `internal_category_id` bigint(20) NOT NULL DEFAULT '0',
  `user_id` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`internal_message_id`,`internal_category_id`,`user_id`),
  KEY `fk_internal_message_has_internal_category_internal_category1_idx` (`internal_category_id`),
  KEY `fk_internal_message_has_internal_category_internal_message1_idx` (`internal_message_id`),
  KEY `fk_internal_message_internal_category_sf_guard_user1_idx` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `invitation`
--

CREATE TABLE IF NOT EXISTS `invitation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inviter_id` bigint(20) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `click_count` int(11) DEFAULT '0',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_invitation_sf_guard_user_idx` (`inviter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `kfm_directories`
--

CREATE TABLE IF NOT EXISTS `kfm_directories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text,
  `parent` int(11) NOT NULL,
  `maxwidth` int(11) DEFAULT '0',
  `maxheight` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Zrzut danych tabeli `kfm_directories`
--

INSERT INTO `kfm_directories` (`id`, `name`, `parent`, `maxwidth`, `maxheight`) VALUES
(1, 'root', 0, 0, 0);

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `kfm_files`
--

CREATE TABLE IF NOT EXISTS `kfm_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text,
  `directory` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=42 ;

--
-- Zrzut danych tabeli `kfm_files`
--

INSERT INTO `kfm_files` (`id`, `name`, `directory`) VALUES
(1, 'wykres_uslugi.png', 1),
(2, 'wykres_segmentacja.png', 1),
(3, 'wykres_konkurencja.png', 1),
(4, 'wykres_pory_roku.png', 1),
(13, 'popyt_suma.png', 1),
(14, 'popyt_1.png', 1),
(15, 'popyt_2.png', 1),
(16, 'popyt_3.png', 1),
(20, 'popyt_lux_suma.png', 1),
(21, 'popyt_lux_1.png', 1),
(22, 'popyt_lux_2.png', 1),
(23, 'popyt_lux_3.png', 1),
(24, 'png;base6429ff40a328ab589.png', 1),
(25, 'sezonowosc.png', 1),
(26, 'uslug_podstawowe.jpg', 1),
(27, 'uslugi_zaawansowane.jpg', 1),
(28, 'popyt_standard_0.jpg', 1),
(30, 'popyt_standard_2.jpg', 1),
(31, 'popyt_standard_3.jpg', 1),
(33, 'popyt_standard_1.jpg', 1),
(34, 'popyt_lux_0.jpg', 1),
(35, 'popyt_lux_1.jpg', 1),
(36, 'popyt_lux_2.jpg', 1),
(37, 'popyt_lux_3.jpg', 1),
(39, 'badania_segmentacja.png', 1),
(40, 'konkurencja.jpg', 1),
(41, 'segmentacja.jpg', 1);

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `kfm_files_images`
--

CREATE TABLE IF NOT EXISTS `kfm_files_images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `caption` text,
  `file_id` int(11) NOT NULL,
  `width` int(11) DEFAULT '0',
  `height` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=42 ;

--
-- Zrzut danych tabeli `kfm_files_images`
--

INSERT INTO `kfm_files_images` (`id`, `caption`, `file_id`, `width`, `height`) VALUES
(1, '', 1, 0, 0),
(2, '', 2, 0, 0),
(3, '', 3, 0, 0),
(4, '', 4, 0, 0),
(13, '', 13, 0, 0),
(14, '', 14, 0, 0),
(15, '', 15, 0, 0),
(16, '', 16, 0, 0),
(20, '', 20, 0, 0),
(21, '', 21, 0, 0),
(22, '', 22, 0, 0),
(23, '', 23, 0, 0),
(24, 'png;base6429ff40a328ab589.png', 24, 0, 0),
(25, 'sezonowosc.png', 25, 0, 0),
(26, 'uslug_podstawowe.jpg', 26, 0, 0),
(27, 'uslugi_zaawansowane.jpg', 27, 0, 0),
(28, 'Created with GIMP', 28, 0, 0),
(30, 'Created with GIMP', 30, 0, 0),
(31, 'Created with GIMP', 31, 0, 0),
(33, 'Created with GIMP', 33, 0, 0),
(34, 'Created with GIMP', 34, 0, 0),
(35, 'Created with GIMP', 35, 0, 0),
(36, 'Created with GIMP', 36, 0, 0),
(37, 'Created with GIMP', 37, 0, 0),
(39, '', 39, 0, 0),
(40, '', 40, 0, 0),
(41, '', 41, 0, 0);

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `kfm_files_images_thumbs`
--

CREATE TABLE IF NOT EXISTS `kfm_files_images_thumbs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` int(11) NOT NULL,
  `width` int(11) DEFAULT '0',
  `height` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=46 ;

--
-- Zrzut danych tabeli `kfm_files_images_thumbs`
--

INSERT INTO `kfm_files_images_thumbs` (`id`, `image_id`, `width`, `height`) VALUES
(1, 1, 64, 37),
(2, 2, 64, 33),
(3, 3, 64, 49),
(4, 4, 64, 38),
(13, 13, 63, 39),
(14, 14, 64, 35),
(15, 15, 64, 36),
(16, 16, 64, 33),
(17, 13, 63, 39),
(21, 20, 64, 35),
(22, 21, 64, 32),
(23, 22, 64, 35),
(24, 23, 64, 33),
(25, 28, 64, 36),
(27, 30, 64, 36),
(28, 31, 64, 42),
(30, 33, 64, 39),
(31, 34, 64, 36),
(32, 35, 64, 39),
(33, 36, 64, 36),
(34, 37, 64, 39),
(36, 24, 64, 37),
(37, 26, 64, 35),
(38, 13, 63, 39),
(39, 27, 64, 46),
(40, 13, 63, 39),
(41, 25, 64, 35),
(42, 39, 64, 46),
(43, 13, 63, 39),
(44, 40, 64, 48),
(45, 41, 64, 44);

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `kfm_parameters`
--

CREATE TABLE IF NOT EXISTS `kfm_parameters` (
  `name` text,
  `value` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Zrzut danych tabeli `kfm_parameters`
--

INSERT INTO `kfm_parameters` (`name`, `value`) VALUES
('version', '1.4'),
('version_db', '8'),
('last_registration', '2015-07-31');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `kfm_plugin_extensions`
--

CREATE TABLE IF NOT EXISTS `kfm_plugin_extensions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `extension` varchar(64) DEFAULT NULL,
  `plugin` varchar(64) DEFAULT NULL,
  `user_id` int(8) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `kfm_session`
--

CREATE TABLE IF NOT EXISTS `kfm_session` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cookie` varchar(32) DEFAULT NULL,
  `last_accessed` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Zrzut danych tabeli `kfm_session`
--

INSERT INTO `kfm_session` (`id`, `cookie`, `last_accessed`) VALUES
(5, 'e4da3b7fbbce2345d7772b0674a318d5', '2015-07-31 11:02:42');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `kfm_session_vars`
--

CREATE TABLE IF NOT EXISTS `kfm_session_vars` (
  `session_id` int(11) DEFAULT NULL,
  `varname` text,
  `varvalue` text,
  KEY `session_id` (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Zrzut danych tabeli `kfm_session_vars`
--

INSERT INTO `kfm_session_vars` (`session_id`, `varname`, `varvalue`) VALUES
(5, 'user_id', '1'),
(5, 'username', '""'),
(5, 'password', '""'),
(5, 'loggedin', '0'),
(5, 'theme', '"default"'),
(5, 'language', '"en"'),
(5, 'cwd_id', '1'),
(5, 'kfm_url', '"http:\\/\\/hotel.prod.arteneo.pl\\/js\\/kfm\\/index.php?\\/\\/js\\/"');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `kfm_settings`
--

CREATE TABLE IF NOT EXISTS `kfm_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) DEFAULT NULL,
  `value` varchar(256) DEFAULT NULL,
  `user_id` int(8) DEFAULT NULL,
  `usersetting` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Zrzut danych tabeli `kfm_settings`
--

INSERT INTO `kfm_settings` (`id`, `name`, `value`, `user_id`, `usersetting`) VALUES
(1, 'kfm_url', '/js/kfm', 1, 0);

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `kfm_tagged_files`
--

CREATE TABLE IF NOT EXISTS `kfm_tagged_files` (
  `file_id` int(11) DEFAULT NULL,
  `tag_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `kfm_tags`
--

CREATE TABLE IF NOT EXISTS `kfm_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `kfm_translations`
--

CREATE TABLE IF NOT EXISTS `kfm_translations` (
  `original` text,
  `translation` text,
  `language` varchar(2) DEFAULT NULL,
  `calls` int(11) DEFAULT '0',
  `found` int(11) DEFAULT '1',
  `context` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `kfm_users`
--

CREATE TABLE IF NOT EXISTS `kfm_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(16) DEFAULT NULL,
  `password` varchar(40) DEFAULT NULL,
  `status` int(1) DEFAULT '2',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Zrzut danych tabeli `kfm_users`
--

INSERT INTO `kfm_users` (`id`, `username`, `password`, `status`) VALUES
(1, 'admin', 'd033e22ae348aeb5660fc2140aec35850c4da997', 1);

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `layout`
--

CREATE TABLE IF NOT EXISTS `layout` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `module` varchar(100) DEFAULT NULL,
  `view` varchar(100) DEFAULT NULL,
  `description` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Zrzut danych tabeli `layout`
--

INSERT INTO `layout` (`id`, `name`, `module`, `view`, `description`) VALUES
(1, 'Default', 'article', 'FullWidth', NULL);

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `layout_layout_param`
--

CREATE TABLE IF NOT EXISTS `layout_layout_param` (
  `layout_id` int(11) NOT NULL DEFAULT '0',
  `param_id` int(11) NOT NULL DEFAULT '0',
  `value` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`layout_id`,`param_id`),
  KEY `fk_layout_param_param1_idx` (`param_id`),
  KEY `fk_layout_param_layout_idx` (`layout_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Zrzut danych tabeli `layout_layout_param`
--

INSERT INTO `layout_layout_param` (`layout_id`, `param_id`, `value`) VALUES
(2, 1, '1'),
(2, 2, '1'),
(2, 3, '1'),
(2, 4, '1'),
(2, 5, '1'),
(2, 6, '1'),
(2, 7, '1'),
(2, 8, '1'),
(2, 9, '1'),
(2, 10, '1'),
(2, 11, '1'),
(2, 12, '1'),
(2, 13, '1'),
(2, 14, '1'),
(2, 15, '1'),
(2, 16, '0'),
(2, 17, 'carousel'),
(2, 18, 'bottom'),
(2, 19, '1'),
(2, 20, 'horizontal'),
(2, 21, '60000'),
(3, 1, '0'),
(3, 2, '0'),
(3, 3, '0'),
(3, 4, '0'),
(3, 5, '0'),
(3, 6, '0'),
(3, 7, '0'),
(3, 8, '0'),
(3, 9, '0'),
(3, 10, '0'),
(3, 11, '0'),
(3, 12, '0'),
(3, 13, '0'),
(3, 14, '0'),
(3, 15, '0'),
(3, 16, '0'),
(3, 17, 'carousel'),
(3, 18, 'bottom'),
(3, 19, '1'),
(3, 20, 'horizontal'),
(3, 21, '60000');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `layout_module`
--

CREATE TABLE IF NOT EXISTS `layout_module` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Zrzut danych tabeli `layout_module`
--

INSERT INTO `layout_module` (`id`, `name`) VALUES
(1, 'email'),
(2, 'gg'),
(3, 'article'),
(4, 'message');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `layout_param`
--

CREATE TABLE IF NOT EXISTS `layout_param` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `layout_id` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `value` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_layout_param_layout_idx` (`layout_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `log_decision`
--

CREATE TABLE IF NOT EXISTS `log_decision` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `round_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `decision` varchar(255) NOT NULL,
  `old_value` mediumtext,
  `new_value` mediumtext,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_decision_round1_idx` (`round_id`),
  KEY `fk_decision_sf_guard_user1_idx` (`user_id`),
  KEY `fk_decision_decision1_idx` (`decision`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=70578 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `log_event`
--

CREATE TABLE IF NOT EXISTS `log_event` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `team_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `round_id` bigint(20) DEFAULT NULL,
  `event` varchar(255) DEFAULT NULL,
  `text` mediumtext,
  `value` mediumtext,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_item_displayed_sf_guard_user1_idx` (`user_id`),
  KEY `fk_item_item1_idx` (`event`),
  KEY `fk_log_event_round1_idx` (`round_id`),
  KEY `fk_log_event_team1_idx` (`team_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1193 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `log_message_displayed`
--

CREATE TABLE IF NOT EXISTS `log_message_displayed` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `message_id` bigint(20) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_table1_messages1_idx` (`message_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `menu_group`
--

CREATE TABLE IF NOT EXISTS `menu_group` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `unique_name` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_name` (`unique_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Zrzut danych tabeli `menu_group`
--

INSERT INTO `menu_group` (`id`, `unique_name`, `created_at`, `updated_at`, `name`) VALUES
(1, 'backend', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 'Panel nauczyciela'),
(2, 'backend_sub1', '2015-07-31 11:02:42', '2015-07-31 11:02:42', NULL),
(3, 'backend_sub2', '2015-07-31 11:02:42', '2015-07-31 11:02:42', NULL),
(4, 'admin', '2015-07-31 11:02:42', '2015-07-31 11:02:42', 'Panel administratora');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `menu_item`
--

CREATE TABLE IF NOT EXISTS `menu_item` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `menu_id` bigint(20) NOT NULL,
  `submenu_id` bigint(20) DEFAULT NULL,
  `url_type` int(11) NOT NULL,
  `order` int(11) NOT NULL,
  `json` text,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fk_menu_item_unique_order_menu_id1_idx` (`menu_id`,`order`),
  KEY `fk_menu_item_menu_id1_idx` (`menu_id`),
  KEY `fk_menu_item_submenu_id1_idx` (`submenu_id`),
  KEY `menu_item_menu_id_idx` (`menu_id`),
  KEY `menu_item_submenu_id_idx` (`submenu_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=23 ;

--
-- Zrzut danych tabeli `menu_item`
--

INSERT INTO `menu_item` (`id`, `menu_id`, `submenu_id`, `url_type`, `order`, `json`, `created_at`, `updated_at`) VALUES
(2, 1, NULL, 4, 1, '{"icon":"icon-plus", "active_equal": 1}', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(3, 1, NULL, 4, 2, '{"icon":"icon-puzzle-piece", "active_equal": 1}', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(5, 1, NULL, 4, 4, '{"icon":"icon-group", "active_equal": 1}', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(6, 1, NULL, 4, 5, '{"icon":"icon-book", "active_equal": 1}', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(7, 1, NULL, 4, 3, '{"icon":"icon-folder-open", "active_equal": 1}', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(8, 1, NULL, 4, 999, '{"icon":"icon-power-off", "active_equal": 1}', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(9, 1, NULL, 4, 6, '{"icon":"icon-cog", "active_equal": 1}', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(10, 4, NULL, 4, 1, '{"icon":"icon-font", "active_equal": 1}', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(11, 4, NULL, 4, 10, '{"icon":"icon-comment-alt", "active_equal": 1}', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(12, 4, NULL, 4, 999, '{"icon":"icon-power-off", "active_equal": 1}', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(13, 4, NULL, 4, 20, '{"icon":"icon-group", "active_equal": 1}', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(14, 1, NULL, 4, 7, '{"icon":"icon-comments", "active_equal": 1}', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(19, 1, NULL, 4, 8, '{"icon":"icon-comments", "active_equal": 1}', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(20, 4, NULL, 4, 5, '{"icon":"icon-tag", "active_equal": 1}', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(21, 4, NULL, 4, 6, '{"icon":"icon-tags", "active_equal": 1}', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(22, 4, NULL, 4, 8, '{"icon":"icon-download-alt", "active_equal": 1}', '2015-07-31 11:02:42', '2015-07-31 11:02:42');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `menu_item_translation`
--

CREATE TABLE IF NOT EXISTS `menu_item_translation` (
  `id` bigint(20) NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `url` text,
  `lang` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`lang`),
  KEY `menu_item_translation_id_idx` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Zrzut danych tabeli `menu_item_translation`
--

INSERT INTO `menu_item_translation` (`id`, `title`, `url`, `lang`) VALUES
(2, 'Tworzenie gry', 'game_new', 'pl'),
(3, 'Lista gier', 'game', 'pl'),
(5, 'Lista graczy', 'users', 'pl'),
(6, 'Materiały', 'materialy', 'pl'),
(7, 'Gry archiwalne', 'gameArchive', 'pl'),
(8, 'Wylogowanie', 'sf_guard_signout', 'pl'),
(9, 'Moje konto', 'myAccount', 'pl'),
(10, 'Artykuły', 'flatyArticle', 'pl'),
(11, 'Tłumaczenia', 'flatyI18nTranslations', 'pl'),
(12, 'Wylogowanie', 'sf_guard_signout', 'pl'),
(13, 'Użytkownicy', 'flatySfGuardUser', 'pl'),
(14, 'Ankieta przed', 'ankieta_przed', 'pl'),
(19, 'Ankieta po', 'ankieta_po', 'pl'),
(20, 'Menu elementy', 'flatyMenuItem', 'pl'),
(21, 'Menu grupy', 'flatyMenuGroup', 'pl'),
(22, 'Ankiety nauczycieli', 'pobranie_ankieta_nauczyciel', 'pl');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `message`
--

CREATE TABLE IF NOT EXISTS `message` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `team_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `round_id` bigint(20) DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `title` mediumtext,
  `category` varchar(255) DEFAULT NULL,
  `body` mediumtext,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_game_article_user_team1_idx` (`team_id`),
  KEY `fk_game_article_user_user1_idx` (`user_id`),
  KEY `fk_game_article_user_round1_idx` (`round_id`),
  KEY `unique_article_game_user_idx` (`team_id`,`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=49252 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `message_center`
--

CREATE TABLE IF NOT EXISTS `message_center` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message_channel_id` int(11) NOT NULL,
  `layout_id` int(11) DEFAULT NULL,
  `collector_class` varchar(100) NOT NULL,
  `newsletter` tinyint(4) DEFAULT '0',
  `unique_name` varchar(45) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_message_center_message_channel_idx` (`message_channel_id`),
  KEY `fk_message_center_layout1_idx` (`layout_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

--
-- Zrzut danych tabeli `message_center`
--

INSERT INTO `message_center` (`id`, `message_channel_id`, `layout_id`, `collector_class`, `newsletter`, `unique_name`, `created_at`, `updated_at`) VALUES
(1, 1, NULL, 'MessageCollectorNewsletter', 2, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(2, 1, NULL, 'MessageCollectorNewsletter', 1, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(3, 2, NULL, 'MessageCollectorSfGuardUser', 0, 'delete account', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(4, 2, NULL, 'MessageCollectorInviteFriendToService', 0, 'invite friend to service', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(5, 2, NULL, 'MessageCollectorInviteFriend', 0, 'invite friend', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(6, 3, NULL, 'MessageCollectorInviteFriend', 0, 'invite friend', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(7, 2, NULL, 'MessageCollectorInviteFriend', 0, 'invitation to friend accepted', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(8, 3, NULL, 'MessageCollectorInviteFriend', 0, 'invitation to friend accepted', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(9, 2, NULL, 'MessageCollectorSfGuardUser', 0, 'registration', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(10, 2, NULL, 'MessageCollectorSfGuardUser', 0, 'activation', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(11, 2, NULL, 'MessageCollectorSfGuardUser', 0, 'new password', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(12, 2, NULL, 'MessageCollectorSfGuardUser', 0, 'reset password', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(13, 2, NULL, 'MessageCollectorActivateNewsletter', 0, 'activate newsletter', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(14, 2, NULL, 'MessageCollectorMessage', 0, 'contact_form', '2015-07-31 11:02:42', '2015-07-31 11:02:42');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `message_center_file`
--

CREATE TABLE IF NOT EXISTS `message_center_file` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message_center_id` int(11) NOT NULL,
  `file` text NOT NULL,
  `original_filename` text NOT NULL,
  `order` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_message_center_file_message_center1_idx` (`message_center_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `message_center_file_translation`
--

CREATE TABLE IF NOT EXISTS `message_center_file_translation` (
  `id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `description` mediumtext,
  `lang` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`lang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `message_channel`
--

CREATE TABLE IF NOT EXISTS `message_channel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channel` varchar(45) DEFAULT NULL,
  `channel_class` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Zrzut danych tabeli `message_channel`
--

INSERT INTO `message_channel` (`id`, `channel`, `channel_class`) VALUES
(1, 'newsletter', 'MessageChannelEmailNewsletter'),
(2, 'email', 'MessageChannelEmail'),
(3, 'internal', 'MessageChannelInternal'),
(4, 'gg', 'MessageChannelGG'),
(5, 'sms', 'MessageChannelSms');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `message_multisend_history`
--

CREATE TABLE IF NOT EXISTS `message_multisend_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message_center_id` int(11) NOT NULL,
  `message_multisend_type_id` int(11) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `newsletter_user_id` int(11) DEFAULT NULL,
  `title` text NOT NULL,
  `description` mediumtext NOT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `error` text,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_message_multisend_history_sf_guard_user1_idx` (`user_id`),
  KEY `fk_message_multisend_history_newsletter_user1_idx` (`newsletter_user_id`),
  KEY `fk_message_multisend_history_message_center1_idx` (`message_center_id`),
  KEY `fk_message_multisend_history_message_multisend_type1_idx` (`message_multisend_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `message_multisend_list`
--

CREATE TABLE IF NOT EXISTS `message_multisend_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message_center_id` int(11) NOT NULL,
  `message_multisend_type_id` int(11) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `newsletter_user_id` int(11) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_message_multisend_list_sf_guard_user1_idx` (`user_id`),
  KEY `fk_message_multisend_list_newsletter_user1_idx` (`newsletter_user_id`),
  KEY `fk_message_multisend_list_message_center1_idx` (`message_center_id`),
  KEY `fk_message_multisend_list_message_multisend_type1_idx` (`message_multisend_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `message_multisend_type`
--

CREATE TABLE IF NOT EXISTS `message_multisend_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Zrzut danych tabeli `message_multisend_type`
--

INSERT INTO `message_multisend_type` (`id`, `name`) VALUES
(1, 'newsletter');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `message_template`
--

CREATE TABLE IF NOT EXISTS `message_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message_center_id` int(11) NOT NULL,
  `order` int(11) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_message_template_message_center1_idx` (`message_center_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

--
-- Zrzut danych tabeli `message_template`
--

INSERT INTO `message_template` (`id`, `message_center_id`, `order`, `created_at`, `updated_at`) VALUES
(1, 1, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(2, 2, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(3, 3, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(4, 14, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(5, 5, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(6, 4, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(7, 6, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(8, 8, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(9, 5, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(10, 9, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(11, 10, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(12, 11, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(13, 12, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(14, 13, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `message_template_translation`
--

CREATE TABLE IF NOT EXISTS `message_template_translation` (
  `id` int(11) NOT NULL DEFAULT '0',
  `title` mediumtext,
  `description` mediumtext,
  `lang` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`lang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Zrzut danych tabeli `message_template_translation`
--

INSERT INTO `message_template_translation` (`id`, `title`, `description`, `lang`) VALUES
(1, 'arteneo.pl Newsletter', 'Hello {user_first_name}!\n\nThis is test message\n', 'en'),
(1, 'arteneo.pl Newsletter', 'Witaj {user_first_name}!\n\nTo jest przykładowa wiadomość\n', 'pl'),
(2, 'arteneo.pl Newsletter', 'Hello {user_first_name}!\n\nThis is test message\n', 'en'),
(2, 'arteneo.pl Newsletter', 'Witaj {user_first_name}!\n\nTo jest przykładowa wiadomość\n', 'pl'),
(3, 'arteneo.pl Confirm of deletion account', 'Hello {first_name}!\n\nIf you want delete your account, just click\n<a href="{delete_account_link}">{delete_account_link}</a>\n', 'en'),
(3, 'arteneo.pl Potwierdzenie usunięcia konta', 'Witaj {first_name}!\n\nJeżeli chcesz usunąć konto, kliknij w link\n<a href="{delete_account_link}">{delete_account_link}</a>\n', 'pl'),
(4, 'Message from site arteneo.pl', '{message}\n', 'en'),
(4, 'Wiadomość z serwisu arteneo.pl', '{message}\n', 'pl'),
(5, 'Invitation to friends', 'I invite you to be my friend!', 'en'),
(5, 'Zaproszenie do znajomych od użytkownika {inviter_name}', 'Zapraszam Cię do znajomych użytkowniku {friend_name}', 'pl'),
(6, NULL, 'I invite you to be my friend!', 'en'),
(6, 'Zaproszenie do znajomych od użytkownika {inviter_name}', 'Witaj, zapraszam Cię do znajomych! Mój email to: {inviter_email} \n', 'pl'),
(7, NULL, 'I invite you to be my friend!', 'en'),
(7, 'Zaproszenie do znajomych od użytkownika {inviter_name}', 'Witaj, zapraszam Cię do znajomych! \nMój email to: {inviter_email} \n', 'pl'),
(8, 'arteneo.pl Invitation accepted', 'I invite you to be my friend!', 'en'),
(8, 'arteneo.pl Zaproszenie zaakceptowane', 'Użytkownik {inviter_name} zaakceptował twoje zaproszenie do przyjaciół.\n', 'pl'),
(9, 'arteneo.pl Invitation accepted', 'User {inviter_name} has accepted your invitation to friendship \n', 'en'),
(9, 'arteneo.pl Zaproszenie zaakceptowane', 'Użytkownik {inviter_name} zaakceptował twoje zaproszenie do przyjaciół\n', 'pl'),
(10, 'arteneo.pl Registration message', 'Welcome, please activate your account by clicking this link:\n<a href="{link}">{link}</a>\n\nIf you are not registered on our website, click on the link to delete the account:\n<a href="{delete_account_link}">{delete_account_link}</a>\n', 'en'),
(10, 'arteneo.pl Rejestracja w serwisie', 'Dziękujemy za rejestrację, kliknij w link aby aktywować konto\n<a href="{link}">{link}</a>\n\nJeżeli to nie Ty rejestrowałeś się w naszym serwisie, kliknij w link aby usunąć konto:\n<a href="{delete_account_link}">{delete_account_link}</a>\n', 'pl'),
(11, 'arteneo.pl Account activated', 'Your account has been succesfully activated.\n', 'en'),
(11, 'arteneo.pl Konto aktywowane', 'Twoje konto zostało pomyślnie aktywowane.\n', 'pl'),
(12, 'arteneo.pl Password changed', 'Your password has been succesfully changed.\n', 'en'),
(12, 'arteneo.pl Zmiana hasła', 'Twoje hasło zostało pomyślnie zmienione.\n', 'pl'),
(13, 'arteneo.pl New Password', 'In order to reset your password click the link below:\n<a href="{link}">{link}</a>\n', 'en'),
(13, 'arteneo.pl Nowe hasło', 'Aby zmienić hasło na serwisie kliknij w poniższy link:\n<a href="{link}">{link}</a>\n', 'pl'),
(14, 'arteneo.pl Aktywacja newslettera', 'Witaj {user_first_name}!\n\nAby potwierdzić aktywację newslettera, kliknij w poniższy link\n<a href="{signin_link}">{signin_link}</a>\n\n\n  \n', 'en'),
(14, 'arteneo.pl Aktywacja newslettera', 'Witaj {user_first_name}!\n\nAby potwierdzić aktywację newslettera, kliknij w poniższy link\n<a href="{signin_link}">{signin_link}</a>\n', 'pl');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `migration_version`
--

CREATE TABLE IF NOT EXISTS `migration_version` (
  `version` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Zrzut danych tabeli `migration_version`
--

INSERT INTO `migration_version` (`version`) VALUES
(9);

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `newsletter_user`
--

CREATE TABLE IF NOT EXISTS `newsletter_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `first_name` varchar(100) DEFAULT NULL,
  `last_name` varchar(100) DEFAULT NULL,
  `status` tinyint(4) DEFAULT '0',
  `message_count` int(11) DEFAULT '0',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`),
  UNIQUE KEY `email` (`email`),
  KEY `fk_newsletter_user_sf_guard_user1_idx` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `newsletter_user_tag`
--

CREATE TABLE IF NOT EXISTS `newsletter_user_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `round`
--

CREATE TABLE IF NOT EXISTS `round` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `team_id` bigint(20) NOT NULL,
  `round_number` int(11) NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `round_data_json` longtext,
  `round_decision_data_json` longtext,
  `round_raport_data_json` longtext,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_round_team_idx` (`team_id`,`round_number`),
  KEY `fk_round_team1_idx` (`team_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15771 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `sf_guard_forgot_password`
--

CREATE TABLE IF NOT EXISTS `sf_guard_forgot_password` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `unique_key` varchar(255) DEFAULT NULL,
  `expires_at` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id_idx` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `sf_guard_group`
--

CREATE TABLE IF NOT EXISTS `sf_guard_group` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `description` text,
  `password_expiration_period` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- Zrzut danych tabeli `sf_guard_group`
--

INSERT INTO `sf_guard_group` (`id`, `name`, `description`, `password_expiration_period`, `created_at`, `updated_at`) VALUES
(1, 'admin', 'Administrator group', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(2, 'teacher', 'Teacher group', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(3, 'teacher_demo', 'Teacher demo group', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(4, 'user', 'User group', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(5, 'tester', 'Tester gry', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(6, 'editor', 'Article editor', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(7, 'translation_edit', 'Edycja tłumaczeń', NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `sf_guard_group_permission`
--

CREATE TABLE IF NOT EXISTS `sf_guard_group_permission` (
  `group_id` bigint(20) NOT NULL DEFAULT '0',
  `permission_id` bigint(20) NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`group_id`,`permission_id`),
  KEY `sf_guard_group_permission_permission_id_sf_guard_permission_id` (`permission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Zrzut danych tabeli `sf_guard_group_permission`
--

INSERT INTO `sf_guard_group_permission` (`group_id`, `permission_id`, `created_at`, `updated_at`) VALUES
(1, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(2, 2, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(3, 3, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(4, 4, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(5, 7, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(6, 9, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(7, 18, '2015-07-31 11:02:42', '2015-07-31 11:02:42');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `sf_guard_permission`
--

CREATE TABLE IF NOT EXISTS `sf_guard_permission` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `description` text,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=19 ;

--
-- Zrzut danych tabeli `sf_guard_permission`
--

INSERT INTO `sf_guard_permission` (`id`, `name`, `description`, `created_at`, `updated_at`) VALUES
(1, 'admin', 'Administrator permission', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(2, 'teacher', 'Teacher permission', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(3, 'teacher_demo', 'Teacher demo permission', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(4, 'user', 'User permission', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(5, 'readonly_game', 'Game read only permission', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(6, 'full_game', 'Game full permission', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(7, 'tester', 'Tester gry', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(8, 'article_add', 'Dodawanie artykułów', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(9, 'article_edit', 'Edycja artykułów', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(10, 'article_meta_edit', 'Edycja metatagów artykułu', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(11, 'article_delete', 'Usuwanie artykułów', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(12, 'article_gallery', 'Zarządzanie galerią artykułu', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(13, 'category_add', 'Dodawanie kategorii', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(14, 'category_edit', 'Edycja kategorii', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(15, 'category_delete', 'Usuwanie kategorii', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(16, 'change_order', 'Zmiana kolejności', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(17, 'art_configuration', 'Zmiana konfiguracji', '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(18, 'translation_edit', 'Edycja tłumaczeń', '2015-07-31 11:02:42', '2015-07-31 11:02:42');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `sf_guard_remember_key`
--

CREATE TABLE IF NOT EXISTS `sf_guard_remember_key` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `remember_key` varchar(32) DEFAULT NULL,
  `ip_address` varchar(50) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id_idx` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `sf_guard_user`
--

CREATE TABLE IF NOT EXISTS `sf_guard_user` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `email_address` varchar(255) NOT NULL,
  `username` varchar(128) NOT NULL,
  `algorithm` varchar(128) NOT NULL DEFAULT 'sha1',
  `salt` varchar(128) DEFAULT NULL,
  `password` varchar(128) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT '0',
  `is_banned` tinyint(1) DEFAULT '0',
  `is_super_admin` tinyint(1) DEFAULT '0',
  `last_login` datetime DEFAULT NULL,
  `password_expired` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email_address` (`email_address`),
  UNIQUE KEY `username` (`username`),
  KEY `is_active_idx_idx` (`is_active`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1425 ;

--
-- Zrzut danych tabeli `sf_guard_user`
--

INSERT INTO `sf_guard_user` (`id`, `first_name`, `last_name`, `email_address`, `username`, `algorithm`, `salt`, `password`, `is_active`, `is_banned`, `is_super_admin`, `last_login`, `password_expired`, `created_at`, `updated_at`) VALUES
(1, 'Super', 'Admin', 'admin.adminowski@arteneo.pl', 'superadmin', 'sha1', '1726f7f23f8a11c77c1750affe154d2c', 'd58d28474de74b877b5ca14dc345bd972cb77641', 1, 0, 1, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(2, 'Administrator', 'Admin', 'administrator@arteneoit.pl', 'admin', 'sha1', 'd8e666e306e193b6c67513fa97771996', '376c94f76caf46e1f9350b3c51d3ecbe2cc7c464', 1, 0, 1, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(3, 'System', NULL, 'mailer@email.arteneo.pl', 'system', 'sha1', NULL, NULL, 0, 0, 0, NULL, NULL, '2015-07-31 11:02:42', '2015-07-31 11:02:42');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `sf_guard_user_group`
--

CREATE TABLE IF NOT EXISTS `sf_guard_user_group` (
  `user_id` bigint(20) NOT NULL DEFAULT '0',
  `group_id` bigint(20) NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `sf_guard_user_group_group_id_sf_guard_group_id` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Zrzut danych tabeli `sf_guard_user_group`
--

INSERT INTO `sf_guard_user_group` (`user_id`, `group_id`, `created_at`, `updated_at`) VALUES
(1, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(2, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `sf_guard_user_index`
--

CREATE TABLE IF NOT EXISTS `sf_guard_user_index` (
  `keyword` varchar(200) NOT NULL DEFAULT '',
  `field` varchar(50) NOT NULL DEFAULT '',
  `position` bigint(20) NOT NULL DEFAULT '0',
  `id` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`keyword`,`field`,`position`,`id`),
  KEY `sf_guard_user_index_id_sf_guard_user_id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `sf_guard_user_permission`
--

CREATE TABLE IF NOT EXISTS `sf_guard_user_permission` (
  `user_id` bigint(20) NOT NULL DEFAULT '0',
  `permission_id` bigint(20) NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`permission_id`),
  KEY `sf_guard_user_permission_permission_id_sf_guard_permission_id` (`permission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `teacher_class`
--

CREATE TABLE IF NOT EXISTS `teacher_class` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `teacher_id` bigint(20) NOT NULL,
  `name` varchar(255) NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `fk_class_sf_guard_user1_idx` (`teacher_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `team`
--

CREATE TABLE IF NOT EXISTS `team` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `game_id` bigint(20) NOT NULL,
  `name` varchar(255) NOT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `max_users` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `fk_team_game1_idx` (`game_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=996 ;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `user_detail`
--

CREATE TABLE IF NOT EXISTS `user_detail` (
  `id` bigint(20) NOT NULL DEFAULT '0',
  `school` varchar(255) DEFAULT NULL,
  `phone` varchar(45) DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `game_id` bigint(20) DEFAULT NULL,
  `teacher_survey_before` longtext,
  `teacher_survey_after` longtext,
  `student_survey_before` longtext,
  `student_survey_after` longtext,
  `student_test_before` longtext,
  `student_test_after` longtext,
  `teacher_test_grade_before` longtext,
  `teacher_test_grade_after` longtext,
  PRIMARY KEY (`id`),
  KEY `fk_user_detail_sf_guard_user_idx` (`id`),
  KEY `user_detail_game_id_idx` (`game_id`),
  KEY `fk_user_detail_game1_idx` (`game_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Zrzut danych tabeli `user_detail`
--

INSERT INTO `user_detail` (`id`, `school`, `phone`, `status`, `game_id`, `teacher_survey_before`, `teacher_survey_after`, `student_survey_before`, `student_survey_after`, `student_test_before`, `student_test_after`, `teacher_test_grade_before`, `teacher_test_grade_after`) VALUES
(2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `user_has_team`
--

CREATE TABLE IF NOT EXISTS `user_has_team` (
  `user_id` bigint(20) NOT NULL DEFAULT '0',
  `team_id` bigint(20) NOT NULL DEFAULT '0',
  `role` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`user_id`,`team_id`),
  KEY `fk_sf_guard_user_has_team_team1_idx` (`team_id`),
  KEY `fk_sf_guard_user_has_team_sf_guard_user1_idx` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `user_message_settings`
--

CREATE TABLE IF NOT EXISTS `user_message_settings` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `message_center_id` int(11) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `enabled` tinyint(4) DEFAULT '1',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_message_center_message_channel_message_center1_idx` (`message_center_id`),
  KEY `fk_message_center_message_channel_sf_guard_user1_idx` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11926 ;

--
-- Zrzut danych tabeli `user_message_settings`
--

INSERT INTO `user_message_settings` (`id`, `message_center_id`, `user_id`, `enabled`, `created_at`, `updated_at`) VALUES
(1, 4, NULL, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(2, 5, NULL, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(3, 6, NULL, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(4, 7, NULL, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(5, 8, NULL, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(6, 12, NULL, 2, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(7, 11, NULL, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(8, 9, NULL, 2, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(9, 10, NULL, 2, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(10, 3, NULL, 2, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(71, 4, 1, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(72, 5, 1, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(73, 6, 1, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(74, 7, 1, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(75, 8, 1, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(76, 12, 1, 2, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(77, 11, 1, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(78, 9, 1, 2, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(79, 10, 1, 2, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(80, 3, 1, 2, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(81, 4, 2, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(82, 5, 2, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(83, 6, 2, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(84, 7, 2, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(85, 8, 2, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(86, 12, 2, 2, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(87, 11, 2, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(88, 9, 2, 2, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(89, 10, 2, 2, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(90, 3, 2, 2, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(91, 4, 3, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(92, 5, 3, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(93, 6, 3, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(94, 7, 3, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(95, 8, 3, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(96, 12, 3, 2, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(97, 11, 3, 1, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(98, 9, 3, 2, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(99, 10, 3, 2, '2015-07-31 11:02:42', '2015-07-31 11:02:42'),
(100, 3, 3, 2, '2015-07-31 11:02:42', '2015-07-31 11:02:42');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `user_tag`
--

CREATE TABLE IF NOT EXISTS `user_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Ograniczenia dla zrzutów tabel
--

--
-- Ograniczenia dla tabeli `article`
--
ALTER TABLE `article`
  ADD CONSTRAINT `article_creator_id_sf_guard_user_id` FOREIGN KEY (`creator_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `article_editor_id_sf_guard_user_id` FOREIGN KEY (`editor_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `article_layout_id_layout_id` FOREIGN KEY (`layout_id`) REFERENCES `layout` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `article_article_blog_category`
--
ALTER TABLE `article_article_blog_category`
  ADD CONSTRAINT `aaai` FOREIGN KEY (`article_blog_category_id`) REFERENCES `article_blog_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `article_article_blog_category_article_id_article_id` FOREIGN KEY (`article_id`) REFERENCES `article` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `article_article_category`
--
ALTER TABLE `article_article_category`
  ADD CONSTRAINT `article_article_category_article_id_article_id` FOREIGN KEY (`article_id`) REFERENCES `article` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `article_article_category_category_id_article_category_id` FOREIGN KEY (`category_id`) REFERENCES `article_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `article_article_category_subcategory_id_article_category_id` FOREIGN KEY (`subcategory_id`) REFERENCES `article_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `article_article_tag`
--
ALTER TABLE `article_article_tag`
  ADD CONSTRAINT `article_article_tag_article_id_article_id` FOREIGN KEY (`article_id`) REFERENCES `article` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `article_article_tag_tag_id_article_tag_id` FOREIGN KEY (`tag_id`) REFERENCES `article_tag` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `article_blog_category_translation`
--
ALTER TABLE `article_blog_category_translation`
  ADD CONSTRAINT `article_blog_category_translation_id_article_blog_category_id` FOREIGN KEY (`id`) REFERENCES `article_blog_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `article_category_translation`
--
ALTER TABLE `article_category_translation`
  ADD CONSTRAINT `article_category_translation_id_article_category_id` FOREIGN KEY (`id`) REFERENCES `article_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `article_comment`
--
ALTER TABLE `article_comment`
  ADD CONSTRAINT `article_comment_article_id_article_id` FOREIGN KEY (`article_id`) REFERENCES `article` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `article_comment_parent_article_comment_id_article_comment_id` FOREIGN KEY (`parent_article_comment_id`) REFERENCES `article_comment` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `article_comment_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `article_file`
--
ALTER TABLE `article_file`
  ADD CONSTRAINT `article_file_article_id_article_id` FOREIGN KEY (`article_id`) REFERENCES `article` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `article_file_translation`
--
ALTER TABLE `article_file_translation`
  ADD CONSTRAINT `article_file_translation_id_article_file_id` FOREIGN KEY (`id`) REFERENCES `article_file` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `article_group`
--
ALTER TABLE `article_group`
  ADD CONSTRAINT `article_group_article_id_article_id` FOREIGN KEY (`article_id`) REFERENCES `article` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `article_group_group_id_sf_guard_group_id` FOREIGN KEY (`group_id`) REFERENCES `sf_guard_group` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `article_index`
--
ALTER TABLE `article_index`
  ADD CONSTRAINT `article_index_id_article_id` FOREIGN KEY (`id`) REFERENCES `article` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `article_permission`
--
ALTER TABLE `article_permission`
  ADD CONSTRAINT `article_permission_article_id_article_id` FOREIGN KEY (`article_id`) REFERENCES `article` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `article_permission_permission_id_sf_guard_permission_id` FOREIGN KEY (`permission_id`) REFERENCES `sf_guard_permission` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `article_photo`
--
ALTER TABLE `article_photo`
  ADD CONSTRAINT `article_photo_article_id_article_id` FOREIGN KEY (`article_id`) REFERENCES `article` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `article_photo_translation`
--
ALTER TABLE `article_photo_translation`
  ADD CONSTRAINT `article_photo_translation_id_article_photo_id` FOREIGN KEY (`id`) REFERENCES `article_photo` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `article_preferred_article`
--
ALTER TABLE `article_preferred_article`
  ADD CONSTRAINT `article_preferred_article_preferred_id_article_id` FOREIGN KEY (`preferred_id`) REFERENCES `article` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `article_tag_translation`
--
ALTER TABLE `article_tag_translation`
  ADD CONSTRAINT `article_tag_translation_id_article_tag_id` FOREIGN KEY (`id`) REFERENCES `article_tag` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `article_translation`
--
ALTER TABLE `article_translation`
  ADD CONSTRAINT `article_translation_id_article_id` FOREIGN KEY (`id`) REFERENCES `article` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `article_translation_index`
--
ALTER TABLE `article_translation_index`
  ADD CONSTRAINT `article_translation_index_id_article_translation_id` FOREIGN KEY (`id`) REFERENCES `article_translation` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `art_configuration_translation`
--
ALTER TABLE `art_configuration_translation`
  ADD CONSTRAINT `art_configuration_translation_id_art_configuration_id` FOREIGN KEY (`id`) REFERENCES `art_configuration` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `class_has_user`
--
ALTER TABLE `class_has_user`
  ADD CONSTRAINT `class_has_user_class_id_teacher_class_id` FOREIGN KEY (`class_id`) REFERENCES `teacher_class` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `class_has_user_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `friend`
--
ALTER TABLE `friend`
  ADD CONSTRAINT `friend_friend_id_friend_id` FOREIGN KEY (`friend_id`) REFERENCES `friend` (`id`),
  ADD CONSTRAINT `friend_friend_id_sf_guard_user_id` FOREIGN KEY (`friend_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `friend_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `friend_blacklist`
--
ALTER TABLE `friend_blacklist`
  ADD CONSTRAINT `friend_blacklist_ignored_user_id_sf_guard_user_id` FOREIGN KEY (`ignored_user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `friend_blacklist_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `game`
--
ALTER TABLE `game`
  ADD CONSTRAINT `game_teacher_id_sf_guard_user_id` FOREIGN KEY (`teacher_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `game_teacher_permission`
--
ALTER TABLE `game_teacher_permission`
  ADD CONSTRAINT `game_teacher_permission_game_id_game_id` FOREIGN KEY (`game_id`) REFERENCES `game` (`id`),
  ADD CONSTRAINT `game_teacher_permission_teacher_id_sf_guard_user_id` FOREIGN KEY (`teacher_id`) REFERENCES `sf_guard_user` (`id`),
  ADD CONSTRAINT `gssi` FOREIGN KEY (`sf_guard_user_permission_id`) REFERENCES `sf_guard_permission` (`id`);

--
-- Ograniczenia dla tabeli `i18n_translations`
--
ALTER TABLE `i18n_translations`
  ADD CONSTRAINT `i18n_translations_cat_id_i18n_category_cat_id` FOREIGN KEY (`cat_id`) REFERENCES `i18n_category` (`cat_id`) ON DELETE CASCADE;

--
-- Ograniczenia dla tabeli `internal_category`
--
ALTER TABLE `internal_category`
  ADD CONSTRAINT `internal_category_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `internal_message`
--
ALTER TABLE `internal_message`
  ADD CONSTRAINT `iiii_3` FOREIGN KEY (`internal_conversation_id`) REFERENCES `internal_conversation` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `internal_message_author_id_sf_guard_user_id` FOREIGN KEY (`author_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE SET NULL ON UPDATE SET NULL,
  ADD CONSTRAINT `internal_message_receiver_id_sf_guard_user_id` FOREIGN KEY (`receiver_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE SET NULL ON UPDATE SET NULL;

--
-- Ograniczenia dla tabeli `internal_message_category`
--
ALTER TABLE `internal_message_category`
  ADD CONSTRAINT `iiii_6` FOREIGN KEY (`internal_message_id`) REFERENCES `internal_message` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `iiii_7` FOREIGN KEY (`internal_category_id`) REFERENCES `internal_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `internal_message_category_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `invitation`
--
ALTER TABLE `invitation`
  ADD CONSTRAINT `invitation_inviter_id_sf_guard_user_id` FOREIGN KEY (`inviter_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `layout_layout_param`
--
ALTER TABLE `layout_layout_param`
  ADD CONSTRAINT `layout_layout_param_layout_id_layout_id` FOREIGN KEY (`layout_id`) REFERENCES `layout` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `layout_layout_param_param_id_layout_param_id` FOREIGN KEY (`param_id`) REFERENCES `layout_param` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `layout_param`
--
ALTER TABLE `layout_param`
  ADD CONSTRAINT `layout_param_layout_id_layout_id` FOREIGN KEY (`layout_id`) REFERENCES `layout` (`id`);

--
-- Ograniczenia dla tabeli `log_decision`
--
ALTER TABLE `log_decision`
  ADD CONSTRAINT `log_decision_round_id_round_id` FOREIGN KEY (`round_id`) REFERENCES `round` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `log_decision_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `log_event`
--
ALTER TABLE `log_event`
  ADD CONSTRAINT `log_event_round_id_round_id` FOREIGN KEY (`round_id`) REFERENCES `round` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `log_event_team_id_team_id` FOREIGN KEY (`team_id`) REFERENCES `team` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `log_event_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `log_message_displayed`
--
ALTER TABLE `log_message_displayed`
  ADD CONSTRAINT `log_message_displayed_message_id_message_id` FOREIGN KEY (`message_id`) REFERENCES `message` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `menu_item`
--
ALTER TABLE `menu_item`
  ADD CONSTRAINT `menu_item_menu_id_menu_group_id` FOREIGN KEY (`menu_id`) REFERENCES `menu_group` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `menu_item_submenu_id_menu_group_id` FOREIGN KEY (`submenu_id`) REFERENCES `menu_group` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `menu_item_translation`
--
ALTER TABLE `menu_item_translation`
  ADD CONSTRAINT `menu_item_translation_id_menu_item_id` FOREIGN KEY (`id`) REFERENCES `menu_item` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `message`
--
ALTER TABLE `message`
  ADD CONSTRAINT `message_round_id_round_id` FOREIGN KEY (`round_id`) REFERENCES `round` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `message_team_id_team_id` FOREIGN KEY (`team_id`) REFERENCES `team` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `message_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `message_center`
--
ALTER TABLE `message_center`
  ADD CONSTRAINT `message_center_layout_id_layout_id` FOREIGN KEY (`layout_id`) REFERENCES `layout` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `message_center_message_channel_id_message_channel_id` FOREIGN KEY (`message_channel_id`) REFERENCES `message_channel` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `message_center_file`
--
ALTER TABLE `message_center_file`
  ADD CONSTRAINT `message_center_file_message_center_id_message_center_id` FOREIGN KEY (`message_center_id`) REFERENCES `message_center` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `message_center_file_translation`
--
ALTER TABLE `message_center_file_translation`
  ADD CONSTRAINT `message_center_file_translation_id_message_center_file_id` FOREIGN KEY (`id`) REFERENCES `message_center_file` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `message_multisend_history`
--
ALTER TABLE `message_multisend_history`
  ADD CONSTRAINT `message_multisend_history_message_center_id_message_center_id` FOREIGN KEY (`message_center_id`) REFERENCES `message_center` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `message_multisend_history_newsletter_user_id_newsletter_user_id` FOREIGN KEY (`newsletter_user_id`) REFERENCES `newsletter_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `message_multisend_history_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `mmmi` FOREIGN KEY (`message_multisend_type_id`) REFERENCES `message_multisend_type` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `message_multisend_list`
--
ALTER TABLE `message_multisend_list`
  ADD CONSTRAINT `message_multisend_list_message_center_id_message_center_id` FOREIGN KEY (`message_center_id`) REFERENCES `message_center` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `message_multisend_list_newsletter_user_id_newsletter_user_id` FOREIGN KEY (`newsletter_user_id`) REFERENCES `newsletter_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `message_multisend_list_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `mmmi_1` FOREIGN KEY (`message_multisend_type_id`) REFERENCES `message_multisend_type` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `message_template`
--
ALTER TABLE `message_template`
  ADD CONSTRAINT `message_template_message_center_id_message_center_id` FOREIGN KEY (`message_center_id`) REFERENCES `message_center` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `message_template_translation`
--
ALTER TABLE `message_template_translation`
  ADD CONSTRAINT `message_template_translation_id_message_template_id` FOREIGN KEY (`id`) REFERENCES `message_template` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `newsletter_user`
--
ALTER TABLE `newsletter_user`
  ADD CONSTRAINT `newsletter_user_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `round`
--
ALTER TABLE `round`
  ADD CONSTRAINT `round_team_id_team_id` FOREIGN KEY (`team_id`) REFERENCES `team` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `sf_guard_forgot_password`
--
ALTER TABLE `sf_guard_forgot_password`
  ADD CONSTRAINT `sf_guard_forgot_password_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE;

--
-- Ograniczenia dla tabeli `sf_guard_group_permission`
--
ALTER TABLE `sf_guard_group_permission`
  ADD CONSTRAINT `sf_guard_group_permission_group_id_sf_guard_group_id` FOREIGN KEY (`group_id`) REFERENCES `sf_guard_group` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `sf_guard_group_permission_permission_id_sf_guard_permission_id` FOREIGN KEY (`permission_id`) REFERENCES `sf_guard_permission` (`id`) ON DELETE CASCADE;

--
-- Ograniczenia dla tabeli `sf_guard_remember_key`
--
ALTER TABLE `sf_guard_remember_key`
  ADD CONSTRAINT `sf_guard_remember_key_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE;

--
-- Ograniczenia dla tabeli `sf_guard_user_group`
--
ALTER TABLE `sf_guard_user_group`
  ADD CONSTRAINT `sf_guard_user_group_group_id_sf_guard_group_id` FOREIGN KEY (`group_id`) REFERENCES `sf_guard_group` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `sf_guard_user_group_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE;

--
-- Ograniczenia dla tabeli `sf_guard_user_index`
--
ALTER TABLE `sf_guard_user_index`
  ADD CONSTRAINT `sf_guard_user_index_id_sf_guard_user_id` FOREIGN KEY (`id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `sf_guard_user_permission`
--
ALTER TABLE `sf_guard_user_permission`
  ADD CONSTRAINT `sf_guard_user_permission_permission_id_sf_guard_permission_id` FOREIGN KEY (`permission_id`) REFERENCES `sf_guard_permission` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `sf_guard_user_permission_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE;

--
-- Ograniczenia dla tabeli `teacher_class`
--
ALTER TABLE `teacher_class`
  ADD CONSTRAINT `teacher_class_teacher_id_sf_guard_user_id` FOREIGN KEY (`teacher_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `team`
--
ALTER TABLE `team`
  ADD CONSTRAINT `team_game_id_game_id` FOREIGN KEY (`game_id`) REFERENCES `game` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `user_detail`
--
ALTER TABLE `user_detail`
  ADD CONSTRAINT `user_detail_game_id_game_id` FOREIGN KEY (`game_id`) REFERENCES `game` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `user_has_team`
--
ALTER TABLE `user_has_team`
  ADD CONSTRAINT `user_has_team_team_id_team_id` FOREIGN KEY (`team_id`) REFERENCES `team` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `user_has_team_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Ograniczenia dla tabeli `user_message_settings`
--
ALTER TABLE `user_message_settings`
  ADD CONSTRAINT `user_message_settings_message_center_id_message_center_id` FOREIGN KEY (`message_center_id`) REFERENCES `message_center` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `user_message_settings_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
