<?php

class defaultActions extends PluginDefaultActions {

    public function executeIndex() {
        
    }

    public function executeDownloadTeachersSurveySpreadsheet() {
        require_once dirname(__FILE__) . '/../lib/surveyCollection.class.php';
        require_once dirname(__FILE__) . '/../lib/userCollection.class.php';

        $surveys = new surveyCollection();
        $users = new userCollection();
        $usersObj = Doctrine_Core::getTable('sfGuardUser')->createQuery('u')
                ->leftJoin('u.user_details ud')
                ->where('ud.teacher_survey_before IS NOT NULL')
                ->orWhere('ud.teacher_survey_after IS NOT NULL')
                ->execute();

        foreach ($usersObj as $user) {
            $userDetails = $user->getUserDetails()->getFirst();
            $id = $user->getId();
            $surveyData = array(
                'before' => $userDetails->getTeacherSurveyBeforeArray(),
                'after' => $userDetails->getTeacherSurveyAfterArray()
            );
            $userData = array(
                'firstName' => $user->getFirstName(),
                'lastName' => $user->getLastName(),
                'schoolName' => $userDetails->getSchool()
            );

            $surveys->addSurvey($surveyData, $id);
            $users->addUser($userData, $id);
        }

        $this->prepareTeacherSurveySpreadsheet($surveys, $users);

        return sfView::NONE;
    }

    public function prepareTeacherSurveySpreadsheet(surveyCollection $surveys, userCollection $users) {
        require_once(sfConfig::get('sf_plugins_dir') . "/artLibraryPlugin/lib/phpExcel/PHPExcel.php");
        require_once(sfConfig::get('sf_plugins_dir') . "/artLibraryPlugin/lib/phpExcel/PHPExcel/IOFactory.php");

        $fileName = 'survey_teachers_' . time() . '.xls';
        $spreadsheetTitle = 'Ankiety nauczycieli przed oceną';
        $spreadsheetTitle2 = 'Ankiety nauczycieli po ocenie';

        $objPHPExcel = new PHPExcel();
        $objPHPExcel->removeSheetByIndex(0); // remove default empty worksheet
        $surveysSpreadsheet = $objPHPExcel->createSheet();
        $surveysSpreadsheet->setTitle($spreadsheetTitle);

        $spreadsheetUserData = array('Typ ankiety', 'Id', 'Imię', 'Nazwisko', 'Płeć', 'Nazwa szkoły');
        $spreadsheetQuestions = array(
            '1. Jak Pan/Pani sądzi, czy uczniowie wykazują zaangażowanie w rozwijaniu swoich postaw prorynkowych?',
            '2. Czy według Pana/Pani uczniowie są skłonni do podejmowania ryzyka?',
            '3. Jak Pan/Pani sądzi, czy uczniowie są dociekliwi w zdobywaniu nowej wiedzy?',
            '4. Czy według Pana/Pani, uczniowie wykazują postawy przedsiębiorcze?',
            '5. Czy według Pana/Pani, uczniowie wykazują postawy prorynkowe?',
            '6. Jak Pan/Pani ocenia program nauczania edukacji ekonomicznej w ramach realizowanego projektu?',
            '7. Czy uważa Pan/Pani, że gra edukacyjna może być przydatnym narzędziem dla nauczyciela w nauce podstaw ekonomii i przedsiębiorczości?'
        );
        $spreadsheetTopRow = array_merge($spreadsheetUserData, $spreadsheetQuestions);
        $spreadsheetData = array(
            $spreadsheetTopRow
        );

        $ids = $surveys->keys();

        foreach ($ids as $id) {
            $user = $users->getUser($id);
            $surveyTypeArray = array_keys($surveys->getSurvey($id));
            $surveyType = $surveyTypeArray[0];
            $surveyTypeSub = ($surveyType == 'before') ? 1 : 2;
            $answersArray = $surveys->getSurvey($id);

            if (!is_null($answersArray[$surveyType])) {
                $answers = $this->getTeacherSurveyAnswersArray($answersArray[$surveyType], $surveyType);
            } else {
                $answers = false;
            }

            if ($answers) {
                $userData = array($surveyTypeSub, $id, $user['firstName'], $user['lastName'], null, $user['schoolName'],);
                $spreadsheetRow = array_merge($userData, $answers);

                array_push($spreadsheetData, $spreadsheetRow);
            }
        }

        $surveysSpreadsheet2 = $objPHPExcel->createSheet();
        $surveysSpreadsheet2->setTitle($spreadsheetTitle2);

        $spreadsheetQuestions2 = array(
            '1. Jak Pan/Pani sądzi, czy w porównaniu do postawy uczniów z początku zajęć, uczniowie obecnie wykazują zaangażowanie w rozwijaniu swoich postaw przedsiębiorczych?',
            '2. Jak Pan/Pani sądzi, czy w porównaniu do postawy uczniów z początku zajęć, uczniowie obecnie są skłonni do podejmowania ryzyka?',
            '3. Jak Pan/Pani sądzi, czy w porównaniu do postawy uczniów z początku zajęć, uczniowie obecnie są dociekliwi w zdobywaniu wiedzy?',
            '4. Jak Pan/Pani sądzi, czy w porównaniu do postawy uczniów z początku zajęć, obecnie wzrosły postawy przedsiębiorcze?',
            '5. Jak Pan/Pani sądzi, czy w porównaniu do postawy uczniów z początku zajęć, obecnie wzrosły postawy prorynkowe?',
            '6. Jak Pan/Pani ocenia zastosowanie gry symulacyjnej do nauki  podstaw ekonomii i przedsiębiorczości?',
            '7. Czy program okazał się być adekwatny w stosunku do potrzeb uczniów w zakresie edukacji ekonomicznej?',
            '8. Czy po realizacji projektu poleciłby Pan/poleciłaby Pani program edukacji ekonomicznej wraz z grą edukacyjną jako dobre narzędzie wspierające naukę przedmiotu dla innych nauczycieli ekonomii i przedsiębiorczości?',
            '9. Jak Pan/Pani ocenia program nauczania edukacji ekonomicznej w ramach realizowanego projektu?'
        );
        $spreadsheetTopRow2 = array_merge($spreadsheetUserData, $spreadsheetQuestions2);
        $spreadsheetData2 = array(
            $spreadsheetTopRow2
        );

        foreach ($ids as $id) {
            $user = $users->getUser($id);
            $surveyTypeArray = array_keys($surveys->getSurvey($id));
            $surveyType = $surveyTypeArray[1];
            $surveyTypeSub = ($surveyType == 'before') ? 1 : 2;
            $answersArray = $surveys->getSurvey($id);

            if (!is_null($answersArray[$surveyType])) {
                $answers = $this->getTeacherSurveyAnswersArray($answersArray[$surveyType], $surveyType);
            } else {
                $answers = false;
            }

            if ($answers) {
                $userData = array($surveyTypeSub, $id, $user['firstName'], $user['lastName'], null, $user['schoolName'],);
                $spreadsheetRow = array_merge($userData, $answers);

                array_push($spreadsheetData2, $spreadsheetRow);
            }
        }

        $objPHPExcel->getSheetByName($spreadsheetTitle)
                ->fromArray(
                        $spreadsheetData, // The data to set
                        NULL, // Array values with this value will not be set
                        'A1'         // Top left coordinate of the worksheet range where we want to set these values (default is A1)
        );

        $objPHPExcel->getSheetByName($spreadsheetTitle2)
                ->fromArray(
                        $spreadsheetData2, // The data to set
                        NULL, // Array values with this value will not be set
                        'A1'         // Top left coordinate of the worksheet range where we want to set these values (default is A1)
        );

        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $fileName . '"');
        header('Cache-Control: max-age=0');

        $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $writer->save('php://output');
    }

    public function getTeacherSurveyAnswersArray($array, $arrayType) {
        if ($arrayType == 'before') {
            return array(
                isset($array['p1_zaangazowanie']) ? $array['p1_zaangazowanie'] : null,
                isset($array['p2_sklonni']) ? $array['p2_sklonni'] : null,
                isset($array['p3_dociekliwi']) ? $array['p3_dociekliwi'] : null,
                isset($array['p4_postawy_przeds']) ? $array['p4_postawy_przeds'] : null,
                isset($array['p5_postawy_pro']) ? $array['p5_postawy_pro'] : null,
                isset($array['p6_ocena_progr']) ? $array['p6_ocena_progr'] : null,
                isset($array['p7_przydatne']) ? $array['p7_przydatne'] : null
            );
        } else {
            return array(
                isset($array['p1_zaangazowanie_po']) ? $array['p1_zaangazowanie_po'] : null,
                isset($array['p2_sklonni_po']) ? $array['p2_sklonni_po'] : null,
                isset($array['p3_dociekliwi_po']) ? $array['p3_dociekliwi_po'] : null,
                isset($array['p4_postawy_przeds_po']) ? $array['p4_postawy_przeds_po'] : null,
                isset($array['p5_postawy_pro_po']) ? $array['p5_postawy_pro_po'] : null,
                isset($array['p6_ocena_progr_po']) ? $array['p6_ocena_progr_po'] : null,
                isset($array['p7_przydatne_po']) ? $array['p7_przydatne_po'] : null,
                isset($array['p8_czypoleci_po']) ? $array['p8_czypoleci_po'] : null,
                isset($array['p9_ocena_programu_po']) ? $array['p9_ocena_programu_po'] : null
            );
        }
    }

}
