<?php

/**
 * Konfiguracja frontend.
 */
class frontendConfiguration extends sfApplicationConfiguration {

  public function initialize() {
    parent::initialize();

    $this->dispatcher->connect('context.load_factories', array($this, 'listenToLoadFactoriesEvent'));

    ProjectConfiguration::addGameYaml(); 
    
    sfForm::disableCSRFProtection();
  }

  /**
   * Podłączenie do eventa. Dołączenie plików JavaScript.
   *
   * @return void
   * */
  public function listenToLoadFactoriesEvent(sfEvent $event) {
    $response = $event->getSubject()->getResponse();

    // Dołączenie JS z CKEditorem dla admina.
    $user = sfContext::getInstance()->getUser(); 
    
    if ($user->isAdmin() || $user->isTester()) {
          $response->addJavascript('/arteneo-theme/js/ckeditor/ckeditor.js', sfWebResponse::LAST);
    }
  }

  /**
   * Konfiguracja frontendu.
   */
  public function configure() {
    sfConfig::set('sf_app_i18n_dir', array(sfConfig::get('sf_app_i18n_dir'), sfConfig::get('sf_root_dir') . '/i18n'));

//    sfWidgetFormSchema::setDefaultFormFormatterName('Default');
  }

  /**
   * Pobiera liste katalogów dla i18n.
   *
   * @param string $moduleName
   * @return array
   */
  public function getI18NDirs($moduleName) {
    $dirs = array();

    if (is_dir($dir = sfConfig::get('sf_app_module_dir') . '/' . $moduleName . '/i18n'))
      $dirs[] = $dir;

    foreach (sfConfig::get('sf_app_i18n_dir') as $dir)
      if (is_dir($dir))
        $dirs[] = $dir;

    return array_merge(
            $dirs, $this->getPluginSubPaths('/modules/' . $moduleName . '/i18n'), $this->getPluginSubPaths('/i18n')
    );
  }

}
