<?php

/**
 * Nakłada walidację, na pole formularza. 
 * 
 * @param sfForm $form
 * @param type $filedName
 * @return string
 */
function ajaxFieldValidator(sfForm $form, $filedName) {
  $validator = $form->getValidator($filedName);

  $json = json_encode(array('validatorClassName' => get_class($validator),
      'options' => json_encode(array_merge($validator->getOptions(), array('fieldName' => $filedName))),
      'value' => '%value%',
      'translationCatalogue' => $form->getWidgetSchema()->getFormFormatter()->getTranslationCatalogue()));

  $id = $form->getName() . '_' . $filedName;

  if (get_class($validator) == 'sfValidatorChoice') {
    $field = $validator->getOptions();

    $validators = "";

    foreach ($field['choices'] as $choise) {

      $json = json_encode(array('validatorClassName' => get_class($validator),
          'options' => json_encode(array_merge($validator->getOptions(), array('fieldName' => $filedName))),
          'value' => '%value%',
          'translationCatalogue' => $form->getWidgetSchema()->getFormFormatter()->getTranslationCatalogue()));

      $json = str_replace('"%value%"', '$("#' . $id . '_' . $choise . '").attr("value")', $json);

      $validators .= setValidator($id . '_' . $choise, $json);
    }

    return $validators;
  } else {
    $json = str_replace('"%value%"', '$("#' . $id . '").val()', $json);

    return setValidator($id, $json);
  }
}

/**
 * Ustawia walidator. 
 * 
 * @param type $id
 * @param type $json
 * @return string
 */
function setValidator($id, $json) {

  $result = '<script type="text/javascript">/* <![CDATA[ */' . "\n";
  $result .= '$(document).ready(function () {' . "\n";
  $result .= '  $("#' . $id . '").change(function(){' . "\n";
  $result .= '    Validator.onChange(\'' . $id . '\',' . $json . ');' . "\n";
  $result .= '  });' . "\n";
  $result .= '});' . "\n";
  $result .= '/* ]]> */</script>' . "\n";

  return $result;
}

/**
 * Nakłada walidcję na wszystkie pola formularza. 
 * 
 * @param sfForm $form
 * @return type
 */
function ajaxAllFieldsValidators(sfForm $form) {
  $result = "";
  $textAreas = array(
      'test_przed_1',   
      'test_przed_2',
      'test_przed_3',
      'test_przed_4',
      'test_przed_5',
      'test_przed_6',
      'test_przed_7',
      'test_przed_8',
      'test_przed_9',
      'test_przed_10',
      'test_przed_11',
      'test_po_1',   
      'test_po_2',
      'test_po_3',
      'test_po_4',
      'test_po_5',
      'test_po_6',
      'test_po_7',
      'test_po_8',
      'test_po_9',
      'test_po_10',
      'test_po_11',
      
  );
  foreach ($form as $fieldName => $field) {
    
    if ($fieldName !== 'logo_marki' && !in_array($fieldName, $textAreas))
      $result .= ajaxFieldValidator($form, $fieldName);
  }
  return $result;
}

/**
 * Nakłada automatyczny zapis, na pole formularza. 
 * 
 * @param sfForm $form
 * @param type $filedName
 * @return string
 */
function ajaxSave(sfForm $form, $filedName, $onChange = FALSE) {
  $validator = $form->getValidator($filedName);

  $json = json_encode(array('validatorClassName' => get_class($validator),
      'options' => json_encode(array_merge($validator->getOptions(), array('fieldName' => $filedName))),
      'value' => '%value%',
      'translationCatalogue' => $form->getWidgetSchema()->getFormFormatter()->getTranslationCatalogue()));

  $id = $form->getName() . '_' . $filedName;

  if (get_class($validator) == 'sfValidatorChoice') {
    $field = $validator->getOptions();
    $validators = "";

    foreach ($field['choices'] as $choise) {

      $json = json_encode(array('validatorClassName' => get_class($validator),
          'options' => json_encode(array_merge($validator->getOptions(), array('fieldName' => $filedName))),
          'value' => '%value%',
          'translationCatalogue' => $form->getWidgetSchema()->getFormFormatter()->getTranslationCatalogue()));

      $json = str_replace('"%value%"', '$("#' . $id . '_' . $choise . '").attr("value")', $json);

      $validators .= setSaveOnChange($id . '_' . $choise, $json);
    }

    return $validators;
  } else {
    $json = str_replace('"%value%"', '$("#' . $id . '").val()', $json);

    if ($onChange)
      return setSaveOnChange($id, $json);
    else
      return generateFunction($id, false, $json);
  }
}

function ajaxSaveDecision(sfForm $form, $filedName) {

  return ajaxSave($form, $filedName);
}

function setSaveOnChange($id, $json) {

  $result = '<script type="text/javascript">/* <![CDATA[ */' . "\n";
  $result .= '$(document).ready(function () {' . "\n";
  $result .= '  $("#' . $id . '").change(function(){' . "\n";
  $result .= '    Validator.onChangeSave(\'' . $id . '\',' . $json . ');' . "\n";
  $result .= '  });' . "\n";
  $result .= '});' . "\n";
  $result .= '/* ]]> */</script>' . "\n";

  return $result;
}

function generateFunction($id,  $header = false, $json = array()) {

  if (!$header) {
    $result = '<script type="text/javascript">/* <![CDATA[ */' . "\n";
    $result .= 'function ' . sfInflector::camelize($id) . '(){' . "\n";
    $result .= '    Validator.saveDecision(\'' . $id . '\',' . $json . ');' . "\n";
    $result .= '}' . "\n";
    $result .= '/* ]]> */</script>' . "\n";
  } else {
    $result = sfInflector::camelize($id) . '();' . "\n";
  }

  return $result;
}

/**
 * Nakłada automatyczny zapis na wszystkie pola formularza. 
 * 
 * @param sfForm $form
 * @return type
 */
function ajaxAllFieldsSaveOnChange(sfForm $form) {
  $result = "";

  foreach ($form as $fieldName => $field) {

    $result .= ajaxSaveOnChange($form, $fieldName);
  }

  return $result;
}