<?php

/**
 * Klasa odpowiadająca za obsługę ajaxową widgetów.   
 * 
 * @version     0.1-DEV
 */
class ajaxFormValidatorActions extends sfActions {

    /**
     * Akcja do validacji i odświerzania informacji w widgetach. 
     * @return type
     */
    public function executeValidateJSON(sfWebRequest $request) {
        $this->forward404If(!$request->isXmlHttpRequest());
        $this->forward404If(is_null($validatorClassName = $this->getRequestParameter('validatorClassName')));

        sfContext::getInstance()->getConfiguration()->loadHelpers(array('View'));
        $array = object_to_array(json_decode($this->getRequestParameter('options')));

        if ($this->getUser()->isAuthenticated()) {
            $gc = HotelGameController::getInstance();
            $form = $gc->getDecisionForm(false, $this->getUser()->getId());
        } else {
            $gc = null;
            $form = new BaseForm();
        }

        $value = $this->getRequestParameter('value');
        $prepareFunction = 'getInfo' . sfInflector::camelize($array['fieldName']);

        // Rozw. Problem z validatorem MultiSelecta.
        if (isset($array['choices']))
            $validator = new $validatorClassName(array('choices' => $array['choices']));
        else
            $validator = new $validatorClassName();

        $validator->setOptions($array);
        $data['messages'] = array();

        try {
            $value = $validator->clean($value);
            $data['isValid'] = true;
        } catch (sfValidatorError $validatorError) {
            $data['isValid'] = false;
            sfContext::getInstance()->getConfiguration()->loadHelpers(array('I18N'));
            if (strpos($validatorError->getMessage(), 'is too long (14')) {
                $data['messages'][] = "Nazwa hotelu nie może przekraczać 14 znaków";
            } elseif (($array['fieldName'] == 'pokoje_standard' || $array['fieldName'] == 'pokoje_lux') && $validatorError->getMessage() == 'Invalid.') {
                $data['messages'][] = "Nie można kupić takiej ilości pokoi";
            } else {
                $data['messages'][] = str_replace('%value%', $value, __($validatorError->getMessage(), array(), $this->getRequestParameter('translationCatalogue')));
            }
        }

        
        if ($data['isValid']) {

            if (!is_numeric($value)) {
                $value = 0;
            }
            
            if (method_exists('HotelGameView', $prepareFunction)) {
                $info = HotelGameView::$prepareFunction($gc, $value, $array['fieldName']);
            } else {
                $info = $form->getWidgetSchema()->getInfo($array['fieldName']);
            }

            $data['info'] = $info;

            $prepareFunction = 'getAbsurdity' . sfInflector::camelize($array['fieldName']);

            if (method_exists('HotelGameView', $prepareFunction)) {
                $absurdity = HotelGameView::$prepareFunction($gc, $value, $array['fieldName']);
            } else {
                $absurdity = null;
            }

            $data['absurdity'] = $absurdity;
        }

        $data['adviser'] = $this->getAdviser($gc, $array['fieldName']); 

        $json = json_encode($data);

        if (!$this->getRequest()->isXmlHttpRequest()) {
            var_dump($json);
            die();
        } else {
            $this->getResponse()->setHttpHeader('Content-type', 'application/json');
        }

        return $this->renderText($json);
    }

    public function getAdviser(HotelGameController $gc, $fieldName) {

        if ($gc->rEQ(1)){

         if ($fieldName === 'pokoje_standard' && !$gc->e('adviser_pokoje_standard_hotel_zapisz', 'decision')) {
           $gc->s('adviser_pokoje_standard_hotel_zapisz', TRUE, 'decision');
           $gc->getGameData()->save();
           return array(__t("pokoje_standard_hotel_zapisz", array(), 'adviser'));
         }

     }
     return array(); 
 }
}