<?php

class articleActions extends PluginarticleActions {
  
  /*
   * Akcja wyświetlająca artykuł.
   *
   * @params sfWebRequest $request;
   * - slug , slug artykułu.
   */

  public function executeShow(sfWebRequest $request) {
    $slug = $request->getParameter('slug');
    $this->article = Doctrine::getTable('Article')->getArticleBySlug($slug);

    $editPermissionsEditor = $this->getUser()->hasPermission('article_edit');
    $editPermissionsAdmin = $this->getUser()->hasPermission('article_edit');

    if (empty($this->article) || !$this->article->isDisplayedAndActive()) {
      $slug = Doctrine::getTable('Article')->getOtherCultureSlugBySlug($slug);

      if ($slug)
        $this->redirect('@article_show?slug=' . $slug);

//      $this->getUser()->setNotice('Podany artykuł nie istnieje lub jest nieaktywny!');
      $this->redirect('@homepage');
    }

    $this->articleId = $this->article->getId();

    if ($this->getUser()->hasInlineEdit()) {

      $article = Doctrine::getTable('Article')->findOneById($this->articleId);
      $this->form = new FmArticleInlineForm($article);

    }

    $this->permissions = false;

    if ($editPermissionsEditor)
      $this->permissions = true;

    if ($editPermissionsAdmin)
      $this->permissions = true;

    if ($this->article)
      $articlePermissions = $this->article->getPermissionsNames();

    if (!empty($articlePermissions)) {
      if ($this->getUser()->isAuthenticated())
        $userPermissions = $this->getUser()->getGuardUser()->getPermissionNames();
      else
        return 'NoPermissions';

      $neededPermissions = array_intersect($userPermissions, $articlePermissions);

      if (empty($neededPermissions))
        return 'NoPermissions';
    }

    if (!$request->isXmlHttpRequest()) {
      $response = $this->getResponse();
      $response = ArtConfiguration::setArticleMetaTags($this->article, $response);
    }

    $view = $this->article->getLayout()->getView();

    if ($view != '')
      return $view;
  }
}
