<div class="cke-article-text">
  <ul class="article-by-category">
    <?php if ($articles->count() > 0) :?>
    <?php foreach($articles as $article): ?>
      <li>
        <h2 class="article title fl w100">
          <?php echo link_to($article->getTitle(), '@article_show?slug=' . $article->getSlug(), array('class' => 'link')); ?>
        </h2>
        <span class="fl w100">
          <?php echo $article->getCreatedAt()." - ".$article->getSfGuardUserEditor()->getFirstName()." ".$article->getSfGuardUserEditor()->getLastName();?>
        </span>
        <div class="cke-article-text article content fl w100">
          <?php echo htmlspecialchars_decode($article->getShortDescription()) ?>
        </div>
        <span>
          <?php echo link_to(__('Więcej'), '@article_show?slug=' . $article->getSlug(), array('class' => 'link fr')); ?>
        </span>
      </li>
    <?php endforeach ?>
    <?php else:?>
      <span class="fl w100">
        <?php echo __('Brak wyników');?>
      </span>
    <?php endif?>
  </ul>
</div>