<?php

class frontendManagementActions extends PluginFrontendManagementActions {

    /**
     * Akcja AJAX edycji artykulu.
     * routing.yml: fm_article_edit
     * Potrzebne prawa: [admin, article_edit]
     * (Poza security.yml poniewaz chcemy inaczej obsluzyc brak praw)
     * 
     * @param sfWebRequest $request
     */
    public function executeArticleEdit(sfWebRequest $request) {

        if (!($this->getUser()->isAdmin() || $this->getUser()->isTester())) {
            return $this->renderText(Redirector::get('AjaxNoPermission', array('user' => $this->getUser())));
        }

        $this->articleId = $request->getParameter('id');
        $article = Doctrine::getTable('Article')->findOneById($this->articleId);
        if (!$article) {
            return $this->renderText(Redirector::get('FmArticleNotExist', array('user' => $this->getUser())));
        }

        $this->form = new FmArticleForm($article);

        if ($this->form->bindFromRequestAndSave($request)) {
            $this->fmClearCache();
            return $this->renderText(Redirector::get('FmArticleEditSuccess', array('user' => $this->getUser())));
        }

        // Ustaw parametry dla url w formularzu (aby przekazac np. id)
        $this->formUrlParameters = $this->getFormUrlParameters($request);
    }

    public function executeUploadFile(sfWebRequest $request) {
        $handler = new UploadHandler();
        die();

        $fileSystem = new sfFileSystem();
        $this->setHttpHeaders();

        $targetDir = sfConfig::get('sf_upload_dir') . DIRECTORY_SEPARATOR . 'loga/';

        $fileSystem->mkdirs($targetDir, 0755);

        $cleanupTargetDir = false;
        $maxFileAge = 5 * 3600;
        @set_time_limit(5 * 60);

        $chunk = $request->getParameter('chunk');
        $chunks = $request->getParameter('chunks');
        $name = $request->getParameter('name');

        $chunk = isset($chunk) ? intval($chunk) : 0;
        $chunks = isset($chunks) ? intval($chunks) : 0;
        $fileName = isset($name) ? $name : '';

        $fileName = preg_replace('/[^\w\._]+/', '_', $fileName);

        if ($chunks < 2 && file_exists($targetDir . DIRECTORY_SEPARATOR . $fileName)) {
            $ext = strrpos($fileName, '.');
            $fileName_a = substr($fileName, 0, $ext);
            $fileName_b = substr($fileName, $ext);
            $count = 1;

            while (file_exists($targetDir . DIRECTORY_SEPARATOR . $fileName_a . '_' . $count . $fileName_b))
                $count++;

            $fileName = $fileName_a . '_' . $count . $fileName_b;
        }

        $filePath = $targetDir . DIRECTORY_SEPARATOR . $fileName;

        if (!file_exists($targetDir))
            $fileSystem->mkdirs($targetDir);

        if ($cleanupTargetDir) {
            if (is_dir($targetDir) && ($dir = opendir($targetDir))) {
                while (($file = readdir($dir)) !== false) {
                    $tmpfilePath = $targetDir . DIRECTORY_SEPARATOR . $file;

                    if (preg_match('/\.part$/', $file) && (filemtime($tmpfilePath) < time() - $maxFileAge) && ($tmpfilePath != "{$filePath}.part")) {
                        @unlink($tmpfilePath);
                    }
                }
                closedir($dir);
            } else {
                die('{"jsonrpc" : "2.0", "error" : {"code": 100, "message": "Failed to open temp directory."}, "id" : "id"}');
            }
        }

        if ($request->getHttpHeader('Content-Type', '')) {
            $contentType = $request->getHttpHeader('Content-Type', '');
        }

        if ($request->getHttpHeader('HTTP_CONTENT_TYPE')) {
            $contentType = $request->getHttpHeader('HTTP_CONTENT_TYPE');
        }

        if ($request->getHttpHeader('CONTENT_TYPE')) {
            $contentType = $request->getHttpHeader('CONTENT_TYPE');
        }

        $files = $request->getFiles();

        if (strpos($contentType, "multipart") !== false) {
            if (isset($files['file']['tmp_name']) && is_uploaded_file($files['file']['tmp_name'])) {

                $out = @fopen("{$filePath}.part", $chunk == 0 ? "wb" : "ab");

                if ($out) {
                    $in = @fopen($files['file']['tmp_name'], "rb");

                    if ($in) {
                        while ($buff = fread($in, 4096))
                            fwrite($out, $buff);
                    } else
                        die('{"jsonrpc" : "2.0", "error" : {"code": 101, "message": "Failed to open input stream."}, "id" : "id"}');

                    @fclose($in);
                    @fclose($out);
                    @unlink($files['file']['tmp_name']);
                } else
                    die('{"jsonrpc" : "2.0", "error" : {"code": 102, "message": "Failed to open output stream."}, "id" : "id"}');
            } else
                die('{"jsonrpc" : "2.0", "error" : {"code": 103, "message": "Failed to move uploaded file."}, "id" : "id"}');
        } else {

            $out = @fopen("{$filePath}.part", $chunk == 0 ? "wb" : "ab");

            if ($out) {
                $in = @fopen("php://input", "rb");

                if ($in) {
                    while ($buff = fread($in, 4096))
                        fwrite($out, $buff);
                } else
                    die('{"jsonrpc" : "2.0", "error" : {"code": 101, "message": "Failed to open input stream."}, "id" : "id"}');

                @fclose($in);
                @fclose($out);
            } else
                die('{"jsonrpc" : "2.0", "error" : {"code": 102, "message": "Failed to open output stream."}, "id" : "id"}');
        }

        if (!$chunks || $chunk == $chunks - 1) {
            $fileSystem->rename("{$filePath}.part", $filePath);
        }

        die('{"jsonrpc" : "2.0", "result" : null, "id" : "id"}');
    }

}
