<?php

/**
 * Frontendowa edycja tłumaczeń
 */
class i18nTranslationsFrontendActions extends PluginI18nTranslationsFrontendActions {
  /** Kategorie * */

  /**
   * Akcja AJAX edycji pojedynczego tlumaczenia. Przekazywanie wartosci do
   * formularza przez options w routing lub request.
   * routing.yml: art_i18n_single_translation_edit
   * Potrzebne prawa: [admin, translation_edit]
   * (Poza security.yml poniewaz chcemy inaczej obsluzyc brak praw)
   *
   * @param sfWebRequest $request
   */
  public function executeI18nSingleTranslationEdit(sfWebRequest $request) {
    $this->modal = true;
    $this->info = false;
    $this->catalogue = $request->getParameter('catalogue', 'messages');

    if (!$this->getRequest()->isXmlHttpRequest()) {
      $this->redirect(Redirector::get('NotXmlHttp'));
    }

    if (!$this->checkPermissions(array('admin', 'translation_edit'))) {
      return $this->renderText(Redirector::get('AjaxNoPermission', array('user' => $this->getUser())));
    }

    if ($request->hasParameter('id')) {
      $this->page = $request->getParameter('page');
      $transObject = Doctrine::getTable('i18nTranslations')->findOneById($request->getParameter('id'));

      $this->form = new I18nTranslationsFrontendForm($transObject);

      if ($request->hasParameter($this->form->getName())) {
        // Formularz nie przekazuje source, a jest potrzebny
        $params = $request->getParameter($this->form->getName());
        $params['source'] = $transObject->getSource();
        $request->setParameter($this->form->getName(), $params);
      }
    } else {
      $this->form = new i18nTranslationsNewForm();

      if ($request->hasParameter($this->form->getName())) {
        // Formularz nie przekazuje source, a jest potrzebny

        $params = $request->getParameter($this->form->getName());
        $params['source'] = $request->getParameter('text');

        $request->setParameter($this->form->getName(), $params);
      }
    }

    if ($request->hasParameter('text')) {
      $this->form->setDefault('source', $request->getParameter('text'));
    }


    if ($request->hasParameter($this->form->getName())) {

      $this->form->bindFromRequest($request);

      if ($this->form->isValid()) {

//        if ($this->form->isNew()) {
          $catalogue = $request->getParameter('catalogue');
          $lang = $this->getUser()->getCulture();


          $catalogue = Doctrine::getTable('i18nCategory')->findOneByName("$catalogue.$lang");

          if (!$catalogue) {
            $this->getUser()->setNotice("Kategoria o nazwie : " . $request->getParameter('catalogue') . '.' . $lang . ' nie istnieje w bazie danych.');
            $catalogue = Doctrine::getTable('i18nCategory')
                    ->createQuery('tc')
                    ->where('tc.name = ?', 'messages.' . $lang)
                    ->fetchOne();
          }
          $save = $this->form->saveObject($catalogue);
//        } else {
//          $save = $this->form->save();
//        }


        $this->info = 'success';

        if (isset($save) && !is_null($save) ? $save : true) {
          $this->modal = false;
        } else {
          $this->modal = false;
        }
      } else {
        $this->modal = false;
        $this->info = 'error';
      }
    }
    $this->clearCache();

    // Ustaw parametry dla url w formularzu (aby przekazac opcje np. category_id)
    $this->formUrlParameters = $this->getFormUrlParameters($request);
  }

  /**
   * Akcja AJAX dla tlumaczen we frontendzie.
   * routing.yml: art_i18nTranslations_list
   * Potrzebne prawa: [admin, translation_edit]
   * (Poza security.yml poniewaz chcemy inaczej obsluzyc brak praw)
   *
   * @param sfWebRequest $request
   */
  public function executeI18nTranslationsList(sfWebRequest $request) {
    if (!$this->getRequest()->isXmlHttpRequest()) {
      $this->redirect(Redirector::get('NotXmlHttp'));
    }

    if (!$this->checkPermissions(array('admin', 'translation_edit'))) {
      return $this->renderText(Redirector::get('AjaxNoPermission', array('user' => $this->getUser())));
    }

    $this->pager = new sfDoctrinePager('i18nTranslations', sfConfig::get('app_i18n_elements', 10));

    $this->pager->setQuery(Doctrine::getTable('i18nTranslations')->createQuery('t')
                    ->leftJoin('t.Category c')
//                    ->where('c.name LIKE ?', 'frontend%')
                    ->orderBy('c.name ASC'));

    $this->pager->setPage($request->getParameter('page', 1));
    $this->pager->init();
  }

  /**
   * Funkcja zwraca string parametrow dla url formularza
   * W parametrach uwzglednia:
   * - 'id'
   * - 'text'
   *
   * @param array $formOptions
   * @return string
   */
  public function getFormUrlParameters($request) {
    $parameters = array();

    if ($request->hasParameter('id')) {
      $parameters[] = 'id=' . $request->getParameter('id');
    }
    if ($request->hasParameter('text')) {
      $parameters[] = 'text=' . $request->getParameter('text');
    }

    return (!empty($parameters) ? '?' . implode('&', $parameters) : '');
  }

  /**
   * Funkcja przeznaczona do zmiany, jesli chcemy ograniczyc zakres czyszczenia
   * cache po zmianie artykulow. Wywoluje sie po dodaniu, edycji, usunieciu
   * artykulow, referencji, kategorii.
   */
  public function clearCache() {
    artTask::clearCache();
  }

  /**
   * Funkcja sprawdza czy user ma prawa podane w tablicy $parmissions
   * @param array $permissions
   * @return boolean
   */
  protected function checkPermissions($permissions) {
    return $this->getUser()->hasPermission($permissions, false);
  }

}
