<?php

/**
 * Klasa z akcjami do obsługi Wiadomości Gry.
 */
class messageActions extends artActions {

  /**
   * Wyświetla widok z treścią wiaodmosći.
   *
   * @param sfWebRequest $request
   * @return string
   * @throws sfException
   */
  public function executeShow(sfWebRequest $request) {
    
    $messageID = $request->getParameter('id', false);

    if ($messageID) {
      $this->message = Doctrine::getTable('Message')->findOneById($messageID);
    }

    $this->message->setStatus(HotelGameMessage::READ);
    $this->message->save();

    if (!$this->message) {
      throw new sfException('Wiadomość o id : ' . $messageID . ' nie istnieje. ');
      return sfView::NONE;
    }

    $this->setControllerJsonResponse($request, HotelGameController::getInstance());
  }

  /**
   * wyświetla listę otrzymanych wiaodmosći.
   *
   * @param sfWebRequest $request
   * @return string
   */
  public function executeMessageList(sfWebRequest $request) {
    
    $this->gameController = HotelGameController::getInstance();
    
    if ($this->gameController->getTabUniqueName() != 'mapa'){
      $this->redirect('@panelGry_gameController'); 
    }
    
    $this->filter = $this->getRequestParameter('filter', null);
    $teamId = $this->getUser()->getActiveTeamId();
    $userId = $this->getUser()->getId();


    if ($teamId) {

      if ($this->gameController->getGameData()->hasLastRound()) {
        $activeRoundRecord = $this->gameController->getGameData()->getLastRound();
        $this->roundId = $activeRoundRecord->getId();
      }

      $this->readMessages = Doctrine::getTable('Message')
              ->getUserMessages($teamId, $userId, HotelGameMessage::READ, $this->filter);

      $this->unreadMessages = Doctrine::getTable('Message')
              ->getUserMessages($teamId, $userId, HotelGameMessage::NOT_READ, $this->filter);
    } else {
      return sfView::NONE;
    }

    $this->setControllerJsonResponse($request, $this->gameController);
  }

   public function getAdviser(HotelGameController $gc) {
    

    if (!$gc->e('adviser_runda_2_3', 'decision') && $gc->gRN() == 2) {
        $gc->s('adviser_runda_2_3', TRUE, 'decision');
        $gc->getGameData()->save();
        return array(__t("adviser_runda_2_3", array(), 'adviser'));
    }

    return array();
  }
  
  public function setControllerJsonResponse(sfWebRequest $request, HotelGameController $gc = null,  $template = 'Success') {

    $buildingsHtml = $this->getHtml('buildings');
    $statusHtml = $this->getHtml('statusBar');
    $accountManagement = $this->getHtml('accountManagement');
    $messageHtml = $this->getHtml('messages');
    $raportsHtml = $this->getHtml('raports');

    $response = array(
        'Components' => array(
            'Adviser' => array(
                'JSON' =>
                array('value' => array(
                        'Adviser.set' => $this->getAdviser($gc),
                    ))
            ),
            'GameStatus' => array(
                'JSON' =>
                array('value' => array(
                        'GameStatus.setHtml' => array($statusHtml),
                    )),
            ),
            'Buildings' => array(
                'JSON' =>
                array('value' => array(
                        'Building.setHtml' => array($buildingsHtml),
                    )),
            ),
            'AccountManagement' => array(
                'JSON' =>
                array('value' => array(
                        'AccountManagement.setHtml' => array($accountManagement),
                    )),
            ),
            'Message' => array(
                'JSON' =>
                array('value' => array(
                        'Message.setHtml' => array($messageHtml),
                    )),
            ),
            'Raport' => array(
                'JSON' =>
                array('value' => array(
                        'Raport.setHtml' => array($raportsHtml),
                    )),
            ),
        ),
        'HTML' => array(
            'id' => null,
            'value' => $this->getHtmlContent($this, $template)
        ),
        'NOTICE' => array(
            'type' => 'info',
            'value' => $this->getUser()->getFlash('notice')
        ),
    );

    $this->setJsonResponse($response);
  }

  public function getHtml($action) {
    $controller = sfContext::getInstance()->getController();

    return $controller->getPresentationFor('panelGry', $action);
  }

}