<?php
/**
 * Komponenty służące do obsługi wiadomosci GRY.
 */

class messageComponents extends sfComponents {

    /**
     * Komponent wczytujący treść wiadomośći, która zostaje zapisywana do bay danych podczas wysyłania.
     *
     * @throws sfException
     */
    public function executeMessage(){
        $this->message = Doctrine_Core::getTable('Article')->getArticleByUniqueName($this->uniqueName);

        if ($this->message == null){
            throw new sfException('Artykuł o podanej unikalnej nazwie (' . $this->uniqueName . ') nie istnieje w bazie danych.');
        }
    }

    /**
     * Komponent wyświetla listę otrzymanych wiaodmosći.
     *
     * @param sfWebRequest $request
     * @return string
     */
    public function executeInbox(sfWebRequest $request){
        $teamId = $this->getUser()->getActiveTeamId();
        $userId = $this->getUser()->getId();

        if ($teamId){

            $this->readMessages = Doctrine::getTable('Message')
                ->getUserMessages($teamId, $userId, HotelGameMessage::READ);

            $this->unreadMessages = Doctrine::getTable('Message')
                ->getUserMessages($teamId, $userId, HotelGameMessage::NOT_READ);

        } else {
            return sfView::NONE;
        }
    }
}