<?php

/**
 * Akcje obslugi panelu gry
 */
class panelGryActions extends artActions {

  public function executeSaveDecision(sfWebRequest $request) {

    $this->forward404If(!$request->isXmlHttpRequest());
    $this->forward404If(is_null($validatorClassName = $this->getRequestParameter('validatorClassName')));

    sfContext::getInstance()->getConfiguration()->loadHelpers(array('View'));

    $array = object_to_array(json_decode($this->getRequestParameter('options')));
    $value = $this->getRequestParameter('value');

    $validator = new $validatorClassName();
    $validator->setOptions($array);

    $name = $array['fieldName'];
    $data['messages'] = array();

    sfContext::getInstance()->getConfiguration()->loadHelpers(array('I18N'));

    if ($this->getUser()->isAuthenticated()) {
      $gc = HotelGameController::getInstance();
    } else {
      $this->forward404();
    }

    try {
      $value = $validator->clean($value);
      $data['isValid'] = true;
    } catch (sfValidatorError $validatorError) {
      $data['isValid'] = false;
      $data['messages'][] = str_replace('%value%', $value, __($validatorError->getMessage(), array(), $this->getRequestParameter('translationCatalogue')));
    }

    // WALIDACJA GC ?
    $gc->backupGameData();
    $error = $gc->validateDecision($name, $value);

    if ($error instanceof sfValidatorError) {
      $data['isValid'] = false;
      $data['messages'][] = str_replace('%value%', $value, __($error->getMessage(), array(), $this->getRequestParameter('translationCatalogue')));
    }
    $gc->restoreGameData();

    if ($data['isValid']) {

      // Jeśli dane są poprawne
      $gc->makeDecision($name, $value);

      $this->sendCommandToNginx($this->getUser()->getActiveTeamId());

      sfContext::getInstance()->getConfiguration()->loadHelpers(array('Tag'));

      $data['kosztObslugiStale'] = HotelGameView::getInfoKosztZatrudnieniaObslugiStale($gc);
      $data['kosztObslugiZlecenie'] = HotelGameView::getInfoKosztZatrudnieniaObslugiZlecenie($gc);
      $data['kosztAdministracjiStale'] = HotelGameView::getInfoKosztZatrudnieniaAdministracjiStale($gc);
      $data['kosztAdministracjiZlecenie'] = HotelGameView::getInfoKosztZatrudnieniaAdministracjiZlecenie($gc);

      $data['status'] = $this->getHtml('statusBar');
      $data['kredytObrotowy'] = $gc->g('kredyt_obrotowy_kwota', 'decision');
    }

    $json = json_encode($data);

    if (!$this->getRequest()->isXmlHttpRequest()) {
      var_dump($json);
      die();
    } else {
      $this->getResponse()->setHttpHeader('Content-type', 'application/json');
    }

    return $this->renderText($json);
  }

  public function executeBuildings(sfWebRequest $request) {

    $this->setLayout(false);
    $this->setTemplate("Components/buildings");
  }
  
  public function executeToggleMap(sfWebRequest $request) {
    $gameController = HotelGameController::getInstance();
    if ($gameController->g('mapa', 'round', true)) {
        $gameController->s('mapa', 0, 'round');
    } else {
        $gameController->s('mapa', 1, 'round');
    }
    $gameController->getGameData()->save(true);
    $this->redirect('@panelGry_gameController');
  }
  
  public function executeToggleMapHd(sfWebRequest $request) {
    $gameController = HotelGameController::getInstance();
    if ($gameController->g('mapa_hd', 'round', true)) {
        $gameController->s('mapa_hd', 0, 'round');
    } else {
        $gameController->s('mapa_hd', 1, 'round');
    }
    $gameController->getGameData()->save(true);
    $this->redirect('@panelGry_gameController');
  }
  
  public function executeToggleMusic(sfWebRequest $request) {
    $gameController = HotelGameController::getInstance();
    if ($gameController->g('muzyka', 'round', true)) {
        $gameController->s('muzyka', 0, 'round');
    } else {
        $gameController->s('muzyka', 1, 'round');
    }
    $gameController->getGameData()->save(true);
    $this->redirect('@panelGry_gameController');
  }

  public function executeMessages(sfWebRequest $request) {

    $teamId = $this->getUser()->getActiveTeamId();
    $userId = $this->getUser()->getId();

    $this->gameController = HotelGameController::getInstance();

    $this->newMessages = false;

    if ($teamId) {
      $this->readMessages = Doctrine::getTable('Message')->getUserMessages($teamId, $userId, HotelGameMessage::READ);
      $this->unreadMessages = Doctrine::getTable('Message')->getUserMessages($teamId, $userId, HotelGameMessage::NOT_READ);

      if ($this->gameController->getGameData()->hasLastRound()) {
        $activeRoundRecord = $this->gameController->getGameData()->getLastRound();

        $newMessages = Doctrine::getTable('Message')->getUserUnreadMessagesForRoundId($activeRoundRecord->getId(), $teamId, $userId);

        $this->newMessages = (count($newMessages) > 0) ? true : false;
      }
    } else {
      return sfView::NONE;
    }

    $this->setLayout(false);
    $this->setTemplate("Components/messages");
  }

  public function executeAccountManagement(sfWebRequest $request) {

    $this->setLayout(false);
    $this->setTemplate("Components/accountManagement");
  }

  public function executeStatusBar(sfWebRequest $request) {

    $this->setLayout(false);
    $this->setTemplate("Components/statusBar");
  }

  public function executeDecisions(sfWebRequest $request) {

    $this->setLayout(false);
    $this->setTemplate("Components/decisions");
  }

  public function executeRaports(sfWebRequest $request) {

    $this->setLayout(false);
    $this->setTemplate("Components/raports");
  }

  public function executeInformations(sfWebRequest $request) {

    $this->setLayout(false);
    $this->setTemplate("Components/informations");
  }

  public function getHtml($action) {
    $controller = sfContext::getInstance()->getController();

    return $controller->getPresentationFor('panelGry', $action);
  }

  public function getAdviser(HotelGameController $gc) {

    if ($gc->rEQ(1)) {

      if ($gc->getTabUniqueName() == "tworzenie_marki") {
        return array(__t("tworzenie_marki", array(), 'adviser'));
      }

      if ($gc->getTabUniqueName() == "badanie_marketingowe_popyt_standard") {
        return array(__t("badanie_marketingowe_popyt_standard", array(), 'adviser'));
      }

      if (!$gc->e('adviser_badanie_marketingowe_1_tresc', 'decision') && $gc->g('badanie_marketingowe_popyt_standard', 'decision')) {

        $gc->s('adviser_badanie_marketingowe_1_tresc', TRUE, 'decision');
        $gc->getGameData()->save();

        return array(__t("badanie_marketingowe_1_tresc", array(), 'adviser'), json_encode(array('style' => 'style3')));
      }

      if ($gc->getTabUniqueName() == "wybor_lokalizacji") {
        return array(__t("wybor_lokalizacji", array(), 'adviser'));
      }

      if ($gc->e('wybor_lokalizacji', 'decision') && !$gc->e('adviser_po_wyborze_lokalizacji', 'decision')) {
        $gc->s('adviser_po_wyborze_lokalizacji', TRUE, 'decision');
        $gc->getGameData()->save();

        return array(__t("po_wyborze_lokalizacji", array(), 'adviser'), json_encode(array('nextBtn' => 'Menu.getBuildingModal(\'hotel\');')));
      }

      if ($this->getRequestParameter('building') === 'hotel' && !$gc->e('adviser_ekran_glowny_hotel', 'decision')) {
        $gc->s('adviser_ekran_glowny_hotel', TRUE, 'decision');
        $gc->getGameData()->save();
        return array(__t("ekran_glowny_hotel_2", array(), 'adviser'));
      }

      if ($this->getRequestParameter('tab_unique_name') === 'hotel_inwestycje' && !$gc->e('adviser_pokoje_standard_hotel', 'decision')) {
        $gc->s('adviser_pokoje_standard_hotel', TRUE, 'decision');
        $gc->getGameData()->save();
        return array(__t("pokoje_standard_hotel", array(), 'adviser'), json_encode(array('style' => 'style4')));
      }

      if ($gc->e('pokoje_standard', 'decision') && !$gc->e('adviser_po_decyzji_ilosci_pokoju', 'decision') && $gc->e('adviser_pokoje_standard_hotel_zapisz', 'decision')) {
        $gc->s('adviser_po_decyzji_ilosci_pokoju', TRUE, 'decision');
        $gc->getGameData()->save();
        return array(__t("po_decyzji_ilosci_pokoju", array(), 'adviser'), json_encode(array('nextBtn' => '$(\'.modal\').hide(); new Adviser.Queue(\'AdviserKolejka1\', {data: Adviser.Queue.Queue0});')));
      }
    }

    if ($gc->rEQ(2)) {
      if (!$gc->e('adviser_runda_2_1', 'decision')) {
        $gc->s('adviser_runda_2_1', TRUE, 'decision');
        $gc->getGameData()->save();
        return array(__t("adviser_runda_2_1", array(), 'adviser'), json_encode(array('nextBtn' => 'Menu.getBuildingModal(\'hotel\');')));
      }

      if ($this->getRequestParameter('building') === 'hotel' && !$gc->e('adviser_runda_2_2', 'decision')) {
        $gc->s('adviser_runda_2_2', TRUE, 'decision');
        $gc->getGameData()->save();
        return array(__t("adviser_runda_2_2", array(), 'adviser'), json_encode(array('style' => 'style6')));
      }
    }

    if ($gc->rEQ(4)) {

//      if (!$gc->e('adviser_runda_4_3', 'decision')) {
//        $gc->s('adviser_runda_4_3', TRUE, 'decision');
//        $gc->getGameData()->save();
//
//        return array(__t("adviser_runda_4_3", array(), 'adviser'), json_encode(array('style' => 'style2')));
//      }

      if (!$gc->e('adviser_runda_4_1', 'decision') && $this->getRequestParameter('building') === 'hotel') {
        $gc->s('adviser_runda_4_1', TRUE, 'decision');
        $gc->getGameData()->save();

        return array(__t("adviser_runda_4_1", array(), 'adviser'), json_encode(array('style' => 'style6')));
      }

      if (!$gc->e('adviser_runda_4_2', 'decision')) {
        $gc->s('adviser_runda_4_2', TRUE, 'decision');
        $gc->getGameData()->save();

        return array(__t("adviser_runda_4_2", array(), 'adviser'));
      }
    }

    if ($gc->rEQ(5)) {

      if (!$gc->e('adviser_runda_5_1', 'decision')) {
        $gc->s('adviser_runda_5_1', TRUE, 'decision');
        $gc->getGameData()->save();

        return array(__t("adviser_runda_5_1", array(), 'adviser'), json_encode(array('style' => 'style3')));
      }

      if (!$gc->e('adviser_runda_5_2', 'decision') && $this->getRequestParameter('building') === 'bank') {
        $gc->s('adviser_runda_5_2', TRUE, 'decision');
        $gc->getGameData()->save();

        return array(__t("adviser_runda_5_2", array(), 'adviser'), json_encode(array('style' => 'style4')));
      }

      if (!$gc->e('adviser_runda_5_3', 'decision') && $this->getRequestParameter('building') === 'agencja') {
        $gc->s('adviser_runda_5_3', TRUE, 'decision');
        $gc->getGameData()->save();

        return array(__t("adviser_runda_5_3", array(), 'adviser'), json_encode(array('style' => 'style2')));
      }
    }

    if ($gc->rEQ(7)) {

      if (!$gc->e('adviser_runda_8_1', 'decision')) {
        $gc->s('adviser_runda_8_1', TRUE, 'decision');
        $gc->getGameData()->save();

        return array(__t("adviser_runda_8_1", array(), 'adviser'), json_encode(array('style' => 'style6')));
      }
    }

    if ($gc->rEQ(9)) {

      if (!$gc->e('adviser_runda_9_1', 'decision')) {
        $gc->s('adviser_runda_9_1', TRUE, 'decision');
        $gc->getGameData()->save();

        return array(__t("adviser_runda_9_1", array(), 'adviser'), json_encode(array('style' => 'style2')));
      }
    }

    if ($gc->rEQ(14)) {

      if (!$gc->e('adviser_runda_14_1', 'decision') && $this->getRequestParameter('building') === 'hotel') {
        $gc->s('adviser_runda_14_1', TRUE, 'decision');
        $gc->getGameData()->save();

        return array(__t("adviser_runda_14_1", array(), 'adviser'), json_encode(array('style' => 'style6')));
      }
    }

    return array();
  }

  public function setControllerJsonResponse(sfWebRequest $request, $isValid, HotelGameController $gc, $template = 'Success') {
    $teamId = $this->getUser()->getActiveTeamId();
    $userId = $this->getUser()->getId();

    if ($isValid) {
      sfContext::getInstance()->getConfiguration()->loadHelpers(array('View'));

      $buildingsHtml = $this->getHtml('buildings');
      $statusHtml = $this->getHtml('statusBar');
      $accountManagement = $this->getHtml('accountManagement');
      $messageHtml = $this->getHtml('messages');
      $raportsHtml = $this->getHtml('raports');

      $wBudowieLux = max(0, $gc->g('pokoje_lux', 'decision'));
      $wBudowieStandard = max(0, $gc->g('pokoje_standard', 'decision'));
      $lux = $gc->gLPL();
      $standard = $gc->gLPS();
      $wBudowie = $wBudowieLux + $wBudowieStandard;
      $pokoje = $lux + $standard + $wBudowie;
      $floors = min(9, max(1, round($pokoje / 20)));

      $crane = ($wBudowie == 0) ? 0 : 1;

      $adviser = true;

      $fcArray = array();
      if ($gc->e('wybor_lokalizacji', 'decision') && !$gc->e('adviser_po_wyborze_lokalizacji', 'decision') && $gc->rEQ(1)) {

        $fcArray = array(
            'window.location.reload' => array()
        );

        $adviser = false;
      } elseif ($gc->getGameProcess()->hasMap()) {
        $fcArray = array(
            'ige.client.obj.hotel.floors' => array($floors),
//            'ige.client.obj.hotel.setCrane' => array($crane),
        );
      }


      if ($adviser) {
        $adviser = $this->getAdviser($gc);
      } else {
        $adviser = array();
      }


      $response = array(
          'Components' => array(
              'GameStatus' => array(
                  'JSON' =>
                  array('value' => array(
                          'GameStatus.setHtml' => array($statusHtml),
                      )),
              ),
              'Map' => array(
                  'JSON' =>
                  array('value' => $fcArray),
              ),
              'Buildings' => array(
                  'JSON' =>
                  array('value' => array(
                          'Building.setHtml' => array($buildingsHtml),
                      )),
              ),
              'AccountManagement' => array(
                  'JSON' =>
                  array('value' => array(
                          'AccountManagement.setHtml' => array($accountManagement),
                      )),
              ),
              'Message' => array(
                  'JSON' =>
                  array('value' => array(
                          'Message.setHtml' => array($messageHtml),
                      )),
              ),
              'Raport' => array(
                  'JSON' =>
                  array('value' => array(
                          'Raport.setHtml' => array($raportsHtml),
                      )),
              ),
              'Adviser' => array(
                  'JSON' =>
                  array('value' => array(
                          'Adviser.set' => $adviser,
                      ))
              ),
          ),
          'HTML' => array(
              'id' => null,
              'value' => html_entity_decode($this->getHtmlContent($this, $template), ENT_COMPAT, 'UTF-8')
          ),
          'NOTICE' => array(
              'type' => 'info',
              'value' => 'Transakcja pomyślna.'
          ),
          'MODAL' => TRUE
      );
    } else {
      $response = array(
          'HTML' => array(
              'id' => null,
              'value' => html_entity_decode($this->getHtmlContent($this, 'AjaxPopup'), ENT_COMPAT, 'UTF-8')
          ),
          'NOTICE' => array(
              'type' => 'error',
              'value' => $this->getUser()->getFlash('error')
          ),
          'ISVALID' => $isValid,
      );
    }

    $this->getResponse()->setContentType('application/json');
    $this->setJsonResponse($response);
  }

  public function executeIndex(sfWebRequest $request) {
    if ($this->getUser()->isTeacher()) {
        if (sfConfig::get('sf_environment') == 'dev') {
            $this->redirect('http://' . $request->getHost() . '/panel_dev.php');
        } else {
            $this->redirect('http://' . $request->getHost() . '/panel.php');
        }
    }
                
    $this->getUser()->setAttribute('team_id', false);
    $sf_user_id = $this->getUser()->getId();

    $teams = Doctrine::getTable('Team')->getActiveTeams($sf_user_id);
    $this->hasTeam = false;
    $this->gameStarted = false;

    if ($teams->count() > 0) {
      // Ma juz druzyne odrazu wchodzimy do gry pierwszej druzyny
      $teamId = $teams->getFirst()->getId();
      $this->getUser()->setActiveTeamId($teamId);
      $this->redirect('@panelGry_gameController');
    } else {
      $gameId = $this->getUser()->getGuardUser()->getUserDetails()->getFirst()->getGameId();
      if (!$gameId) {
        $this->getUser()->setError('Nie jesteś przypisany do żadnej gry.');
        $this->teams = array();
      } else {
        $this->game = Doctrine::getTable('Game')->findOneById($gameId);
        if ($this->game->isArchive()) {
          $this->getUser()->setError('Gra została przeniesiona do Archiwum.');
          $this->gameStarted = true;
        } elseif (!($this->game->isInActive() || $this->game->isPrepared())) {
          $this->getUser()->setError('Gra już się rozpoczeła. Nie możesz już dołączyć do zespołu.');
          $this->gameStarted = true;
        }
        $this->teams = Doctrine::getTable('Team')->findByGameId($gameId);
        $userTeams = Doctrine::getTable('Team')->getUserTeams($sf_user_id);
        if ($userTeams->count() > 0) {
          $this->hasTeam = true;
        }
        if ($this->teams->count() == 0) {
          $this->getUser()->setError('Brak zespołów w grze. Poproś nauczyciela o stworzenie.');
        }
      }
    }
  }

  public function executeChooseTeam(sfWebRequest $request) {
    $teamId = $request->getParameter('team_id');
    $team = Doctrine::getTable('Team')->findOneById($teamId);

    if (!$team->canUserJoin()) {
      $this->getUser()->setError('Maksymalna liczba osób w zespole. Proszę wybrać inny zespół.');
    } else {
      $userTeam = new UserTeam();
      $userTeam->setTeamId($teamId);
      $userTeam->setUserId($this->getUser()->getId());
      $userTeam->save();
      $this->getUser()->setNotice('Zostałeś zapisany do "' . $team->getName() . '"');
    }
    $this->redirect('@homepage');
  }

  /**
   * Testowa akcja do HTTP_PUSH
   * @param sfWebRequest $request
   */
  public function executeHttpPush(sfWebRequest $request) {
    $channel = md5('arteneo_team_1');

    $host = $_SERVER['HTTP_HOST'];

    $curlRequest = new sfCurl("http://$host/pub?id=$channel");

    $array = array('time' => time());
    $curlRequest->setPost(json_encode($array));
    $curlRequest->createCurl();

    var_dump($curlRequest->getHttpStatus());

    die("Koniec");
  }

  /**
   * Formularz do zmiany danych json z rundy i rundy poprzedniej. Wykorzystuje HotelGameController
   * @param sfWebRequest $request 
   */
  public function executeDataJsonForm(sfWebRequest $request) {
    $this->forward404If(!$request->isXmlHttpRequest());

    $this->onlyForm = FALSE;
    $this->gameController = HotelGameController::getInstance();

    $this->type = $request->getParameter('type');

    if (!$this->gameController->getGameData()->hasLastRound() && ($this->type == 'last_round' || $this->type == 'last_decision' || $this->type == 'last_raport')) {
      $this->data = false;
    } else {
      $this->data = $this->gameController->getAll($this->type);
    }

    $this->form = new DataJsonForm(array(), array('data' => $this->data));

    if ($request->hasParameter($this->form->getName()) && $request->isMethod('POST')) {
      $this->form->bind($request->getParameter($this->form->getName()), $request->getFiles($this->form->getName()));

      if ($this->form->isValid()) {
        $this->getUser()->setFlash('notice', 'Transakcja pomyślna.');
        $values = $this->form->save();

        $this->gameController->getGameData()->setAll($values, $this->type);
        $this->gameController->getGameData()->save(true);
      } else {
        $this->getUser()->setFlash('error', 'Transakcja nie mogła zostać zrealizowana. Popraw błędy formularza.');
      }

      $this->onlyForm = TRUE;

      $this->setControllerJsonResponse($request, true, $this->gameController);
    }
  }

  public function executeSetUserTeam(sfWebRequest $request) {
    $teamId = $request->getParameter('team_id', false);
    $test = Doctrine::getTable('Team')->findOneById($teamId);

    if ($test) {
      $this->getUser()->setActiveTeamId($teamId);
    } else {
      throw new sfException('Brak zespołu o podanym ID w bazie danych.');
    }

    $this->redirect('@panelGry_gameController');
  }

  public function executeGameController(sfWebRequest $request) {
    if ($request->isXmlHttpRequest()) {
      $this->checkSecurity();
    } else {
      if (!$this->getUser()->getAttribute('team_id', false)) {
        $this->redirect('@homepage');
      }
    }

    $template = 'AjaxPopup';
    $this->setTemplate("Controller/");
    $teamID = $this->getUser()->getActiveTeamId();
    $this->JavaScriptCode = '';

    $this->gameController = HotelGameController::getInstance();
    $this->isTabFromGameController = false;

    $this->tabUniqueName = $request->getParameter('tab_unique_name', NULL);
    $this->title = $request->getParameter('title', NULL);
    $this->id = $request->getParameter('id', NULL);

    if (is_null($this->tabUniqueName)) {
      $this->tabUniqueName = $this->gameController->getTabUniqueName();
      $this->isTabFromGameController = true;
    }
    
    $this->form = $this->gameController->getDecisionForm($this->tabUniqueName, $this->getUser()->getId());
    $isValid = true;

    if ($request->hasParameter($this->form->getName()) && $request->isMethod('POST')) {
      // Zapis formularza // 
      $template = 'Ajax';
      $this->form->bind($request->getParameter($this->form->getName()), $request->getFiles($this->form->getName()));
      $isValid = $this->form->isValid();

      if ($isValid) {

        $this->form->save();

        $this->sendCommandToNginx($teamID);

        $this->getUser()->setNotice('Transakcja pomyślna.');

        if ($this->isTabFromGameController) {
          $this->redirect('@panelGry_gameController');
        } else {
          // Musza sie wykonac ponownie prepareTab* i postPrepareTab* bo widgety moga zmieniac stan po decyzjach
          // Jesli formularz byl dobry i zostal zapisany to wszystkie dane formularza beda zgodne z tym co jest w GC
          // $this->form = $this->gameController->getDecisionForm($this->tabUniqueName, $this->getUser()->getId());

          $this->redirect('@panelGry_building?building=' . $this->id);
        }
      } else {
        $this->getUser()->setFlash('error', 'Transakcja nie mogła zostać zrealizowana. Popraw błędy formularza.');
      }
    }

    // Partiale do renderowania z funckji PREPARE. 
    $this->partials = $this->mergePartialsParams($this->gameController->getPartials());

    if ($request->isXmlHttpRequest()) {
      $this->setControllerJsonResponse($request, $isValid, $this->gameController, $template);
    } else {

      $this->JavaScriptData = array(
          'Components' => array(
              'Adviser' => array(
                  'JSON' =>
                  array('value' => array(
                          'Adviser.set' => $this->getAdviser($this->gameController),
                      ))
              ),
          ),
      );
    }

    return "PostBack";
  }

  public function sendCommandToNginx($teamID) {

    $channel = md5("arteneo_team_$teamID");
    $host = $_SERVER['HTTP_HOST'];
    $curlRequest = new sfCurl("http://$host/pub?id=$channel");

    $timestamp = sfContext::getInstance()->getRequest()->getCookie('timestamp', null);
    $symfony = sfContext::getInstance()->getRequest()->getCookie('symfony', null);

    $array = array(
        'timestamp' => $timestamp,
        'symfony' => $symfony,
        'sender' => $this->getUser()->getId(),
        'reload' => TRUE,
        'host' => $host,
        'channel' => $channel
    );

    $curlRequest->setPost(json_encode($array));
    $curlRequest->createCurl();

    if ($curlRequest->getHttpStatus() != 200) {
      //throw new sfException("CURL NGINX Request FAILED !"); 
    }
  }

  public function executeDecisionList(sfWebRequest $request) {
    $this->gameController = HotelGameController::getInstance();

    if ($request->isXmlHttpRequest()) {
      $this->checkSecurity();
    } else {
      $this->forward404();
    }

    $this->tabUniqueName = 'lista_decyzji';
    $this->form = $this->gameController->getDecisionForm($this->tabUniqueName, $this->getUser()->getId());

    $isValid = false;
    if ($request->hasParameter($this->form->getName()) && $request->isMethod('POST')) {
      $this->form->bind($request->getParameter($this->form->getName()), $request->getFiles($this->form->getName()));
      $isValid = $this->form->isValid();
      if ($isValid) {
        $this->form->save();
        $this->getUser()->setNotice('Transakcja pomyślna.');
      } else {
        $this->getUser()->setFlash('error', 'Transakcja nie mogła zostać zrealizowana. Popraw błędy formularza.');
      }
    }

    $this->partials = $this->mergePartialsParams($this->gameController->getPartials());
  }

  /**
   * Funkcja do kazdego zdefiniowanego partiala doklada dodatkowe parametry
   * 'isTabFromGameController'
   * 'tabUniqueName'
   * 'form'
   * @param array $partials
   * @return array
   */
  protected function mergePartialsParams($partials) {
    $newPartials = array();

    if (!empty($partials)) {
      $mergeArray = array('isTabFromGameController' => $this->isTabFromGameController, 'tabUniqueName' => $this->tabUniqueName, 'form' => $this->form);
      foreach ($partials as $name => $params) {
        $newPartials[$name] = array_merge($params, $mergeArray);
      }
    }

    return $newPartials;
  }

  /**
   * Zwraca wnętrze budynków. 
   * @param sfWebRequest $request
   */
  public function executeBuilding(sfWebRequest $request) {

    $gc = HotelGameController::getInstance();

    if ($gc->getTabUniqueName() != 'mapa') {
      $this->redirect('@panelGry_gameController');
    }

    if ($request->isXmlHttpRequest()) {
      $this->checkSecurity();
    } else {
      $this->forward404();
    }

    $building = $this->getRequestParameter('building', FALSE);

    if (!$building) {
      throw new sfException("Nie zdefiniowano nazwy budynku");
    }

    $this->setTemplate("Buildings/building");
    $game = HotelGameController::getInstance();

    $squares = $game->getGameView()->getSquaresList($building);

    $this->title = $squares['label'];
    $this->squares = $squares['squares'];
    $this->id = $building;

    $this->setControllerJsonResponse($request, true, $game);
  }

  public function checkSecurity() {

    if (!$this->getUser()->isAuthenticated() || !$this->getUser()->getAttribute('team_id', false)) {

      $response = array(
          'Components' => array(
              'Controller' => array(
                  'JSON' =>
                  array('value' => array(
                          'Redirect.url' => array('homepage'),
                      )),
              ),
          ),
          'HTML' => array()
      );

      die(json_encode($response));
    }
  }

}
