<?php if (isset($sf_game) && $sf_game != false): ?>
    <div class="game-status">

        <div class="company_result fl">
            <div class="text fl w100"><?= __t("Wynik firmy") ?></div>
            <div class="boxed w50 fl">
                <div class="icon-box">
                    <div class="balans-icon" tooltip="true" data-original-title="<?= __('Aktualny budżet'); ?>"></div>
                </div>
                <div class="value fl" id="GS_Balans"><?= format_money_value_color($sf_game->gB()); ?></div>
            </div>
            <div class="boxed w50 fl">
                <div class="icon-box">
                    <div class="cash-icon" tooltip="true" data-original-title="<?= __('Zysk z poprzedniej rundy'); ?>"></div>
                </div>
                <?php if ($sf_game->rGT(1)): ?>
                    <div class="value fl" id="GS_Cash"><?= format_money_value_color($sf_game->g('status_bar_saldo', 'round', 0)); ?></div>
                <?php else: ?>
                    <div class="value fl" id="GS_Cash"><?= format_money_value_color(0); ?></div>
                <?php endif; ?>
            </div>
        </div>

        <div class="separator"></div>

        <div class="demand fl">
            <div class="text fl w100"><?= __t("Popyt") ?></div>

            <div class="boxed <?= ($sf_game->gLPL() > 0) ? 'w50' : 'w100'; ?> fl">
                <div class="icon-box">
                    <div class="demand-icon" tooltip="true" data-original-title="<?= __('Obłożenie pokoi standard'); ?>"></div>
                </div>
                <div class="value fl standard" id="GS_OccupiedStandardRooms"><?= round($sf_game->gPOSProc()) . '%'; ?></div>
            </div>

            <?php if ($sf_game->gLPL() > 0) : ?>

                <div class="boxed w50 fl">
                    <div class="icon-box">
                        <div class="demend-lux-icon" tooltip="true" data-original-title="<?= __('Obłożenie pokoi Delux'); ?>"></div>
                    </div>
                    <div class="value fl lux" id="GS_OccupiedLuxRooms"><?= round($sf_game->gPOLProc()) . '%'; ?></div>
                </div>

            <?php endif; ?>
        </div>

        <div class="separator"></div>

        <div class="rooms_standard">
            <div class="text fl w100"><?= __t("Pokoje ") ?><span class="standard"><?= __t(" STANDARD") ?></span></div>

            <div class="fl clear value-2"><?= __t("W budowie: <b>%pokojeStandard%</b>", array('%pokojeStandard%' => max(0, $sf_game->g('pokoje_standard', 'decision')))); ?></div>
            <div class="fl clear value-2 standard"><?= __t("Aktualna liczba: <b>%pokojeStandard%</b>", array('%pokojeStandard%' => $sf_game->gLPS())); ?></div>
        </div>

        <?php if ($sf_game->gLPL() > 0 || $sf_game->g('pokoje_lux', 'decision') > 0) : ?>
            <div class="separator"></div>

            <div class="rooms_lux">
                <div class="text fl w100"><?= __t("Pokoje") ?><span class="lux"><?= __t(" DELUX") ?></span></div>

                <?php if ($sf_game->g('pokoje_lux', 'decision') > 0 || $sf_game->gLPL() > 0) : ?>
                    <div class="fl clear value-2"><?= __t("W budowie: <b>%pokojeLux%</b>", array('%pokojeLux%' => max(0, $sf_game->g('pokoje_lux', 'decision')))); ?></div>
                <?php endif; ?>
                <?php if ($sf_game->gLPL() > 0) : ?>
                    <div class="fl clear value-2 lux"><?= __t("Aktualna liczba: <b>%pokojeLux%</b>", array('%pokojeLux%' => $sf_game->gLPL())); ?></div>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <?php if ($sf_game->rGT(6)): ?>

            <div class="separator"></div>
            <div class="rank">
                <div class="text fl w100"><?= __t("Ranking") ?></div>
                <div class="icon_rank cp" onclick="raports.getRaportRankingModal();"></div>
                <div class="fl">
                    <div class="place standard fl"><?= __t("Miejsce") ?> <b id="GS_Rank"><?= $sf_game->getRankingMiejsce(); ?></b></div>
                    <div class="clear"></div>
                    <div class="ptk lux fl"><?= __t("Punkty"); ?> <b><?= round($sf_game->getRankingWartosc(), 2); ?></b></div>
                </div>
            </div>

        <?php endif; ?>
    </div>

    <div class="roza">
        <?php if ($sf_game->g('mapa', 'game', false)) : ?>
            <div class="roza-box">
                <div class="roza-N" onclick="MoveCamera.top();
                        return false;"></div>
                <div class="roza-E" onclick="MoveCamera.right();
                        return false;"></div>
                <div class="roza-S" onclick="MoveCamera.bottom();
                        return false;"></div>
                <div class="roza-W" onclick="MoveCamera.left();
                        return false;"></div>
                <div class="roza-C"></div>
            </div>
        <?php else : ?>
            <div class="roza-box empty"></div>
        <?php endif; ?>

        <div class="przyciski-box">

            <?php if ($sf_game->g('muzyka', 'game', false)) : ?>
                <a href="<?= url_for('@panelGry_toggleMusic'); ?>">
                    <div class="przycisk"
                         data-placement="top"
                         data-toggle="tooltip" tooltip="true" data-original-title="<?= __("Włącz/Wyłącz muzykę") ?>">
                        <div class="muzyka<?= ($sf_game->getGameProcess()->hasMusic() ? ' on' : ''); ?>"></div>
                    </div>
                </a>
            <?php else: ?>
                <div class="przycisk"
                     data-placement="top"
                     data-toggle="tooltip" tooltip="true" data-original-title="<?= __("Nauczyciel wyłączył muzykę") ?>">
                    <div class="muzyka<?= ($sf_game->getGameProcess()->hasMusic() ? ' on' : ''); ?>"></div>
                </div>
            <?php endif; ?>

            <?php if ($sf_game->g('mapa', 'game', false)) : ?>
                <a href="<?= url_for('@panelGry_toggleMapHd'); ?>">
                    <div class="przycisk"
                         data-placement="top"
                         data-toggle="tooltip" tooltip="true" data-original-title="<?= __("Zmień jakość mapy") ?>">
                        <div class="hd<?= ($sf_game->getGameProcess()->hasMapHd() ? ' on' : ''); ?>"></div>
                    </div>
                </a>
            <?php else: ?>
                <div class="przycisk"
                     data-placement="top"
                     data-toggle="tooltip" tooltip="true" data-original-title="<?= __("Nauczyciel wyłączył mapę") ?>">
                    <div class="hd<?= ($sf_game->getGameProcess()->hasMapHd() ? ' on' : ''); ?>"></div>
                </div>
            <?php endif; ?>

            <?php if ($sf_game->g('mapa', 'game', false)) : ?>
                <a href="<?= url_for('@panelGry_toggleMap'); ?>">
                    <div class="przycisk"
                         data-placement="top"
                         data-toggle="tooltip" tooltip="true" data-original-title="<?= __("Włącz/Wyłącz mapę") ?>">
                        <div class="map<?= ($sf_game->getGameProcess()->hasMap() ? ' on' : ''); ?>"></div>
                    </div>
                </a>
            <?php else: ?>
                <div class="przycisk"
                     data-placement="top"
                     data-toggle="tooltip" tooltip="true" data-original-title="<?= __("Nauczyciel wyłączył mapę") ?>">
                    <div class="map<?= ($sf_game->getGameProcess()->hasMap() ? ' on' : ''); ?>"></div>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>