<?= get_widget('begin_popup', 'panelGry', array('title' => __('Wybór zespołu'), 'id' => 'chooseGame', 'class' => 'modal-building modal-2')); ?>

<?php if ($teams->count() > 0): ?>
    <div class="row-fluid">
        <div class="span12 w100 fl">
            <?php if (!$gameStarted) : ?>
                <div class="alert alert-success mt10 mr50 ml50 fl">
                    <?php if ($hasTeam) : ?>
                        Wybrałeś już zespół. Poczekaj aż nauczyciel aktywuje grę.
                    <?php else : ?>
                        Wybierz zespół w których chciałbyś grać. Zastanów się dobrze, tej decyzji nie będziesz mógł cofnąć.
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <?php include_partial('panelGry/flashes'); ?>
        </div>
        <div class="span6 w50 fl mb15">
            <label class="cd">Nazwa gry: <?= $game->getName(); ?></label>
        </div>
        <div class="span6 w50 fl mb15">
            <label class="cd">Prowadzący: <?= $game->getTeacher()->getName(); ?></label>
        </div>
        <?php foreach ($teams as $team) : ?>
            <div class="span6 w50 fl">
                <div class="m20 p20 wybor-zespolu-border">
                    <div class="wybor-zespolu-border p10"><?= $team->getName(); ?> - zapisanych <?= $team->getUsersCount(); ?>/<?= $team->getMaxUsers(); ?></div>
                    <div class="clear"></div>
                    <?php if ($team->getUsersCount() > 0) : ?>
                        <div class="pt10 pb10 pl20 pr20">
                            <?php foreach ($team->getUsers() as $user) : ?>
                                <?= $user->getName(); ?>
                                <div class="clear"></div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                    <?php if (!$hasTeam && $team->canUserJoin() && !$gameStarted) : ?>
                        <a href="<?= url_for('@chooseTeam?team_id=' . $team->getId()); ?>" class="btn mt10 tac cp">Wybierz</a>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>

    <script type="text/javascript">
        $(document).ready(function() {
            Helper.setPopupSize();
            Helper.updateScroll();
        })
    </script>
<?php endif; ?>

<?= get_widget('end_popup', 'panelGry', array()) ?>