<?= get_widget('begin_popup', 'panelGry', array('title' => __('Raport Operacyjny - Rok %rok% Kwartał %kwartal%', array('%rok%' => $sf_game->getLastYear(), '%kwartal%' => $sf_game->getPoprzedniKwartalRzymski())), 'id' => 'raportOperacyjny', 'class' => 'modal-building o1', 'scroll' => true)); ?>

<?php if ($sf_game->gRn() > HotelGameProcess::FIRST_ROUND): ?>  
  <?php 
  $raportCalosc = $gameController->getAll('last_raport'); 
  $dataArray = array(); 
  
  foreach ($raportCalosc['operacyjny'] as $round => $roundCategoryData){
    if (is_object($roundCategoryData))
      $dataArray = array_merge_recursive($dataArray,  (array) artEscaper::escape($roundCategoryData));
  }
  ?>

  <script type='text/javascript'>
    var RaportOperacyjnyChartData = <?= json_encode(artEscaper::escape($dataArray)); ?>;
  </script>

  <table class="table table-raport operacyjny">
    <tbody>
      <?php foreach ($raportCalosc['operacyjny'] as $round => $roundCategoryData): ?>
        <?php $roundNumber = $sf_game->gRN()-1;
        if ($round === 'runda_' . $roundNumber): ?>
        <?php foreach ($roundCategoryData as $category => $categoryData): ?>
          <tr level="0"  row="<?= $category; ?>">
            <td colspan="3">
            <?php if ($category == 'konkurencja') : ?>
                <?php 
                  $seriesDataStandard = array(
                      array(
                          'label' => __t('konkurencja_standard_ty', array(), 'raport_operacyjny'),
                          'data' => $gameController->g('popyt_standard', 'round'),
                      ),
                      array(
                          'label' => __t('konkurencja_standard_p1', array(), 'raport_operacyjny'),
                          'data' => $roundCategoryData['konkurencja']['konkurencja_standard']['p1'],
                      ),
                      array(
                          'label' => __t('konkurencja_standard_p2', array(), 'raport_operacyjny'),
                          'data' => $roundCategoryData['konkurencja']['konkurencja_standard']['p2'],
                      ),
                      array(
                          'label' => __t('konkurencja_standard_p3', array(), 'raport_operacyjny'),
                          'data' => $roundCategoryData['konkurencja']['konkurencja_standard']['p3'],
                      ),
                  );
                  $seriesDataLux = array(
                      array(
                          'label' => __t('konkurencja_lux_ty', array(), 'raport_operacyjny'),
                          'data' => $gameController->g('popyt_lux', 'round'),
                      ),
                      array(
                          'label' => __t('konkurencja_lux_p1', array(), 'raport_operacyjny'),
                          'data' => $roundCategoryData['konkurencja']['konkurencja_lux']['p1'],
                      ),
                      array(
                          'label' => __t('konkurencja_lux_p2', array(), 'raport_operacyjny'),
                          'data' => $roundCategoryData['konkurencja']['konkurencja_lux']['p2'],
                      ),
                      array(
                          'label' => __t('konkurencja_lux_p3', array(), 'raport_operacyjny'),
                          'data' => $roundCategoryData['konkurencja']['konkurencja_lux']['p3'],
                      ),
                  );
              ?>
              <i class="icon-plus cp"
                data-toggle="tooltip" tooltip="true" data-original-title="<?= __("Pokaż / ukryj szczegóły") ?>"
                onclick="Raport.toggleSection('<?= Slug::slugify($category) ?>', 1, $(this).parent().parent());
                          RaportOperacyjny.showPieChart(<?= htmlspecialchars(json_encode($seriesDataStandard)) ?>, $(this), '<?= $category.'_konkurencja_standard' ?>');
                          RaportOperacyjny.showPieChart(<?= htmlspecialchars(json_encode($seriesDataLux)) ?>, $(this), '<?= $category.'_konkurencja_lux' ?>');
                          return false;"
                ></i> 
            <?php else: ?>
              <i class="icon-plus cp"
                data-toggle="tooltip" tooltip="true" data-original-title="<?= __("Pokaż / ukryj szczegóły") ?>"
                onclick="Raport.toggleSection('<?= Slug::slugify($category) ?>', 1, $(this).parent().parent());"
                ></i> 
            <?php endif; ?>
              <?= __t($category, array(), 'raport_operacyjny') ?>
            </td>
            <td class="td-icon">
              <?php if ($sf_game->rGT(2)) : ?>
                <?php if ($category == 'konkurencja') : ?>
                    <i class="hotel-icon-raport-chart fr"
                        data-placement="left"
                        data-chart="hidden"
                        data-toggle="tooltip" tooltip="true" data-original-title="<?= __("Pokaż / ukryj wykres") ?>"
                        onclick="Raport.toggleSection('<?= Slug::slugify($category) ?>', 1, $(this).parent().parent());
                          RaportOperacyjny.showPieChart(<?= htmlspecialchars(json_encode($seriesDataStandard)) ?>, $(this), '<?= $category.'_konkurencja_standard' ?>');
                          RaportOperacyjny.showPieChart(<?= htmlspecialchars(json_encode($seriesDataLux)) ?>, $(this), '<?= $category.'_konkurencja_lux' ?>');
                          return false;">
                    </i>
                <?php else: ?>
                    <?php $legendNames = '['; ?>
                    <?php foreach ($categoryData as $key => $value): ?>
                        <?php $legendNames .= '\''.__t($key, array(), 'raport_operacyjny').'\',';?>
                    <?php endforeach; ?>
                    <?php $legendNames = rtrim($legendNames, ",").']'; ?>
                    <i class="hotel-icon-raport-chart fr"
                        data-placement="left"
                        data-chart="hidden"
                        data-toggle="tooltip" tooltip="true" data-original-title="<?= __("Pokaż / ukryj wykres") ?>"
                        onclick="
                          RaportOperacyjny.showChart({0: '<?= $category ?>'}, $(this), <?= $legendNames ?>); 
                          return false; ">
                    </i>
                  <?php endif; ?>
              <?php endif; ?>
            </td>
          </tr>
          
          <tr chart="<?= $category ?>" style="display: none">
            <td colspan="5" style="text-align: center !important; ">
              <div class="chart-container">
                <div id="placeholder_<?= $category; ?>" class="demo-placeholder" style="float:left; width:780px; height: 250px;"></div>
              </div>
              <!--<canvas id="<?= $category?>" height="350" width="770"></canvas>-->
            </td>
          </tr>
          
          <?php foreach ($categoryData as $key => $value): ?>
          <?php if ($key != 'konkurencja_lux') : ?>
            <tr level="1" record="<?= Slug::slugify($category) ?>" row="<?= $key; ?>" style="display: none;">
            <?php if ($category == 'konkurencja'): ?>
                <?php if ($value === 'brak_konkurencji'): ?>
                  <td colspan="4">
                    <?= __t('Za wcześnie, aby dokładnie oszacować konkurencję', array(), 'raport_operacyjny'); ?>
                  </td>
                <?php else: ?>
                  <td colspan="1" style="width: 50%">
                    <?= __t('konkurencja_standard', array(), 'raport_operacyjny'); ?>
                    <div class="chart-container" style="width: 100%">
                      <div id="placeholder_<?= $category.'_konkurencja_standard'; ?>" class="demo-placeholder" style="float:left; width:100%; height: 255px;"></div>
                    </div>
                  </td>
                  <td colspan="3" style="width: 50%">
                    <?= __t('konkurencja_lux', array(), 'raport_operacyjny'); ?>
                    <div class="chart-container" style="width: 100%">
                      <div id="placeholder_<?= $category.'_konkurencja_lux'; ?>" class="demo-placeholder" style="float:left; width:100%; height: 255px;"></div>
                    </div>
                  </td>
                <?php endif; ?>
              <?php else: ?>
              <td>
                <?= __t($key, array(), 'raport_operacyjny') ?>
              </td>
              
              <?php if ($category == 'firma' || $category == 'marza') : ?>
              <td>
                <span>
                  <?php if ($value === 'brak_pokoi_standard'): ?>
                    <?= __t('Brak pokoi Standard', array(), 'raport_operacyjny'); ?>
                  <?php elseif ($value === 'brak_pokoi_lux'): ?>
                    <?= __t('Brak pokoi Delux', array(), 'raport_operacyjny'); ?>
                  <?php elseif ($value === 'brak_pracownikow'): ?>
                    <?= __t('Brak pracowników', array(), 'raport_operacyjny'); ?>
                  <?php else: ?>
                    <?= format_money_value_color($value) ?>
                  <?php endif; ?>
                    </span>
              </td>
              <?php else: ?>
                    <td>
                <span>
                  <?php if ($value === 'brak_pokoi_standard'): ?>
                    <?= __t('Brak pokoi Standard', array(), 'raport_operacyjny'); ?>
                  <?php elseif ($value === 'brak_pokoi_lux'): ?>
                    <?= __t('Brak pokoi Delux', array(), 'raport_operacyjny'); ?>
                  <?php elseif ($value === 'brak_pracownikow'): ?>
                    <?= __t('Brak pracowników', array(), 'raport_operacyjny'); ?>
                  <?php elseif ($value === 'brak_efektywnosci_marketingu_standard'): ?>
                    <?= __t('Za wcześnie, aby dokładnie oszacować efektywność', array(), 'raport_operacyjny'); ?>
                  <?php elseif ($value === 'brak_efektywnosci_marketingu_lux'): ?>
                    <?= __t('Za wcześnie, aby dokładnie oszacować efektywność', array(), 'raport_operacyjny'); ?>
                  <?php elseif ($value === 'brak_jakosci_pokoju_standard'): ?>
                    <?= __t('Za wcześnie, aby dokładnie oszacować jakość', array(), 'raport_operacyjny'); ?>
                  <?php elseif ($value === 'brak_jakosci_pokoju_lux'): ?>
                    <?= __t('Za wcześnie, aby dokładnie oszacować jakość', array(), 'raport_operacyjny'); ?>
                  <?php elseif ($value === 'brak_satysfakcji_klienta_standard'): ?>
                    <?= __t('Za wcześnie, aby dokładnie oszacować satysfakcję', array(), 'raport_operacyjny'); ?>
                  <?php elseif ($value === 'brak_satysfakcji_klienta_lux'): ?>
                    <?= __t('Za wcześnie, aby dokładnie oszacować satysfakcję', array(), 'raport_operacyjny'); ?>
                  <?php else: ?>
                    <?= round($value, 0) ?><?= ($category === 'oblozenie')?' %':''; ?>
                  <?php endif; ?>
                    </span>
                  </td>
              <?php endif; ?>
              <td class="td-icon">
                <i class="hotel-icon-empty-32" data-placement="left" tooltip="true" data-toggle="tooltip" data-original-title="<?= __tt($category.'_'.$key, array(), 'hint_raport_operacyjny') ?>">?</i>
              </td>
              <td class="td-icon">
                <?php if ($sf_game->rGT(2) && $value != 'brak_konkurencji') : ?>
                    <?php if ($category != 'konkurencja') : ?>
                    <i class="hotel-icon-raport-chart" 
                    data-placement="top"
                    data-chart="hidden"
                    data-toggle="tooltip" tooltip="true" data-original-title="<?= __("Pokaż / ukryj wykres") ?>"
                    onclick="RaportOperacyjny.showChart({0: '<?= $category ?>', 1: '<?= $key ?>'}, $(this), ['<?= __t($key, array(), 'raport_operacyjny') ?>']); return false;"></i>
                  <?php else: ?>
                  <?php 
                      $seriesData = array(
                          array(
                              'label' => __t($key.'_p1', array(), 'raport_operacyjny'),
                              'data' => 20,
                          ),
                          array(
                              'label' => __t($key.'_p2', array(), 'raport_operacyjny'),
                              'data' => 30,
                          ),
                          array(
                              'label' => __t($key.'_p3', array(), 'raport_operacyjny'),
                              'data' => 120,
                          ),
                      );
                  ?>
                    <i class="hotel-icon-raport-chart" 
                    data-placement="top"
                    data-chart="hidden"
                    data-toggle="tooltip" tooltip="true" data-original-title="<?= __("Pokaż / ukryj wykres") ?>"
                    onclick="RaportOperacyjny.showPieChart(<?= htmlspecialchars(json_encode($seriesData)) ?>, $(this), '<?= $category.'_'.$key ?>'); return false;"></i>
                    <?php endif; ?>
                <?php endif; ?>
              </td>
              <?php endif; ?>
            </tr>
            
            <tr chart="<?= $category.'_'.$key; ?>" style="display: none">
              <td colspan="4" style="text-align: center !important; ">
                <div class="chart-container">
                  <div id="placeholder_<?= $category.'_'.$key; ?>" class="demo-placeholder" style="float:left; width:780px; height: 255px;"></div>
                </div>
                <!--<canvas id="<//?= $category.'_'.$key; ?>" height="350" width="770"></canvas>-->
                <!--<div id="<//?= 'legend_'.$category.'_'.$key; ?>" class="lineLegend"></div>-->
              </td>
            </tr>
          <?php endif; ?>
          <?php endforeach; ?>
        <?php endforeach; ?>
      <?php endif; ?>
    <?php endforeach; ?>
  </tbody>
</table> 
<?php else: ?>
  <h4 class="m40"><?= __("Raport opercyjny nie jest jeszcze dostępny.") ?></h4>
<?php endif; ?>
<?= get_widget('end_popup', 'panelGry', array('close' => true)); ?>
