<?= get_widget('begin_popup', 'panelGry', array('title' => __('Ranking'), 'id' => 'raportOperacyjny', 'class' => 'modal-building o1')); ?>

<?php if ($gameController->rGT(1)): ?>  
  <?php
  $last = $gameController->gRN() - 1; 
  $actual = "runda_" . $last; 
  $data = $gameController->g('ranking|'.$actual, 'game');
  
  $rankingArray = array();
  foreach ($data as $key => $team) {
    $rankingArray[] = array(
      'id' => $key,
      'pozycja' => $team->get('pozycja'),
      'nazwa_firmy' => $team->get('nazwa_firmy'),
      'wartosc_rankingu'=> $team->get('wartosc_rankingu'),
      'wynik_ekonomiczny_firmy' => $team->get('wynik_ekonomiczny_firmy'),
      'wsp_zrownowazonego_rozwoju' => $team->get('wsp_zrownowazonego_rozwoju'),
      'wsp_satysfakcji' => $team->get('wsp_satysfakcji'),
    );
  }
  ksort($rankingArray);
  ?>

  <table class="table table-raport table-ranking">
    <thead>
      <tr>
        <th></th>
        <th><?= __t('Miejsce', array(), 'raport_ranking') ?></th>
        <th><?= __t('Nazwa hotelu', array(), 'raport_ranking') ?></th>
        <th><?= __t('Punkty rankingowe', array(), 'raport_ranking') ?></th>
        <th></th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($rankingArray as $pozycja => $dane): ?>
        <?php $key = $dane['id']; ?>
        <tr level="0" <?= ($key != $sf_user->getActiveTeamId()) ? 'class="active"' : ''; ?>>
          <td class="td-icon-rank"><?= ($dane['pozycja'] <= 3) ? '<i class="hotel-icon-rank hotel-icon-rank'.$dane['pozycja'].'"></i>' : ''; ?></td>
          <td><?= $dane['pozycja']; ?></td>
          <td style="max-width: 250px; overflow: hidden;"><?= $dane['nazwa_firmy']; ?></td>
          <td><?= round($dane['wartosc_rankingu'], 2) ?></td>
          <td class="td-icon"><i onclick="$('.rank-team-<?= $key; ?>').toggle(); Helper.updateScroll();" class="mt10 mr5 cp icon icon-list" data-placement="top" data-toggle="tooltip" tooltip="true" data-original-title="<?= __('Pokaż/Ukryj szczegóły'); ?>"></i></td>
        </tr>
        <tr style="display:none;" level="0" class="sorter-false rank-details <?= 'rank-team-'.$key; ?><?= ($key != $sf_user->getActiveTeamId()) ? ' active' : ''; ?>">
          <td class="td-hidden" colspan="2"></td>
          <td class="rank-details"><?= __t('Wynik ekonomiczny firmy'); ?></td>
          <td><?= format_money_value($dane['wynik_ekonomiczny_firmy']); ?></td>
          <td></td>
        </tr>
        <tr style="display:none;" level="0" class="sorter-false <?= 'rank-team-'.$key; ?><?= ($key != $sf_user->getActiveTeamId()) ? ' active' : ''; ?>">
          <td class="td-hidden" colspan="2"></td>
          <td class="rank-details"><?= __t('Współczynnik rozwoju'); ?></td>
          <td><?= round($dane['wsp_zrownowazonego_rozwoju'], 2) ?></td>
          <td></td>
        </tr>
        <tr style="display:none;" level="0" class="sorter-false rank-details <?= 'rank-team-'.$key; ?><?= ($key != $sf_user->getActiveTeamId()) ? ' active' : ''; ?>">
          <td class="td-hidden" colspan="2"></td>
          <td class="rank-details"><?= __t('Współczynnik satysfakcji'); ?></td>
          <td><?= round($dane['wsp_satysfakcji'], 2) ?></td>
          <td></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
<?php else: ?>
  <h4 class="m40"><?= __("Ranking nie jest jeszcze dostepny.") ?></h4>
<?php endif; ?>
<?= get_widget('end_popup', 'panelGry', array('close' => true)); ?>
