<?php

class sfGuardAuthActions extends PluginsfGuardAuthActions {

    public function executeActivate(sfWebRequest $request) {
        $this->email = $request->getParameter('e', null);
        $this->hashmd5 = $request->getParameter('u', null);

        if (is_null($this->email) || is_null($this->hashmd5)) {
            $this->getUser()->setError('Twój link aktywacyjny jest niepoprawny.');
            $this->redirect('@homepage');
        }

        $user = Doctrine::getTable('sfGuardUser')->findOneByEmailAddress($this->email);

        if (!$user) {
            $this->getUser()->setError('Twój link aktywacyjny jest niepoprawny.');
            $this->redirect('@homepage');
        } else if ($this->hashmd5 == $user->getMd5ActivationCode()) {
            if ($user->getIsActive() == 1) {
                $this->getUser()->setFlash('notice', 'Twoje konto jest już aktywne.');
                $this->redirect('@homepage');
            } else {
                $user->setIsActive(1);
                $user->save();

                $emailKontaktowy = ArtConfiguration::getConfig('contact_email', 'hotelstars@arteneo.pl');
                $sender = new MessageSender();
                $sender->send($emailKontaktowy, $user->getEmailAddress(), $sender->getComponentBody('messages', 'activationSuccess', array(), 'panel'), 'HotelStars - Konto aktywne');


                $this->getUser()->setNotice('Twóje konto zostało aktywowane. Życzymy owocnej gry.');
                $this->redirect('@homepage');
            }
        }

        $this->getUser()->setError('Twój link aktywacyjny jest niepoprawny.');
        $this->redirect('@homepage');
    }

    public function executeSignin(sfWebRequest $request) {
        $user = $this->getUser();

        // Użytkownik jest zalogowany;

        if ($user->isAuthenticated()) {

            if (!$request->isXmlHttpRequest())
                return $this->redirect(
                                Redirector::get('GuardUser_SignInAuthenticated'
                                        , array('request' => $request)));
            else {
                // AJAX Request
                $this->url = url_for(Redirector::get('GuardUser_SignInAuthenticated', array('request' => $request)));
                return 'Redirect';
            }
        }

        if ($this->getUser()->hasFlash('homepageReferer'))
            $this->getUser()->setFlash('homepage_referer', $this->getUser()->getFlash('homepageReferer'));
        else
            $this->getUser()->forwardFlash('homepage_referer');

        $class = sfConfig::get('app_sf_guard_plugin_signin_form', 'sfGuardFormSignin');
        $this->form = new $class();

        if ($request->isMethod('post') && $request->hasParameter('signin')) {
            $this->form->bind($request->getParameter('signin'));

            if ($this->form->isValid()) {
                $values = $this->form->getValues();
                $this->getUser()->signin($values['user'], array_key_exists('remember', $values) ? $values['remember'] : false);

                $referer = $user->getReferer($request->getReferer());

                $this->url = Redirector::get('GuardUser_SignIn', array('request' => $request, 'user' => $user));

                if ($this->getUser()->hasFlash('homepage_referer')) {
                    $this->url = $this->getUser()->getFlash('homepage_referer');

                    return 'Redirect';
                }

                if ($request->isXmlHttpRequest() && $this->getUser()->hasAttribute('ajax_referer')) {
                    $ajaxReferer = $this->getUser()->getAttribute('ajax_referer', $referer);
                    $this->getUser()->offsetUnset('ajax_referer');
                    $urlToParse = str_replace(str_replace(sfConfig::get('sf_web_dir'), '', $_SERVER['SCRIPT_FILENAME']) . '/', '', $ajaxReferer);
                    $params = $this->getContext()->getRouting()->parse($urlToParse);

                    if ($params['action'] == 'signin' && $params['module'] == 'sfGuardAuth')
                        return 'Redirect';
                    else
                        return $this->forward($params['module'], $params['action']);
                }

                if ($this->getUser()->isTeacher()) {
                    if (sfConfig::get('sf_environment') == 'dev') {
                        $this->redirect('http://' . $request->getHost() . '/panel_dev.php');
                    } else {
                        $this->redirect('http://' . $request->getHost() . '/panel.php');
                    }
                }

                return $this->redirect($this->url);
            }
        } else {
            if ($request->isXmlHttpRequest()) {
                $this->getUser()->setAttribute('ajax_referer', $_SERVER['REQUEST_URI']);

                return 'Success';
            }

            $user->setReferer($this->getContext()->getActionStack()->getSize() > 1 ? $request->getUri() : $request->getReferer());
            $module = sfConfig::get('sf_login_module');

            if ($this->getModuleName() != $module)
                return $this->redirect($module . '/' . sfConfig::get('sf_login_action'));

            $this->getResponse()->setStatusCode(401);
        }
    }

}
