<?php
$title = __("Logowanie");
$id = 'loginModal';
$class = 'modal-building modal-intro';
?>

<div id="<?= $id ?>" slug="<?= Slug::slugify($title) ?>" class="modal fade <?= $class; ?>  <?= Slug::slugify($title) ?>">
    <div class="error-popup" style="<?php if (!isset($error)) echo 'display: none;'; ?>">
        <div class="error-popup-img"></div>
        <div class="error-popup-text"><?php if (isset($error)) echo $error; ?></div>
    </div>

    <div class="info-popup" style="<?php if (!isset($error)) echo 'display: none;'; ?>">
        <div class="info-popup-img"></div>
        <div class="info-popup-text"><?php if (isset($error)) echo $error; ?></div>
    </div>

    <div class="popup-all">
        <div class="modal-header">
            <h3 class="headline-blue">
                <?php echo $title; ?></h3>
        </div>

        <div class="clear"></div>
        <?= form_tag('@sf_guard_signin', array('id' => 'LoginForm')); ?>
        <div class="modal-body <?= (isset($scroll) && !$scroll) ? "oa" : ""; ?>">
            <div scrollArea="<?= (isset($scroll) && !$scroll) ? "false" : "true"; ?>">
                <?php include_partial('panelGry/flashes'); ?>

                <?= $form; ?>
            </div>
        </div>
        <div class="modal-footer">
            <a href="<?= url_for('@new_account') ?>" class="btn fl mt10 ml20"><?= __('Rejestracja') ?></a>
            <input class="btn fr mt10 mr20" value="Logowanie" type="submit">
        </div>
        </form>
    </div>
</div>


<script type="text/javascript">
    $(document).ready(function() {
        Helper.setPopupSize();
    })
</script>