<?php

class sfGuardRegisterActions extends PluginsfGuardRegisterActions {

  public function executeIndex(sfWebRequest $request) {
    $class = class_exists('sfGuardRegisterForm') ? 'sfGuardRegisterForm' : 'PluginsfGuardRegisterForm';

    if (!$this->getUser()->hasFlash('email_from_invitation')) {
      $this->form = new $class();
    } else {
      $user = new sfGuardUser();
      $user->setEmailAddress($this->getUser()->getFlash('email_from_invitation'));
      $this->form = new $class($user, array('invitation' => true));
    }
    if ($request->isMethod('post') && $request->hasParameter($this->form->getName())) {
      $this->form->bind($request->getParameter($this->form->getName()));

      if ($this->form->isValid()) {
        $user = $this->form->save();

        $activationLink = $this->generateUrl('activate', array('e' => $user->getEmailAddress(), 'u' => $user->getMd5ActivationCode()), true);
        $emailKontaktowy = ArtConfiguration::getConfig('contact_email', 'hotelstars@arteneo.pl');
        $vars = array(
          'activationLink' => $activationLink
        );
        
        $sender = new MessageSender();
        $sender->send($emailKontaktowy, $user->getEmailAddress(), $sender->getComponentBody('messages', 'activationLink', $vars, 'panel'), 'HotelStars - Aktywacja konta');
        $this->getUser()->setNotice('Dziękujemy za rejestrację! Na Twój e-mail została wysłana wiadomość z linkiem aktywacyjnym. Pamiętaj o sprawdzeniu folderu SPAM. Kliknięcie go spowoduje aktywację konta.');
        $this->redirect('@homepage');
      }
    }
  }

}
