<?php
$title = __("Rejestracja");
$id = 'loginModal';
$class = 'modal-building modal-intro';
?>

<div id="<?= $id ?>" slug="<?= Slug::slugify($title) ?>" class="modal fade <?= $class; ?>  <?= Slug::slugify($title) ?>">
  <div class="error-popup" style="<?php if (!isset($error)) echo 'display: none;'; ?>">
    <div class="error-popup-img"></div>
    <div class="error-popup-text"><?php if (isset($error)) echo $error; ?></div>
  </div>

  <div class="info-popup" style="<?php if (!isset($error)) echo 'display: none;'; ?>">
    <div class="info-popup-img"></div>
    <div class="info-popup-text"><?php if (isset($error)) echo $error; ?></div>
  </div>

  <div class="popup-all">
    <div class="modal-header">
      <h3 class="headline-blue">
        <?php echo $title; ?></h3>

      <?php if (isset($message_filters) && $message_filters): ?>
        <div class="messages-filters">
          <a href="javascript:void(0)" 
             class="<?php if ($filter == FALSE) echo 'active'; ?>" 
             onclick="Message.getMessageListModal();">
            <i class="wiadomosci-all"></i>
            <?= __('Łącznie'); ?></a>

          <a href="javascript:void(0)" 
             class="<?php if ($filter == "message") echo 'active'; ?>" 
             onclick="Message.getMessageListModal('message');">
            <i class="wiadomosci-only"></i>
            <?= __('Wiadomości'); ?></a>

          <a href="javascript:void(0)" 
             class="<?php if ($filter == "event") echo 'active'; ?>" 
             onclick="Message.getMessageListModal('event');">
            <i class="wiadomosci-eventy"></i>
            <?= __('Eventy'); ?></a>
        </div>
      <?php endif; ?>
    </div>

    <div class="clear"></div>
    <?= form_tag('@sf_guard_register', array('id' => 'signin-form')); ?>
    <div class="modal-body <?= (isset($scroll) && !$scroll) ? "oa" : ""; ?>">
      <div scrollArea="<?= (isset($scroll) && !$scroll) ? "false" : "true"; ?>">
          <?= $form; ?>
      </div>
    </div>
    <div class="modal-footer">
      <a href="<?= url_for('@homepage') ?>" class="btn fl mt10 ml20"><?= __('Anuluj') ?></a>
      <input class="btn fr mt10 mr20" value="Rejestracja" type="submit">
    </div>
    </form>
  </div>
</div>

<script type="text/javascript">
    $(document).ready(function(){ Helper.setPopupSize(); }) 
</script>