<?php

/**
 * Game form.
 *
 * @package    hotel
 * @author     Your name here
 */
class BackendChangePasswordForm extends sfGuardChangeSigninPasswordForm
{
  public function configure()
  {
    parent::configure();
    
    $this->setWidgets(array(
      'old_password' => new sfWidgetFormInputPassword(array('label' => 'Aktualne hasło', 'type' => 'password')),
      'password' => new sfWidgetFormInputPassword(array('label' => 'Nowe hasło', 'type' => 'password')),
      'password_again' => new sfWidgetFormInputPassword(array('label' => 'Nowe hasło (ponownie)', 'type' => 'password')),
    ));
    
    $this->setValidators(array(
      'old_password' => new sfValidatorString(array('min_length' => 4, 'max_length' => 128, 'required' => true), array('min_length' => 'Podane hasło jest za krótkie (minimun %min_length% znaków)', 'max_length' => 'Podane hasło jest za długie (maksimum %max_length% znaków)')),
      'password' => new sfValidatorString(array('min_length' => 4, 'max_length' => 128, 'required' => true), array('min_length' => 'Podane hasło jest za krótkie (minimun %min_length% znaków)', 'max_length' => 'Podane hasło jest za długie (maksimum %max_length% znaków)')),
      'password_again' => new sfValidatorString(array('min_length' => 4, 'max_length' => 128, 'required' => true), array('min_length' => 'Podane hasło jest za krótkie (minimun %min_length% znaków)', 'max_length' => 'Podane hasło jest za długie (maksimum %max_length% znaków)')),
    ));
    
    $this->getWidget('old_password')->setAttribute('class', 'form-control');
    $this->getWidget('password')->setAttribute('class', 'form-control');
    $this->getWidget('password_again')->setAttribute('class', 'form-control');
    
    $this->mergePostValidator(new sfValidatorSchemaCompare('password', sfValidatorSchemaCompare::EQUAL, 'password_again', array(), array('invalid' => 'Oba hasła muszą być takie same')));
    $this->mergePostValidator(new sfValidatorSchemaCompare('password', sfValidatorSchemaCompare::NOT_EQUAL, 'old_password', array('throw_global_error' => true), array('invalid' => 'Aktualne i nowe hasło nie mogą być takie same')));
    $this->mergePostValidator(new artGuardPasswordValidator('old_password', $this->getObject()));
    
    $this->disableRequiredsFieldText();
    $this->widgetSchema->setNameFormat('change_password[%s]');
    $this->getWidgetSchema()->setFormFormatterName('Flaty');
  }
  
  public function save($con = null) {
    $this->getObject()->setPassword($this->getValue('password'));
    $this->getObject()->save();
    // Nie ma potrzeby wywolywac parent::save($con) bo formularz juz nam nic nie zmienia
  }
}
