<?php

/**
 * Game form.
 *
 * @package    hotel
 * @author     Your name here
 */
class BackendGameForm extends GameForm {

  public function getChoices() {
    return array(
      0 => 'Nie',
      1 => 'Tak'
    );
  }

  public function getBaseWidgets() {
    return array(
      'id' => new sfWidgetFormInputHidden(),
      'name' => new sfArtWidgetFormInputText(array('label' => 'Nazwa gry'), array('class' => 'form-control')),
      'teams_count' => new sfArtWidgetFormInputText(array('label' => 'Liczba zespołów'), array('class' => 'form-control')),
      'max_users_per_team' => new sfArtWidgetFormInputText(array('label' => 'Maksymalna liczba graczy w zespole'), array('class' => 'form-control')),
      'efekt_pamieci' => new sfWidgetFormChoice(array('choices' => $this->getChoices(), 'label' => 'Efekt pamięci'), array('class' => 'form-control')),
      'placa_minimalna_obsluga' => new sfArtWidgetFormInputText(array('label' => 'Płaca minimalna pracowników obsługi'), array('class' => 'form-control')),
      'placa_minimalna_administracja' => new sfArtWidgetFormInputText(array('label' => 'Płaca minimalna pracowników administracji'), array('class' => 'form-control')),
      'mapa' => new sfWidgetFormChoice(array('choices' => $this->getChoices(), 'label' => 'Mapa'), array('class' => 'form-control')),
      'muzyka' => new sfWidgetFormChoice(array('choices' => $this->getChoices(), 'label' => 'Muzyka'), array('class' => 'form-control')),
    );
  }

  public function getBaseValidators() {
    return array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'name' => new sfValidatorString(array('max_length' => 255, 'min_length' => 4, 'required' => true)),
      'teams_count' => new sfValidatorInteger(array('max' => 15, 'min' => 1, 'required' => true)),
      'max_users_per_team' => new sfValidatorInteger(array('max' => 10, 'min' => 1, 'required' => true)),
      'efekt_pamieci' => new sfValidatorChoice(array('choices' => array_keys($this->getChoices()), 'required' => true)),
      'placa_minimalna_obsluga' => new sfValidatorInteger(array('max' => 50000, 'min' => 1, 'required' => true)),
      'placa_minimalna_administracja' => new sfValidatorInteger(array('max' => 50000, 'min' => 1, 'required' => true)),
      'mapa' => new sfValidatorChoice(array('choices' => array_keys($this->getChoices()), 'required' => true)),
      'muzyka' => new sfValidatorChoice(array('choices' => array_keys($this->getChoices()), 'required' => true)),
    );
  }

  public function setup() {
    $this->gameData = sfYaml::load(sfConfig::get('sf_lib_dir') . '/game/config/game.yml');
    $this->step = $this->getOption('step', 1);
    $this->teacher = $this->getOption('teacher');
    $this->setWidgets($this->getBaseWidgets());

    $this->setValidators($this->getBaseValidators());
    
    $this->validatorSchema->setPostValidator(
      new sfValidatorDoctrineUnique(array('model' => 'Game', 'column' => array('name')), array('invalid' => 'Podany nazwa gry już istnieje. Proszę wybrać inną nazwę.'))
    );

    $this->disableRequiredsFieldText();
    $this->getWidgetSchema()->setFormFormatterName('Flaty');

    $this->widgetSchema->setNameFormat('backend_game[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function configure() {
    $this->edit = false;
    $this->configureStep($this->step);
    
    $this->widgetSchema->setNameFormat('backend_game[%s]');
  }

  public function configureStep($step) {
    $baseWidgets = $this->getBaseWidgets();
    $baseValidators = $this->getBaseValidators();
    foreach ($this->getWidgetSchema()->getFields() as $name => $field) {
      $this->setWidget($name, new sfWidgetFormInputHidden());
      $this->getValidator($name)->setOption('required', false);
    }

    switch ($step) {
      case 1:
        $this->setWidget('name', $baseWidgets['name']);
        $this->setValidator('name', $baseValidators['name']);
        break;
      case 2:
        $this->setWidget('teams_count', $baseWidgets['teams_count']);
        $this->setValidator('teams_count', $baseValidators['teams_count']);
        $this->setWidget('max_users_per_team', $baseWidgets['max_users_per_team']);
        $this->setValidator('max_users_per_team', $baseValidators['max_users_per_team']);
        break;
      case 3:
        $this->setWidget('efekt_pamieci', $baseWidgets['efekt_pamieci']);
        $this->setValidator('efekt_pamieci', $baseValidators['efekt_pamieci']);
        $this->setWidget('placa_minimalna_obsluga', $baseWidgets['placa_minimalna_obsluga']);
        $this->setValidator('placa_minimalna_obsluga', $baseValidators['placa_minimalna_obsluga']);
        $this->setWidget('placa_minimalna_administracja', $baseWidgets['placa_minimalna_administracja']);
        $this->setValidator('placa_minimalna_administracja', $baseValidators['placa_minimalna_administracja']);
        $this->setWidget('mapa', $baseWidgets['mapa']);
        $this->setValidator('mapa', $baseValidators['mapa']);
        $this->setWidget('muzyka', $baseWidgets['muzyka']);
        $this->setValidator('muzyka', $baseValidators['muzyka']);
        break;
      case 4:
        break;
    }

    $this->setDefaults(array(
      'name' => substr($this->teacher->getFirstName(), 0, 1) . substr($this->teacher->getLastName(), 0, 1) . '-',
      'efekt_pamieci' => 0,
      'placa_minimalna_obsluga' => $this->gameData['all']['.array_math_model']['math_model']['zatrudnienie']['pracownicy_obslugi']['placa_minimalna'],
      'placa_minimalna_administracja' => $this->gameData['all']['.array_math_model']['math_model']['zatrudnienie']['pracownicy_administracji']['placa_minimalna'],
      'mapa' => 0,
      'muzyka' => 0,
    ));
  }

  public function configureForEdit() {
    $this->edit = true;
    $this->setWidgets($this->getBaseWidgets());
    $this->setValidators($this->getBaseValidators());

    $this->useFields(array('name', 'efekt_pamieci', 'placa_minimalna_obsluga', 'placa_minimalna_administracja', 'mapa', 'muzyka'));

    $this->getWidget('name')->setAttribute('class', 'form-control');
    $this->getWidget('efekt_pamieci')->setAttribute('class', 'form-control');
    $this->getWidget('placa_minimalna_obsluga')->setAttribute('class', 'form-control');
    $this->getWidget('placa_minimalna_administracja')->setAttribute('class', 'form-control');
    $this->getWidget('mapa')->setAttribute('class', 'form-control');
    $this->getWidget('muzyka')->setAttribute('class', 'form-control');
    $this->getWidgetSchema()->setFormFormatterName('Flaty');

    $this->gameData = HotelGameData::jsonToArray($this->getObject()->getGameDataJson());
    $this->setDefaults(array(
      'name' => $this->getObject()->getName(),
      'efekt_pamieci' => $this->gameData['efekt_pamieci'],
      'placa_minimalna_obsluga' => $this->gameData['zatrudnienie']['pracownicy_obslugi']['placa_minimalna'],
      'placa_minimalna_administracja' => $this->gameData['zatrudnienie']['pracownicy_administracji']['placa_minimalna'],
      'mapa' => $this->gameData['mapa'],
      'muzyka' => $this->gameData['muzyka'],
    ));
    
    $this->widgetSchema->setNameFormat('backend_game[%s]');
  }

  public function save($con = null) {
    $this->getObject()->setTeacherId($this->getUser()->getId());
    $this->getObject()->setGameControllerClass('HotelGameController');
    if ($this->edit) {
      $gameArray = $this->gameData;
    } else {
        $this->getObject()->setStatus(Game::PREPARED);
      $gameArray = $this->gameData['all']['.array_math_model']['math_model'];
    }
    $gameArray['zatrudnienie']['pracownicy_obslugi']['placa_minimalna'] = $this->getValue('placa_minimalna_obsluga');
    $gameArray['zatrudnienie']['pracownicy_administracji']['placa_minimalna'] = $this->getValue('placa_minimalna_administracja');
    $gameArray['efekt_pamieci'] = $this->getValue('efekt_pamieci');
    $gameArray['mapa'] = $this->getValue('mapa');
    $gameArray['muzyka'] = $this->getValue('muzyka');
    $this->getObject()->setGameDataJson(HotelGameData::arrayToJson($gameArray));
    parent::save($con);

    if (!$this->edit) {
      $gameId = $this->getObject()->getId();
      $limit = $this->getValue('teams_count');
      $teamCapacity = $this->getValue('max_users_per_team');

      for ($i = 0; $i < $limit; $i++) {
        $team = new Team();
        $team->setGameId($gameId);
        $team->setName('Zespół ' . ($i + 1));
        $team->setMaxUsers($teamCapacity);
        $team->save();
      }
    }

    return $this->getObject();
  }

}
