<?php

/**
 * sfGuardUser form.
 *
 * @package    hotel
 * @subpackage form
 * @author     Your name here
 * @version    SVN: $Id: sfDoctrinePluginFormTemplate.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class BackendGuardUserForm extends sfGuardUserForm {

  public function configure() {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'first_name' => new sfArtWidgetFormInputText(),
      'last_name' => new sfArtWidgetFormInputText(),
      'email_address' => new sfArtWidgetFormInputText(),
      'school' => new sfArtWidgetFormInputText(array('label' => 'Szkoła')),
    ));
    
    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'first_name' => new sfValidatorString(array('max_length' => 24, 'min_length' => 3, 'required' => true)),
      'last_name' => new sfValidatorString(array('max_length' => 24, 'min_length' => 2, 'required' => true)),
      'email_address' => new sfValidatorEmail(array('max_length' => 32)),
      'school' => new sfValidatorString(array('max_length' => 255, 'min_length' => 2, 'required' => true)),
    ));
    
    $this->useFields(array(
      'id', 'first_name', 'last_name', 'email_address', 'school'
    ));
    
    $this->getWidget('first_name')->setAttribute('class', 'form-control');
    $this->getWidget('last_name')->setAttribute('class', 'form-control');
    $this->getWidget('email_address')->setAttribute('class', 'form-control');
    $this->getWidget('school')->setAttribute('class', 'form-control');
    
    $userDetail = $this->getObject()->getUserDetails()->getFirst();
    if ($userDetail) {
      $this->setDefault('school', $userDetail->getSchool());
    } else {
      // Robimy na chama wpis jak nie ma
      $ud = new UserDetail();
      $ud->setId($this->getObject()->getId());
      $ud->save();
    }
    
    $this->validatorSchema->setPostValidator(
      new sfValidatorDoctrineUnique(array('model' => 'sfGuardUser', 'column' => array('email_address')), array('invalid' => 'Podany e-mail już istnieje w naszej bazie.'))
    );
    
    $this->disableRequiredsFieldText();
    $this->widgetSchema->setNameFormat('backend_profile[%s]');
    $this->getWidgetSchema()->setFormFormatterName('Flaty');
  }

  public function save($con = null) {
    $this->values['username'] = $this->values['email_address'];
    $user = parent::save($con);
    $user->getUserDetails()->getFirst()->setSchool($this->values['school']);
    $user->getUserDetails()->getFirst()->save();
    
    return $user;
  }

}
