<?php

/**
 * Game form.
 *
 * @package    hotel
 * @author     Your name here
 */
class BackendSigninForm extends sfGuardFormSignin
{
  public function configure()
  {
    $this->setWidgets(array(
        'username' => new sfArtWidgetFormInputText(),
        'password' => new sfWidgetFormInputPassword(array('type' => 'password')),
    ));
    $this->setValidators(array(
        'username' => new sfValidatorString(),
        'password' => new sfValidatorString(),
    ));
    
    
    if (sfConfig::get('app_sf_guard_plugin_remember_in_signin_form', true))
    {
      $this->widgetSchema['remember'] = new sfWidgetFormInputCheckbox();
      $this->validatorSchema['remember'] = new sfValidatorBoolean();
    }

    if (sfConfig::get('app_sf_guard_plugin_allow_login_with_email', true))
      $this->widgetSchema['username']->setLabel('E-mail');

    $this->validatorSchema->setPostValidator(new sfGuardValidatorUser());
    
    $this->getWidget('username')->setAttribute('class', 'form-control');
    $this->getWidget('password')->setAttribute('class', 'form-control');
    
    $this->disableRequiredsFieldText();
    $this->widgetSchema->setNameFormat('signin[%s]');
    $this->getWidgetSchema()->setFormFormatterName('Flaty');
  }
}
