<?php

/**
 * Game form.
 *
 * @package    hotel
 * @author     Your name here
 */
class NauczycielAnkietaPoForm extends BaseForm {

    public function setup() {
        $this->setWidgets(array(
            'p1_zaangazowanie_po' => new sfWidgetFormChoice(
                    array(
                'choices' => array(
                    '1' => '1 - Zdecydowanie większe',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4 - Nie mam zdania',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7 - Zdecydowanie mniejsze',
                ),
                'label' => '1. Jak Pan/Pani sądzi, czy w porównaniu do postawy uczniów z początku zajęć, uczniowie obecnie wykazują zaangażowanie w rozwijaniu swoich postaw przedsiębiorczych?'
                    ), array(
                'class' => 'form-control'
                    )
            ),
            'p2_sklonni_po' => new sfWidgetFormChoice(
                    array(
                'choices' => array(
                    '1' => '1 - Zdecydowanie w większym stopniu',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4 - Nie mam zdania',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7 - zdecydowanie w mniejszym stopniu',
                ),
                'label' => '2. Jak Pan/Pani sądzi, czy w porównaniu do postawy uczniów z początku zajęć, uczniowie obecnie są skłonni do podejmowania ryzyka?'
                    ), array(
                'class' => 'form-control'
                    )
            ),
            'p3_dociekliwi_po' => new sfWidgetFormChoice(
                    array(
                'choices' => array(
                    '1' => '1 - Zdecydowanie w większym stopniu',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4 - Nie mam zdania',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7 - Zdecydowanie w mniejszym stopniu',
                ),
                'label' => '3. Jak Pan/Pani sądzi, czy w porównaniu do postawy uczniów z początku zajęć, uczniowie obecnie są dociekliwi w zdobywaniu wiedzy?'
                    ), array(
                'class' => 'form-control'
                    )
            ),
            'p4_postawy_przeds_po' => new sfWidgetFormChoice(
                    array(
                'choices' => array(
                    '1' => '1 - Zdecydowanie tak',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4 - Nie mam zdania',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7 - Zdecydowanie nie',
                ),
                'label' => '4. Jak Pan/Pani sądzi, czy w porównaniu do postawy uczniów z początku zajęć, obecnie wzrosły postawy przedsiębiorcze?'
                    ), array(
                'class' => 'form-control'
                    )
            ),
            'p5_postawy_pro_po' => new sfWidgetFormChoice(
                    array(
                'choices' => array(
                    '1' => '1 - Zdecydowanie tak',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4 - Nie mam zdania',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7 - Zdecydowanie nie',
                ),
                'label' => '5. Jak Pan/Pani sądzi, czy w porównaniu do postawy uczniów z początku zajęć, obecnie wzrosły postawy prorynkowe?'
                    ), array(
                'class' => 'form-control'
                    )
            ),
            'p6_ocena_progr_po' => new sfWidgetFormChoice(
                    array(
                'choices' => array(
                    '1' => '1 - Bardzo dobrze',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4 - Nie mam zdania',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7 - Bardzo źle',
                ),
                'label' => '6. Jak Pan/Pani ocenia zastosowanie gry symulacyjnej do nauki  podstaw ekonomii i przedsiębiorczości?'
                    ), array(
                'class' => 'form-control'
                    )
            ),
            'p7_przydatne_po' => new sfWidgetFormChoice(
                    array(
                'choices' => array(
                    '1' => '1 - Bardzo przydatnym',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4 - Nie mam zdania',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7 - Kompletnie nieprzydatnym',
                ),
                'label' => '7. Czy program okazał się być adekwatny w stosunku do potrzeb uczniów w zakresie edukacji ekonomicznej?'
                    ), array(
                'class' => 'form-control'
                    )
            ),
            'p8_czypoleci_po' => new sfWidgetFormChoice(
                    array(
                'choices' => array(
                    '1' => '1 - Zdecydowanie tak',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4 - Nie mam zdania',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7 - Zdecydowanie nie',
                ),
                'label' => '8. Czy po realizacji projektu poleciłby Pan/poleciłaby Pani program edukacji ekonomicznej wraz z grą edukacyjną jako dobre narzędzie wspierające naukę przedmiotu dla innych nauczycieli ekonomii i przedsiębiorczości?'
                    ), array(
                'class' => 'form-control'
                    )
            ),
            'p9_ocena_programu_po' => new sfWidgetFormChoice(
                    array(
                'choices' => array(
                    '1' => '1 - Bardzo dobrze',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4 - Nie mam zdania',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7 - Bardzo źle',
                ),
                'label' => '9. Jak Pan/Pani ocenia program nauczania edukacji ekonomicznej w ramach realizowanego projektu?'
                    ), array(
                'class' => 'form-control'
                    )
            ),
        ));
        $this->setValidators(array(
            'p1_zaangazowanie_po' => new hotelValidatorNumber(array('required' => false, 'min' => 1)),
            'p2_sklonni_po' => new hotelValidatorNumber(array('required' => false, 'min' => 1)),
            'p3_dociekliwi_po' => new hotelValidatorNumber(array('required' => false, 'min' => 1)),
            'p4_postawy_przeds_po' => new hotelValidatorNumber(array('required' => false, 'min' => 1)),
            'p5_postawy_pro_po' => new hotelValidatorNumber(array('required' => false, 'min' => 1)),
            'p6_ocena_progr_po' => new hotelValidatorNumber(array('required' => false, 'min' => 1)),
            'p7_przydatne_po' => new hotelValidatorNumber(array('required' => false, 'min' => 1)),
            'p8_czypoleci_po' => new hotelValidatorNumber(array('required' => false, 'min' => 1)),
            'p9_ocena_programu_po' => new hotelValidatorNumber(array('required' => false, 'min' => 1)),
        ));
//    $this->getWidget('kwota')->setAttribute('class', 'form-control');

        $this->disableRequiredsFieldText();
        $this->getWidgetSchema()->setFormFormatterName('ankieta');
        $this->widgetSchema->setNameFormat('nauczyciel_ankieta_po[%s]');
        $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    }

    public function save($con = null) {

        $usersOdp = json_encode(
                array(
                    'p1_zaangazowanie_po' => $this->getValue('p1_zaangazowanie_po'),
                    'p2_sklonni_po' => $this->getValue('p2_sklonni_po'),
                    'p3_dociekliwi_po' => $this->getValue('p3_dociekliwi_po'),
                    'p4_postawy_przeds_po' => $this->getValue('p4_postawy_przeds_po'),
                    'p5_postawy_pro_po' => $this->getValue('p5_postawy_pro_po'),
                    'p6_ocena_progr_po' => $this->getValue('p6_ocena_progr_po'),
                    'p7_przydatne_po' => $this->getValue('p7_przydatne_po'),
                    'p8_czypoleci_po' => $this->getValue('p8_czypoleci_po'),
                    'p9_ocena_programu_po' => $this->getValue('p9_ocena_programu_po'),
                )
        );


        $userDetail = Doctrine::getTable('UserDetail')->findOneById($this->getUserId());

        if (!$userDetail) {
            $userDetail = new UserDetail();
            $userDetail->setSchool('Brak wypełnionej szkoły');
            $userDetail->setId($this->getUser()->getId());
            $userDetail->save();
        }

        $userDetail->setTeacherSurveyAfter($usersOdp);
        $userDetail->save();
    }

    public function configure() {
        
    }

}
