<?php

/**
 * Game form.
 *
 * @package    hotel
 * @author     Your name here
 */
class NauczycielAnkietaPrzedForm extends BaseForm {

    public function setup() {
        $this->setWidgets(array(
            'p1_zaangazowanie' => new sfWidgetFormChoice(
                    array(
                'choices' => array(
                    '1' => '1 - Bardzo duże',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4 - Nie mam zdania',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7 - Bardzo małe',
                ),
                'label' => '1. Jak Pan/Pani sądzi, czy uczniowie wykazują zaangażowanie w rozwijaniu swoich postaw prorynkowych?'
                    ), array(
                'class' => 'form-control'
                    )
            ),
            'p2_sklonni' => new sfWidgetFormChoice(
                    array(
                'choices' => array(
                    '1' => '1 - Zdecydowanie tak',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4 - Nie mam zdania',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7 - zdecydowanie nie',
                ),
                'label' => '2. Czy według Pana/Pani uczniowie są skłonni do podejmowania ryzyka?'
                    ), array(
                'class' => 'form-control'
                    )
            ),
            'p3_dociekliwi' => new sfWidgetFormChoice(
                    array(
                'choices' => array(
                    '1' => '1 - W bardzo dużym stopniu',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4 - Nie mam zdania',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7 - W bardzo małym stop',
                ),
                'label' => '3. Jak Pan/Pani sądzi, czy uczniowie są dociekliwi w zdobywaniu nowej wiedzy?'
                    ), array(
                'class' => 'form-control'
                    )
            ),
            'p4_postawy_przeds' => new sfWidgetFormChoice(
                    array(
                'choices' => array(
                    '1' => '1 - Zdecydowanie tak',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4 - Nie mam zdania',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7 - Zdecydowanie nie',
                ),
                'label' => '4. Czy według Pana/Pani, uczniowie wykazują postawy przedsiębiorcze?'
                    ), array(
                'class' => 'form-control'
                    )
            ),
            'p5_postawy_pro' => new sfWidgetFormChoice(
                    array(
                'choices' => array(
                    '1' => '1 - Zdecydowanie tak',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4 - Nie mam zdania',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7 - Zdecydowanie nie',
                ),
                'label' => '5. Czy według Pana/Pani, uczniowie wykazują postawy prorynkowe?'
                    ), array(
                'class' => 'form-control'
                    )
            ),
            'p6_ocena_progr' => new sfWidgetFormChoice(
                    array(
                'choices' => array(
                    '1' => '1 - Bardzo dobrze',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4 - Nie mam zdania',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7 - Bardzo źle',
                ),
                'label' => '6. Jak Pan/Pani ocenia program nauczania edukacji ekonomicznej w ramach realizowanego projektu?'
                    ), array(
                'class' => 'form-control'
                    )
            ),
            'p7_przydatne' => new sfWidgetFormChoice(
                    array(
                'choices' => array(
                    '1' => '1 - Bardzo przydatnym',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4 - Nie mam zdania',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7 - Kompletnie nieprzydatnym',
                ),
                'label' => '7. Czy uważa Pan/Pani, że gra edukacyjna może być przydatnym narzędziem dla nauczyciela w nauce podstaw ekonomii i przedsiębiorczości?'
                    ), array(
                'class' => 'form-control'
                    )
            ),
        ));
        $this->setValidators(array(
            'p1_zaangazowanie' => new hotelValidatorNumber(array('required' => false, 'min' => 1)),
            'p2_sklonni' => new hotelValidatorNumber(array('required' => false, 'min' => 1)),
            'p3_dociekliwi' => new hotelValidatorNumber(array('required' => false, 'min' => 1)),
            'p4_postawy_przeds' => new hotelValidatorNumber(array('required' => false, 'min' => 1)),
            'p5_postawy_pro' => new hotelValidatorNumber(array('required' => false, 'min' => 1)),
            'p6_ocena_progr' => new hotelValidatorNumber(array('required' => false, 'min' => 1)),
            'p7_przydatne' => new hotelValidatorNumber(array('required' => false, 'min' => 1)),
        ));
//    $this->getWidget('kwota')->setAttribute('class', 'form-control');

        $this->disableRequiredsFieldText();
        $this->getWidgetSchema()->setFormFormatterName('Ankieta');
        $this->widgetSchema->setNameFormat('nauczyciel_ankieta_przed[%s]');
        $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
//        $this->setupInheritance();
    }

    public function save($con = null) {

        $usersOdp = json_encode(
                array(
                    'p1_zaangazowanie' => $this->getValue('p1_zaangazowanie'),
                    'p2_sklonni' => $this->getValue('p2_sklonni'),
                    'p3_dociekliwi' => $this->getValue('p3_dociekliwi'),
                    'p4_postawy_przeds' => $this->getValue('p4_postawy_przeds'),
                    'p5_postawy_pro' => $this->getValue('p5_postawy_pro'),
                    'p6_ocena_progr' => $this->getValue('p6_ocena_progr'),
                    'p7_przydatne' => $this->getValue('p7_przydatne'),
                )
        );

        $userDetail = Doctrine::getTable('UserDetail')->findOneById($this->getUser()->getId());

        if (!$userDetail) {
            $userDetail = new UserDetail();
            $userDetail->setSchool('Brak wypełnionej szkoły');
            $userDetail->setId($this->getUser()->getId());
            $userDetail->save();
        }
        
        $userDetail->setTeacherSurveyBefore($usersOdp);
        $userDetail->save();
    }

    public function configure() {
        
    }

}
