<?php

/**
 * Game form.
 *
 * @package    hotel
 * @author     Your name here
 */
class NauczycielAnkietaPrzedOcenaForm extends BaseTeamForm {

    public $formData;

    /**
     * Returns choices for adequacy inputs
     * @return array
     */
    private function getAdequacyFormChoices() {
        return array(
            1 => '1 - Nieadekwatnie',
            2 => '2',
            3 => '3 - Średnio',
            4 => '4',
            5 => '5 - Adekwatnie'
        );
    }

    /**
     * Returns choices for correctness inputs
     * @return array
     */
    private function getCorrectnessFormChoices() {
        return array(
            1 => '1 - Niepoprawnie',
            2 => '2',
            3 => '3 - Średnio',
            4 => '4',
            5 => '5 - Poprawnie'
        );
    }

    /**
     * Returns choices for accuracy inputs
     * @return array
     */
    private function getAccuracyFormChoices() {
        return array(
            1 => '1 - Nietrafnie',
            2 => '2',
            3 => '3 - Średnio',
            4 => '4',
            5 => '5 - Trafnie'
        );
    }

    /**
     * Returns array with names of open-type questions
     * @return array
     */
    private function getOpenQuestionsNames() {
        return array(
            0 => 'test_przed_1',
            1 => 'test_przed_2',
            2 => 'test_przed_5',
            3 => 'test_przed_6',
            4 => 'test_przed_10',
            5 => 'test_przed_11',
            6 => 'test_przed_12',
            7 => 'test_przed_13',
            8 => 'test_przed_14',
            9 => 'test_przed_15',
            10 => 'test_przed_16',
        );
    }

    /**
     * Returns array with names of open-type questions
     * @return array
     */
    private function getOpenQuestionsTrans() {
        return array(
            0 => 'test_przed_1',
            1 => 'test_przed_2',
            2 => 'test_przed_3',
            3 => 'test_przed_4',
            4 => 'test_przed_5',
            5 => 'test_przed_6',
            6 => 'test_przed_7',
            7 => 'test_przed_8',
            8 => 'test_przed_9',
            9 => 'test_przed_10',
            10 => 'test_przed_11',
        );
    }

    public function setup() {
        $this->formData = array();
        $this->setWidgets(array());
        $this->setValidators(array());
        $qNames = $this->getOpenQuestionsNames();
        $qTrans = $this->getOpenQuestionsTrans();
        $team = $this->getObject()->getId();
        $users = Doctrine_Core::getTable('sfGuardUser')->createQuery('u')
                ->leftJoin('u.user_details ud')
                ->leftJoin('u.user_has_teams t')
                ->where('t.team_id = ?', $team)
                ->andWhere('ud.student_test_before IS NOT NULL')
                ->execute();

        foreach ($users as $user) {
            $userDetail = $user->getUserDetails()->getFirst();
            $surveys = $userDetail->getStudentTestBeforeTeamArray($team);
            $grades = $userDetail->getTeacherTestGradeBeforeTeamArray($team);

            foreach ($surveys as $key => $survey) {
                foreach ($survey as $question => $answer) {
                    if (\in_array($question, $qNames)) {
                        $this->setWidget($key . '_' . $question . '_r', new sfWidgetFormChoice(array(
                            'choices' => $this->getAdequacyFormChoices(),
                            'default' => 3,
                            'label' => 'Adekwatność'))
                        );
                        $this->setValidator($key . '_' . $question . '_r', new hotelValidatorNumber(array(
                            'required' => false,
                            'min' => 1,
                            'max' => 5))
                        );
                        $this->setWidget($key . '_' . $question . '_e', new sfWidgetFormChoice(array(
                            'choices' => $this->getCorrectnessFormChoices(),
                            'default' => 3,
                            'label' => 'Poprawność'))
                        );
                        $this->setValidator($key . '_' . $question . '_e', new hotelValidatorNumber(array(
                            'required' => false,
                            'min' => 1,
                            'max' => 5))
                        );
                        $this->setWidget($key . '_' . $question . '_p', new sfWidgetFormChoice(array(
                            'choices' => $this->getAccuracyFormChoices(),
                            'default' => 3,
                            'label' => 'Trafność'))
                        );
                        $this->setValidator($key . '_' . $question . '_p', new hotelValidatorNumber(array(
                            'required' => false,
                            'min' => 1,
                            'max' => 5))
                        );
                        $graded = true;

                        if (isset($grades[$key . '_' . $question . '_r'])) {
                            $this->setDefault($key . '_' . $question . '_r', $grades[$key . '_' . $question . '_r']);
                        } else {
                            $graded = false;
                        }

                        if (isset($grades[$key . '_' . $question . '_e'])) {
                            $this->setDefault($key . '_' . $question . '_e', $grades[$key . '_' . $question . '_e']);
                        } else {
                            $graded = false;
                        }

                        if (isset($grades[$key . '_' . $question . '_p'])) {
                            $this->setDefault($key . '_' . $question . '_p', $grades[$key . '_' . $question . '_p']);
                        } else {
                            $graded = false;
                        }
                        //add question attributes block
                        $this->formData[$key . '_' . $question] = array(
                            'w1' => $key . '_' . $question . '_r',
                            'w2' => $key . '_' . $question . '_e',
                            'w3' => $key . '_' . $question . '_p',
                            'question' => $qTrans[array_search($question, $qNames)],
                            'answer' => $answer,
                            'graded' => $graded,
                        );
                    }
                }
            }
        }

        $this->disableRequiredsFieldText();
        $this->getWidgetSchema()->setFormFormatterName('Flaty');
        $this->widgetSchema->setNameFormat('nauczyciel_ankieta_przed_ocena[%s]');
        $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
        $this->setupInheritance();
    }

    public function save($con = null) {
        $team = $this->getObject()->getId();
        $qNames = $this->getOpenQuestionsNames();
        $users = Doctrine_Core::getTable('sfGuardUser')->createQuery('u')
                ->leftJoin('u.user_details ud')
                ->leftJoin('u.user_has_teams t')
                ->where('t.team_id = ?', $team)
                ->andWhere('ud.student_test_before IS NOT NULL')
                ->execute();

        foreach ($users as $user) {
            $userDetail = $user->getUserDetails()->getFirst();
            $surveys = $userDetail->getStudentTestBeforeTeamArray($team);
            $grades = $userDetail->getTeacherTestGradeBeforeTeamArray($team);

            foreach ($surveys as $key => $survey) {
                foreach ($survey as $question => $answer) {
                    if (\in_array($question, $qNames)) {
                        $grades[$key . '_' . $question . '_r'] = $this->getValue($key . '_' . $question . '_r');
                        $grades[$key . '_' . $question . '_e'] = $this->getValue($key . '_' . $question . '_e');
                        $grades[$key . '_' . $question . '_p'] = $this->getValue($key . '_' . $question . '_p');
                    }
                }
            }

            $gradesAll = $userDetail->getTeacherTestGradeBeforeArray();
            $gradesAll[$team] = $grades;
            $userDetail->setTeacherTestGradeBefore(json_encode($gradesAll));
            $userDetail->save();
        }
    }

    public function configure() {
        
    }

}
