<?php

/*
 * This file is part of the symfony package.
 * (c) 2004-2006 Fabien Potencier <fabien.potencier@symfony-project.com>
 * 
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * defaultActions module.
 *
 * @package    symfony
 * @subpackage action
 * @author     Fabien Potencier <fabien.potencier@symfony-project.com>
 * @version    SVN: $Id: actions.class.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class defaultActions extends PluginDefaultActions {

  public function executeMaterialy(sfWebRequest $request) {
    $this->files = array(
      'LC_Roznorodnosc_ver4' => '/files/LC_Roznorodnosc_ver4.pptx',
      'Orange Diversity - Managerowie - Druk dwustronny 1 raz dla grupy' => '/files/Orange Diversity - Managerowie - Druk dwustronny 1 raz dla grupy.pdf',
      'Orange Diversity - Specjaliści - Bez podziału na role - Druk dwustronny 1 raz dla każdego uczestnika' => '/files/Orange Diversity - Specjaliści - Bez podziału na role - Druk dwustronny 1 raz dla każdego uczestnika.pdf',
      'Orange Diversity - Specjaliści - Druk dwustronny 1 raz dla grupy' => '/files/Orange Diversity - Specjaliści - Druk dwustronny 1 raz dla grupy.pdf',
      'Orange Diversity - Zaawansowani Managerowie - Druk dwustronny 1 raz dla grupy Skrócone role' => '/files/Orange Diversity - Zaawansowani Managerowie - Druk dwustronny 1 raz dla grupy Skrócone role.pdf',
      'Orange Roznorodnosc - Arkusz obserwacji grupy x ilość grup' => '/files/Orange Roznorodnosc - Arkusz obserwacji grupy x ilość grup.pdf',
      'Orange Roznorodnosc - Hand out ver 4.0' => '/files/Orange Roznorodnosc - Hand out ver 4.0.pdf',
      'Orange Roznorodnosc - Hand out z Przykładami v 2' => '/files/Orange Roznorodnosc - Hand out z Przykładami v 2.pdf',
      'Orange Roznorodnosc - Pytania & Podsumowanie po każdej rundzie ver 2.0' => '/files/Orange Roznorodnosc - Pytania & Podsumowanie po każdej rundzie ver 2.0.pdf',
      'Zarządzanie różnorodnością - Scenariusz Warsztatu ver 6.02.2014' => '/files/Zarządzanie różnorodnością - Scenariusz Warsztatu ver 6.02.2014.xlsx',
    );
  }

  /**
   * Congratulations page for creating an application
   *
   */
  public function executeIndex() {
    
  }

  /**
   * Congratulations page for creating a module
   *
   */
  public function executeModule() {
    
  }

  /**
   * Error page for page not found (404) error
   *
   */
  public function executeError404() {
    
  }

  /**
   * Warning page for restricted area - requires login
   *
   */
  public function executeSecure() {
    
  }

  /**
   * Warning page for restricted area - requires credentials
   *
   */
  public function executeLogin() {
    
  }

  /**
   * Module disabled in settings.yml
   *
   */
  public function executeDisabled() {
    
  }

  public function executeMojeKonto(sfWebRequest $request) {
    $this->formProfile = new BackendGuardUserForm($this->getUser()->getGuardUser());
    $this->formPassword = new BackendChangePasswordForm($this->getUser()->getGuardUser());
    $type = $request->getParameter('formType', false);

    if ($type && $type == 'profile') {
      $this->formProfile->bindFromRequest($request);

      if ($this->formProfile->isValid()) {
        $this->formProfile->save();
        $this->getUser()->setNotice('Twoje dane zostały pomyślnie zaktualizowane.');
      }
    }
    if ($type && $type == 'password') {
      $this->formPassword->bindFromRequest($request);
          
      if ($this->formPassword->isValid()) {
        $this->formPassword->save();
        $this->getUser()->setNotice('Twoje hasło zostało pomyślnie zaktualizowane.');
      }
    }
  }

}
