<?php

function FileSizeConvert($bytes) {
    $bytes = floatval($bytes);
    $arBytes = array(
        0 => array(
            "UNIT" => "TB",
            "VALUE" => pow(1024, 4)
        ),
        1 => array(
            "UNIT" => "GB",
            "VALUE" => pow(1024, 3)
        ),
        2 => array(
            "UNIT" => "MB",
            "VALUE" => pow(1024, 2)
        ),
        3 => array(
            "UNIT" => "KB",
            "VALUE" => 1024
        ),
        4 => array(
            "UNIT" => "B",
            "VALUE" => 1
        ),
    );

    foreach ($arBytes as $arItem) {
        if ($bytes >= $arItem["VALUE"]) {
            $result = $bytes / $arItem["VALUE"];
            $result = str_replace(".", ",", strval(round($result, 2))) . " " . $arItem["UNIT"];

            break;
        }
    }

    return $result;
}
?>

<div class="row">
    <div class="col-md-12">
        <div class="box">
            <div class="box-title">
                <h3><i class="icon-book"></i> <?php echo __('Materiały') ?></h3>
                <div class="box-tool">
                    <a data-action="collapse" href="#"><i class="icon-chevron-up"></i></a>
                </div>
            </div>
            <div class="box-content">
                <ul class="things-to-do">
                    <?php foreach ($files as $name => $file) : ?>
                        <li>
                            <p>
                                <a href="<?= $file; ?>" target="_blank">
                                    <?php if (strpos($file, '.pdf') === false) : ?>
                                        <i class="megaicon1-page"></i>
                                    <?php else: ?>
                                        <i class="megaicon1-page-pdf"></i>
                                    <?php endif; ?>
                                    <span><?= $name; ?></span>
                                    <span class="btn btn-success">Pobierz</span>
                                </a>
                            </p>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
    </div>
</div>