<?php

require_once dirname(__FILE__) . '/../lib/gameGeneratorConfiguration.class.php';
require_once dirname(__FILE__) . '/../lib/gameGeneratorHelper.class.php';

/**
 * game actions.
 *
 * @package    hotel
 * @subpackage game
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class gameActions extends autoGameActions {

    public function executeZmienne(sfWebRequest $request) {
        $this->game = Doctrine::getTable('Game')->findOneById($request->getParameter('id'));

        if ($this->game) {
            $this->team = $this->game->getTeams()->getFirst();
        } else {
            $this->getUser()->setError('Gra nie istnieje. Proszę spróbować ponownie.');
            $this->redirect('@teamArchive');
        }

        if (!$this->team) {
            $this->getUser()->setError('Gracz nie istnieje w tym zespole');
            $this->redirect('@teamArchive');
        }

        try {
            $data = $this->game->getGameDataJson();
            $this->gameData = HotelGameData::jsonToArray($data);
        } catch (Exception $ex) {
            $this->getUser()->setError('Raport który chcesz podejrzeć nie jest jeszcze dostępny.');
            $this->redirect('@teamArchive');
        }
    }

    public function executeMaterialy(sfWebRequest $request) {
        
    }

    public function executeWynikiGry(sfWebRequest $request) {
        $gameId = $request->getParameter('id');
        $this->game = Doctrine::getTable('Game')->findOneById($gameId);

        if (!$this->game) {
            $this->getUser()->setError('Gra nie istnieje. Spróbuj ponownie.');
            $this->redirect('@game');
        }

        $teams = Doctrine::getTable('Team')->getTeamsByGameId($gameId);
        $this->gameControllers = array();

        foreach ($teams as $team) {
            $this->gameControllers[$team->getId()] = $this->getGameControllerForTeam($team->getId());
        }
    }

    public function getGameControllerForTeam($teamId) {
        $team = Doctrine::getTable('Team')->findOneById($teamId);

        if (!$team) {
            $this->getUser()->setError('Zespół nie istnieje');
            $this->redirect('@team');
        }

        try {
            $gameController = new HotelGameController($team->getId());
        } catch (Exception $ex) {
            $this->getUser()->setError('Raport który chcesz podejrzeć nie jest jeszcze dostępny.');
            $this->redirect('@team');
        }

        if (!$gameController->rGT(1)) {
            $this->getUser()->setError('Raport który chcesz podejrzeć nie jest jeszcze dostępny.');
            $this->redirect('@team');
        }

        return $gameController;
    }

    public function executeActivate(sfWebRequest $request) {
        $gameId = $request->getParameter('id');

        try {
            HotelGameController::activateGame($gameId);
            $this->getUser()->setNotice('Gra "' . $this->getRoute()->getObject()->getName() . '" została aktywowana.');
        } catch (Exception $e) {
            $this->getUser()->setNotice('Przypisz co najmniej jeden zespół, aby aktywować grę.');
        }

        $this->redirect('@game');
    }

    public function executeDeactivate(sfWebRequest $request) {
        $gameId = $request->getParameter('id');
        HotelGameController::deactivateGame($gameId);
        $this->getUser()->setNotice('Gra została deaktywowana.');
        $this->redirect('@game');
    }

    public function executeNextRound(sfWebRequest $request) {
        $gameId = $request->getParameter('id');

        try {
            HotelGameController::moveToNextRoundForGame($gameId);
            $this->getUser()->setNotice('Wszystkie zespoły w grze "' . $this->getRoute()->getObject()->getName() . '" zostały przeniesione do kolejnej rundy.');
        } catch (Exception $e) {
            $this->getUser()->setNotice($e->getMessage());
        }

        $this->redirect('@game');
    }

    public function executeArchive(sfWebRequest $request) {
        $gameId = $request->getParameter('id');
        HotelGameController::archiveGame($gameId);
        $this->getUser()->setNotice('Gra "' . $this->getRoute()->getObject()->getName() . '" została przeniesiona do archiwum.');
        $this->redirect('@game');
    }

    public function executeNew(sfWebRequest $request) {
        $this->step = $request->getParameter('step', 1);
        $this->form = new BackendGameForm(null, array('step' => $this->step, 'teacher' => $this->getUser()->getGuardUser()));
        $this->game = $this->form->getObject();
    }

    public function executeCreate(sfWebRequest $request) {
        $this->step = $request->getParameter('step', 1);
        $this->form = new BackendGameForm(null, array('step' => $this->step, 'teacher' => $this->getUser()->getGuardUser()));
        $this->game = $this->form->getObject();

        $this->processFormWizard($request, $this->form);

        $this->setTemplate('new');
    }

    protected function processFormWizard(sfWebRequest $request, sfForm $form) {
        $form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));

        if ($form->isValid()) {
            if ($this->step == 4) {
                $game = $form->save();
                $this->getUser()->setFlash('notice', 'Gra "' . $game->getName() . '" została pomyślnie utworzona.');
                $this->redirect('@game');
            } else {
                $this->step++;
                $form->configureStep($this->step);
            }
        }
    }

    public function executeEdit(sfWebRequest $request) {
        $this->game = $this->getRoute()->getObject();
        $this->form = $this->configuration->getForm($this->game);
    }

    public function executeUpdate(sfWebRequest $request) {
        $this->game = $this->getRoute()->getObject();
        $this->form = $this->configuration->getForm($this->game);

        $this->processForm($request, $this->form);

        $this->setTemplate('edit');
    }

    public function executeAnkietaPrzed(sfWebRequest $request) {
        $survey = '{}';
        if ($this->getUser()->hasSurveyBefore()) {
            $survey = $this->getUser()->getGuardUser()->getUserDetails()->getFirst()->getTeacherSurveyBefore();
        }
        $defaults = json_decode($survey, true);
        $this->form = new NauczycielAnkietaPrzedForm($defaults);

        if ($request->isMethod('post')) {
            $this->form->bind($request->getParameter($this->form->getName()));

            if ($this->form->isValid()) {
                $this->form->save();
                $this->getUser()->setNotice('Ankieta zapisana poprawnie. Dziękujemy!');
            }
        }

        $this->setTemplate('ankieta');
    }

    public function executeAnkietaPo(sfWebRequest $request) {
        $survey = '{}';
        if ($this->getUser()->hasSurveyAfter()) {
            $survey = $this->getUser()->getGuardUser()->getUserDetails()->getFirst()->getTeacherSurveyAfter();
        }
        $defaults = json_decode($survey, true);
        $this->form = new NauczycielAnkietaPoForm($defaults);

        if ($request->isMethod('post')) {
            $this->form->bind($request->getParameter($this->form->getName()));

            if ($this->form->isValid()) {
                $this->form->save();
                $this->getUser()->setNotice('Ankieta zapisana poprawnie. Dziękujemy!');
            }
        }

        $this->setTemplate('ankieta2');
    }

    public function executeAnkietaPrzedOcena(sfWebRequest $request) {
        $this->team = Doctrine::getTable('Team')->findOneById($request->getParameter('team_id'));
        $this->form = new NauczycielAnkietaPrzedOcenaForm($this->team);
        $this->viewTitle = 'Ankieta przed oceną';

        /**
         * Get attributes blocks for form rendering
         * @see NauczycielAnkietaPrzedOcenaForm
         */
        $this->formData = $this->form->formData;

        if ($request->isMethod('post')) {
            $this->form->bind($request->getParameter($this->form->getName()));

            if ($this->form->isValid()) {
                $this->form->save();
                $this->getUser()->setNotice('Ocena testu zapisana poprawnie. Dziękujemy!');
            }
        }

        $this->formRouting = 'ankieta_przed_ocena';
        $this->setTemplate('ankietaOcena');
    }

    public function executeAnkietaPoOcenie(sfWebRequest $request) {
        $this->team = Doctrine::getTable('Team')->findOneById($request->getParameter('team_id'));
        $this->form = new NauczycielAnkietaPoOcenaForm($this->team);
        $this->viewTitle = 'Ankieta po ocenie';

        /**
         * Get attributes blocks for form rendering
         * @see NauczycielAnkietaPoOcenaForm
         */
        $this->formData = $this->form->formData;

        if ($request->isMethod('post')) {
            $this->form->bind($request->getParameter($this->form->getName()));

            if ($this->form->isValid()) {
                $this->form->save();
                $this->getUser()->setNotice('Ocena testu zapisana poprawnie. Dziękujemy!');
            }
        }

        $this->formRouting = 'ankieta_po_ocenie';
        $this->setTemplate('ankietaOcena');
    }

    public function executeDownloadStudentSurveyBefore(sfWebRequest $request) {
        require_once dirname(__FILE__) . '/../lib/surveyCollection.class.php';
        require_once dirname(__FILE__) . '/../lib/userCollection.class.php';

        $game = Doctrine::getTable('Game')->findOneById($request->getParameter('id'));

        if (!$game) {
            $this->getUser()->setError('Gra nie istnieje. Spróbuj ponownie.');
            $this->redirect('@game');
        }

        $surveys = new surveyCollection();
        $users = new userCollection();
        $usersObj = Doctrine_Core::getTable('sfGuardUser')->createQuery('u')
                ->leftJoin('u.user_details ud')
                ->leftJoin('u.user_has_teams ut')
                ->leftJoin('ut.Team t')
                ->where('t.game_id = ?', $game->getId())
                ->andWhere('ud.student_survey_before IS NOT NULL')
                ->execute();

        foreach ($usersObj as $user) {
            $userDetail = $user->getUserDetails()->getFirst();
            $id = $user->getId();
            $surveyData = $userDetail->getStudentSurveyBeforeArray();
            $userData = array(
                'firstName' => $user->getFirstName(),
                'lastName' => $user->getLastName(),
                'schoolName' => $userDetail->getSchool()
            );

            $surveys->addSurvey($surveyData, $id);
            $users->addUser($userData, $id);
        }

        $this->prepareSurveySpreadsheet($surveys, $users, $game->getName(), 'before');

        return sfView::NONE;
    }

    public function executeDownloadStudentSurveyAfter(sfWebRequest $request) {
        require_once dirname(__FILE__) . '/../lib/surveyCollection.class.php';
        require_once dirname(__FILE__) . '/../lib/userCollection.class.php';

        $game = Doctrine::getTable('Game')->findOneById($request->getParameter('id'));

        if (!$game) {
            $this->getUser()->setError('Gra nie istnieje. Spróbuj ponownie.');
            $this->redirect('@game');
        }

        $surveys = new surveyCollection();
        $users = new userCollection();
        $usersObj = Doctrine_Core::getTable('sfGuardUser')->createQuery('u')
                ->leftJoin('u.user_details ud')
                ->leftJoin('u.user_has_teams ut')
                ->leftJoin('ut.Team t')
                ->where('t.game_id = ?', $game->getId())
                ->andWhere('ud.student_survey_after IS NOT NULL')
                ->execute();

        foreach ($usersObj as $user) {
            $userDetail = $user->getUserDetails()->getFirst();
            $id = $user->getId();
            $surveyData = $userDetail->getStudentSurveyAfterArray();
            $userData = array(
                'firstName' => $user->getFirstName(),
                'lastName' => $user->getLastName(),
                'schoolName' => $userDetail->getSchool()
            );

            $surveys->addSurvey($surveyData, $id);
            $users->addUser($userData, $id);
        }

        $this->prepareSurveySpreadsheet($surveys, $users, $game->getName(), 'after');

        return sfView::NONE;
    }

    public function executeDownloadStudentTestBefore(sfWebRequest $request) {
        require_once dirname(__FILE__) . '/../lib/testCollection.class.php';
        require_once dirname(__FILE__) . '/../lib/userCollection.class.php';

        $game = Doctrine::getTable('Game')->findOneById($request->getParameter('id'));

        if (!$game) {
            $this->getUser()->setError('Gra nie istnieje. Spróbuj ponownie.');
            $this->redirect('@game');
        }

        $tests = new testCollection();
        $users = new userCollection();
        $usersObj = Doctrine_Core::getTable('sfGuardUser')->createQuery('u')
                ->leftJoin('u.user_details ud')
                ->leftJoin('u.user_has_teams ut')
                ->leftJoin('ut.Team t')
                ->where('t.game_id = ?', $game->getId())
                ->andWhere('ud.student_test_before IS NOT NULL')
                ->andWhere('ud.teacher_test_grade_before IS NOT NULL')
                ->execute();

        foreach ($usersObj as $user) {
            $userDetail = $user->getUserDetails()->getFirst();
            $id = $user->getId();
            $testData = $userDetail->getStudentTestBeforeArray();
            $gradeData = $userDetail->getTeacherTestGradeBeforeArray();
            $userData = array(
                'firstName' => $user->getFirstName(),
                'lastName' => $user->getLastName(),
                'schoolName' => $userDetail->getSchool(),
            );
            $tests->addTest($testData, $gradeData, $id);
            $users->addUser($userData, $id);
        }

        $this->prepareTestSpreadsheet($tests, $users, $game->getName(), 'before');

        return sfView::NONE;
    }

    public function executeDownloadStudentTestAfter(sfWebRequest $request) {
        require_once dirname(__FILE__) . '/../lib/testCollection.class.php';
        require_once dirname(__FILE__) . '/../lib/userCollection.class.php';

        $game = Doctrine::getTable('Game')->findOneById($request->getParameter('id'));

        if (!$game) {
            $this->getUser()->setError('Gra nie istnieje. Spróbuj ponownie.');
            $this->redirect('@game');
        }

        $tests = new testCollection();
        $users = new userCollection();
        $usersObj = Doctrine_Core::getTable('sfGuardUser')->createQuery('u')
                ->leftJoin('u.user_details ud')
                ->leftJoin('u.user_has_teams ut')
                ->leftJoin('ut.Team t')
                ->where('t.game_id = ?', $game->getId())
                ->andWhere('ud.student_test_before IS NOT NULL')
                ->andWhere('ud.teacher_test_grade_after IS NOT NULL')
                ->execute();

        foreach ($usersObj as $user) {
            $userDetail = $user->getUserDetails()->getFirst();
            $id = $user->getId();
            $testData = $userDetail->getStudentTestAfterArray();
            $gradeData = $userDetail->getTeacherTestGradeAfterArray();
            $userData = array(
                'firstName' => $user->getFirstName(),
                'lastName' => $user->getLastName(),
                'schoolName' => $userDetail->getSchool(),
            );

            $tests->addTest($testData, $gradeData, $id);
            $users->addUser($userData, $id);
        }

        $this->prepareTestSpreadsheet($tests, $users, $game->getName(), 'after');

        return sfView::NONE;
    }

    public function prepareSurveySpreadsheet(surveyCollection $surveys, userCollection $users, $gameName, $surveyType) {
        require_once(sfConfig::get('sf_plugins_dir') . "/artLibraryPlugin/lib/phpExcel/PHPExcel.php");
        require_once(sfConfig::get('sf_plugins_dir') . "/artLibraryPlugin/lib/phpExcel/PHPExcel/IOFactory.php");

        $fileName = 'survey_' . $surveyType . '_' . $gameName . '_' . time() . '.xls';
        $spreadsheetTitle = 'Ankiety ' . (($surveyType == 'before') ? 'przed ' : 'po ') . $gameName;
        $spreadsheetUserData = array('Typ ankiety', 'Id', 'Imię', 'Nazwisko', 'Płeć', 'Nazwa szkoły', 'Numer klasy');

        if ($surveyType == 'before') {
            $spreadsheetQuestions = array(
                '1. Co sądzisz o założeniu własnej firmy w przyszłości?',
                '2. Czy uważasz, że rola przedsiębiorcy jest',
                '3. Twoim zdaniem możliwość pracy w małym przedsiębiorstwie',
                '4. Z regułami rynkowymi nie da się wygrać',
                '5. Wiedzę ekonomiczną uważam za',
                '6. Uważam, że kariera zawodowa jako właściciel własnej firmy',
                '7. Uważam, że praca w czyjejś firmie',
                '8. Określ w jakim stopniu Twoja przyszłość zależy od Ciebie',
                '9. Czy uważasz, że posiadasz wystarczającą wiedzę pozwalającą na założenie i prowadzenie własnej firmy?',
                '10. Czy uważasz, że wiesz na czym polega prowadzenie własnej firmy?',
                '11. Czy sądzisz, że rola przedsiębiorcy jest niedoceniania w społeczeństwie?',
                '12. Czy sądzisz, że branie kredytów to dobry pomysł?',
                '13. Twoim zdaniem, firmy na rynku powinny zachowywać się'
            );
        } else {
            $spreadsheetQuestions = array(
                '1. Co sądzisz o założeniu własnej firmy w przyszłości?',
                '2. Rola przedsiębiorcy jest',
                '3. Możliwość pracy w małym przedsiębiorstwie',
                '4. Z regułami rynkowymi nie da się wygrać',
                '5. Wiedzę ekonomiczną uważam za',
                '6. Uważam, że kariera zawodowa jako właściciel własnej firmy',
                '7. Uważam, że praca w czyjejś firmie',
                '8. Określ w jakim stopniu Twoja przyszłość zależy od Ciebie',
                '9. Czy uważasz, że posiadasz wystarczającą wiedzę pozwalającą na założenie i prowadzenie własnej firmy?',
                '10. Czy uważasz, że wiesz na czym polega prowadzenie własnej firmy?',
                '11. Czy sądzisz, że rola przedsiębiorcy jest niedoceniania w społeczeństwie?',
                '12. Czy sądzisz, że branie kredytów to dobry pomysł?',
                '13. Twoim zdaniem, firmy na rynku powinny zachowywać się',
                '14. Czy byłbyś zainteresowany dalszym pogłębianie wiedzy ekonomicznej?',
                '15. Jak oceniasz ten program nauczania na tle innych zrealizowanych zajęć w szkole?',
                '16. Jak oceniasz wykorzystanie gry symulacyjnej do realizacji tego przedmiotu?',
                '17. Czy kontynuowałbyś naukę dotyczącą przedsiębiorczości, jeśli miałbyś taką możliwość?',
                '18. Czy w przyszłości, samodzielnie będziesz poszerzał swoją wiedzę na temat rynku?',
                '19. Czy podobała Ci się taka forma przekazywania wiedzy na temat przedsiębiorczości?',
                '20. Czy zarekomendowałbyś te zajęcia swoim  kolegom/koleżankom?',
                '21. Czy taka forma według Ciebie jest ciekawsza od standardowych zajęć?',
                '22. Czy uważasz, że zastosowanie gry symulacyjnej w tym przedmiocie pomogło w nauce?');
        }

        $spreadsheetTopRow = array_merge($spreadsheetUserData, $spreadsheetQuestions);

        $spreadsheetData = array(
            $spreadsheetTopRow
        );

        $objPHPExcel = new PHPExcel();
        $objPHPExcel->removeSheetByIndex(0); // remove default empty worksheet
        $surveysSpreadsheet = $objPHPExcel->createSheet();
        $surveysSpreadsheet->setTitle($spreadsheetTitle);

        $ids = $surveys->keys();

        foreach ($ids as $id) {
            $surveyTypeSub = ($surveyType == 'before') ? 1 : 2;
            $user = $users->getUser($id);
            $answers = $this->getSurveyAnswersArray($surveys->getSurvey($id), $surveyType);
            $userData = array($surveyTypeSub, $id, $user['firstName'], $user['lastName'], null, $user['schoolName'], null,);
            $spreadsheetRow = array_merge($userData, $answers);

            array_push($spreadsheetData, $spreadsheetRow);
        }

        $objPHPExcel->getSheetByName($spreadsheetTitle)
                ->fromArray(
                        $spreadsheetData, // The data to set
                        NULL, // Array values with this value will not be set
                        'A1'         // Top left coordinate of the worksheet range where we want to set these values (default is A1)
        );

        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $fileName . '"');
        header('Cache-Control: max-age=0');

        $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $writer->save('php://output');
    }

    public function getSurveyAnswersArray($array, $arrayType) {
        $type = ($arrayType == 'before') ? 'przed' : 'po';

        if ($arrayType == 'before') {
            return array(
                isset($array['ankiety_' . $type . '_1']) ? $array['ankiety_' . $type . '_1'] : null,
                isset($array['ankiety_' . $type . '_2']) ? $array['ankiety_' . $type . '_2'] : null,
                isset($array['ankiety_' . $type . '_3']) ? $array['ankiety_' . $type . '_3'] : null,
                isset($array['ankiety_' . $type . '_4']) ? $array['ankiety_' . $type . '_4'] : null,
                isset($array['ankiety_' . $type . '_5']) ? $array['ankiety_' . $type . '_5'] : null,
                isset($array['ankiety_' . $type . '_6']) ? $array['ankiety_' . $type . '_6'] : null,
                isset($array['ankiety_' . $type . '_7']) ? $array['ankiety_' . $type . '_7'] : null,
                isset($array['ankiety_' . $type . '_8']) ? $array['ankiety_' . $type . '_8'] : null,
                isset($array['ankiety_' . $type . '_9']) ? $array['ankiety_' . $type . '_9'] : null,
                isset($array['ankiety_' . $type . '_10']) ? $array['ankiety_' . $type . '_10'] : null,
                isset($array['ankiety_' . $type . '_11']) ? $array['ankiety_' . $type . '_11'] : null,
                isset($array['ankiety_' . $type . '_12']) ? $array['ankiety_' . $type . '_12'] : null,
                isset($array['ankiety_' . $type . '_13']) ? $array['ankiety_' . $type . '_13'] : null
            );
        } else {
            return array(
                isset($array['ankiety_' . $type . '_1']) ? $array['ankiety_' . $type . '_1'] : null,
                isset($array['ankiety_' . $type . '_2']) ? $array['ankiety_' . $type . '_2'] : null,
                isset($array['ankiety_' . $type . '_3']) ? $array['ankiety_' . $type . '_3'] : null,
                isset($array['ankiety_' . $type . '_4']) ? $array['ankiety_' . $type . '_4'] : null,
                isset($array['ankiety_' . $type . '_5']) ? $array['ankiety_' . $type . '_5'] : null,
                isset($array['ankiety_' . $type . '_6']) ? $array['ankiety_' . $type . '_6'] : null,
                isset($array['ankiety_' . $type . '_7']) ? $array['ankiety_' . $type . '_7'] : null,
                isset($array['ankiety_' . $type . '_8']) ? $array['ankiety_' . $type . '_8'] : null,
                isset($array['ankiety_' . $type . '_9']) ? $array['ankiety_' . $type . '_9'] : null,
                isset($array['ankiety_' . $type . '_10']) ? $array['ankiety_' . $type . '_10'] : null,
                isset($array['ankiety_' . $type . '_11']) ? $array['ankiety_' . $type . '_11'] : null,
                isset($array['ankiety_' . $type . '_12']) ? $array['ankiety_' . $type . '_12'] : null,
                isset($array['ankiety_' . $type . '_13']) ? $array['ankiety_' . $type . '_13'] : null,
                isset($array['ankiety_' . $type . '_14']) ? $array['ankiety_' . $type . '_14'] : null,
                isset($array['ankiety_' . $type . '_15']) ? $array['ankiety_' . $type . '_15'] : null,
                isset($array['ankiety_' . $type . '_16']) ? $array['ankiety_' . $type . '_16'] : null,
                isset($array['ankiety_' . $type . '_17']) ? $array['ankiety_' . $type . '_17'] : null,
                isset($array['ankiety_' . $type . '_18']) ? $array['ankiety_' . $type . '_18'] : null,
                isset($array['ankiety_' . $type . '_19']) ? $array['ankiety_' . $type . '_19'] : null,
                isset($array['ankiety_' . $type . '_20']) ? $array['ankiety_' . $type . '_20'] : null,
                isset($array['ankiety_' . $type . '_21']) ? $array['ankiety_' . $type . '_21'] : null,
                isset($array['ankiety_' . $type . '_22']) ? $array['ankiety_' . $type . '_22'] : null
            );
        }
    }

    public function prepareTestSpreadsheet(testCollection $tests, userCollection $users, $gameName, $testType) {
        require_once(sfConfig::get('sf_plugins_dir') . "/artLibraryPlugin/lib/phpExcel/PHPExcel.php");
        require_once(sfConfig::get('sf_plugins_dir') . "/artLibraryPlugin/lib/phpExcel/PHPExcel/IOFactory.php");

        $fileName = 'test_' . $testType . '_' . $gameName . '_' . time() . '.xls';
        $spreadsheetTitle = 'Testy ' . (($testType == 'before') ? 'przed ' : 'po ') . $gameName;
        $spreadsheetUserData = array('Typ testu', 'Id', 'Imię', 'Nazwisko', 'Płeć', 'Nazwa szkoły', 'Numer klasy');

        /* to merge cells instead of displaying them separately simply uncomment
         * what's commented and comment out the a, b, c, d, e variants
         */
        if ($testType == 'before') {
            $spreadsheetQuestions = array(
                '1. Wymień zasady planowania',
                '2. Wymieńcie jak najwięcej czynników wpływających na popyt na usługi hotelarskie',
//                '3. Co wpływa na sezonowe wahania popytu?',
                '3a. Co wpływa na sezonowe wahania popytu?',
                '3b. Co wpływa na sezonowe wahania popytu?',
                '3c. Co wpływa na sezonowe wahania popytu?',
                '3d. Co wpływa na sezonowe wahania popytu?',
                '3e. Co wpływa na sezonowe wahania popytu?',
//                '4. Czym są koszty stałe?',
                '4a. Czym są koszty stałe?',
                '4b. Czym są koszty stałe?',
                '4c. Czym są koszty stałe?',
                '4d. Czym są koszty stałe?',
                '5. Czy przedsiębiorstwo może zbankrutować pomimo pozytywnego wyniku finansowego? Odpowiedź uzasadnij',
                '6. Wymień rodzaje kredytów udzielanych przedsiębiorcom',
//                '7. Co poza odsetkami stanowi koszt kredytu?',
                '7a. Co poza odsetkami stanowi koszt kredytu?',
                '7b. Co poza odsetkami stanowi koszt kredytu?',
                '7c. Co poza odsetkami stanowi koszt kredytu?',
                '7d. Co poza odsetkami stanowi koszt kredytu?',
//                '8. Co to jest zdolność kredytowa?',
                '8a. Co to jest zdolność kredytowa?',
                '8b. Co to jest zdolność kredytowa?',
                '8c. Co to jest zdolność kredytowa?',
                '8d. Co to jest zdolność kredytowa?',
//                '9. Jakie usługi świadczy bank?',
                '9a. Jakie usługi świadczy bank?',
                '9b. Jakie usługi świadczy bank?',
                '9c. Jakie usługi świadczy bank?',
                '9d. Jakie usługi świadczy bank?',
                '10. Jakie znasz formy zatrudnienia?',
                '11. Wymień zalety umowy o pracę (z punktu widzenia pracownika)',
                '12. Co poza płacą brutto stanowi koszt wynagrodzenia po stronie pracodawcy?',
                '13. Wymień jak najwięcej sposobów motywowania pracowników',
                '14. Czym mogą konkurować firmy?',
                '15. Opisz na czym polega konkurencja marketingowa',
                '16. Czym jest segmentacja?'
            );
        } else {
            $spreadsheetQuestions = array(
                '1. Wymień zasady planowania',
                '2. Wymień jak najwięcej czynników wpływających na popyt na usługi hotelarskie',
//                '3. Czym są koszty zmienne?',
                '3a. Czym są koszty zmienne?',
                '3b. Czym są koszty zmienne?',
                '3c. Czym są koszty zmienne?',
                '3d. Czym są koszty zmienne?',
                '4. Czy przedsiębiorstwo może zbankrutować pomimo pozytywnego wyniku finansowego? Odpowiedź uzasadnij',
                '5. Wymień rodzaje kredytów udzielanych przedsiębiorcom',
//                '6. Co poza odsetkami stanowi koszt kredytu?',
                '6a. Co poza odsetkami stanowi koszt kredytu?',
                '6b. Co poza odsetkami stanowi koszt kredytu?',
                '6c. Co poza odsetkami stanowi koszt kredytu?',
                '6d. Co poza odsetkami stanowi koszt kredytu?',
//                '7. Co to jest zdolność kredytowa?',
                '7a. Co to jest zdolność kredytowa?',
                '7b. Co to jest zdolność kredytowa?',
                '7c. Co to jest zdolność kredytowa?',
                '7d. Co to jest zdolność kredytowa?',
//                '8. Jakie usługi świadczy bank?',
                '8a. Jakie usługi świadczy bank?',
                '8b. Jakie usługi świadczy bank?',
                '8c. Jakie usługi świadczy bank?',
                '8d. Jakie usługi świadczy bank?',
                '9. Jakie znasz formy zatrudnienia?',
                '10. Wymień zalety umowy o pracę (z punktu widzenia pracownika)',
                '11. Co poza płacą brutto stanowi koszt wynagrodzenia po stronie pracodawcy?',
                '12. Wymień jak najwięcej sposobów motywowania pracowników',
                '13. Czym mogą konkurować firmy?',
                '14. Opisz na czym polega konkurencja marketingowa',
//                '15. Strategię firmy możemy określić jako',
                '15a. Strategię firmy możemy określić jako',
                '15b. Strategię firmy możemy określić jako',
                '15c. Strategię firmy możemy określić jako',
                '15d. Strategię firmy możemy określić jako',
                '15e. Strategię firmy możemy określić jako',
                '16. Wymień co najmniej 2 kryteria segmentacji rynku'
            );
        }

        $spreadsheetTopRow = array_merge($spreadsheetUserData, $spreadsheetQuestions);

        $spreadsheetData = array(
            $spreadsheetTopRow
        );

        $objPHPExcel = new PHPExcel();
        $objPHPExcel->removeSheetByIndex(0); // remove default empty worksheet
        $surveysSpreadsheet = $objPHPExcel->createSheet();
        $surveysSpreadsheet->setTitle($spreadsheetTitle);

        $ids = $tests->keys();

        foreach ($ids as $id) {
            $testTypeSub = ($testType == 'before') ? 1 : 2;
            $user = $users->getUser($id);
            $results = $this->getTestResultsArray($tests->getTest($id), $id, $testType);
            $userData = array($testTypeSub, $id, $user['firstName'], $user['lastName'], null, $user['schoolName'], null,);
            $spreadsheetRow = array_merge($userData, $results);

            array_push($spreadsheetData, $spreadsheetRow);
        }

        $objPHPExcel->getSheetByName($spreadsheetTitle)
                ->fromArray(
                        $spreadsheetData, // The data to set
                        NULL, // Array values with this value will not be set
                        'A1'         // Top left coordinate of the worksheet range where we want to set these values (default is A1)
        );

//        if ($testType == 'before') {
//            $objPHPExcel->getSheetByName($spreadsheetTitle)->mergeCells('J1:N1')
//                    ->mergeCells('O1:R1')
//                    ->mergeCells('U1:X1')
//                    ->mergeCells('Y1:AB1')
//                    ->mergeCells('AC1:AF1');
//        } else {
//            $objPHPExcel->getSheetByName($spreadsheetTitle)->mergeCells('J1:M1')
//                    ->mergeCells('P1:S1')
//                    ->mergeCells('T1:W1')
//                    ->mergeCells('X1:AA1')
//                    ->mergeCells('AH1:AL1');
//        }

        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $fileName . '"');
        header('Cache-Control: max-age=0');

        $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $writer->save('php://output');
    }

    public function getTestResultsArray($array, $id, $arrayType) {
        $type = ($arrayType == 'before') ? 'przed' : 'po';
        $partial = $id . '_test_' . $type . '_';

        if ($arrayType == 'before') {
            $c1 = $this->getTestChoicesArray(isset($array['test_' . $type . '_3']) ? $array['test_' . $type . '_3'] : 9, 5);
            $c2 = $this->getTestChoicesArray(isset($array['test_' . $type . '_4']) ? $array['test_' . $type . '_4'] : 9, 4);
            $c3 = $this->getTestChoicesArray(isset($array['test_' . $type . '_7']) ? $array['test_' . $type . '_7'] : 9, 4);
            $c4 = $this->getTestChoicesArray(isset($array['test_' . $type . '_8']) ? $array['test_' . $type . '_8'] : 9, 4);
            $c5 = $this->getTestChoicesArray(isset($array['test_' . $type . '_9']) ? $array['test_' . $type . '_9'] : 9, 4);

            return array(
                $this->getTestScoreValue(isset($array[$partial . '1_r']) ? $array[$partial . '1_r'] : 0, isset($array[$partial . '1_e']) ? $array[$partial . '1_e'] : 0, isset($array[$partial . '1_p']) ? $array[$partial . '1_p'] : 0),
                $this->getTestScoreValue(isset($array[$partial . '2_r']) ? $array[$partial . '2_r'] : 0, isset($array[$partial . '2_e']) ? $array[$partial . '2_e'] : 0, isset($array[$partial . '2_p']) ? $array[$partial . '2_p'] : 0),
                $c1[0],
                $c1[1],
                $c1[2],
                $c1[3],
                $c1[4],
                $c2[0],
                $c2[1],
                $c2[2],
                $c2[3],
                $this->getTestScoreValue(isset($array[$partial . '5_r']) ? $array[$partial . '5_r'] : 0, isset($array[$partial . '5_e']) ? $array[$partial . '5_e'] : 0, isset($array[$partial . '5_p']) ? $array[$partial . '5_p'] : 0),
                $this->getTestScoreValue(isset($array[$partial . '6_r']) ? $array[$partial . '6_r'] : 0, isset($array[$partial . '6_e']) ? $array[$partial . '6_e'] : 0, isset($array[$partial . '6_p']) ? $array[$partial . '6_p'] : 0),
                $c3[0],
                $c3[1],
                $c3[2],
                $c3[3],
                $c4[0],
                $c4[1],
                $c4[2],
                $c4[3],
                $c5[0],
                $c5[1],
                $c5[2],
                $c5[3],
                $this->getTestScoreValue(isset($array[$partial . '10_r']) ? $array[$partial . '10_r'] : 0, isset($array[$partial . '10_e']) ? $array[$partial . '10_e'] : 0, isset($array[$partial . '10_p']) ? $array[$partial . '10_p'] : 0),
                $this->getTestScoreValue(isset($array[$partial . '11_r']) ? $array[$partial . '11_r'] : 0, isset($array[$partial . '11_e']) ? $array[$partial . '11_e'] : 0, isset($array[$partial . '11_p']) ? $array[$partial . '11_p'] : 0),
                $this->getTestScoreValue(isset($array[$partial . '12_r']) ? $array[$partial . '12_r'] : 0, isset($array[$partial . '12_e']) ? $array[$partial . '12_e'] : 0, isset($array[$partial . '12_p']) ? $array[$partial . '12_p'] : 0),
                $this->getTestScoreValue(isset($array[$partial . '13_r']) ? $array[$partial . '13_r'] : 0, isset($array[$partial . '13_e']) ? $array[$partial . '13_e'] : 0, isset($array[$partial . '13_p']) ? $array[$partial . '13_p'] : 0),
                $this->getTestScoreValue(isset($array[$partial . '14_r']) ? $array[$partial . '14_r'] : 0, isset($array[$partial . '14_e']) ? $array[$partial . '14_e'] : 0, isset($array[$partial . '14_p']) ? $array[$partial . '14_p'] : 0),
                $this->getTestScoreValue(isset($array[$partial . '15_r']) ? $array[$partial . '15_r'] : 0, isset($array[$partial . '15_e']) ? $array[$partial . '15_e'] : 0, isset($array[$partial . '15_p']) ? $array[$partial . '15_p'] : 0),
                $this->getTestScoreValue(isset($array[$partial . '16_r']) ? $array[$partial . '16_r'] : 0, isset($array[$partial . '16_e']) ? $array[$partial . '16_e'] : 0, isset($array[$partial . '16_p']) ? $array[$partial . '16_p'] : 0)
            );
        } else {
            $c1 = $this->getTestChoicesArray(isset($array['test_' . $type . '_3']) ? $array['test_' . $type . '_3'] : 9, 4);
            $c2 = $this->getTestChoicesArray(isset($array['test_' . $type . '_6']) ? $array['test_' . $type . '_6'] : 9, 4);
            $c3 = $this->getTestChoicesArray(isset($array['test_' . $type . '_7']) ? $array['test_' . $type . '_7'] : 9, 4);
            $c4 = $this->getTestChoicesArray(isset($array['test_' . $type . '_8']) ? $array['test_' . $type . '_8'] : 9, 4);
            $c5 = $this->getTestChoicesArray(isset($array['test_' . $type . '_15']) ? $array['test_' . $type . '_15'] : 9, 5);

            return array(
                $this->getTestScoreValue(isset($array[$partial . '1_r']) ? $array[$partial . '1_r'] : 0, isset($array[$partial . '1_e']) ? $array[$partial . '1_e'] : 0, isset($array[$partial . '1_p']) ? $array[$partial . '1_p'] : 0),
                $this->getTestScoreValue(isset($array[$partial . '2_r']) ? $array[$partial . '2_r'] : 0, isset($array[$partial . '2_e']) ? $array[$partial . '2_e'] : 0, isset($array[$partial . '2_p']) ? $array[$partial . '2_p'] : 0),
                $c1[0],
                $c1[1],
                $c1[2],
                $c1[3],
                $this->getTestScoreValue(isset($array[$partial . '4_r']) ? $array[$partial . '4_r'] : 0, isset($array[$partial . '4_e']) ? $array[$partial . '4_e'] : 0, isset($array[$partial . '4_p']) ? $array[$partial . '4_p'] : 0),
                $this->getTestScoreValue(isset($array[$partial . '5_r']) ? $array[$partial . '5_r'] : 0, isset($array[$partial . '5_e']) ? $array[$partial . '5_e'] : 0, isset($array[$partial . '5_p']) ? $array[$partial . '5_p'] : 0),
                $c2[0],
                $c2[1],
                $c2[2],
                $c2[3],
                $c3[0],
                $c3[1],
                $c3[2],
                $c3[3],
                $c4[0],
                $c4[1],
                $c4[2],
                $c4[3],
                $this->getTestScoreValue(isset($array[$partial . '9_r']) ? $array[$partial . '9_r'] : 0, isset($array[$partial . '9_e']) ? $array[$partial . '9_e'] : 0, isset($array[$partial . '9_p']) ? $array[$partial . '9_p'] : 0),
                $this->getTestScoreValue(isset($array[$partial . '10_r']) ? $array[$partial . '10_r'] : 0, isset($array[$partial . '10_e']) ? $array[$partial . '10_e'] : 0, isset($array[$partial . '10_p']) ? $array[$partial . '10_p'] : 0),
                $this->getTestScoreValue(isset($array[$partial . '11_r']) ? $array[$partial . '11_r'] : 0, isset($array[$partial . '11_e']) ? $array[$partial . '11_e'] : 0, isset($array[$partial . '11_p']) ? $array[$partial . '11_p'] : 0),
                $this->getTestScoreValue(isset($array[$partial . '12_r']) ? $array[$partial . '12_r'] : 0, isset($array[$partial . '12_e']) ? $array[$partial . '12_e'] : 0, isset($array[$partial . '12_p']) ? $array[$partial . '12_p'] : 0),
                $this->getTestScoreValue(isset($array[$partial . '13_r']) ? $array[$partial . '13_r'] : 0, isset($array[$partial . '13_e']) ? $array[$partial . '13_e'] : 0, isset($array[$partial . '13_p']) ? $array[$partial . '13_p'] : 0),
                $this->getTestScoreValue(isset($array[$partial . '14_r']) ? $array[$partial . '14_r'] : 0, isset($array[$partial . '14_e']) ? $array[$partial . '14_e'] : 0, isset($array[$partial . '14_p']) ? $array[$partial . '14_p'] : 0),
                $c5[0],
                $c5[1],
                $c5[2],
                $c5[3],
                $c5[4],
                $this->getTestScoreValue(isset($array[$partial . '16_r']) ? $array[$partial . '16_r'] : 0, isset($array[$partial . '16_e']) ? $array[$partial . '16_e'] : 0, isset($array[$partial . '16_p']) ? $array[$partial . '16_p'] : 0)
            );
        }
    }

    public function getTestScoreValue($val1, $val2, $val3) {
        return $val1 + $val2 + $val3;
    }

    public function getTestChoicesArray($val, $num) {
        $arr = array();

        if ($num == 4) {
            switch ($val) {
                case 0:
                    $arr = array('1', '0', '0', '0');
                    break;
                case 1:
                    $arr = array('0', '1', '0', '0');
                    break;
                case 2:
                    $arr = array('0', '0', '1', '0');
                    break;
                case 3:
                    $arr = array('0', '0', '0', '1');
                    break;
                default:
                    $arr = array(null, null, null, null);
                    break;
            }
        } else if ($num == 5) {
            switch ($val) {
                case 0:
                    $arr = array('1', '0', '0', '0', '0');
                    break;
                case 1:
                    $arr = array('0', '1', '0', '0', '0');
                    break;
                case 2:
                    $arr = array('0', '0', '1', '0', '0');
                    break;
                case 3:
                    $arr = array('0', '0', '0', '1', '0');
                    break;
                case 4:
                    $arr = array('0', '0', '0', '0', '1');
                    break;
                default:
                    $arr = array(null, null, null, null, null);
                    break;
            }
        }

        return $arr;
    }

}
