<?php if (!isset($configuration)) $configuration = new gameGeneratorConfiguration(); ?>

<td>

    <?php if ($game->canBeActivated()): ?>
        <?php echo link_to('<i class="icon-bullhorn"></i> ' . __('Aktywuj', array(), 'messages'), 'game/activate?id=' . $game->getId(), array('class' => 'btn btn-success btn-sm', 'onclick' => 'if (confirm("Czy jesteś pewien, że chcesz aktywować grę?")) {this.submit()} else {return false;}')) ?>
    <?php endif; ?>


    <?php if ($game->hasNextRound()): ?>
        <?php echo link_to('<i class="icon-arrow-right"></i> ' . __('Następna runda', array(), 'messages'), 'game/nextRound?id=' . $game->getId(), array('class' => 'btn btn-primary btn-sm', 'onclick' => 'if (confirm("Czy jesteś pewien, że chcesz przejść do następnej rundy?")) {this.submit()} else {return false;}')) ?>
    <?php endif; ?>


    <?php if ($game->canBeArchived()): ?>
        <?php echo link_to('<i class="icon-folder-open"></i> ' . __('Archiwizuj', array(), 'messages'), 'game/archive?id=' . $game->getId(), array('class' => 'btn btn-warning btn-sm',)) ?>
    <?php endif; ?>

    <div class="btn-group">
        <a href="#" data-toggle="dropdown" class="btn dropdown-toggle btn-sm">Zarządzaj grą <span class="caret"></span></a>
        <ul class="dropdown-menu">
            <li>
                <?php echo link_to('<i class="icon-group"></i> ' . __('Zespoły', array(), 'messages'), 'team', array('game_id' => $game->getId())) ?>
            </li>
            <li>
                <?php echo link_to('<i class="icon-wrench"></i> ' . __('Zmienne gry', array(), 'messages'), 'zmienne', array('id' => $game->getId())) ?>
            </li>
        </ul>
    </div>

    <div class="btn-group">
        <a href="#" data-toggle="dropdown" class="btn dropdown-toggle btn-sm"><i class="icon-tasks"></i> Raporty <span class="caret"></span></a>
        <ul class="dropdown-menu">
            <li>
                <?= link_to('' . __('<i class="icon-list"></i> Wyniki gry', array(), 'messages'), 'game/wynikiGry?id=' . $game->getId(), array()) ?>
            </li>
            <li>
                <a href="<?= url_for('@team_raportRanking?game_id=' . $game->getId()); ?>"><i class="icon-trophy"></i> Ranking</a> 
            </li>
        </ul>
    </div>
</td>
