<div class="page-title">
    <div>
        <h1><i class="icon-list"></i> Wyniki dla gry "<?= $game->getName(); ?>"</h1>
    </div>
</div>

<a class="btn btn-primary btn-sm" href="<?= url_for('@team?game_id=' . $game->getId()); ?>"><i class="icon-mail-reply"></i> Wróć do zespołów</a>

<?php
foreach ($gameControllers as $gc) {
    $exampleGameController = $gc;
    break;
}
?>

<?php
$gcData = array();
$wyposazenie = HotelGameDecision::getWyposazenieStandard();
$last = $exampleGameController->gRN() - 1;
$actual = "runda_" . $last;
$data = $exampleGameController->g('ranking|' . $actual, 'game');
foreach ($gameControllers as $gc) {
    $gcData[] = array(
        'nazwa' => $gc->g('nazwa_marki', 'decision', 'Brak nazwy'),
        'lps' => $gc->gLPS(),
        'lpl' => $gc->gLPL(),
        'cps' => $gc->gCPS(),
        'cpl' => $gc->gCPL(),
        'buds' => max(0, $gc->g('pokoje_standard', 'decision')),
        'budl' => max(0, $gc->g('pokoje_lux', 'decision')),
        'obls' => $gc->g('pokoje_oblozone_standard_procent', 'round'),
        'obll' => $gc->g('pokoje_oblozone_lux_procent', 'round'),
        'wyps' => $wyposazenie[$gc->g('pokoje_standard_wyposazenie', 'decision')]['log_label'],
        'wypl' => $wyposazenie[$gc->g('pokoje_lux_wyposazenie', 'decision')]['log_label'],
        'satysfP' => $gc->getGameProcess()->getStatysfakcjaPracownikow(),
        'satysfKS' => $gc->getGameProcess()->getStatysfakcjaKlientaStandard(),
        'satysfKL' => $gc->getGameProcess()->getStatysfakcjaKlientaLux(),
        'efektMS' => $gc->getGameProcess()->getEfektywnoscMarketinguStandard(),
        'efektML' => $gc->getGameProcess()->getEfektywnoscMarketinguLux(),
        'sniad' => $gc->g('sniadania_kwota', 'decision', 0),
        'uslug' => $gc->getGameProcess()->iloscUslug(),
        'marketingL' => $gc->g('media_lokalne_bilboardy', 'decision') * $gc->g('media|koszty|lokalne|bilboardy', 'game') + $gc->g('media_lokalne_prasa', 'decision') * $gc->g('media|koszty|lokalne|prasa', 'game') + $gc->g('media_lokalne_radio', 'decision') * $gc->g('media|koszty|lokalne|radio', 'game'),
        'marketingR' => $gc->g('media_regionalne_prasa', 'decision') * $gc->g('media|koszty|regionalne|prasa', 'game') + $gc->g('media_regionalne_radio', 'decision') * $gc->g('media|koszty|regionalne|radio', 'game') + $gc->g('media_regionalne_tv', 'decision') * $gc->g('media|koszty|regionalne|tv', 'game'),
        'marketingK' => $gc->g('media_krajowe_prasa', 'decision') * $gc->g('media|koszty|krajowe|prasa', 'game') + $gc->g('media_krajowe_radio', 'decision') * $gc->g('media|koszty|krajowe|radio', 'game') + $gc->g('media_krajowe_tv', 'decision') * $gc->g('media|koszty|krajowe|tv', 'game'),
        'uslug' => $gc->getGameProcess()->iloscUslug(),
        'zadluzenie' => $gc->getGameProcess()->getZadluzenieFirmy(),
        'gotowka' => $gc->gB(),
        'majatek' => $gc->getGameProcess()->getMajatekFirmy(),
        'wynik_finansowy' => $gc->g('zmiana_saldo', 'last_round', 0),
        'wartosc_rankingu' => $data[$gc->getGameData()->getTeam()->getId()]['wartosc_rankingu'],
    );
}
?>

<div class="row raport raport-operacyjny">
    <div class="col-md-12">
        <div class="box box-gray">

            <div class="box-title">
                <h3><i class="icon-trophy"></i> Ranking</h3>
                <div class="box-tool">
                    <a data-action="collapse" href="#"><i class="icon-chevron-up"></i></a>
                </div>
            </div>
            <div class="box-content">
                <?php
                $rankingArray = array();
                foreach ($data as $key => $team) {
                    $rankingArray[] = array(
                        'id' => $key,
                        'pozycja' => $team->get('pozycja'),
                        'nazwa_firmy' => $team->get('nazwa_firmy'),
                        'wartosc_rankingu' => $team->get('wartosc_rankingu'),
                        'wynik_ekonomiczny_firmy' => $team->get('wynik_ekonomiczny_firmy'),
                        'wsp_zrownowazonego_rozwoju' => $team->get('wsp_zrownowazonego_rozwoju'),
                        'wsp_satysfakcji' => $team->get('wsp_satysfakcji'),
                    );
                }
                ksort($rankingArray);
                ?>
                <table class="table table-striped table-hover fill-head">
                    <thead>
                        <tr>
                            <th></th>
                            <th><?= __t('Pozycja', array(), 'raport_ranking') ?></th>
                            <th><?= __t('Nazwa firmy', array(), 'raport_ranking') ?></th>
                            <th><?= __t('Wartość rankingu', array(), 'raport_ranking') ?></th>
                            <th><?= __t('Wynik ekonomiczny firmy', array(), 'raport_ranking') ?></th>
                            <th><?= __t('Współczynnik rozwoju', array(), 'raport_ranking') ?></th>
                            <th><?= __t('Współczynnik satysfakcji', array(), 'raport_ranking') ?></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($rankingArray as $pozycja => $dane): ?>
                            <?php $key = $dane['id']; ?>
                            <tr level="0">
                                <td class="td-icon-rank"><?= ($dane['pozycja'] <= 3) ? '<i class="hotel-icon-rank hotel-icon-rank' . $dane['pozycja'] . '"></i>' : ''; ?></td>
                                <td><?= $dane['pozycja']; ?></td>
                                <td><?= $dane['nazwa_firmy']; ?></td>
                                <td><?= $dane['wartosc_rankingu']; ?></td>
                                <td><?= HotelGameFunctions::format_money_value(round($dane['wynik_ekonomiczny_firmy'], 2)); ?></td>
                                <td><?= round($dane['wsp_satysfakcji'], 2) ?></td>
                                <td><?= round($dane['wsp_zrownowazonego_rozwoju'], 2) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="row raport raport-operacyjny">
    <div class="col-md-12">
        <div class="box box-gray">
            <div class="box-title">
                <h3><i class="icon-usd"></i> Wyniki finansowe firm</h3>
                <div class="box-tool">
                    <a data-action="collapse" href="#"><i class="icon-chevron-up"></i></a>
                </div>
            </div>

            <div class="box-content">
                <table class="table table-striped table-hover fill-head">
                    <thead>
                        <tr>
                            <th><?= __t('Nazwa firmy', array(), 'raport_ranking') ?></th>
                            <th><?= __t('Wynik finansowy', array(), 'raport_ranking') ?></th>
                            <th><?= __t('Poziom gotówki', array(), 'raport_ranking') ?></th>
                            <th><?= __t('Zadłużenie firmy', array(), 'raport_ranking') ?></th>
                            <th><?= __t('Majątek firmy', array(), 'raport_ranking') ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($gcData as $dane): ?>
                            <tr level="0">
                                <td><?= $dane['nazwa']; ?></td>
                                <td><?= HotelGameFunctions::format_money_value($dane['wynik_finansowy']); ?></td>
                                <td><?= HotelGameFunctions::format_money_value($dane['gotowka']) ?></td>
                                <td><?= HotelGameFunctions::format_money_value($dane['zadluzenie']) ?></td>
                                <td><?= HotelGameFunctions::format_money_value($dane['majatek']) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="row raport raport-operacyjny">
    <div class="col-md-12">
        <div class="box box-gray">
            <div class="box-title">
                <h3><i class="icon-gears"></i> Wyniki operacyjne firm</h3>
                <div class="box-tool">
                    <a data-action="collapse" href="#"><i class="icon-chevron-up"></i></a>
                </div>
            </div>

            <div class="box-content">
                <table class="table table-striped table-hover fill-head">
                    <thead>
                        <tr>
                            <th><?= __t('Nazwa firmy', array(), 'raport_ranking') ?></th>
                            <th><?= __t('Liczba pokoi Standard / Delux', array(), 'raport_ranking') ?></th>
                            <th><?= __t('Procent obłożenia Standard / Delux', array(), 'raport_ranking') ?></th>
                            <th><?= __t('Wyposażenie pokoi Standard / Delux', array(), 'raport_ranking') ?></th>
                            <th><?= __t('Pokoje w budowie Standard / Delux', array(), 'raport_ranking') ?></th>
                            <th><?= __t('Satysfakcja pracowników', array(), 'raport_ranking') ?></th>
                            <th><?= __t('Satysfakcja klientów Standard / Delux', array(), 'raport_ranking') ?></th>
                            <th><?= __t('Budżet reklamowy na media lokalne / regionalne / krajowe', array(), 'raport_ranking') ?></th>
                            <th><?= __t('Efektowność reklamy Standard / Delux', array(), 'raport_ranking') ?></th>
                            <th><?= __t('Liczba usług', array(), 'raport_ranking') ?></th>
                            <th><?= __t('Cena śniadań', array(), 'raport_ranking') ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($gcData as $dane): ?>
                            <tr level="0">
                                <td><?= $dane['nazwa']; ?></td>
                                <td><?= $dane['lps']; ?> / <?= $dane['lpl']; ?></td>
                                <td><?= round($dane['obls'], 0); ?> % / <?= round($dane['obll'], 0); ?> %</td>
                                <td><?= $dane['wyps']; ?> / <?= $dane['wypl']; ?></td>
                                <td><?= $dane['buds']; ?> / <?= $dane['budl']; ?></td>
                                <td><?= $dane['satysfP']; ?></td>
                                <td><?= round($dane['satysfKS'], 0); ?> / <?= round($dane['satysfKL'], 0); ?></td>
                                <td><?= HotelGameFunctions::format_money_value($dane['marketingL']); ?> / <?= HotelGameFunctions::format_money_value($dane['marketingR']); ?> / <?= HotelGameFunctions::format_money_value($dane['marketingK']); ?></td>
                                <td><?= round($dane['efektMS'], 0); ?> / <?= round($dane['efektML'], 0); ?></td>
                                <td><?= $dane['uslug']; ?></td>
                                <td><?= HotelGameFunctions::format_money_value($dane['sniad']); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include_partial('game/wykres', array('gcData' => $gcData, 'title' => 'Wartość rankingu', 'id' => 'chartWR', 'key' => 'wartosc_rankingu')); ?>
<?php include_partial('game/wykres', array('gcData' => $gcData, 'title' => 'Liczba pokoi Standard', 'id' => 'chartLPS', 'key' => 'lps')); ?>
<?php include_partial('game/wykres', array('gcData' => $gcData, 'title' => 'Liczba pokoi Delux', 'id' => 'chartLPL', 'key' => 'lpl')); ?>
<?php include_partial('game/wykres_not', array('gcData' => $gcData, 'title' => 'Liczba pokoi Delux', 'id' => 'chartLPL', 'key' => 'lpl')); ?>

<a class="btn btn-primary btn-sm mt10" href="<?= url_for('@team?game_id=' . $game->getId()); ?>"><i class="icon-mail-reply"></i> Wróć do zespołów</a>
