<?php

require_once dirname(__FILE__) . '/../lib/gameArchiveGeneratorConfiguration.class.php';
require_once dirname(__FILE__) . '/../lib/gameArchiveGeneratorHelper.class.php';

class gameArchiveActions extends autoGameArchiveActions {

    public function executeWynikiGry(sfWebRequest $request) {
        $gameId = $request->getParameter('id');
        $this->game = Doctrine::getTable('Game')->findOneById($gameId);

        if (!$this->game) {
            $this->getUser()->setError('Gra nie istnieje. Spróbuj ponownie.');
            $this->redirect('@gameArchive');
        }

        $teams = Doctrine::getTable('Team')->getTeamsByGameId($gameId);
        $this->gameControllers = array();

        foreach ($teams as $team) {
            $this->gameControllers[$team->getId()] = $this->getGameControllerForTeam($team->getId());
        }
    }

    public function getGameControllerForTeam($teamId) {
        $team = Doctrine::getTable('Team')->findOneById($teamId);

        if (!$team) {
            $this->getUser()->setError('Zespół nie istnieje');
            $this->redirect('@teamArchive');
        }

        try {
            $gameController = new HotelGameController($team->getId());
        } catch (Exception $ex) {
            $this->getUser()->setError($ex->getMessage());
//            $this->getUser()->setError('Raport który chcesz podejrzeć nie jest jeszcze dostępny.');
            //$this->redirect('@teamArchive');
        }

//        if (!$gameController->rGT(1)) {
//            $this->getUser()->setError('Raport który chcesz podejrzeć nie jest jeszcze dostępny.');
//            $this->redirect('@teamArchive');
//        }

        return $gameController;
    }

}
