<?php

class sfGuardAuthActions extends PluginsfGuardAuthActions
{
      
  public function executePassword($request) {
    $this->user = $this->getUser()->getGuardUser();
    $this->form = new BackendChangePasswordForm($this->user);

    if ($request->isMethod('post') && $request->hasParameter('change_password')) {
      $this->form->bind($request->getParameter('change_password'));
      $oldPassword = $this->form->getValue('old_password');

      if ($this->form->isValid()) {
        if (!$this->getUser()->checkPassword($oldPassword))
          $this->getUser()->setError('Invalid old password.');
        else {
          $this->form->getObject()->setPassword($this->form->getValue('password'));
          $this->form->getObject()->save();

          ArtSimpleMessenger::sendNewPasswordMessage($this->user);

          $this->getUser()->setNotice('Hasło zostało zmienione.');
        }
      }
    }
  }
  
  public function executeSignin(sfWebRequest $request) {
    $user = $this->getUser();
    // Użytkownik jest zalogowany;

    if ($user->isAuthenticated()) {

      if (!$request->isXmlHttpRequest())
        return $this->redirect(
                Redirector::get('GuardUser_SignInAuthenticated'
                    , array('request' => $request)));
      else {
        // AJAX Request
        $this->url = url_for(Redirector::get('GuardUser_SignInAuthenticated', array('request' => $request)));
        return 'Redirect';
      }
    }

    if ($this->getUser()->hasFlash('homepageReferer'))
      $this->getUser()->setFlash('homepage_referer', $this->getUser()->getFlash('homepageReferer'));
    else
      $this->getUser()->forwardFlash('homepage_referer');

    $class = sfConfig::get('app_sf_guard_plugin_signin_form', 'sfGuardFormSignin');
    $this->form = new $class();

    if ($request->isMethod('post') && $request->hasParameter('signin')) {
      $this->form->bind($request->getParameter('signin'));
      if ($this->form->isValid()) {
        $values = $this->form->getValues();
        $this->getUser()->signin($values['user'], array_key_exists('remember', $values) ? $values['remember'] : false);
        
        if (!$this->getUser()->hasSurveyBefore()) {
            $this->redirect('@ankieta_przed');
        }

        $referer = $user->getReferer($request->getReferer());

        $this->url = Redirector::get('GuardUser_SignIn', array('request' => $request, 'user' => $user));

        if ($this->getUser()->hasFlash('homepage_referer')) {
          $this->url = $this->getUser()->getFlash('homepage_referer');

          return 'Redirect';
        }

        if ($request->isXmlHttpRequest() && $this->getUser()->hasAttribute('ajax_referer')) {
          $ajaxReferer = $this->getUser()->getAttribute('ajax_referer', $referer);
          $this->getUser()->offsetUnset('ajax_referer');
          $urlToParse = str_replace(str_replace(sfConfig::get('sf_web_dir'), '', $_SERVER['SCRIPT_FILENAME']) . '/', '', $ajaxReferer);
          $params = $this->getContext()->getRouting()->parse($urlToParse);

          if ($params['action'] == 'signin' && $params['module'] == 'sfGuardAuth')
            return 'Redirect';
          else
            return $this->forward($params['module'], $params['action']);
        }

        return $this->redirect($this->url);
      }
    } else {
      if ($request->isXmlHttpRequest()) {
        $this->getUser()->setAttribute('ajax_referer', $_SERVER['REQUEST_URI']);

        return 'Success';
      }

      $user->setReferer($this->getContext()->getActionStack()->getSize() > 1 ? $request->getUri() : $request->getReferer());
      $module = sfConfig::get('sf_login_module');

      if ($this->getModuleName() != $module)
        return $this->redirect($module . '/' . sfConfig::get('sf_login_action'));

      $this->getResponse()->setStatusCode(401);
    }
  }
}