<?php $routes = $sf_context->getRouting()->getRoutes() ?>

<?php  include_partial('partials/flashes') ?>

<div class="signin-form-div art-relative">
<?php if ($sf_request->isXmlHttpRequest()): ?>
  <?php $params = $sf_request->getGetParameters(); artEscaper::escape($params) ?>
    <?php echo jq_form_remote_tag(
            array(
                'url' => url_for('sf_guard_signin', $params),
                'success' => '$("#signin-form-wrapper").parent().html(data)',
                'loading' => '$("#signin-form-wrapper").modalIndicator();'
            ),
            array(
                'id' => 'signin-form'
            )
            ) ?>
  <?php else: ?>
    <form id="signin-form" action="<?php echo url_for('@sf_guard_signin') ?>" method="post">
  <?php endif ?>
    <table class="signin_form_table">
      <tr><td><?php echo $form['_csrf_token'] ?></td></tr>
      <tr class="username">
        <td>
          <?php echo $form['username']->renderLabel() ?>:<?php echo $form['username'] ?>
        </td>
      </tr>
      <tr class="password">
        <td>
          <?php echo $form['password']->renderLabel() ?>:<?php echo $form['password'] ?>
        </td>   
      </tr>   
      <tr class="submit">
        <td>
          <?php include_partial('partials/submit', array('value' => __('Signin'), 'aroundTagOptions' => array('id' => 'login-submit'))) ?>
        </td>
      </tr>   
      <?php if (isset($routes['sf_guard_forgot_password'])): ?>
        <tr>
          <td>
            <div class="signin_form_forgot">
              <?php echo link_to(__('Forgot your password?'), '@sf_guard_forgot_password') ?>
            </div>        
          </td>
        </tr>
      <?php endif; ?>
      <?php if (isset($routes['sf_guard_register_choose'])): ?>
        <tr>
          <td>
            <div class="signin_form_register">
              <?php echo link_to(__('Register'), '@sf_guard_register_choose') ?>
            </div>
          </td>    
        </tr>
      <?php endif; ?>
    </table>
  </form>
  <?php if ($form->hasErrors()): ?>
    <div class="sf-error-beak art-absolute" ></div>
    <div class="sf-errors  art-absolute art-auto-height">
      <?php echo artBox::beginBox() ?>
      <?php echo __('The username and/or password is invalid') ?>
      <?php echo artBox::endBox() ?>
    </div>
  <?php endif ?>
</div>