<?php

require_once dirname(__FILE__) . '/../lib/teamGeneratorConfiguration.class.php';
require_once dirname(__FILE__) . '/../lib/teamGeneratorHelper.class.php';

/**
 * team actions.
 *
 * @package    hotel
 * @subpackage team
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class teamActions extends autoTeamActions {

    public function preExecute() {
        parent::preExecute();
        if ($this->getRequest()->hasParameter('game_id') || $this->getUser()->hasAttribute('panel_game_id')) {
            $gameId = $this->getRequest()->getParameter('game_id', $this->getUser()->getAttribute('panel_game_id'));
            $this->getUser()->setAttribute('panel_game_id', $gameId);
            $this->game = Doctrine::getTable('Game')->findOneById($gameId);
        } else {
            $this->redirect('@homepage');
        }
    }

    public function executeResetPassword(sfWebRequest $request) {
        $user = Doctrine::getTable('sfGuardUser')->findOneById($request->getParameter('user_id'));
        if ($user) {
            if ($user->getUserDetails()->getFirst()->getGameId() == $this->getUser()->getAttribute('panel_game_id')) {
                $password = substr(md5($user->getUpdatedAt() . 'hs' . $user->getName()), 0, 8);
                $user->setPassword($password);
                $user->save();

                $emailKontaktowy = ArtConfiguration::getConfig('contact_email', 'hotelstars@arteneo.pl');
                $vars = array(
                    'password' => $password,
                );
                $sender = new MessageSender();
                $sender->send($emailKontaktowy, $user->getEmailAddress(), $sender->getComponentBody('messages', 'resetPassword', $vars, 'panel'), 'HotelStars - Restart hasła');


                $this->getUser()->setNotice('Nowe hasło zostało zostało wysłane na e-mail "' . $user->getEmailAddress() . '"');
            } else {
                $this->getUser()->setError('Niepoprawny gracz');
            }
        }

        $this->redirect('@team');
    }

    public function executeRemoveFromTeam(sfWebRequest $request) {
        $userId = $request->getParameter('user_id');
        $team = Doctrine::getTable('Team')->findOneById($request->getParameter('team_id'));

        if (!$team) {
            $this->getUser()->setError('Gracz nie istnieje w tym zespole');
            $this->redirect('@team');
        }

        $userTeam = Doctrine::getTable('UserTeam')->getUserTeam($userId, $team->getId());

        if ($team->getGameId() == $this->getUser()->getAttribute('panel_game_id') && $userTeam) {
            $userTeam->delete();
            $this->getUser()->setNotice('Gracz został usunięty z zespołu "' . $team->getName() . '"');
        } else {
            $this->getUser()->setError('Gracz nie istnieje w tym zespole');
        }

        $this->redirect('@team');
    }

    public function executeRaportOperacyjny(sfWebRequest $request) {
        $this->prepareRaport($request);
    }

    public function executeRaportKpir(sfWebRequest $request) {
        $this->prepareRaport($request);
    }

    public function executeRaportFinansowy(sfWebRequest $request) {
        $this->prepareRaport($request);
    }

    public function executeListaDecyzji(sfWebRequest $request) {
        $teamId = $request->getParameter('team_id');
        
        $this->team = Doctrine::getTable('Team')->findOneById($teamId);

        if (!$this->team) {
            $this->getUser()->setError('Zespół nie istnieje. Proszę spróbować ponownie.');
            $this->redirect('@team');
        }
        
        $this->decisionList = Doctrine::getTable('Round')
                ->createQuery('r')
                ->leftJoin('r.Team t')
                ->leftJoin('r.log_decisions ld')
                ->leftJoin('ld.User u')
                ->where('t.id = ?', $teamId)
                ->orderBy('r.round_number DESC')
                ->addOrderBy('ld.created_at DESC')
                ->execute();
    }

    public function executeRaportRanking(sfWebRequest $request) {
        $this->game = Doctrine::getTable('Game')->findOneById($request->getParameter('game_id'));

        if ($this->game) {
            $this->team = $this->game->getTeams()->getFirst();
        } else {
            $this->getUser()->setError('Gra nie istnieje. Proszę spróbować ponownie.');
            $this->redirect('@team');
        }

        if (!$this->team) {
            $this->getUser()->setError('Gracz nie istnieje w tym zespole');
            $this->redirect('@team');
        }

        try {
            $this->gameController = new HotelGameController($this->team->getId());
        } catch (Exception $ex) {
            $this->getUser()->setError('Raport który chcesz podejrzeć nie jest jeszcze dostępny.');
            $this->redirect('@team');
        }

        if (!$this->gameController->rGT(6)) {
            $this->getUser()->setError('Raport który chcesz podejrzeć nie jest jeszcze dostępny.');
            $this->redirect('@team');
        }
    }

    public function prepareRaport(sfWebRequest $request) {
        $this->team = Doctrine::getTable('Team')->findOneById($request->getParameter('team_id'));

        if (!$this->team) {
            $this->getUser()->setError('Gracz nie istnieje w tym zespole');
            $this->redirect('@team');
        }

        try {
            $this->gameController = new HotelGameController($this->team->getId());
        } catch (Exception $ex) {
            $this->getUser()->setError('Raport który chcesz podejrzeć nie jest jeszcze dostępny.');
            $this->redirect('@team');
        }

        if (!$this->gameController->rGT(1)) {
            $this->getUser()->setError('Raport który chcesz podejrzeć nie jest jeszcze dostępny.');
            $this->redirect('@team');
        }
    }

    public function executeNauczycielDoplata(sfWebRequest $request) {
        $values = $request->getParameter('nauczyciel_change_balance');
        $team = Doctrine::GetTable('Team')->findOneById($values['id']);
        if (!$team) {
            $this->getUser()->setError('Zespół nie istnieje');
            $this->redirect('@team');
        }
        $this->form = new NauczycielChangeBalanceForm($team);

        if ($request->hasParameter($this->form->getName()) && $request->isMethod('POST')) {
            $values = $request->getParameter($this->form->getName());
            $this->form->bind($values);
            if ($this->form->isValid()) {
                try {
                    $gc = new HotelGameController($team->getId());
                    $gc->getGameProcess()->nauczycielDoplata($this->form->getValue('kwota'));
                    $gc->getGameData()->save();
                    $this->getUser()->setNotice('Gracz otrzymał dopłatę w wysokości ' . $this->form->getValue('kwota') . ' zł');
                } catch (Exception $ex) {
                    $this->getUser()->setError('Wystąpił błąd. Spróbuj ponownie, a jeśli błąd się powtarza, skontaktuj się z administratorem.');
                }
            } else {
                $this->getUser()->setError('Niepoprawna kwota dopłaty.');
            }
        }

        $this->redirect('@team');
    }

    public function executeNauczycielKara(sfWebRequest $request) {
        $values = $request->getParameter('nauczyciel_change_balance');
        $team = Doctrine::GetTable('Team')->findOneById($values['id']);
        if (!$team) {
            $this->getUser()->setError('Zespół nie istnieje');
            $this->redirect('@team');
        }
        $this->form = new NauczycielChangeBalanceForm($team);

        if ($request->hasParameter($this->form->getName()) && $request->isMethod('POST')) {
            $values = $request->getParameter($this->form->getName());
            $this->form->bind($values);
            if ($this->form->isValid()) {
                try {
                    $gc = new HotelGameController($team->getId());
                    $gc->getGameProcess()->nauczycielKara($this->form->getValue('kwota'));
                    $gc->getGameData()->save();
                    $this->getUser()->setNotice('Gracz otrzymał karę w wysokości ' . $this->form->getValue('kwota') . ' zł');
                } catch (Exception $ex) {
                    $this->getUser()->setError('Wystąpił błąd. Spróbuj ponownie, a jeśli błąd się powtarza, skontaktuj się z administratorem.');
                }
            } else {
                $this->getUser()->setError('Niepoprawna kwota kary.');
            }
        }

        $this->redirect('@team');
    }

}
