
<div class="page-title">
  <div>
    <h1><i class="icon-group"></i> Zespoły w grze "<?= $game->getName(); ?>"</h1>
    <a class="btn btn-primary btn-sm mb10" href="<?= url_for('game/wynikiGry?id=' . $game->getId()); ?>"><i class="icon-list"></i> Wyniki gry</a> 
    <a class="btn btn-primary btn-sm mb10" href="<?= url_for('@team_raportRanking?game_id='.$game->getId()); ?>"><i class="icon-trophy"></i> Ranking</a> 
  </div>
</div>

<div class="row">
  <?php foreach ($pager->getResults() as $i => $team): ?>
    <div class="col-md-6">
      <div class="box box-gray">

        <div class="box-title">
          <h3><i class="icon-group"></i> Zespół "<?= $team->getName(); ?>"</h3>
          <div class="box-tool">
            <a data-action="collapse" href="#"><i class="icon-chevron-up"></i></a>
          </div>
        </div>
        <div class="box-content">
          <a class="btn btn-primary btn-sm mb10" href="<?= url_for('@team_raportOperacyjny?team_id='.$team->getId()); ?>"><i class="icon-cogs"></i> Raport operacyjny</a> 
          <a class="btn btn-primary btn-sm mb10" href="<?= url_for('@team_raportKpir?team_id='.$team->getId()); ?>"><i class="icon-book"></i> KWiW</a> 
          <a class="btn btn-primary btn-sm mb10" href="<?= url_for('@team_raportFinansowy?team_id='.$team->getId()); ?>"><i class="icon-usd"></i> Raport finansowy</a> 
          <a class="btn btn-primary btn-sm mb10" href="<?= url_for('@team_listaDecyzji?team_id='.$team->getId()); ?>"><i class="icon-list"></i> Lista decyzji</a> 
          <a class="btn btn-primary btn-sm mb10" href="<?= url_for('@ankieta_przed_ocena?team_id='.$team->getId()); ?>"><i class="icon-list"></i> Oceń test początkowy</a> 
          <a class="btn btn-primary btn-sm mb10" href="<?= url_for('@ankieta_po_ocenie?team_id='.$team->getId()); ?>"><i class="icon-list"></i> Oceń test końcowy</a> 
                      
          <table class="table table-striped table-hover fill-head">
            <thead>
              <tr>
                <th class="sf_admin_text sf_admin_list_th_name">
                  Imię i nazwisko</th>
                <th class="sf_admin_text sf_admin_list_th_users_count">
                  E-mail</th>
                <th id="sf_admin_list_th_actions">
                  Akcje
                </th>
              </tr>
            </thead>
            <tbody>
              <?php if ($team->getUsersCount() > 0) : ?>
                <?php foreach ($team->getUsers() as $user) : ?>
                  <tr>
                    <td><?= $user->getName(); ?></td>
                    <td><?= $user->getEmailAddress(); ?></td>
                    <td>
                      <a class="btn btn-warning btn-sm" href="<?= url_for('@team_resetPassword?user_id=' . $user->getId()); ?>"><i class="icon-retweet"></i> Zrestartuj hasło</a> 
                      <?php if ($game->isPrepared()) : ?>
                        <a class="btn btn-danger btn-sm" onclick="if (confirm('Czy jesteś pewien, że chcesz usunąć gracza z zespołu?')) {this.submit()} else {return false;}" href="<?= url_for('@team_removeFromTeam?team_id=' . $team->getId() . '&user_id=' . $user->getId()); ?>"><i class="icon-trash"></i> Usuń</a> 
                      <?php endif; ?>
                    </td>
                  </tr>
                <?php endforeach; ?>
              <?php else : ?>
                <tr class="sf_admin_row2 sf_admin_row odd">
                  <td colspan="3">
                    Brak graczy w zespole
                  </td>
                </tr>
              <?php endif; ?>
            </tbody>
          </table>
          <?php if ($game->isActive()) : ?>
            <?php $form = new NauczycielChangeBalanceForm($team->getRawValue()); ?>
            <form method="post" action="<?= url_for('@team_nauczycielDoplata'); ?>" class="form-horizontal form-row-separated">
              <div class="form-group">
                <label class="control-label col-sm-2 col-lg-2 control-label">Kwota dopłaty</label>
                <div class="col-sm-8 col-lg-8">
                  <?= $form['kwota']->render(); ?>
                  <?= $form->renderHiddenFields(); ?>
                </div>
                <div class="col-sm-2 col-lg-2" style="margin-top: 3px;">
                  <button type="submit" class="btn btn-success btn-sm pull-right"><i class="icon-plus"></i> Dopłata</button>
                </div>
              </div>
            </form>

            <form method="post" action="<?= url_for('@team_nauczycielKara'); ?>" class="form-horizontal form-row-separated">
              <div class="form-group">
                <label class="control-label col-sm-2 col-lg-2 control-label">Kwota kary</label>
                <div class="col-sm-8 col-lg-8">
                  <?= $form['kwota']->render(); ?>
                  <?= $form->renderHiddenFields(); ?>
                </div>
                <div class="col-sm-2 col-lg-2" style="margin-top: 3px;">
                  <button type="submit" class="btn btn-danger btn-sm pull-right"><i class="icon-minus"></i> Kara</button>
                </div>
              </div>
            </form>
          <?php endif; ?>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
</div>