<div class="page-title">
  <div>
    <h1><i class="icon-trophy"></i> Ranking dla gry "<?= $gameController->getGameData()->getGame()->getName(); ?>"</h1>
  </div>
</div>

<div class="row raport raport-operacyjny">
  <div class="col-md-12">
    <div class="box box-gray">

      <div class="box-title">
        <h3><i class="icon-trophy"></i> Ranking</h3>
        <div class="box-tool">
          <a data-action="collapse" href="#"><i class="icon-chevron-up"></i></a>
        </div>
      </div>
      <div class="box-content">
        <a class="btn btn-primary btn-sm mb10" href="<?= url_for('@team?game_id=' . $team->getGameId()); ?>"><i class="icon-mail-reply"></i> Wróć do zespołów</a>
        <?php
        $last = $gameController->gRN() - 1;
        $actual = "runda_" . $last;
        $data = $gameController->g('ranking|' . $actual, 'game');

        $rankingArray = array();
        foreach ($data as $key => $team) {
          $rankingArray[] = array(
            'id' => $key,
            'pozycja' => $team->get('pozycja'),
            'nazwa_firmy' => $team->get('nazwa_firmy'),
            'wartosc_rankingu' => $team->get('wartosc_rankingu'),
            'wynik_ekonomiczny_firmy' => $team->get('wynik_ekonomiczny_firmy'),
            'wsp_zrownowazonego_rozwoju' => $team->get('wsp_zrownowazonego_rozwoju'),
            'wsp_satysfakcji' => $team->get('wsp_satysfakcji'),
          );
        }
        ksort($rankingArray);
        ?>
        <table class="table table-striped table-hover fill-head">
          <thead>
            <tr>
              <th></th>
              <th><?= __t('Pozycja', array(), 'raport_ranking') ?></th>
              <th><?= __t('Nazwa firmy', array(), 'raport_ranking') ?></th>
              <th><?= __t('Wartość rankingu', array(), 'raport_ranking') ?></th>
              <th><?= __t('Wynik ekonomiczny firmy', array(), 'raport_ranking') ?></th>
              <th><?= __t('Współczynnik rozwoju', array(), 'raport_ranking') ?></th>
              <th><?= __t('Współczynnik satysfakcji', array(), 'raport_ranking') ?></th>
              <th></th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($rankingArray as $pozycja => $dane): ?>
              <?php $key = $dane['id']; ?>
              <tr level="0">
                <td class="td-icon-rank"><?= ($dane['pozycja'] <= 3) ? '<i class="hotel-icon-rank hotel-icon-rank' . $dane['pozycja'] . '"></i>' : ''; ?></td>
                <td><?= $dane['pozycja']; ?></td>
                <td><?= $dane['nazwa_firmy']; ?></td>
                <td><?= HotelGameFunctions::format_money_value($dane['wynik_ekonomiczny_firmy']); ?></td>
                <td><?= round($dane['wartosc_rankingu'], 2) ?></td>
                <td><?= round($dane['wsp_satysfakcji'], 2) ?></td>
                <td><?= round($dane['wsp_zrownowazonego_rozwoju'], 2) ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>

        <a class="btn btn-primary btn-sm mt10" href="<?= url_for('@team?game_id=' . $game->getId()); ?>"><i class="icon-mail-reply"></i> Wróć do zespołów</a>
      </div>
    </div>
  </div>
</div>