<?php

require_once dirname(__FILE__) . '/../lib/teamArchiveGeneratorConfiguration.class.php';
require_once dirname(__FILE__) . '/../lib/teamArchiveGeneratorHelper.class.php';

/**
 * team actions.
 *
 * @package    hotel
 * @subpackage team
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class teamArchiveActions extends autoTeamArchiveActions {

    public function preExecute() {
        parent::preExecute();
        if ($this->getRequest()->hasParameter('game_id') || $this->getUser()->hasAttribute('panel_game_id')) {
            $gameId = $this->getRequest()->getParameter('game_id', $this->getUser()->getAttribute('panel_game_id'));
            $this->getUser()->setAttribute('panel_game_id', $gameId);
            $this->game = Doctrine::getTable('Game')->findOneById($gameId);
        } else {
            $this->redirect('@homepage');
        }
    }

    public function executeRaportOperacyjny(sfWebRequest $request) {
        $this->prepareRaport($request);
    }

    public function executeRaportKpir(sfWebRequest $request) {
        $this->prepareRaport($request);
    }

    public function executeRaportFinansowy(sfWebRequest $request) {
        $this->prepareRaport($request);
    }

    public function executeZmienne(sfWebRequest $request) {
        $this->game = Doctrine::getTable('Game')->findOneById($request->getParameter('game_id'));

        if ($this->game) {
            $this->team = $this->game->getTeams()->getFirst();
        } else {
            $this->getUser()->setError('Gra nie istnieje. Proszę spróbować ponownie.');
            $this->redirect('@teamArchive');
        }

        if (!$this->team) {
            $this->getUser()->setError('Gracz nie istnieje w tym zespole');
            $this->redirect('@teamArchive');
        }

        try {
            $data = $this->game->getGameDataJson();
            $this->gameData = HotelGameData::jsonToArray($data);
        } catch (Exception $ex) {
            $this->getUser()->setError('Raport który chcesz podejrzeć nie jest jeszcze dostępny.');
            $this->redirect('@teamArchive');
        }
    }

    public function executeListaDecyzji(sfWebRequest $request) {
        $teamId = $request->getParameter('team_id');

        $this->team = Doctrine::getTable('Team')->findOneById($teamId);

        if (!$this->team) {
            $this->getUser()->setError('Zespół nie istnieje. Proszę spróbować ponownie.');
            $this->redirect('@teamArchive');
        }

        $this->decisionList = Doctrine::getTable('Round')
                ->createQuery('r')
                ->leftJoin('r.Team t')
                ->leftJoin('r.log_decisions ld')
                ->leftJoin('ld.User u')
                ->where('t.id = ?', $teamId)
                ->orderBy('r.round_number DESC')
                ->addOrderBy('ld.created_at DESC')
                ->execute();
    }

    public function executeRaportRanking(sfWebRequest $request) {
        $this->game = Doctrine::getTable('Game')->findOneById($request->getParameter('game_id'));

        if ($this->game) {
            $this->team = $this->game->getTeams()->getFirst();
        } else {
            $this->getUser()->setError('Gra nie istnieje. Proszę spróbować ponownie.');
            $this->redirect('@teamArchive');
        }

        if (!$this->team) {
            $this->getUser()->setError('Gracz nie istnieje w tym zespole');
            $this->redirect('@teamArchive');
        }

        try {
            $data = $this->game->getGameDataJson();
            $this->gameData = HotelGameData::jsonToArray($data);
        } catch (Exception $ex) {
            $this->getUser()->setError('Raport który chcesz podejrzeć nie jest jeszcze dostępny.');
            $this->redirect('@teamArchive');
        }
    }

    public function prepareRaport(sfWebRequest $request) {
        $this->team = Doctrine::getTable('Team')->findOneById($request->getParameter('team_id'));

        if (!$this->team) {
            $this->getUser()->setError('Gracz nie istnieje w tym zespole');
            $this->redirect('@teamArchive');
        }

        try {
            $round = Doctrine::getTable('Round')
                    ->createQuery('r')
                    ->leftJoin('r.Team t')
                    ->where('t.id = ?', $this->team->getId())
                    ->orderBy('r.round_number DESC')
                    ->fetchOne();
            $data = $round->getRoundRaportDataJson();
            $this->raportData = HotelGameData::jsonToArray($data);
        } catch (Exception $ex) {
            $this->getUser()->setError('Raport który chcesz podejrzeć nie jest jeszcze dostępny.');
            $this->redirect('@teamArchive');
        }
    }

}
