<div class="page-title">
    <div>
        <h1><i class="icon-list"></i> Lista decyzji dla zespołu "<?= $team->getName(); ?>"</h1>
    </div>
</div>

<div class="row raport raport-finansowy">
    <div class="col-md-12">
        <div class="box box-gray">

            <div class="box-title">
                <h3><i class="icon-list"></i> Lista decyzji</h3>
                <div class="box-tool">
                    <a data-action="collapse" href="#"><i class="icon-chevron-up"></i></a>
                </div>
            </div>
            <div class="box-content">
                <a class="btn btn-primary btn-sm mb10" href="<?= url_for('@teamArchive?game_id=' . $team->getGameId()); ?>"><i class="icon-mail-reply"></i> Wróć do zespołów</a>

                <table class="table table-striped table-hover fill-head">
                    <tbody>
                        <tr level="0" row="przychody">
                            <td>Nazwa decyzji</td>
                            <td>Podejmujący decyzję</td>
                            <td>Stara decyzja</td>
                            <td>Nowa decyzja</td>
                            <td>Czas podjęcia</td>
                        </tr>
                        <?php foreach ($decisionList as $round): ?>
                            <tr level="1" row="przychody">
                                <td class="td-title" style="text-align: center;" colspan="5">
                                    <?php echo __('Runda ') . $round->getRoundNumber(); ?>
                                </td>
                            </tr>

                            <?php $decisions = $round->getLogDecisions(); ?>
                            <?php foreach ($decisions as $index => $decisionDetails): ?>
                                <tr class="single-event">
                                    <td><?php echo __t($decisionDetails->getDecision(), array(), 'decision_log'); ?></td>
                                    <td><?php echo $decisionDetails->getUser()->getFirstAndLastName(); ?></td>
                                    <td><?php echo $decisionDetails->getValueString($decisionDetails->getDecision(), $decisionDetails->getOldValue()); ?></td>
                                    <td><?php echo $decisionDetails->getValueString($decisionDetails->getDecision(), $decisionDetails->getNewValue()); ?></td>
                                    <td><?php echo $decisionDetails->getDateTimeObject('created_at')->format('m/d/Y H:i'); ?></td>
                                </tr>
                            <?php endforeach; ?>
                            <?php if ($decisions->count() == 0) : ?>
                                <tr class="single-event">
                                    <td style="text-align: center;" colspan="5">Nie podjęto decyzji w tej rundzie</td>
                                </tr>
                            <?php endif; ?>
                        <?php endforeach; ?>
                        <?php if ($decisionList->count() == 0) : ?>
                            <tr class="single-event">
                                <td style="text-align: center;" colspan="5">Nie podjęto jeszcze żadnych decyzji</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>

                <a class="btn btn-primary btn-sm mt10" href="<?= url_for('@teamArchive?game_id=' . $team->getGameId()); ?>"><i class="icon-mail-reply"></i> Wróć do zespołów</a>
            </div>
        </div>
    </div>
</div>