<div class="page-title">
    <div>
        <h1><i class="icon-usd"></i> Raport finansowy "<?= $team->getName(); ?>"</h1>
    </div>
</div>

<?php
$raportData = $sf_data->getRaw('raportData');
$roundCategoryData = $raportData['finansowy'];
$raportHead = $raportData['finansowy_head'];
asort($raportHead);
$maxDepth = 4;
?>

<?php foreach ($raportHead as $activeYear => $quarters): ?>
    <?php
    if ($activeYear == 5) {
        continue;
    }
    ?>
    <?php $headSize = 5; ?>

    <div class="row raport raport-finansowy">
        <div class="col-md-12">
            <div class="box box-gray">

                <div class="box-title">
                    <h3><i class="icon-usd"></i> Raport finansowy - Rok <?= $activeYear; ?></h3>
                    <div class="box-tool">
                        <a data-action="collapse" href="#"><i class="icon-chevron-up"></i></a>
                    </div>
                </div>
                <div class="box-content">
                    <a class="btn btn-primary btn-sm mb10" href="<?= url_for('@teamArchive?game_id=' . $team->getGameId()); ?>"><i class="icon-mail-reply"></i> Wróć do zespołów</a>

                    <table class="table table-striped table-hover fill-head">
                        <thead>
                        <th colspan="<?= $headSize; ?>"></th>
                        <?php $headSize += count($quarters); ?>
                        <th>
                            Rok <?= $activeYear; ?> (suma)
                        </th>
                        <?php foreach ($quarters as $quarter) : ?>
                            <th>
                                Rok <?= $activeYear; ?> / <?= $quarter; ?>
                            </th>
                        <?php endforeach; ?>
                        </thead>
                        <tbody>

                            <?php foreach ($roundCategoryData as $category => $categoryData): ?>
                                <tr level="0"  row="<?= $category; ?>">
                                    <td colspan="<?= 1 + $maxDepth; ?>" class="td-title">
                                        <?= __t($category, array(), 'raport_finansowy'); ?>
                                    </td>
                                    <?php foreach ($categoryData['values'] as $year => $value) : ?>
                                        <?php
                                        if ($year != $activeYear) {
                                            continue;
                                        }
                                        ?>
                                        <td>
                                            <?= HotelGameFunctions::format_money_value($value['sum']); ?>
                                        </td>
                                        <?php foreach ($value['items'] as $quarter => $value): ?>
                                            <td>
                                                <?= HotelGameFunctions::format_money_value($value); ?>
                                            </td>
                                        <?php endforeach; ?>
                                    <?php endforeach; ?>
                                </tr>

                                <?php if (isset($categoryData['items']) && count($categoryData['items']) > 0) : ?>
                                    <?php include_partial('raportFinansowy', array('activeYear' => $activeYear, 'categoryString' => $category, 'depth' => 1, 'maxDepth' => $maxDepth, 'data' => $categoryData['items'])); ?>
                                <?php endif; ?>

                            <?php endforeach; ?>

                        </tbody>
                    </table>

                    <a class="btn btn-primary btn-sm" href="<?= url_for('@teamArchive?game_id=' . $team->getGameId()); ?>"><i class="icon-mail-reply"></i> Wróć do zespołów</a>
                </div>
            </div>
        </div>
    </div>

<?php endforeach; ?>