<div class="page-title">
  <div>
    <h1><i class="icon-book"></i> KWiW dla zespołu "<?= $team->getName(); ?>"</h1>
  </div>
</div>

<div class="row raport raport-kpir">
  <div class="col-md-12">
    <div class="box box-gray">

      <div class="box-title">
        <h3><i class="icon-book"></i> Księga Wpływów i Wypływów</h3>
        <div class="box-tool">
          <a data-action="collapse" href="#"><i class="icon-chevron-up"></i></a>
        </div>
      </div>
      <div class="box-content">
        <a class="btn btn-primary btn-sm mb10" href="<?= url_for('@teamArchive?game_id=' . $team->getGameId()); ?>"><i class="icon-mail-reply"></i> Wróć do zespołów</a>

        <table class="table table-striped table-hover fill-head">
          <tbody>
            <?php
            $roundCategoryData = $raportData['kpir'];
            $maxDepth = 3;
            ?>
            <?php foreach ($roundCategoryData as $category => $categoryData): ?>
              <tr level="0"  row="<?= $category; ?>">
                <td colspan="<?= 1 + $maxDepth; ?>" class="td-title">
                  <?= __t($category, array(), 'raport_kpir') ?>
                </td>
                <td>
                  <?php if (isset($categoryData['sum'])) : ?>
                    <?= HotelGameFunctions::format_money_value($categoryData['sum']); ?>
                  <?php else: ?>
                    <?= HotelGameFunctions::format_money_value($categoryData); ?>
                  <?php endif; ?>
                </td>
              </tr>

              <?php if (isset($categoryData['items']) && count($categoryData['items']) > 0) : ?>
                <?php include_partial('raportKpir', array('categoryString' => $category, 'depth' => 1, 'maxDepth' => $maxDepth, 'data' => $categoryData['items'])); ?>
              <?php endif; ?>

            <?php endforeach; ?>
          </tbody>
        </table>

        <a class="btn btn-primary btn-sm mt10" href="<?= url_for('@teamArchive?game_id=' . $team->getGameId()); ?>"><i class="icon-mail-reply"></i> Wróć do zespołów</a>
      </div>
    </div>
  </div>
</div>